/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import org.netbeans.modules.java.navigation.JavaMembersAndHierarchyOptions;
import org.openide.filesystems.FileObject;
import org.openide.windows.WindowManager;

final class ResizablePopup {
    static final String HELP_COOKIE = "help";
    private static final Logger LOG = Logger.getLogger(ResizablePopup.class.getName());
    private static final WindowListener windowListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            ResizablePopup.cleanup(windowEvent.getWindow());
        }

        private boolean aboutToShowHelp(Window window) {
            JRootPane rootPane;
            if (window instanceof RootPaneContainer && Boolean.TRUE.equals((rootPane = ((RootPaneContainer)((Object)window)).getRootPane()).getClientProperty(ResizablePopup.HELP_COOKIE))) {
                rootPane.putClientProperty(ResizablePopup.HELP_COOKIE, null);
                return true;
            }
            return false;
        }
    };

    ResizablePopup() {
    }

    static JDialog getDialog(FileObject file) {
        JDialog dialog = new JDialog(WindowManager.getDefault().getMainWindow(), "", false){

            @Override
            public void setVisible(boolean visible) {
                boolean wasVisible = this.isVisible();
                if (wasVisible && !visible) {
                    JavaMembersAndHierarchyOptions.setLastBounds(this.getBounds());
                }
                super.setVisible(visible);
            }
        };
        Rectangle bounds = JavaMembersAndHierarchyOptions.getLastBounds();
        LOG.log(Level.FINE, "Dialog bounds {0}", bounds);
        dialog.setBounds(bounds);
        dialog.addWindowListener(windowListener);
        dialog.setDefaultCloseOperation(2);
        Logger.getLogger("TIMER").log(Level.FINE, "Java Navigation Dialogs", new Object[]{file, dialog});
        return dialog;
    }

    static void cleanup(Window window) {
        window.setVisible(false);
        if (window instanceof RootPaneContainer) {
            ((RootPaneContainer)((Object)window)).setContentPane(new JPanel());
        }
        window.removeWindowListener(windowListener);
        window.dispose();
    }
}

