/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.java.navigation.DocumentationScrollPane;
import org.netbeans.modules.java.navigation.JavaElement;
import org.netbeans.modules.java.navigation.JavaHierarchyModel;
import org.netbeans.modules.java.navigation.JavaMembersAndHierarchyIcons;
import org.netbeans.modules.java.navigation.JavaMembersAndHierarchyOptions;
import org.netbeans.modules.java.navigation.JavaTreeCellRenderer;
import org.netbeans.modules.java.navigation.NoBorderToolBar;
import org.netbeans.modules.java.navigation.ResizablePopup;
import org.netbeans.modules.java.navigation.Utils;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JavaHierarchyPanel
extends JPanel {
    private static TreeModel pleaseWaitTreeModel;
    private static final RequestProcessor RP;
    private JavaHierarchyModel javaHierarchyModel;
    private Component lastFocusedComponent;
    private DocumentationScrollPane docPane;
    public JCheckBox caseSensitiveFilterCheckBox;
    public JButton closeButton;
    public JButton expandAllButton;
    public JLabel filterLabel;
    public JTextField filterTextField;
    public JLabel filtersLabel;
    public JToolBar filtersToolbar;
    public ButtonGroup javaHierarchyModeButtonGroup;
    public JTree javaHierarchyTree;
    public JScrollPane javaHierarchyTreeScrollPane;
    public JToggleButton showFQNToggleButton;
    public JToggleButton showInnerToggleButton;
    public JToggleButton showSubTypeHierarchyToggleButton;
    public JToggleButton showSuperTypeHierarchyToggleButton;
    public JEditorPane signatureEditorPane;
    public JSplitPane splitPane;

    public JavaHierarchyPanel(FileObject fileObject, ElementHandle[] elements) {
        this.initComponents();
        this.docPane = new DocumentationScrollPane(true);
        this.splitPane.setRightComponent(this.docPane);
        this.splitPane.setDividerLocation(JavaMembersAndHierarchyOptions.getHierarchyDividerLocation());
        ToolTipManager.sharedInstance().registerComponent(this.javaHierarchyTree);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        this.caseSensitiveFilterCheckBox.setSelected(JavaMembersAndHierarchyOptions.isCaseSensitive());
        this.showSuperTypeHierarchyToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowSuperTypeHierarchy());
        this.showSubTypeHierarchyToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowSubTypeHierarchy());
        this.showFQNToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowFQN());
        this.showInnerToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowInner());
        this.javaHierarchyTree.getSelectionModel().setSelectionMode(1);
        this.javaHierarchyTree.setRootVisible(false);
        this.javaHierarchyTree.setShowsRootHandles(true);
        this.javaHierarchyTree.setCellRenderer(new JavaTreeCellRenderer());
        this.javaHierarchyModel = new JavaHierarchyModel(fileObject, elements);
        this.registerActions();
        this.enterBusy();
        RP.post(new Runnable(){

            @Override
            public void run() {
                JavaHierarchyPanel.this.javaHierarchyModel.update();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JavaHierarchyPanel.this.leaveBusy();
                    }
                });
            }
        });
    }

    private void registerActions() {
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaHierarchyPanel.this.close();
            }
        }, KeyStroke.getKeyStroke(27, 0, true), 1);
        this.filterTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                JavaHierarchyPanel.this.selectMatchingRow();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                JavaHierarchyPanel.this.selectMatchingRow();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                JavaHierarchyPanel.this.selectMatchingRow();
            }
        });
        this.filterTextField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Utils.firstRow(JavaHierarchyPanel.this.javaHierarchyTree);
            }
        }, KeyStroke.getKeyStroke(36, 0, false), 0);
        this.filterTextField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Utils.previousRow(JavaHierarchyPanel.this.javaHierarchyTree);
            }
        }, KeyStroke.getKeyStroke(38, 0, false), 0);
        this.filterTextField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Utils.nextRow(JavaHierarchyPanel.this.javaHierarchyTree);
            }
        }, KeyStroke.getKeyStroke(40, 0, false), 0);
        this.filterTextField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Utils.lastRow(JavaHierarchyPanel.this.javaHierarchyTree);
            }
        }, KeyStroke.getKeyStroke(35, 0, false), 0);
        this.signatureEditorPane.putClientProperty("HighlightsLayerExcludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.CaretRowHighlighting$");
        this.signatureEditorPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Utils.firstRow(JavaHierarchyPanel.this.javaHierarchyTree);
            }
        }, KeyStroke.getKeyStroke(36, 0, false), 0);
        this.signatureEditorPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Utils.previousRow(JavaHierarchyPanel.this.javaHierarchyTree);
            }
        }, KeyStroke.getKeyStroke(38, 0, false), 0);
        this.signatureEditorPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Utils.nextRow(JavaHierarchyPanel.this.javaHierarchyTree);
            }
        }, KeyStroke.getKeyStroke(40, 0, false), 0);
        this.signatureEditorPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Utils.lastRow(JavaHierarchyPanel.this.javaHierarchyTree);
            }
        }, KeyStroke.getKeyStroke(35, 0, false), 0);
        this.filterTextField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object node;
                TreePath treePath = JavaHierarchyPanel.this.javaHierarchyTree.getSelectionPath();
                if (treePath != null && (node = treePath.getLastPathComponent()) instanceof JavaElement) {
                    JavaHierarchyPanel.this.applyFilter();
                }
            }
        }, KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), true), 0);
        this.filterTextField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object node;
                TreePath treePath = JavaHierarchyPanel.this.javaHierarchyTree.getSelectionPath();
                if (treePath != null && (node = treePath.getLastPathComponent()) instanceof JavaElement) {
                    JavaHierarchyPanel.this.gotoElement((JavaElement)node);
                }
            }
        }, KeyStroke.getKeyStroke(10, 0, true), 0);
        this.filterTextField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Component view = JavaHierarchyPanel.this.docPane.getViewport().getView();
                if (view instanceof JEditorPane) {
                    JEditorPane editorPane = (JEditorPane)view;
                    ActionListener actionForKeyStroke = editorPane.getActionForKeyStroke(KeyStroke.getKeyStroke(33, 0, false));
                    actionForKeyStroke.actionPerformed(new ActionEvent(editorPane, 1001, ""));
                }
            }
        }, KeyStroke.getKeyStroke(33, 1, false), 0);
        this.filterTextField.registerKeyboardAction(new ActionListener(){
            private boolean firstTime = true;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Component view = JavaHierarchyPanel.this.docPane.getViewport().getView();
                if (view instanceof JEditorPane) {
                    JEditorPane editorPane = (JEditorPane)view;
                    ActionListener actionForKeyStroke = editorPane.getActionForKeyStroke(KeyStroke.getKeyStroke(34, 0, false));
                    actionEvent = new ActionEvent(editorPane, 1001, "");
                    actionForKeyStroke.actionPerformed(actionEvent);
                    if (this.firstTime) {
                        actionForKeyStroke.actionPerformed(actionEvent);
                        this.firstTime = false;
                    }
                }
            }
        }, KeyStroke.getKeyStroke(34, 1, false), 0);
        this.caseSensitiveFilterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaMembersAndHierarchyOptions.setCaseSensitive(JavaHierarchyPanel.this.caseSensitiveFilterCheckBox.isSelected());
                if (JavaHierarchyPanel.this.filterTextField.getText().trim().length() > 0) {
                    JavaHierarchyPanel.this.selectMatchingRow();
                }
            }
        });
        this.javaHierarchyTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                Object node;
                Point point = me.getPoint();
                TreePath treePath = JavaHierarchyPanel.this.javaHierarchyTree.getPathForLocation(point.x, point.y);
                if (treePath != null && (node = treePath.getLastPathComponent()) instanceof JavaElement) {
                    if (me.getClickCount() == 1) {
                        if (me.isControlDown()) {
                            JavaElement javaToolsJavaElement = (JavaElement)node;
                            JavaHierarchyPanel.this.applyFilter();
                        }
                    } else if (me.getClickCount() == 2) {
                        JavaHierarchyPanel.this.gotoElement((JavaElement)node);
                    }
                }
            }
        });
        this.javaHierarchyTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                JavaHierarchyPanel.this.showSignature();
                JavaHierarchyPanel.this.showJavaDoc();
            }
        });
        this.javaHierarchyTree.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object node;
                TreePath treePath = JavaHierarchyPanel.this.javaHierarchyTree.getLeadSelectionPath();
                if (treePath != null && (node = treePath.getLastPathComponent()) instanceof JavaElement) {
                    JavaHierarchyPanel.this.gotoElement((JavaElement)node);
                }
            }
        }, KeyStroke.getKeyStroke(10, 0, true), 0);
        this.javaHierarchyTree.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object node;
                TreePath treePath = JavaHierarchyPanel.this.javaHierarchyTree.getLeadSelectionPath();
                if (treePath != null && (node = treePath.getLastPathComponent()) instanceof JavaElement) {
                    JavaHierarchyPanel.this.applyFilter();
                }
            }
        }, KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), true), 0);
        this.showSuperTypeHierarchyToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!JavaMembersAndHierarchyOptions.isShowSuperTypeHierarchy()) {
                    JavaHierarchyPanel.this.applyFilter(true);
                }
            }
        });
        this.showSubTypeHierarchyToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!JavaMembersAndHierarchyOptions.isShowSubTypeHierarchy()) {
                    JavaHierarchyPanel.this.applyFilter(true);
                }
            }
        });
        this.showFQNToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaMembersAndHierarchyOptions.setShowFQN(JavaHierarchyPanel.this.showFQNToggleButton.isSelected());
                JavaHierarchyPanel.this.javaHierarchyModel.fireTreeStructureChanged();
            }
        });
        this.showInnerToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaHierarchyPanel.this.applyFilter(true);
            }
        });
        this.expandAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaHierarchyPanel.this.expandAll();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaHierarchyPanel.this.close();
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JavaHierarchyPanel.this.applyFilter(true);
                JavaHierarchyPanel.this.filterTextField.requestFocusInWindow();
            }
        });
    }

    @Override
    public void removeNotify() {
        JavaMembersAndHierarchyOptions.setHierarchyDividerLocation(this.splitPane.getDividerLocation());
        this.docPane.setData(null);
        super.removeNotify();
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        JRootPane rootPane;
        if ((e.getKeyCode() == 112 || e.getKeyCode() == 156) && (rootPane = SwingUtilities.getRootPane(this)) != null) {
            rootPane.putClientProperty("help", Boolean.TRUE);
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    private void enterBusy() {
        Window window;
        this.javaHierarchyTree.setModel(pleaseWaitTreeModel);
        JRootPane rootPane = SwingUtilities.getRootPane(this);
        if (rootPane != null) {
            rootPane.setCursor(Cursor.getPredefinedCursor(3));
        }
        if ((window = SwingUtilities.getWindowAncestor(this)) != null) {
            this.lastFocusedComponent = window.getFocusOwner();
        }
        this.filterTextField.setEnabled(false);
        this.caseSensitiveFilterCheckBox.setEnabled(false);
        this.showSubTypeHierarchyToggleButton.setEnabled(false);
        this.showSuperTypeHierarchyToggleButton.setEnabled(false);
        this.showFQNToggleButton.setEnabled(false);
        this.showInnerToggleButton.setEnabled(false);
        this.expandAllButton.setEnabled(false);
    }

    private void leaveBusy() {
        this.javaHierarchyTree.setModel(this.javaHierarchyModel);
        JRootPane rootPane = SwingUtilities.getRootPane(this);
        if (rootPane != null) {
            rootPane.setCursor(Cursor.getDefaultCursor());
        }
        this.filterTextField.setEnabled(true);
        this.caseSensitiveFilterCheckBox.setEnabled(true);
        this.showSubTypeHierarchyToggleButton.setEnabled(true);
        this.showSuperTypeHierarchyToggleButton.setEnabled(true);
        this.showFQNToggleButton.setEnabled(true);
        this.showInnerToggleButton.setEnabled(true);
        this.expandAllButton.setEnabled(true);
        if (this.lastFocusedComponent != null) {
            if (this.lastFocusedComponent.isDisplayable()) {
                this.lastFocusedComponent.requestFocusInWindow();
            }
            this.lastFocusedComponent = null;
        }
    }

    private void applyFilter() {
        this.applyFilter(true);
    }

    private void applyFilter(final boolean structural) {
        if (structural) {
            this.enterBusy();
        }
        JavaMembersAndHierarchyOptions.setCaseSensitive(this.caseSensitiveFilterCheckBox.isSelected());
        JavaMembersAndHierarchyOptions.setShowSuperTypeHierarchy(this.showSuperTypeHierarchyToggleButton.isSelected());
        JavaMembersAndHierarchyOptions.setShowSubTypeHierarchy(this.showSubTypeHierarchyToggleButton.isSelected());
        JavaMembersAndHierarchyOptions.setShowFQN(this.showFQNToggleButton.isSelected());
        JavaMembersAndHierarchyOptions.setShowInner(this.showInnerToggleButton.isSelected());
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (structural) {
                        JavaHierarchyPanel.this.javaHierarchyModel.update();
                    }
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (structural) {
                                JavaHierarchyPanel.this.leaveBusy();
                            }
                            for (int row = 0; row < JavaHierarchyPanel.this.javaHierarchyTree.getRowCount(); ++row) {
                                TreePath treePath = JavaHierarchyPanel.this.javaHierarchyTree.getPathForRow(row);
                                if (JavaMembersAndHierarchyOptions.isShowSubTypeHierarchy()) {
                                    if (treePath.getPathCount() >= JavaMembersAndHierarchyOptions.getSubTypeHierarchyDepth()) continue;
                                    JavaHierarchyPanel.this.javaHierarchyTree.expandRow(row);
                                    continue;
                                }
                                JavaHierarchyPanel.this.javaHierarchyTree.expandRow(row);
                            }
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    private void expandAll() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JRootPane rootPane = SwingUtilities.getRootPane(JavaHierarchyPanel.this);
                if (rootPane != null) {
                    rootPane.setCursor(Cursor.getPredefinedCursor(3));
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    for (int row = 0; row < JavaHierarchyPanel.this.javaHierarchyTree.getRowCount(); ++row) {
                        JavaHierarchyPanel.this.javaHierarchyTree.expandRow(row);
                    }
                    JavaHierarchyPanel.this.selectMatchingRow();
                }
                finally {
                    JRootPane rootPane = SwingUtilities.getRootPane(JavaHierarchyPanel.this);
                    if (rootPane != null) {
                        rootPane.setCursor(Cursor.getDefaultCursor());
                    }
                }
            }
        });
    }

    private void selectMatchingRow() {
        this.filterTextField.setForeground(UIManager.getColor("TextField.foreground"));
        this.javaHierarchyTree.setSelectionRow(-1);
        for (int row = 0; row < this.javaHierarchyTree.getRowCount(); ++row) {
            String filterText;
            Object o = this.javaHierarchyTree.getPathForRow(row).getLastPathComponent();
            if (!(o instanceof JavaElement) || !Utils.patternMatch((JavaElement)o, filterText = this.filterTextField.getText(), filterText.toLowerCase())) continue;
            this.javaHierarchyTree.setSelectionRow(row);
            this.javaHierarchyTree.scrollRowToVisible(row);
            return;
        }
        this.filterTextField.setForeground(Color.RED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gotoElement(JavaElement javaToolsJavaElement) {
        try {
            javaToolsJavaElement.gotoElement();
        }
        finally {
            this.close();
        }
    }

    private void showSignature() {
        Object node;
        this.signatureEditorPane.setText("");
        this.signatureEditorPane.setToolTipText(null);
        TreePath treePath = this.javaHierarchyTree.getSelectionPath();
        if (treePath != null && (node = treePath.getLastPathComponent()) instanceof JavaElement) {
            this.signatureEditorPane.setText(((JavaElement)node).getTooltip());
            this.signatureEditorPane.setCaretPosition(0);
            this.signatureEditorPane.setToolTipText(((JavaElement)node).getTooltip());
        }
    }

    private void showJavaDoc() {
        Object node;
        TreePath treePath = this.javaHierarchyTree.getSelectionPath();
        if (treePath != null && (node = treePath.getLastPathComponent()) instanceof JavaElement) {
            this.docPane.setData(((JavaElement)node).getJavaDoc());
        }
    }

    private void close() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            ResizablePopup.cleanup(window);
        }
    }

    private void initComponents() {
        this.javaHierarchyModeButtonGroup = new ButtonGroup();
        this.filterLabel = new JLabel();
        this.filterTextField = new JTextField();
        this.caseSensitiveFilterCheckBox = new JCheckBox();
        this.splitPane = new JSplitPane();
        this.javaHierarchyTreeScrollPane = new JScrollPane();
        this.javaHierarchyTree = new JTree();
        this.signatureEditorPane = new JEditorPane();
        this.filtersLabel = new JLabel();
        this.closeButton = new JButton();
        this.filtersToolbar = new NoBorderToolBar();
        this.showSuperTypeHierarchyToggleButton = new JToggleButton();
        this.showSubTypeHierarchyToggleButton = new JToggleButton();
        this.showFQNToggleButton = new JToggleButton();
        this.showInnerToggleButton = new JToggleButton();
        this.expandAllButton = new JButton();
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.filterLabel.setLabelFor(this.filterTextField);
        Mnemonics.setLocalizedText((JLabel)this.filterLabel, (String)NbBundle.getBundle(JavaHierarchyPanel.class).getString("LABEL_filterLabel"));
        this.filterTextField.setToolTipText(NbBundle.getBundle(JavaHierarchyPanel.class).getString("TOOLTIP_filterTextField"));
        Mnemonics.setLocalizedText((AbstractButton)this.caseSensitiveFilterCheckBox, (String)NbBundle.getBundle(JavaHierarchyPanel.class).getString("LABEL_caseSensitiveFilterCheckBox"));
        this.caseSensitiveFilterCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.splitPane.setDividerLocation(350);
        this.splitPane.setOneTouchExpandable(true);
        this.javaHierarchyTreeScrollPane.setBorder(null);
        this.javaHierarchyTreeScrollPane.setViewportView(this.javaHierarchyTree);
        this.javaHierarchyTree.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JavaHierarchyPanel.class, (String)"ACSN_JavaHierarchyTree"));
        this.javaHierarchyTree.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavaHierarchyPanel.class, (String)"ACSD_JavaHierarchyTree"));
        this.splitPane.setLeftComponent(this.javaHierarchyTreeScrollPane);
        this.signatureEditorPane.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Nb.ScrollPane.Border.color")));
        this.signatureEditorPane.setContentType("text/x-java");
        this.signatureEditorPane.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)this.filtersLabel, (String)NbBundle.getMessage(JavaHierarchyPanel.class, (String)"LABEL_filtersLabel"));
        Mnemonics.setLocalizedText((AbstractButton)this.closeButton, (String)NbBundle.getMessage(JavaHierarchyPanel.class, (String)"LABEL_Close"));
        this.filtersToolbar.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.filtersToolbar.setFloatable(false);
        this.filtersToolbar.setBorderPainted(false);
        this.filtersToolbar.setOpaque(false);
        this.javaHierarchyModeButtonGroup.add(this.showSuperTypeHierarchyToggleButton);
        this.showSuperTypeHierarchyToggleButton.setIcon(JavaMembersAndHierarchyIcons.SUPER_TYPE_HIERARCHY_ICON);
        this.showSuperTypeHierarchyToggleButton.setMnemonic('S');
        this.showSuperTypeHierarchyToggleButton.setSelected(true);
        this.showSuperTypeHierarchyToggleButton.setToolTipText(NbBundle.getBundle(JavaHierarchyPanel.class).getString("TOOLTIP_showSuperTypeHierarchyToggleButton"));
        this.filtersToolbar.add(this.showSuperTypeHierarchyToggleButton);
        this.javaHierarchyModeButtonGroup.add(this.showSubTypeHierarchyToggleButton);
        this.showSubTypeHierarchyToggleButton.setIcon(JavaMembersAndHierarchyIcons.SUB_TYPE_HIERARCHY_ICON);
        this.showSubTypeHierarchyToggleButton.setMnemonic('B');
        this.showSubTypeHierarchyToggleButton.setToolTipText(NbBundle.getBundle(JavaHierarchyPanel.class).getString("TOOLTIP_showSubTypeHierarchyToggleButton"));
        this.filtersToolbar.add(this.showSubTypeHierarchyToggleButton);
        this.showFQNToggleButton.setIcon(JavaMembersAndHierarchyIcons.FQN_ICON);
        this.showFQNToggleButton.setMnemonic('Q');
        this.showFQNToggleButton.setToolTipText(NbBundle.getBundle(JavaHierarchyPanel.class).getString("TOOLTIP_showFQNToggleButton"));
        this.filtersToolbar.add(this.showFQNToggleButton);
        this.showInnerToggleButton.setIcon(JavaMembersAndHierarchyIcons.INNER_CLASS_ICON);
        this.showInnerToggleButton.setMnemonic('I');
        this.showInnerToggleButton.setSelected(true);
        this.showInnerToggleButton.setToolTipText(NbBundle.getBundle(JavaHierarchyPanel.class).getString("TOOLTIP_showInnerToggleButton"));
        this.filtersToolbar.add(this.showInnerToggleButton);
        this.expandAllButton.setIcon(JavaMembersAndHierarchyIcons.EXPAND_ALL_ICON);
        this.expandAllButton.setMnemonic('E');
        this.expandAllButton.setToolTipText(NbBundle.getMessage(JavaHierarchyPanel.class, (String)"TOOLTIP_expandAll"));
        this.expandAllButton.setMargin(new Insets(2, 2, 2, 2));
        this.filtersToolbar.add(this.expandAllButton);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.splitPane, -1, 797, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.filterLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filterTextField, -1, 614, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.caseSensitiveFilterCheckBox)).addComponent(this.signatureEditorPane, -1, 797, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.filtersLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filtersToolbar, -1, 655, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.filterLabel).addComponent(this.caseSensitiveFilterCheckBox).addComponent(this.filterTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.splitPane, -1, 79, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.signatureEditorPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.filtersLabel).addComponent(this.closeButton)).addComponent(this.filtersToolbar, -2, 25, -2)).addContainerGap()));
        this.caseSensitiveFilterCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavaHierarchyPanel.class, (String)"caseSensitiveFilterCheckBox_ACSD"));
    }

    static {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        root.add(new DefaultMutableTreeNode(NbBundle.getMessage(JavaHierarchyPanel.class, (String)"LBL_WaitNode")));
        pleaseWaitTreeModel = new DefaultTreeModel(root);
        RP = new RequestProcessor(JavaHierarchyPanel.class.getName(), 1, false, false);
    }
}

