/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.util.ArrayList;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.modules.profiler.api.EditorSupport;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilingSettingsManager;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.java.JavaProfilerSource;
import org.netbeans.modules.profiler.api.java.SourceMethodInfo;
import org.netbeans.modules.profiler.ui.NBSwingWorker;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class AddRootMethodAction
extends NodeAction {
    public AddRootMethodAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return NbBundle.getMessage(AddRootMethodAction.class, (String)"LBL_AddRootMethodAction");
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] nodes) {
        return true;
    }

    protected void performAction(final Node[] nodes) {
        new NBSwingWorker(){

            protected void doInBackground() {
                try {
                    DataObject dobj = (DataObject)nodes[0].getLookup().lookup(DataObject.class);
                    if (dobj == null) {
                        return;
                    }
                    JavaProfilerSource src = JavaProfilerSource.createFrom((FileObject)dobj.getPrimaryFile());
                    if (src == null) {
                        return;
                    }
                    int currentOffsetInEditor = EditorSupport.getCurrentOffset();
                    if (currentOffsetInEditor == -1) {
                        return;
                    }
                    SourceMethodInfo resolvedMethod = src.resolveMethodAtPosition(currentOffsetInEditor);
                    if (resolvedMethod == null) {
                        ProfilerDialogs.displayWarning((String)NbBundle.getMessage(AddRootMethodAction.class, (String)"MSG_NoMethodFoundAtPosition"));
                        return;
                    }
                    if (resolvedMethod == null) {
                        return;
                    }
                    if (!resolvedMethod.isExecutable()) {
                        ProfilerDialogs.displayInfo((String)NbBundle.getMessage(AddRootMethodAction.class, (String)"MSG_CannotAddAbstractNativeProfilingRoot"));
                        return;
                    }
                    Lookup.Provider project = ProjectUtilities.getProject((FileObject)dobj.getPrimaryFile());
                    ProfilingSettings[] projectSettings = ProfilingSettingsManager.getProfilingSettings((Lookup.Provider)project).getProfilingSettings();
                    ArrayList<ProfilingSettings> cpuSettings = new ArrayList<ProfilingSettings>();
                    for (ProfilingSettings settings : projectSettings) {
                        if (!ProfilingSettings.isCPUSettings((int)settings.getProfilingType())) continue;
                        cpuSettings.add(settings);
                    }
                    ProfilingSettings settings = IDEUtils.selectSettings(16, cpuSettings.toArray(new ProfilingSettings[cpuSettings.size()]), null);
                    if (settings == null) {
                        return;
                    }
                    settings.addRootMethod(resolvedMethod.getClassName(), resolvedMethod.getVMName(), resolvedMethod.getSignature());
                    if (cpuSettings.contains(settings)) {
                        ProfilingSettingsManager.storeProfilingSettings((ProfilingSettings[])projectSettings, (ProfilingSettings)settings, (Lookup.Provider)project);
                    } else {
                        ProfilingSettings[] newProjectSettings = new ProfilingSettings[projectSettings.length + 1];
                        System.arraycopy(projectSettings, 0, newProjectSettings, 0, projectSettings.length);
                        newProjectSettings[projectSettings.length] = settings;
                        ProfilingSettingsManager.storeProfilingSettings((ProfilingSettings[])newProjectSettings, (ProfilingSettings)settings, (Lookup.Provider)project);
                    }
                }
                catch (Exception ex) {
                    ProfilerDialogs.displayWarning((String)NbBundle.getMessage(AddRootMethodAction.class, (String)"MSG_ProblemAddingRootMethod"));
                }
            }
        }.execute();
    }
}

