/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.project.execuiimpl;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Types;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2me.cdc.platform.CDCPlatform;
import org.netbeans.modules.j2me.cdc.project.execui.MainClassChooser;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MainClassChooserImpl
extends MainClassChooser {
    protected ChangeListener changeListener;
    private String dialogSubtitle = null;
    protected List<String> possibleMainClasses;
    private FileObject sourcesRoot;
    private String bcp;
    protected boolean onlyMain;
    protected String mainClass;
    protected Map<String, String> executionModes;
    protected String specialExecFqnXlet;
    protected String specialExecFqnApplet;
    public static Boolean unitTestingSupport_hasMainMethodResult = null;
    private JRadioButton appletExecution;
    private ButtonGroup buttonGroup1;
    private JLabel jLabel1;
    private JList jMainClassList;
    private JScrollPane jScrollPane1;
    private JRadioButton mainExecution;
    private JCheckBox multipleXlets;
    private JLabel onlymainLabel;
    private JRadioButton xletExecution;

    public MainClassChooserImpl() {
        this.initComponents();
    }

    public void inicialize(FileObject sourceRoot, Map<String, String> executionModes, String bootcp) {
        this.dialogSubtitle = null;
        this.sourcesRoot = sourceRoot;
        this.onlyMain = false;
        this.executionModes = executionModes;
        this.initClassesView(this.sourcesRoot);
        if (this.onlyMain) {
            this.onlymainLabel.setText(NbBundle.getMessage(MainClassChooserImpl.class, (String)"MSG_OnlyMainAllowed"));
        }
        this.bcp = bootcp;
        this.specialExecFqnXlet = executionModes != null ? executionModes.get(CDCPlatform.PROP_EXEC_XLET) : null;
        this.specialExecFqnApplet = executionModes != null ? executionModes.get(CDCPlatform.PROP_EXEC_APPLET) : null;
    }

    private void initClassesView(final FileObject sourcesRoot) {
        this.possibleMainClasses = null;
        this.jMainClassList.setSelectionMode(0);
        this.jMainClassList.setListData(this.getWarmupList());
        this.jMainClassList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                MainClassChooserImpl.this.checkSelectionOptions();
                if (MainClassChooserImpl.this.changeListener != null) {
                    MainClassChooserImpl.this.changeListener.stateChanged(new ChangeEvent(evt));
                }
            }
        });
        this.jMainClassList.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isDoubleClick((MouseEvent)e) && MainClassChooserImpl.this.getSelectedMainClass() != null && MainClassChooserImpl.this.changeListener != null) {
                    MainClassChooserImpl.this.changeListener.stateChanged(new ChangeEvent(e));
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                MainClassChooserImpl.this.possibleMainClasses = MainClassChooserImpl.getMainClasses(new FileObject[]{sourcesRoot}, MainClassChooserImpl.this.executionModes, MainClassChooserImpl.this.bcp);
                if (MainClassChooserImpl.this.possibleMainClasses.isEmpty()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MainClassChooserImpl.this.jMainClassList.setListData(new String[]{NbBundle.getMessage(MainClassChooserImpl.class, (String)"LBL_ChooseMainClass_NO_CLASSES_NODE")});
                        }
                    });
                } else {
                    Object[] arr = MainClassChooserImpl.this.possibleMainClasses.toArray(new String[0]);
                    Arrays.sort(arr);
                    if (MainClassChooserImpl.this.onlyMain) {
                        final ArrayList<String> l = new ArrayList<String>(MainClassChooserImpl.this.possibleMainClasses);
                        Iterator it = l.iterator();
                        while (it.hasNext()) {
                            String elem = (String)it.next();
                            if (MainClassChooserImpl.isMainClass(elem, sourcesRoot) && (MainClassChooserImpl.this.executionModes == null || !MainClassChooserImpl.this.executionModes.containsKey(CDCPlatform.PROP_EXEC_MAIN))) continue;
                            it.remove();
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Object[] arr = l.toArray(new String[0]);
                                if (arr.length == 0) {
                                    MainClassChooserImpl.this.jMainClassList.setListData(new String[]{NbBundle.getMessage(MainClassChooserImpl.class, (String)"LBL_ChooseMainClass_NO_CLASSES_NODE")});
                                    return;
                                }
                                Arrays.sort(arr);
                                MainClassChooserImpl.this.jMainClassList.setListData(arr);
                                MainClassChooserImpl.this.jMainClassList.setSelectedIndex(0);
                            }
                        });
                        return;
                    }
                    boolean xlet = false;
                    if (!MainClassChooserImpl.this.possibleMainClasses.isEmpty()) {
                        for (String elem : MainClassChooserImpl.this.possibleMainClasses) {
                            if (!MainClassChooserImpl.isXletClass(elem, sourcesRoot, MainClassChooserImpl.this.specialExecFqnXlet)) continue;
                            xlet = true;
                            break;
                        }
                        if (xlet && MainClassChooserImpl.this.mainClass != null && MainClassChooserImpl.this.mainClass.indexOf(59) != -1) {
                            int i;
                            final String[] xlets = MainClassChooserImpl.this.updateListView(true);
                            StringTokenizer st = new StringTokenizer(MainClassChooserImpl.this.mainClass, ";");
                            ArrayList<Integer> indicies = new ArrayList<Integer>();
                            while (st.hasMoreTokens()) {
                                String token = st.nextToken();
                                for (i = 0; i < xlets.length; ++i) {
                                    if (!token.equals(xlets[i])) continue;
                                    indicies.add(new Integer(i));
                                }
                            }
                            final int[] sel = new int[indicies.size()];
                            for (i = 0; i < sel.length; ++i) {
                                sel[i] = (Integer)indicies.get(i);
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    int[] nArray;
                                    MainClassChooserImpl.this.multipleXlets.setSelected(sel.length > 1);
                                    MainClassChooserImpl.this.jMainClassList.setListData(xlets);
                                    JList jList = MainClassChooserImpl.this.jMainClassList;
                                    if (sel.length != 0) {
                                        nArray = sel;
                                    } else {
                                        int[] nArray2 = new int[1];
                                        nArray = nArray2;
                                        nArray2[0] = 0;
                                    }
                                    jList.setSelectedIndices(nArray);
                                }
                            });
                        } else {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    MainClassChooserImpl.this.jMainClassList.setListData(MainClassChooserImpl.this.updateListView(false));
                                    if (MainClassChooserImpl.this.mainClass != null && MainClassChooserImpl.this.isValidMainClassName(MainClassChooserImpl.this.mainClass)) {
                                        MainClassChooserImpl.this.jMainClassList.setSelectedValue(MainClassChooserImpl.this.mainClass, true);
                                    } else {
                                        MainClassChooserImpl.this.jMainClassList.setSelectedIndex(0);
                                    }
                                }
                            });
                        }
                        MainClassChooserImpl.this.checkSelectionOptions();
                    }
                }
            }
        });
        if (this.dialogSubtitle != null) {
            Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)this.dialogSubtitle);
        }
    }

    protected void checkSelectionOptions() {
        if (!this.multipleXlets.isSelected()) {
            String tmpMainClass = this.getSelectedMainClass();
            if (tmpMainClass == null) {
                tmpMainClass = this.mainClass;
            }
            final String mainClass = tmpMainClass;
            final boolean[] isMain = new boolean[]{false};
            final boolean[] isXlet = new boolean[]{false};
            final boolean[] isApplet = new boolean[]{false};
            RequestProcessor.Task task = RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    isMain[0] = MainClassChooserImpl.isMainClass(mainClass, MainClassChooserImpl.this.sourcesRoot);
                    isXlet[0] = MainClassChooserImpl.isXletClass(mainClass, MainClassChooserImpl.this.sourcesRoot, MainClassChooserImpl.this.specialExecFqnXlet);
                    isApplet[0] = MainClassChooserImpl.isAppletClass(mainClass, MainClassChooserImpl.this.sourcesRoot, MainClassChooserImpl.this.specialExecFqnApplet);
                }
            });
            task.waitFinished();
            this.mainExecution.setEnabled(isMain[0] && (this.executionModes == null || this.executionModes.containsKey(CDCPlatform.PROP_EXEC_MAIN)));
            this.xletExecution.setEnabled(isXlet[0] && !this.onlyMain && (this.executionModes == null || this.executionModes.containsKey(CDCPlatform.PROP_EXEC_XLET)));
            this.appletExecution.setEnabled(isApplet[0] && !this.onlyMain && (this.executionModes == null || this.executionModes.containsKey(CDCPlatform.PROP_EXEC_APPLET)));
            this.multipleXlets.setEnabled(isXlet[0] && (this.executionModes == null || this.executionModes.containsKey(CDCPlatform.PROP_EXEC_XLET)));
            if (isApplet[0] && this.appletExecution.isSelected()) {
                return;
            }
            if (isXlet[0] && this.xletExecution.isSelected()) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (isMain[0] || MainClassChooserImpl.this.onlyMain) {
                        MainClassChooserImpl.this.mainExecution.setSelected(isMain[0]);
                    } else if (isXlet[0]) {
                        MainClassChooserImpl.this.xletExecution.setSelected(isXlet[0]);
                    } else if (isApplet[0]) {
                        MainClassChooserImpl.this.appletExecution.setSelected(isApplet[0]);
                    }
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainClassChooserImpl.this.mainExecution.setEnabled(false);
                    MainClassChooserImpl.this.xletExecution.setEnabled(true);
                    MainClassChooserImpl.this.appletExecution.setEnabled(false);
                    MainClassChooserImpl.this.xletExecution.setSelected(true);
                }
            });
        }
    }

    private Object[] getWarmupList() {
        return new Object[]{NbBundle.getMessage(MainClassChooserImpl.class, (String)"LBL_ChooseMainClass_WARMUP_MESSAGE")};
    }

    protected boolean isValidMainClassName(Object value) {
        return this.possibleMainClasses != null && this.possibleMainClasses.contains(value);
    }

    public String getSelectedMainClass() {
        if (this.isValidMainClassName(this.jMainClassList.getSelectedValue()) && !this.multipleXlets.isSelected()) {
            return (String)this.jMainClassList.getSelectedValue();
        }
        if (this.multipleXlets.isSelected()) {
            Object[] classes = this.jMainClassList.getSelectedValues();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < classes.length; ++i) {
                if (!this.isValidMainClassName(classes[i])) continue;
                sb.append(classes[i]);
                sb.append(';');
            }
            return sb.length() != 0 ? sb.toString().substring(0, sb.length() - 1) : null;
        }
        return null;
    }

    public void setSelectedMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public boolean isXletExecution() {
        return this.xletExecution.isSelected();
    }

    public void setXletExecution(boolean selected) {
        this.xletExecution.setSelected(selected);
    }

    public boolean isAppletExecution() {
        return this.appletExecution.isSelected();
    }

    public void setAppletExecution(boolean selected) {
        this.appletExecution.setSelected(selected);
    }

    public synchronized void addChangeListener(ChangeListener l) {
        this.changeListener = l;
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        this.changeListener = null;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jMainClassList = new JList();
        this.mainExecution = new JRadioButton();
        this.xletExecution = new JRadioButton();
        this.appletExecution = new JRadioButton();
        this.multipleXlets = new JCheckBox();
        this.onlymainLabel = new JLabel();
        this.setPreferredSize(new Dimension(380, 300));
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.jMainClassList);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getBundle(MainClassChooserImpl.class).getString("CTL_AvaialableMainClasses"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 2, 12);
        this.add(this.jLabel1, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(100, 200));
        this.jScrollPane1.setViewportView(this.jMainClassList);
        this.jMainClassList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MainClassChooserImpl.class, (String)"ACSN_jMainClassList"));
        this.jMainClassList.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(MainClassChooserImpl.class).getString("ACSD_jMainClassList"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.add(this.jScrollPane1, gridBagConstraints);
        this.buttonGroup1.add(this.mainExecution);
        this.mainExecution.setSelected(true);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/j2me/cdc/project/execuiimpl/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.mainExecution, (String)bundle.getString("LBL_RunAsMain"));
        this.mainExecution.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.mainExecution.setEnabled(false);
        this.mainExecution.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add(this.mainExecution, gridBagConstraints);
        this.mainExecution.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MainClassChooserImpl.class, (String)"ACSN_CustomizerRun_Main"));
        this.mainExecution.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MainClassChooserImpl.class, (String)"ACSD_CustomizerRun_Main"));
        this.buttonGroup1.add(this.xletExecution);
        Mnemonics.setLocalizedText((AbstractButton)this.xletExecution, (String)bundle.getString("LBL_RunAsXlet"));
        this.xletExecution.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.xletExecution.setEnabled(false);
        this.xletExecution.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add(this.xletExecution, gridBagConstraints);
        this.xletExecution.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MainClassChooserImpl.class, (String)"ACSN_CustomizerRun_Xlet"));
        this.xletExecution.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MainClassChooserImpl.class, (String)"ACSD_CustomizerRun_Xlet"));
        this.buttonGroup1.add(this.appletExecution);
        Mnemonics.setLocalizedText((AbstractButton)this.appletExecution, (String)bundle.getString("LBL_RunAsApplet"));
        this.appletExecution.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.appletExecution.setEnabled(false);
        this.appletExecution.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add(this.appletExecution, gridBagConstraints);
        this.appletExecution.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MainClassChooserImpl.class, (String)"ACSN_CustomizerRun_Applet"));
        this.appletExecution.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MainClassChooserImpl.class, (String)"ACSD_CustomizerRun_Applet"));
        Mnemonics.setLocalizedText((AbstractButton)this.multipleXlets, (String)bundle.getString("LBL_AllowMultipleXlets"));
        this.multipleXlets.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.multipleXlets.setEnabled(false);
        this.multipleXlets.setMargin(new Insets(0, 0, 0, 0));
        this.multipleXlets.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainClassChooserImpl.this.multipleXletsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add(this.multipleXlets, gridBagConstraints);
        this.multipleXlets.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MainClassChooserImpl.class, (String)"ACSN_CustomizerRun_AllowMultiple"));
        this.multipleXlets.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MainClassChooserImpl.class, (String)"ACSD_CustomizerRun_AllowMultiple"));
        this.onlymainLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add(this.onlymainLabel, gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(MainClassChooserImpl.class).getString("AD_MainClassChooser"));
    }

    private void multipleXletsActionPerformed(ActionEvent evt) {
        boolean xlets = this.multipleXlets.isSelected();
        String[] arr = this.updateListView(xlets);
        this.jMainClassList.setListData(arr);
        this.jMainClassList.setSelectedIndex(0);
        this.checkSelectionOptions();
    }

    protected String[] updateListView(boolean onlyXlets) {
        if (onlyXlets) {
            this.jMainClassList.setSelectionMode(2);
            ArrayList<String> l = new ArrayList<String>(this.possibleMainClasses);
            Iterator it = l.iterator();
            while (it.hasNext()) {
                String elem = (String)it.next();
                if (MainClassChooserImpl.isXletClass(elem, this.sourcesRoot, this.specialExecFqnXlet)) continue;
                it.remove();
            }
            Object[] arr = l.toArray(new String[0]);
            Arrays.sort(arr);
            return arr;
        }
        this.jMainClassList.setSelectionMode(0);
        Object[] arr = this.possibleMainClasses.toArray(new String[0]);
        Arrays.sort(arr);
        return arr;
    }

    public static boolean hasMainMethod(FileObject fo) {
        if (fo == null) {
            return false;
        }
        return !SourceUtils.getMainClasses((FileObject)fo).isEmpty();
    }

    public static List<String> getMainClasses(FileObject[] roots, Map<String, String> executionModes, String bootcp) {
        ArrayList<String> result = new ArrayList<String>();
        for (FileObject fo : roots) {
            MainClassChooserImpl.getMainClasses(fo, result, executionModes, bootcp);
        }
        return result;
    }

    private static void getMainClasses(FileObject root, final List<String> addInto, final Map<String, String> executionModes, String bootcp) {
        final String specialXletFqn = executionModes != null ? executionModes.get(CDCPlatform.PROP_EXEC_XLET) : null;
        final String specialAppletFqn = executionModes != null ? executionModes.get(CDCPlatform.PROP_EXEC_APPLET) : null;
        ClassPath bcp = null;
        if (bootcp != null) {
            String[] items = PropertyUtils.tokenizePath((String)bootcp);
            if (items.length > 0) {
                LinkedList<FileObject> bcpRoots = new LinkedList<FileObject>();
                for (String item : items) {
                    File f = new File(item);
                    if (!f.exists()) {
                        Logger.getLogger(MainClassChooserImpl.class.getName()).log(Level.INFO, "Non existent boot class path entry " + item + "'." + "Entire bootclasspath: " + bootcp);
                        continue;
                    }
                    FileObject fo = FileUtil.toFileObject((File)(f = FileUtil.normalizeFile((File)f)));
                    if (fo == null) {
                        Logger.getLogger(MainClassChooserImpl.class.getName()).log(Level.INFO, "Unresolvable boot class path entry '" + item + "'." + "Entire bootclasspath: " + bootcp);
                        continue;
                    }
                    if (FileUtil.isArchiveFile((FileObject)fo)) {
                        bcpRoots.add(FileUtil.getArchiveRoot((FileObject)fo));
                        continue;
                    }
                    bcpRoots.add(fo);
                }
                FileObject[] roots = bcpRoots.toArray(new FileObject[0]);
                bcp = ClassPathSupport.createClassPath((FileObject[])roots);
            }
        } else {
            bcp = ClassPath.getClassPath((FileObject)root, (String)"classpath/boot");
        }
        ClassPath boot = bcp;
        ClassPath rtm2 = ClassPath.getClassPath((FileObject)root, (String)"classpath/execute");
        final ClassPath rtm1 = ClassPath.getClassPath((FileObject)root, (String)"classpath/compile");
        ClassPath rtm = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{rtm1, rtm2});
        ArrayList<ClassPath> srcRoots = new ArrayList<ClassPath>();
        final ArrayList<FileObject> srcRootsFO = new ArrayList<FileObject>();
        ClassPath path = ClassPath.getClassPath((FileObject)root, (String)"classpath/source");
        srcRoots.add(path);
        for (ClassPath.Entry entry : path.entries()) {
            srcRootsFO.add(entry.getRoot());
        }
        Library[] libs = LibraryManager.getDefault().getLibraries();
        HashSet libSet = new HashSet();
        for (Library lib : libs) {
            try {
                List url = lib.getContent("src");
                libSet.addAll(url);
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
        HashSet<URL> entrySet = new HashSet<URL>();
        for (ClassPath.Entry e : rtm2.entries()) {
            FileObject[] roots;
            SourceForBinaryQuery.Result res = null;
            try {
                res = SourceForBinaryQuery.findSourceRoots((URL)e.getURL());
            }
            catch (Exception ex) {
                // empty catch block
            }
            for (FileObject r : roots = res.getRoots()) {
                path = ClassPath.getClassPath((FileObject)r, (String)"classpath/source");
                entrySet.clear();
                for (ClassPath.Entry entry : path.entries()) {
                    entrySet.add(entry.getURL());
                }
                entrySet.removeAll(libSet);
                if (srcRoots.contains(path) || entrySet.size() <= 0) continue;
                srcRoots.add(path);
                for (ClassPath.Entry entry : path.entries()) {
                    srcRootsFO.add(entry.getRoot());
                }
            }
        }
        final ClassPath src = ClassPathSupport.createProxyClassPath((ClassPath[])srcRoots.toArray(new ClassPath[srcRoots.size()]));
        ClasspathInfo cpInfo = ClasspathInfo.create((ClassPath)boot, (ClassPath)rtm, (ClassPath)src);
        JavaSource js = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[0]);
        try {
            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){
                HashSet<ClassIndex.SearchKind> sk = new HashSet();
                HashSet<ClassIndex.SearchScope> ss = new HashSet();
                CompilationController control;

                Collection<ElementHandle<TypeElement>> addChildren(ClassIndex index, Collection<ElementHandle<TypeElement>> elems) {
                    ArrayList<ElementHandle<TypeElement>> elcl = new ArrayList<ElementHandle<TypeElement>>();
                    for (ElementHandle<TypeElement> elem : elems) {
                        Set newEl = index.getElements(elem, this.sk, this.ss);
                        if (newEl.size() != 0) {
                            elcl.addAll(this.addChildren(index, newEl));
                        }
                        elcl.add(elem);
                    }
                    return elcl;
                }

                public void run(CompilationController control) throws Exception {
                    control.toPhase(JavaSource.Phase.RESOLVED);
                    TypeElement xlet = control.getElements().getTypeElement(specialXletFqn != null ? specialXletFqn : "javax.microedition.xlet.Xlet");
                    TypeElement applet = control.getElements().getTypeElement(specialAppletFqn != null ? specialAppletFqn : "java.applet.Applet");
                    this.sk.add(ClassIndex.SearchKind.IMPLEMENTORS);
                    this.ss.add(ClassIndex.SearchScope.SOURCE);
                    this.ss.add(ClassIndex.SearchScope.DEPENDENCIES);
                    Collection<ElementHandle<TypeElement>> arr = new ArrayList();
                    if (executionModes == null || executionModes != null && executionModes.containsKey(CDCPlatform.PROP_EXEC_MAIN)) {
                        arr = SourceUtils.getMainClasses((FileObject[])srcRootsFO.toArray(new FileObject[srcRootsFO.size()]));
                    }
                    ArrayList<ElementHandle<TypeElement>> exec = new ArrayList<ElementHandle<TypeElement>>();
                    Types types = control.getTypes();
                    if (xlet != null && (executionModes == null || executionModes.containsKey(CDCPlatform.PROP_EXEC_XLET))) {
                        exec.add(ElementHandle.create((Element)xlet));
                    }
                    if (applet != null && (executionModes == null || executionModes.containsKey(CDCPlatform.PROP_EXEC_APPLET))) {
                        exec.add(ElementHandle.create((Element)applet));
                    }
                    if (arr == null && exec.size() == 0) {
                        return;
                    }
                    ClasspathInfo newInfo = ClasspathInfo.create((ClassPath)rtm1, (ClassPath)rtm1, (ClassPath)src);
                    ClassIndex index = newInfo.getClassIndex();
                    arr.addAll(this.addChildren(index, exec));
                    arr.removeAll(exec);
                    for (ElementHandle elementHandle : arr) {
                        TypeElement elem = (TypeElement)elementHandle.resolve((CompilationInfo)control);
                        if (elem == null) continue;
                        addInto.add(elem.getQualifiedName().toString());
                    }
                }

                public void cancel() {
                }
            }, true);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static boolean isMainClass(String className, FileObject root) {
        ClassPath boot = ClassPath.getClassPath((FileObject)root, (String)"classpath/boot");
        ClassPath rtm2 = ClassPath.getClassPath((FileObject)root, (String)"classpath/execute");
        ClassPath rtm1 = ClassPath.getClassPath((FileObject)root, (String)"classpath/compile");
        ClassPath rtm = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{rtm1, rtm2});
        ClassPath clp = ClassPath.getClassPath((FileObject)root, (String)"classpath/source");
        ClasspathInfo cpInfo = ClasspathInfo.create((ClassPath)boot, (ClassPath)rtm, (ClassPath)clp);
        return SourceUtils.isMainClass((String)className, (ClasspathInfo)cpInfo);
    }

    private static boolean isSubclass(final String className, final String baseClassName, FileObject root) {
        final Boolean[] result = new Boolean[]{false};
        if (className == null) {
            return result[0];
        }
        if (unitTestingSupport_hasMainMethodResult != null) {
            return unitTestingSupport_hasMainMethodResult;
        }
        ClassPath boot = ClassPath.getClassPath((FileObject)root, (String)"classpath/boot");
        ClassPath rtm2 = ClassPath.getClassPath((FileObject)root, (String)"classpath/execute");
        ClassPath rtm1 = ClassPath.getClassPath((FileObject)root, (String)"classpath/compile");
        ClassPath rtm = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{rtm1, rtm2});
        ClassPath clp = ClassPath.getClassPath((FileObject)root, (String)"classpath/source");
        ClasspathInfo cpInfo = ClasspathInfo.create((ClassPath)boot, (ClassPath)rtm, (ClassPath)clp);
        JavaSource js = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[0]);
        try {
            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void run(CompilationController control) throws Exception {
                    TypeElement type = control.getElements().getTypeElement(baseClassName);
                    if (type == null) {
                        return;
                    }
                    TypeElement xtype = control.getElements().getTypeElement(className);
                    if (xtype == null) {
                        return;
                    }
                    Types types = control.getTypes();
                    result[0] = types.isSubtype(types.erasure(xtype.asType()), types.erasure(type.asType()));
                }

                public void cancel() {
                }
            }, true);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return result[0];
    }

    public static boolean isXletClass(String className, FileObject root, String specialXletFqn) {
        return MainClassChooserImpl.isSubclass(className, specialXletFqn != null ? specialXletFqn : "javax.microedition.xlet.Xlet", root);
    }

    public static boolean isAppletClass(String className, FileObject root, String specialAppletFqn) {
        return MainClassChooserImpl.isSubclass(className, specialAppletFqn != null ? specialAppletFqn : "java.applet.Applet", root);
    }
}

