/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.source;

import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.cnd.source.CppEditorSupport;
import org.netbeans.modules.cnd.source.SourceDataObject;
import org.netbeans.modules.cnd.source.spi.CndCookieProvider;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.SaveAsCapable;
import org.openide.util.lookup.InstanceContent;

public final class CppEditorSupportProvider
extends CndCookieProvider {
    static final CppEditorSupportFactory staticFactory = new CppEditorSupportFactory();
    static final CppSaveAsFactory saveAsStaticFactory = new CppSaveAsFactory();

    @Override
    public void addLookup(DataObject dao, InstanceContent ic) {
        SourceDataObject sdao = (SourceDataObject)dao;
        ic.add((Object)sdao, (InstanceContent.Convertor)staticFactory);
    }

    static void notifyClosed(DataObject dobj) {
        CppEditorSupportProvider.staticFactory.notifyClosed(dobj);
    }

    private static class CppSaveAsFactory
    implements InstanceContent.Convertor<SourceDataObject, SaveAsCapable> {
        public SaveAsCapable convert(final SourceDataObject obj) {
            return new SaveAsCapable(){

                public void saveAs(FileObject folder, String fileName) throws IOException {
                    CppEditorSupport ces = (CppEditorSupport)((Object)obj.getLookup().lookup(CppEditorSupport.class));
                    if (ces != null) {
                        ces.saveAs(folder, fileName);
                    }
                }
            };
        }

        public Class<? extends SaveAsCapable> type(SourceDataObject obj) {
            return SaveAsCapable.class;
        }

        public String id(SourceDataObject obj) {
            return "CndSaveAsCapable" + obj.getPrimaryFile().getPath();
        }

        public String displayName(SourceDataObject obj) {
            return this.id(obj);
        }
    }

    static class CppEditorSupportFactory
    implements InstanceContent.Convertor<SourceDataObject, CppEditorSupport> {
        private final Map<DataObject, CppEditorSupport> cache = new WeakHashMap<DataObject, CppEditorSupport>();

        public synchronized CppEditorSupport convert(SourceDataObject obj) {
            CppEditorSupport res = this.cache.get((Object)obj);
            if (res == null) {
                res = new CppEditorSupport(obj);
                this.cache.put((DataObject)obj, res);
            }
            return res;
        }

        public Class<? extends CppEditorSupport> type(SourceDataObject obj) {
            return CppEditorSupport.class;
        }

        public String id(SourceDataObject obj) {
            return CppEditorSupport.class.getName() + obj.getPrimaryFile().getPath();
        }

        public String displayName(SourceDataObject obj) {
            return this.id(obj);
        }

        private synchronized void notifyClosed(DataObject dobj) {
            this.cache.remove(dobj);
        }
    }
}

