/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.editor.index.CompositeComponentModel;
import org.netbeans.modules.web.jsf.editor.index.IndexedFile;
import org.netbeans.modules.web.jsf.editor.index.JsfPageModelFactory;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class JsfIndex {
    private final FileObject[] sourceRoots;
    private final FileObject[] binaryRoots;
    private final FileObject[] customRoots;
    private final FileObject base;

    public static JsfIndex create(WebModule wm) {
        return new JsfIndex(wm);
    }

    private JsfIndex(WebModule wm) {
        ClassPath executeCp;
        this.base = wm.getDocumentBase();
        HashSet<FileObject> roots = new HashSet<FileObject>();
        ClassPath compileCp = ClassPath.getClassPath((FileObject)wm.getDocumentBase(), (String)"classpath/compile");
        if (compileCp != null) {
            roots.addAll(Arrays.asList(compileCp.getRoots()));
        }
        if ((executeCp = ClassPath.getClassPath((FileObject)wm.getDocumentBase(), (String)"classpath/execute")) != null) {
            roots.addAll(Arrays.asList(executeCp.getRoots()));
        }
        this.binaryRoots = roots.toArray(new FileObject[0]);
        Collection croots = QuerySupport.findRoots((FileObject)this.base, null, null, null);
        this.customRoots = croots.toArray(new FileObject[0]);
        this.sourceRoots = this.customRoots;
    }

    private QuerySupport createEmbeddingIndex() throws IOException {
        return QuerySupport.forRoots((String)"jsf", (int)1, (FileObject[])this.sourceRoots);
    }

    private QuerySupport createBinaryIndex() throws IOException {
        return QuerySupport.forRoots((String)"jsfBinary", (int)8, (FileObject[])this.binaryRoots);
    }

    private QuerySupport createCustomIndex() throws IOException {
        return QuerySupport.forRoots((String)"jsfCustomIndexer", (int)3, (FileObject[])this.customRoots);
    }

    public Collection<String> getAllCompositeLibraryNames() {
        ArrayList<String> col = new ArrayList<String>();
        try {
            col.addAll(this.getAllCompositeLibraryNames(this.createBinaryIndex()));
            col.addAll(this.getAllCompositeLibraryNames(this.createCustomIndex()));
            col.addAll(this.getAllCompositeLibraryNames(this.createEmbeddingIndex()));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return col;
    }

    private Collection<String> getAllCompositeLibraryNames(QuerySupport index) {
        ArrayList<String> libNames = new ArrayList<String>();
        try {
            Collection results = index.query("library", "", QuerySupport.Kind.PREFIX, new String[]{"library"});
            for (IndexResult result : results) {
                String libraryName = result.getValue("library");
                if (libraryName == null) continue;
                libNames.add(libraryName);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return libNames;
    }

    public Collection<String> getCompositeLibraryComponents(String libraryName) {
        ArrayList<String> col = new ArrayList<String>();
        try {
            col.addAll(this.getCompositeLibraryComponents(this.createBinaryIndex(), libraryName));
            col.addAll(this.getCompositeLibraryComponents(this.createEmbeddingIndex(), libraryName));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return col;
    }

    private Collection<String> getCompositeLibraryComponents(QuerySupport index, String libraryName) {
        ArrayList<String> components = new ArrayList<String>();
        try {
            Collection results = index.query("library", libraryName, QuerySupport.Kind.EXACT, new String[]{"library"});
            for (IndexResult result : results) {
                FileObject file = result.getFile();
                if (file == null) continue;
                components.add(file.getName());
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return components;
    }

    public CompositeComponentModel getCompositeComponentModel(String libraryName, String componentName) {
        try {
            CompositeComponentModel model = this.getCompositeComponentModel(this.createEmbeddingIndex(), libraryName, componentName);
            return model != null ? model : this.getCompositeComponentModel(this.createBinaryIndex(), libraryName, componentName);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private CompositeComponentModel getCompositeComponentModel(QuerySupport index, String libraryName, String componentName) {
        try {
            Collection results = index.query("library", libraryName, QuerySupport.Kind.EXACT, new String[]{"library", "interface_attributes", "has_implementation"});
            for (IndexResult result : results) {
                String fileName;
                FileObject file = result.getFile();
                if (file == null || !(fileName = file.getName()).equals(componentName)) continue;
                return (CompositeComponentModel)JsfPageModelFactory.getFactory(CompositeComponentModel.Factory.class).loadFromIndex(result);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public Collection<IndexedFile> getAllFaceletsLibraryDescriptors() {
        ArrayList<IndexedFile> files = new ArrayList<IndexedFile>();
        try {
            this.queryFaceletsLibraryDescriptors(this.createBinaryIndex(), files);
            this.queryFaceletsLibraryDescriptors(this.createCustomIndex(), files);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return files;
    }

    private void queryFaceletsLibraryDescriptors(QuerySupport index, Collection<IndexedFile> files) throws IOException {
        Collection results = index.query("faceletsLibraryDescriptor", "true", QuerySupport.Kind.EXACT, new String[]{"faceletsLibraryDescriptor", "timestamp"});
        this.convertToFiles(results, files);
    }

    public IndexedFile getTagLibraryDescriptor(String namespace) {
        try {
            IndexedFile file = this.findTLD(this.createCustomIndex(), namespace);
            return file != null ? file : this.findTLD(this.createBinaryIndex(), namespace);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private IndexedFile findTLD(QuerySupport index, String namespace) throws IOException {
        Collection results = index.query("namespace", namespace, QuerySupport.Kind.EXACT, new String[]{"tagLibraryDescriptor", "timestamp"});
        for (IndexResult result : results) {
            FileObject file;
            if (result.getValue("tagLibraryDescriptor") == null || (file = result.getFile()) == null) continue;
            long timestamp = Long.parseLong(result.getValue("timestamp"));
            return new IndexedFile(timestamp, file);
        }
        return null;
    }

    private void convertToFiles(Collection<? extends IndexResult> results, Collection<IndexedFile> files) {
        for (IndexResult indexResult : results) {
            FileObject file = indexResult.getFile();
            if (file == null) continue;
            long timestamp = Long.parseLong(indexResult.getValue("timestamp"));
            files.add(new IndexedFile(timestamp, file));
        }
    }
}

