/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.facelets;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.modules.web.jsf.editor.facelets.AbstractFaceletsLibrary;
import org.netbeans.modules.web.jsf.editor.facelets.CompositeLibraryDescriptor;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibrary;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibrarySupport;
import org.netbeans.modules.web.jsf.editor.facelets.GenericTag;
import org.netbeans.modules.web.jsf.editor.facelets.LibraryDescriptor;
import org.netbeans.modules.web.jsf.editor.facelets.LibraryDescriptorException;
import org.netbeans.modules.web.jsf.editor.index.CompositeComponentModel;
import org.netbeans.modules.web.jsf.editor.index.JsfIndex;
import org.netbeans.modules.web.jsfapi.api.Attribute;
import org.netbeans.modules.web.jsfapi.api.LibraryType;
import org.netbeans.modules.web.jsfapi.api.Tag;
import org.netbeans.modules.web.jsfapi.spi.LibraryUtils;
import org.openide.util.NbBundle;

public class CompositeComponentLibrary
extends FaceletsLibrary {
    private final String compositeLibraryResourceFolderName;
    private final String defaultPrefix;

    public CompositeComponentLibrary(FaceletsLibrarySupport support, String compositeLibraryName, String namespace, URL libraryDescriptorURL) {
        super(support, namespace, libraryDescriptorURL);
        this.compositeLibraryResourceFolderName = compositeLibraryName;
        this.defaultPrefix = this.generateVirtualLibraryPrefix();
    }

    @Override
    protected LibraryDescriptor getFaceletsLibraryDescriptor() throws LibraryDescriptorException {
        return new CompositeLibraryDescriptor(super.getFaceletsLibraryDescriptor(), new CCVirtualLibraryDescriptor());
    }

    @Override
    public LibraryType getType() {
        return LibraryType.COMPOSITE;
    }

    @Override
    public String getDefaultNamespace() {
        return LibraryUtils.getCompositeLibraryURL((String)this.getLibraryName());
    }

    @Override
    public String getDefaultPrefix() {
        return this.defaultPrefix;
    }

    public String getLibraryName() {
        return this.compositeLibraryResourceFolderName;
    }

    @Override
    public Map<String, ? extends AbstractFaceletsLibrary.NamedComponent> getComponentsMap() {
        HashMap<String, ? extends AbstractFaceletsLibrary.NamedComponent> all = new HashMap<String, AbstractFaceletsLibrary.NamedComponent>(super.getComponentsMap());
        all.putAll(this.getCompositeComponentsMap());
        return all;
    }

    private Map<String, CompositeComponent> getCompositeComponentsMap() {
        HashMap<String, CompositeComponent> ccomponents = new HashMap<String, CompositeComponent>();
        Collection<String> componentNames = this.index().getCompositeLibraryComponents(this.getLibraryName());
        for (String compName : componentNames) {
            CompositeComponent comp = new CompositeComponent(compName);
            ccomponents.put(compName, comp);
        }
        return ccomponents;
    }

    private JsfIndex index() {
        return this.support.getJsfSupport().getIndex();
    }

    private String generateVirtualLibraryPrefix() {
        StringTokenizer st = new StringTokenizer(this.getLibraryName(), "/");
        LinkedList<String> tokens = new LinkedList<String>();
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken());
        }
        if (tokens.size() == 1) {
            return (String)tokens.peek();
        }
        StringBuilder sb = new StringBuilder();
        for (String folderName : tokens) {
            sb.append(folderName.charAt(0));
        }
        return sb.toString();
    }

    protected class CCVirtualLibraryDescriptor
    implements LibraryDescriptor {
        protected CCVirtualLibraryDescriptor() {
        }

        @Override
        public Map<String, Tag> getTags() {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            Collection components = CompositeComponentLibrary.this.getCompositeComponentsMap().values();
            for (CompositeComponent cc : components) {
                map.put(cc.getName(), new LazyLoadingTag(cc));
            }
            return map;
        }

        @Override
        public String getNamespace() {
            return CompositeComponentLibrary.this.getNamespace();
        }

        private class LazyLoadingTag
        extends GenericTag {
            private CompositeComponent cc;
            private Map<String, Attribute> attrs;
            private String description;

            public LazyLoadingTag(CompositeComponent cc) {
                this.cc = cc;
            }

            private synchronized void load() {
                CompositeComponentModel model = this.cc.getComponentModel();
                String relativePath = model.getRelativePath();
                this.attrs = new HashMap<String, Attribute>();
                String msgNoTld = NbBundle.getBundle(CompositeComponentLibrary.class).getString("MSG_NO_DESCRIPTOR");
                for (Map<String, String> attrsMap : model.getExistingInterfaceAttributes()) {
                    String attrname = attrsMap.get("name");
                    boolean required = Boolean.parseBoolean(attrsMap.get("required"));
                    String attributeDescription = this.getAttributesDescription(model, true);
                    this.attrs.put(attrname, (Attribute)new Attribute.DefaultAttribute(attrname, attributeDescription, required));
                }
                StringBuilder sb = new StringBuilder();
                sb.append("<p><b>");
                sb.append(NbBundle.getMessage(CompositeComponentLibrary.class, (String)"MSG_COMPOSITE_COMPONENT_SOURCE"));
                sb.append("</b>");
                sb.append("&nbsp;");
                sb.append(relativePath);
                sb.append("</p>");
                sb.append("<p>");
                sb.append(this.getAttributesDescription(model, false));
                sb.append("</p>");
                sb.append("<p style=\"color: red\">").append(msgNoTld).append("</p>");
                this.description = sb.toString();
            }

            private String getAttributesDescription(CompositeComponentModel model, boolean includeNoDescriptorMsg) {
                if (model.getExistingInterfaceAttributes().isEmpty()) {
                    return NbBundle.getMessage(CompositeComponentLibrary.class, (String)"MSG_NO_TAG_ATTRS");
                }
                StringBuilder sb = new StringBuilder();
                sb.append("<b>");
                sb.append(NbBundle.getMessage(CompositeComponentLibrary.class, (String)"MSG_TAG_ATTRS"));
                sb.append("</b>");
                sb.append("<table border=\"1\">");
                for (Map<String, String> descr : model.getExistingInterfaceAttributes()) {
                    sb.append("<tr>");
                    sb.append("<td>");
                    sb.append("<div style=\"font-weight: bold\">");
                    String attrname = descr.get("name");
                    sb.append(attrname);
                    sb.append("</div>");
                    sb.append("</td>");
                    if (descr.size() > 1) {
                        sb.append("<td>");
                        sb.append("<table border=\"0\" padding=\"0\" margin=\"0\" spacing=\"2\">");
                        for (String key : descr.keySet()) {
                            if (key.equals("name")) continue;
                            String val = descr.get(key);
                            sb.append("<tr><td><b>");
                            sb.append(key);
                            sb.append("</b></td><td>");
                            sb.append(val);
                            sb.append("</td></tr>");
                        }
                        sb.append("</table>");
                        sb.append("</td>");
                    }
                    sb.append("</tr>");
                }
                sb.append("</table>");
                if (includeNoDescriptorMsg) {
                    String msgNoDescriptor = NbBundle.getBundle(CompositeComponentLibrary.class).getString("MSG_NO_DESCRIPTOR");
                    sb.append("<p style=\"color: red\">").append(msgNoDescriptor).append("</p>");
                }
                return sb.toString();
            }

            public String getName() {
                return this.cc.getName();
            }

            public String getDescription() {
                this.load();
                return this.description;
            }

            @Override
            public boolean hasNonGenenericAttributes() {
                this.load();
                return !this.attrs.isEmpty();
            }

            @Override
            public Collection<Attribute> getAttributes() {
                this.load();
                ArrayList<Attribute> all = new ArrayList<Attribute>(super.getAttributes());
                all.addAll(this.attrs.values());
                return all;
            }

            @Override
            public Attribute getAttribute(String name) {
                this.load();
                Attribute superA = super.getAttribute(name);
                return superA != null ? superA : this.attrs.get(name);
            }
        }
    }

    public class CompositeComponent
    extends AbstractFaceletsLibrary.NamedComponent {
        public CompositeComponent(String name) {
            super(name);
        }

        public CompositeComponentModel getComponentModel() {
            return CompositeComponentLibrary.this.index().getCompositeComponentModel(CompositeComponentLibrary.this.getLibraryName(), this.name);
        }
    }
}

