/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2se;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.modules.profiler.api.JavaPlatform;
import org.netbeans.modules.profiler.api.java.JavaProfilerSource;
import org.netbeans.modules.profiler.api.java.ProfilerTypeUtils;
import org.netbeans.modules.profiler.nbimpl.project.JavaProjectProfilingSupportProvider;
import org.netbeans.modules.profiler.nbimpl.project.ProjectUtilities;
import org.netbeans.modules.profiler.projectsupport.utilities.AppletSupport;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Lookup;

public class J2SEProjectProfilingSupportProvider
extends JavaProjectProfilingSupportProvider {
    public static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.profiler.j2se");
    private String mainClassSetManually = null;

    public boolean isFileObjectSupported(FileObject fo) {
        if (!"java".equals(fo.getExt()) && !"class".equals(fo.getExt())) {
            return false;
        }
        return super.isFileObjectSupported(fo);
    }

    public JavaPlatform getProjectJavaPlatform() {
        PropertyEvaluator props = this.getProjectProperties(this.getProject());
        String platformName = props.getProperty("platform.active");
        if (platformName == null) {
            return null;
        }
        if (platformName.equals("default_platform")) {
            return JavaPlatform.getDefaultPlatform();
        }
        return JavaPlatform.getJavaPlatformById((String)platformName);
    }

    public boolean checkProjectCanBeProfiled(FileObject profiledClassFile) {
        if (profiledClassFile == null) {
            Project p = this.getProject();
            PropertyEvaluator pp = this.getProjectProperties(p);
            String profiledClass = pp.getProperty("main.class");
            if (profiledClass == null || "".equals(profiledClass) || ProfilerTypeUtils.resolveClass((String)profiledClass, (Lookup.Provider)p) == null) {
                this.mainClassSetManually = ProjectUtilities.selectMainClass((Project)p, null, (String)ProjectUtilities.getProjectName((Project)p), (int)-1);
                if (this.mainClassSetManually == null) {
                    return false;
                }
            }
            return true;
        }
        return this.isFileObjectSupported(profiledClassFile);
    }

    public void configurePropertiesForProfiling(Properties props, FileObject profiledClassFile) {
        if (profiledClassFile == null) {
            if (this.mainClassSetManually != null) {
                props.put("main.class", this.mainClassSetManually);
                this.mainClassSetManually = null;
            }
        } else {
            JavaProfilerSource src = JavaProfilerSource.createFrom((FileObject)profiledClassFile);
            if (src != null) {
                Project project = this.getProject();
                if (src.isApplet()) {
                    String jvmargs = props.getProperty("run.jvmargs");
                    URL url = null;
                    if (jvmargs == null || jvmargs.indexOf("java.security.policy") <= 0) {
                        PropertyEvaluator projectProps = this.getProjectProperties(project);
                        String buildDirProp = projectProps.getProperty("build.dir");
                        FileObject buildFolder = ProjectUtilities.getOrCreateBuildFolder((Project)project, (String)buildDirProp);
                        AppletSupport.generateSecurityPolicy((FileObject)project.getProjectDirectory(), (FileObject)buildFolder);
                        if (jvmargs == null || jvmargs.length() == 0) {
                            props.setProperty("run.jvmargs", "-Djava.security.policy=" + FileUtil.toFile((FileObject)buildFolder).getPath() + File.separator + "applet.policy");
                        } else {
                            props.setProperty("run.jvmargs", jvmargs + " -Djava.security.policy=" + FileUtil.toFile((FileObject)buildFolder).getPath() + File.separator + "applet.policy");
                        }
                    }
                    if ((url = profiledClassFile.existsExt("html") || profiledClassFile.existsExt("HTML") ? ProjectUtilities.copyAppletHTML((Project)project, (PropertyEvaluator)this.getProjectProperties(project), (FileObject)profiledClassFile, (String)"html") : ProjectUtilities.generateAppletHTML((Project)project, (PropertyEvaluator)this.getProjectProperties(project), (FileObject)profiledClassFile)) == null) {
                        return;
                    }
                    props.setProperty("applet.url", url.toString());
                } else {
                    String profiledClass = src.getTopLevelClass().getQualifiedName();
                    props.setProperty("profile.class", profiledClass);
                }
                String clazz = FileUtil.getRelativePath((FileObject)ProjectUtilities.getRootOf((FileObject[])ProjectUtilities.getSourceRoots((Project)project), (FileObject)profiledClassFile), (FileObject)profiledClassFile);
                props.setProperty("javac.includes", clazz);
            }
        }
    }

    public void setupProjectSessionSettings(SessionSettings ss) {
        PropertyEvaluator pp = this.getProjectProperties(this.getProject());
        if (this.mainClassSetManually == null) {
            String mainClass = pp.getProperty("main.class");
            ss.setMainClass(mainClass != null ? mainClass : "");
        } else {
            ss.setMainClass(this.mainClassSetManually);
        }
        String appArgs = pp.getProperty("application.args");
        ss.setMainArgs(appArgs != null ? appArgs : "");
        String runCP = pp.getProperty("run.classpath");
        ss.setMainClassPath(runCP != null ? runCP : "");
        String jvmArgs = pp.getProperty("run.jvmargs");
        ss.setJVMArgs(jvmArgs != null ? jvmArgs : "");
    }

    public boolean supportsSettingsOverride() {
        return true;
    }

    public boolean supportsUnintegrate() {
        return true;
    }

    public void unintegrateProfiler() {
        ProjectUtilities.unintegrateProfiler((Project)this.getProject());
    }

    PropertyEvaluator getProjectProperties(Project project) {
        final Properties privateProps = new Properties();
        final Properties projectProps = new Properties();
        final Properties userPropsProps = new Properties();
        final Properties configProps = new Properties();
        final FileObject privatePropsFile = project.getProjectDirectory().getFileObject("nbproject/private/private.properties");
        final FileObject projectPropsFile = project.getProjectDirectory().getFileObject("nbproject/project.properties");
        final File userPropsFile = InstalledFileLocator.getDefault().locate("build.properties", null, false);
        final FileObject configPropsFile = project.getProjectDirectory().getFileObject("nbproject/private/config.properties");
        final FileObject configPropsDir = project.getProjectDirectory().getFileObject("nbproject/configs");
        ProjectManager.mutex().readAccess(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block30: {
                    InputStream is;
                    if (privatePropsFile != null) {
                        try {
                            is = privatePropsFile.getInputStream();
                            try {
                                privateProps.load(is);
                            }
                            finally {
                                is.close();
                            }
                        }
                        catch (IOException e) {
                            err.notify(1, (Throwable)e);
                        }
                    }
                    if (projectPropsFile != null) {
                        try {
                            is = projectPropsFile.getInputStream();
                            try {
                                projectProps.load(is);
                            }
                            finally {
                                is.close();
                            }
                        }
                        catch (IOException e) {
                            err.notify(1, (Throwable)e);
                        }
                    }
                    if (userPropsFile != null) {
                        try {
                            is = new BufferedInputStream(new FileInputStream(userPropsFile));
                            try {
                                userPropsProps.load(is);
                            }
                            finally {
                                is.close();
                            }
                        }
                        catch (IOException e) {
                            err.notify(1, (Throwable)e);
                        }
                    }
                    if (configPropsDir != null && configPropsFile != null) {
                        try {
                            is = configPropsFile.getInputStream();
                            Properties activeConfigProps = new Properties();
                            try {
                                FileObject configSpecPropFile;
                                activeConfigProps.load(is);
                                String activeConfig = activeConfigProps.getProperty("config");
                                if (activeConfig == null || activeConfig.length() <= 0 || (configSpecPropFile = configPropsDir.getFileObject(activeConfig + ".properties")) == null) break block30;
                                InputStream configSpecIn = configSpecPropFile.getInputStream();
                                try {
                                    configProps.load(configSpecIn);
                                }
                                finally {
                                    configSpecIn.close();
                                }
                            }
                            finally {
                                is.close();
                            }
                        }
                        catch (IOException e) {
                            err.notify(1, (Throwable)e);
                        }
                    }
                }
            }
        });
        PropertyEvaluator pe = PropertyUtils.sequentialPropertyEvaluator(null, (PropertyProvider[])new PropertyProvider[]{new MyPropertyProvider(configProps), new MyPropertyProvider(privateProps), new MyPropertyProvider(userPropsProps), new MyPropertyProvider(projectProps)});
        return pe;
    }

    public J2SEProjectProfilingSupportProvider(Project project) {
        super(project);
    }

    private static class MyPropertyProvider
    implements PropertyProvider {
        private Properties props;

        private MyPropertyProvider(Properties props) {
            this.props = props;
        }

        public Map getProperties() {
            return this.props;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }
}

