/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.jsps;

import java.io.File;
import javax.enterprise.deploy.spi.DeploymentManager;
import org.netbeans.modules.j2ee.deployment.plugins.spi.FindJSPServlet;
import org.netbeans.modules.tomcat5.TomcatManager;
import org.netbeans.modules.tomcat5.jsps.JspNameUtil;

public class FindJSPServletImpl
implements FindJSPServlet {
    private static final String WEB_INF_TAGS = "WEB-INF/tags/";
    private static final String META_INF_TAGS = "META-INF/tags/";
    private TomcatManager tm;

    public FindJSPServletImpl(DeploymentManager manager) {
        this.tm = (TomcatManager)manager;
    }

    public File getServletTempDirectory(String moduleContextPath) {
        File baseDir = this.tm.getTomcatProperties().getCatalinaDir();
        if (baseDir == null || !baseDir.exists()) {
            return null;
        }
        File hostBase = new File(baseDir, "work/Catalina/localhost".replace('/', File.separatorChar));
        File workDir = new File(hostBase, this.getContextRootString(moduleContextPath));
        return workDir;
    }

    private String getContextRootString(String moduleContextPath) {
        String contextRootPath = moduleContextPath;
        if (contextRootPath.startsWith("/")) {
            contextRootPath = contextRootPath.substring(1);
        }
        if (contextRootPath.equals("")) {
            return "_";
        }
        return contextRootPath;
    }

    public String getServletResourcePath(String moduleContextPath, String jspResourcePath) {
        String path = this.getTagHandlerClassName(jspResourcePath);
        path = path != null ? path.replace('.', '/') + ".java" : this.getServletPackageName(jspResourcePath).replace('.', '/') + '/' + this.getServletClassName(jspResourcePath) + ".java";
        return path;
    }

    public String getServletPackageName(String jspUri) {
        String dPackageName = this.getDerivedPackageName(jspUri);
        if (dPackageName.length() == 0) {
            return "org.apache.jsp";
        }
        return "org.apache.jsp." + this.getDerivedPackageName(jspUri);
    }

    private String getDerivedPackageName(String jspUri) {
        int iSep = jspUri.lastIndexOf(47);
        return iSep > 0 ? JspNameUtil.makeJavaPackage(jspUri.substring(0, iSep)) : "";
    }

    public String getServletClassName(String jspUri) {
        int iSep = jspUri.lastIndexOf(47) + 1;
        return JspNameUtil.makeJavaIdentifier(jspUri.substring(iSep));
    }

    public String getServletEncoding(String moduleContextPath, String jspResourcePath) {
        return "UTF8";
    }

    private String getTagHandlerClassName(String path) {
        String className = null;
        int begin = 0;
        int index = path.lastIndexOf(".tag");
        if (index == -1) {
            return null;
        }
        index = path.indexOf(WEB_INF_TAGS);
        if (index != -1) {
            className = "org.apache.jsp.tag.web.";
            begin = index + WEB_INF_TAGS.length();
        } else {
            index = path.indexOf(META_INF_TAGS);
            if (index != -1) {
                className = "org.apache.jsp.tag.meta.";
                begin = index + META_INF_TAGS.length();
            } else {
                return null;
            }
        }
        className = className + JspNameUtil.makeJavaPackage(path.substring(begin));
        return className;
    }
}

