/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ContextRootConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DatasourceConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DeploymentPlanConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfiguration;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.tomcat5.TomcatManager;
import org.netbeans.modules.tomcat5.config.TomcatDatasource;
import org.netbeans.modules.tomcat5.config.gen.Context;
import org.netbeans.modules.tomcat5.config.gen.Parameter;
import org.netbeans.modules.tomcat5.config.gen.ResourceParams;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class TomcatModuleConfiguration
implements ModuleConfiguration,
ContextRootConfiguration,
DatasourceConfiguration,
DeploymentPlanConfiguration,
PropertyChangeListener {
    private final J2eeModule j2eeModule;
    private final TomcatManager.TomcatVersion tomcatVersion;
    private DataObject contextDataObject;
    private final File contextXml;
    private Context context;
    private static final String ATTR_PATH = "path";
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.tomcat5");

    public TomcatModuleConfiguration(J2eeModule j2eeModule, TomcatManager.TomcatVersion tomcatVersion) {
        this.j2eeModule = j2eeModule;
        this.tomcatVersion = tomcatVersion;
        this.contextXml = j2eeModule.getDeploymentConfigurationFile("META-INF/context.xml");
        this.init(this.contextXml);
    }

    private void init(File contextXml) {
        try {
            this.getContext();
        }
        catch (ConfigurationException e) {
            LOGGER.log(Level.FINE, null, e);
        }
        if (this.contextDataObject == null) {
            try {
                this.contextDataObject = DataObject.find((FileObject)FileUtil.toFileObject((File)FileUtil.normalizeFile((File)contextXml)));
                this.contextDataObject.addPropertyChangeListener((PropertyChangeListener)this);
            }
            catch (DataObjectNotFoundException donfe) {
                LOGGER.log(Level.FINE, null, donfe);
            }
        }
    }

    public Lookup getLookup() {
        return Lookups.fixed((Object[])new Object[]{this});
    }

    public void dispose() {
    }

    public boolean supportsCreateDatasource() {
        return true;
    }

    public synchronized Context getContext() throws ConfigurationException {
        if (this.context == null) {
            if (this.contextXml.exists()) {
                try {
                    this.context = Context.createGraph(this.contextXml);
                }
                catch (IOException e) {
                    String msg = NbBundle.getMessage(TomcatModuleConfiguration.class, (String)"MSG_ContextXmlReadFail", (Object)this.contextXml.getPath());
                    throw new ConfigurationException(msg, (Throwable)e);
                }
                catch (RuntimeException e) {
                    String msg = NbBundle.getMessage(TomcatModuleConfiguration.class, (String)"MSG_ContextXmlBroken", (Object)this.contextXml.getPath());
                    throw new ConfigurationException(msg, (Throwable)e);
                }
            } else {
                this.context = this.genereateContext();
                this.writefile(this.contextXml);
            }
        }
        return this.context;
    }

    public String getContextRoot() throws ConfigurationException {
        return this.getContext().getAttributeValue(ATTR_PATH);
    }

    public Set<Datasource> getDatasources() throws ConfigurationException {
        Context context = this.getContext();
        HashSet<Datasource> result = new HashSet<Datasource>();
        int length = context.getResource().length;
        if (this.tomcatVersion != TomcatManager.TomcatVersion.TOMCAT_50) {
            for (int i = 0; i < length; ++i) {
                String type = context.getResourceType(i);
                if (!"javax.sql.DataSource".equals(type)) continue;
                String name = context.getResourceName(i);
                String username = context.getResourceUsername(i);
                String url = context.getResourceUrl(i);
                String password = context.getResourcePassword(i);
                String driverClassName = context.getResourceDriverClassName(i);
                if (name == null || username == null || url == null || driverClassName == null) continue;
                result.add(new TomcatDatasource(username, url, password, name, driverClassName));
            }
        } else {
            ResourceParams[] resourceParams = context.getResourceParams();
            for (int i = 0; i < length; ++i) {
                String type = context.getResourceType(i);
                if (!"javax.sql.DataSource".equals(type)) continue;
                String name = context.getResourceName(i);
                for (int j = 0; j < resourceParams.length; ++j) {
                    if (!name.equals(resourceParams[j].getName())) continue;
                    Parameter[] params = resourceParams[j].getParameter();
                    HashMap<String, String> paramNameValueMap = new HashMap<String, String>(params.length);
                    for (Parameter parameter : params) {
                        paramNameValueMap.put(parameter.getName(), parameter.getValue());
                    }
                    String username = (String)paramNameValueMap.get("username");
                    String url = (String)paramNameValueMap.get("url");
                    String password = (String)paramNameValueMap.get("password");
                    String driverClassName = (String)paramNameValueMap.get("driverClassName");
                    if (username == null || url == null || driverClassName == null) continue;
                    result.add(new TomcatDatasource(username, url, password, name, driverClassName));
                }
            }
        }
        return result;
    }

    public Datasource createDatasource(final String name, final String url, final String username, final String password, final String driverClassName) throws ConfigurationException, DatasourceAlreadyExistsException {
        ArrayList<Datasource> conflictingDS = new ArrayList<Datasource>();
        for (Datasource datasource : this.getDatasources()) {
            if (!name.equals(datasource.getJndiName())) continue;
            conflictingDS.add(datasource);
        }
        if (conflictingDS.size() > 0) {
            throw new DatasourceAlreadyExistsException(conflictingDS);
        }
        if (this.tomcatVersion != TomcatManager.TomcatVersion.TOMCAT_50) {
            this.modifyContext(new ContextModifier(){

                @Override
                public void modify(Context context) {
                    int idx = context.addResource(true);
                    context.setResourceName(idx, name);
                    context.setResourceAuth(idx, "Container");
                    context.setResourceType(idx, "javax.sql.DataSource");
                    context.setResourceDriverClassName(idx, driverClassName);
                    context.setResourceUrl(idx, url);
                    context.setResourceUsername(idx, username);
                    context.setResourcePassword(idx, password);
                    context.setResourceMaxActive(idx, "20");
                    context.setResourceMaxIdle(idx, "10");
                    context.setResourceMaxWait(idx, "-1");
                }
            });
        } else {
            this.modifyContext(new ContextModifier(){

                @Override
                public void modify(Context context) {
                    int idx = context.addResource(true);
                    context.setResourceName(idx, name);
                    context.setResourceAuth(idx, "Container");
                    context.setResourceType(idx, "javax.sql.DataSource");
                    ResourceParams[] resourceParams = context.getResourceParams();
                    for (int i = 0; i < resourceParams.length; ++i) {
                        if (!name.equals(resourceParams[i].getName())) continue;
                        context.removeResourceParams(resourceParams[i]);
                    }
                    ResourceParams newResourceParams = TomcatModuleConfiguration.this.createResourceParams(name, new Parameter[]{TomcatModuleConfiguration.this.createParameter("factory", "org.apache.commons.dbcp.BasicDataSourceFactory"), TomcatModuleConfiguration.this.createParameter("driverClassName", driverClassName), TomcatModuleConfiguration.this.createParameter("url", url), TomcatModuleConfiguration.this.createParameter("username", username), TomcatModuleConfiguration.this.createParameter("password", password), TomcatModuleConfiguration.this.createParameter("maxActive", "20"), TomcatModuleConfiguration.this.createParameter("maxIdle", "10"), TomcatModuleConfiguration.this.createParameter("maxWait", "-1")});
                    context.addResourceParams(newResourceParams);
                }
            });
        }
        return new TomcatDatasource(username, url, password, name, driverClassName);
    }

    public void setContextRoot(String contextPath) throws ConfigurationException {
        if (!this.isCorrectCP(contextPath)) {
            String ctxRoot = contextPath;
            StringTokenizer tok = new StringTokenizer(contextPath, "/");
            StringBuffer buf = new StringBuffer();
            while (tok.hasMoreTokens()) {
                buf.append("/" + tok.nextToken());
            }
            ctxRoot = buf.toString();
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(TomcatModuleConfiguration.class, (String)"MSG_invalidCP", (Object)contextPath), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            contextPath = ctxRoot;
        }
        final String newContextPath = contextPath;
        this.modifyContext(new ContextModifier(){

            @Override
            public void modify(Context context) {
                if (TomcatModuleConfiguration.this.tomcatVersion == TomcatManager.TomcatVersion.TOMCAT_50) {
                    String oldContextPath = context.getAttributeValue(TomcatModuleConfiguration.ATTR_PATH);
                    String oldPrefix = context.getLoggerPrefix();
                    if (oldPrefix != null && oldPrefix.equals(TomcatModuleConfiguration.this.computeLoggerPrefix(oldContextPath))) {
                        context.setLoggerPrefix(TomcatModuleConfiguration.this.computeLoggerPrefix(newContextPath));
                    }
                }
                context.setAttributeValue(TomcatModuleConfiguration.ATTR_PATH, newContextPath);
            }
        });
    }

    public DataObject getContextDataObject() {
        return this.contextDataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "modified" && evt.getNewValue() == Boolean.FALSE) {
            TomcatModuleConfiguration tomcatModuleConfiguration = this;
            synchronized (tomcatModuleConfiguration) {
                this.context = null;
            }
        }
    }

    public J2eeModule getJ2eeModule() {
        return this.j2eeModule;
    }

    public void save(OutputStream os) throws ConfigurationException {
        Context ctx = this.getContext();
        try {
            ctx.write(os);
        }
        catch (IOException ioe) {
            String msg = NbBundle.getMessage(TomcatModuleConfiguration.class, (String)"MSG_ContextXmlWriteFail", (Object)this.contextXml.getPath());
            throw new ConfigurationException(msg, (Throwable)ioe);
        }
    }

    private Context genereateContext() {
        Context newContext = new Context();
        String path = "";
        newContext.setAttributeValue(ATTR_PATH, path);
        if (this.tomcatVersion == TomcatManager.TomcatVersion.TOMCAT_50) {
            newContext.setLogger(true);
            newContext.setLoggerClassName("org.apache.catalina.logger.FileLogger");
            newContext.setLoggerPrefix(this.computeLoggerPrefix(path));
            newContext.setLoggerSuffix(".log");
            newContext.setLoggerTimestamp("true");
        } else {
            newContext.setAntiJARLocking("true");
        }
        return newContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyContext(ContextModifier modifier) throws ConfigurationException {
        assert (this.contextDataObject != null) : "DataObject has not been initialized yet";
        try {
            SaveCookie cookie;
            EditorCookie editor = (EditorCookie)this.contextDataObject.getCookie(EditorCookie.class);
            StyledDocument doc = editor.getDocument();
            if (doc == null) {
                doc = editor.openDocument();
            }
            Context newContext = null;
            try {
                byte[] docString = doc.getText(0, doc.getLength()).getBytes();
                newContext = Context.createGraph(new ByteArrayInputStream(docString));
            }
            catch (RuntimeException e) {
                Context oldContext = this.getContext();
                NotifyDescriptor.Confirmation notDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(TomcatModuleConfiguration.class, (String)"MSG_ContextXmlNotValid"), 2);
                Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)notDesc);
                if (result == NotifyDescriptor.CANCEL_OPTION) {
                    return;
                }
                newContext = oldContext;
            }
            modifier.modify(newContext);
            boolean modified = this.contextDataObject.isModified();
            this.replaceDocument(doc, newContext);
            if (!modified && (cookie = (SaveCookie)this.contextDataObject.getCookie(SaveCookie.class)) != null) {
                cookie.save();
            }
            TomcatModuleConfiguration tomcatModuleConfiguration = this;
            synchronized (tomcatModuleConfiguration) {
                this.context = newContext;
            }
        }
        catch (BadLocationException e) {
            String msg = NbBundle.getMessage(TomcatModuleConfiguration.class, (String)"MSG_ContextXmlWriteFail", (Object)this.contextXml.getPath());
            throw new ConfigurationException(msg, (Throwable)e);
        }
        catch (IOException e) {
            String msg = NbBundle.getMessage(TomcatModuleConfiguration.class, (String)"MSG_ContextXmlWriteFail", (Object)this.contextXml.getPath());
            throw new ConfigurationException(msg, (Throwable)e);
        }
    }

    private Parameter createParameter(String name, String value) {
        Parameter parameter = new Parameter();
        parameter.setName(name);
        parameter.setValue(value);
        return parameter;
    }

    private ResourceParams createResourceParams(String name, Parameter[] parameters) {
        ResourceParams resourceParams = new ResourceParams();
        resourceParams.setName(name);
        for (int i = 0; i < parameters.length; ++i) {
            resourceParams.addParameter(parameters[i]);
        }
        return resourceParams;
    }

    private String computeLoggerPrefix(String contextPath) {
        return contextPath.length() > 0 ? contextPath.substring(1).replace('/', '_').concat(".") : "ROOT.";
    }

    private void writefile(final File file) throws ConfigurationException {
        assert (file != null) : "File to write can't be null";
        assert (file.getParentFile() != null) : "File parent folder can't be null";
        try {
            FileObject cfolder = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file.getParentFile()));
            if (cfolder == null) {
                try {
                    cfolder = FileUtil.createFolder((File)FileUtil.normalizeFile((File)file.getParentFile()));
                }
                catch (IOException ex) {
                    throw new ConfigurationException(NbBundle.getMessage(TomcatModuleConfiguration.class, (String)"MSG_FailedToCreateConfigFolder", (Object)file.getParentFile().getAbsolutePath()));
                }
            }
            final FileObject folder = cfolder;
            final ConfigurationException[] anonClassException = new ConfigurationException[]{null};
            FileSystem fs = folder.getFileSystem();
            fs.runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    String name = file.getName();
                    FileObject configFO = folder.getFileObject(name);
                    if (configFO == null) {
                        configFO = folder.createData(name);
                    }
                    Context ctx = null;
                    try {
                        ctx = TomcatModuleConfiguration.this.getContext();
                    }
                    catch (ConfigurationException e) {
                        anonClassException[0] = e;
                        return;
                    }
                    FileLock lock = configFO.lock();
                    try {
                        BufferedOutputStream os = new BufferedOutputStream(configFO.getOutputStream(lock), 4096);
                        try {
                            if (ctx != null) {
                                ctx.write(os);
                            }
                        }
                        finally {
                            ((OutputStream)os).close();
                        }
                    }
                    finally {
                        lock.releaseLock();
                    }
                }
            });
            if (anonClassException[0] != null) {
                throw anonClassException[0];
            }
        }
        catch (IOException e) {
            String msg = NbBundle.getMessage(TomcatModuleConfiguration.class, (String)"MSG_ContextXmlWriteFail", (Object)this.contextXml.getPath());
            throw new ConfigurationException(msg, (Throwable)e);
        }
    }

    private void replaceDocument(final StyledDocument doc, BaseBean graph) {
        final StringWriter out = new StringWriter();
        try {
            graph.write((Writer)out);
        }
        catch (Schema2BeansException ex) {
            Logger.getLogger(TomcatModuleConfiguration.class.getName()).log(Level.INFO, null, ex);
        }
        catch (IOException ioe) {
            Logger.getLogger(TomcatModuleConfiguration.class.getName()).log(Level.INFO, null, ioe);
        }
        NbDocument.runAtomic((StyledDocument)doc, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    doc.remove(0, doc.getLength());
                    doc.insertString(0, out.toString(), null);
                }
                catch (BadLocationException ble) {
                    Exceptions.printStackTrace((Throwable)ble);
                }
            }
        });
    }

    private boolean isCorrectCP(String contextPath) {
        boolean correct = true;
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            correct = false;
        } else if (contextPath.endsWith("/")) {
            correct = false;
        } else if (contextPath.indexOf("//") >= 0) {
            correct = false;
        }
        return correct;
    }

    public void bindDatasourceReference(final String referenceName, final String jndiName) throws ConfigurationException {
        Set<Datasource> datasources = this.getDatasources();
        for (Datasource ds : datasources) {
            if (!referenceName.equals(ds.getJndiName())) continue;
            return;
        }
        Context context = this.getContext();
        int lengthResourceLink = context.getResourceLink().length;
        for (int i = 0; i < lengthResourceLink; ++i) {
            if (!referenceName.equals(context.getResourceLinkName(i))) continue;
            return;
        }
        for (Datasource ds : datasources) {
            if (!jndiName.equals(ds.getJndiName())) continue;
            try {
                this.createDatasource(referenceName, ds.getUrl(), ds.getUsername(), ds.getPassword(), ds.getDriverClassName());
            }
            catch (DatasourceAlreadyExistsException ex) {
                LOGGER.info("Datasource with the '" + referenceName + "' reference name already exists.");
            }
            return;
        }
        this.modifyContext(new ContextModifier(){

            @Override
            public void modify(Context context) {
                int idx = context.addResourceLink(true);
                context.setResourceLinkName(idx, referenceName);
                context.setResourceLinkGlobal(idx, jndiName);
                context.setResourceLinkType(idx, "javax.sql.DataSource");
            }
        });
    }

    public void bindDatasourceReferenceForEjb(String ejbName, String ejbType, String referenceName, String jndiName) throws ConfigurationException {
    }

    public String findDatasourceJndiName(String referenceName) throws ConfigurationException {
        Context context = this.getContext();
        if (context != null) {
            int lengthResource = context.getResource().length;
            for (int i = 0; i < lengthResource; ++i) {
                if (!referenceName.equals(context.getResourceName(i))) continue;
                return referenceName;
            }
            int lengthResourceLink = context.getResourceLink().length;
            for (int i = 0; i < lengthResourceLink; ++i) {
                if (!referenceName.equals(context.getResourceLinkName(i))) continue;
                return context.getResourceLinkGlobal(i);
            }
        }
        return null;
    }

    public String findDatasourceJndiNameForEjb(String ejbName, String referenceName) throws ConfigurationException {
        return null;
    }

    private static interface ContextModifier {
        public void modify(Context var1);
    }
}

