/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.modules.apisupport.project.universe.SourceRootsProvider;
import org.netbeans.modules.apisupport.project.universe.SourceRootsSupport;
import org.netbeans.modules.apisupport.project.universe.TestEntry;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.ChangeSupport;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class GlobalSourceForBinaryImpl
implements SourceForBinaryQueryImplementation {
    static boolean quiet = false;

    public SourceForBinaryQuery.Result findSourceRoots(URL binaryRoot) {
        try {
            if (binaryRoot.toExternalForm().startsWith("jar:file:")) {
                FileObject resultFO;
                URL result;
                TestEntry testJar;
                File jar = FileUtil.archiveOrDirForURL((URL)binaryRoot);
                TestEntry testEntry = testJar = jar != null ? TestEntry.get(jar) : null;
                if (testJar != null && (result = testJar.getSrcDir()) != null && (resultFO = URLMapper.findFileObject((URL)result)) != null) {
                    return new SourceForBinaryQuery.Result(){

                        public FileObject[] getRoots() {
                            return new FileObject[]{resultFO};
                        }

                        public void addChangeListener(ChangeListener l) {
                        }

                        public void removeChangeListener(ChangeListener l) {
                        }
                    };
                }
            }
            NbPlatform supposedPlaf = null;
            for (NbPlatform plaf : NbPlatform.getPlatformsOrNot()) {
                if (binaryRoot.toExternalForm().indexOf(plaf.getDestDir().toURI().toURL().toExternalForm()) == -1) continue;
                supposedPlaf = plaf;
                break;
            }
            if (!binaryRoot.getProtocol().equals("jar")) {
                Util.err.log(binaryRoot + " is not an archive file.");
                return null;
            }
            File binaryRootF = FileUtil.archiveOrDirForURL((URL)binaryRoot);
            if (binaryRootF == null) {
                return null;
            }
            String name = binaryRootF.getName();
            if (!name.endsWith(".jar")) {
                return null;
            }
            String cnb = name.substring(0, name.length() - 4).replace('-', '.');
            if (supposedPlaf == null) {
                URL[] sourceRoots = ModuleList.getSourceRootsForExternalModule(binaryRootF);
                if (sourceRoots.length > 0) {
                    return new ExtClusterResult(new SourceRootsSupport(sourceRoots, null), cnb);
                }
                return null;
            }
            return new NbPlatformResult(supposedPlaf, cnb);
        }
        catch (IOException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static final class NetBeansSourcesParser {
        private static final Map<File, NetBeansSourcesParser> instances = new HashMap<File, NetBeansSourcesParser>();
        private static final String NBBUILD_ENTRY = "nbbuild/";
        private Map<String, String> cnbToPrjDir;
        private final ZipFile nbSrcZip;
        private final String zipNBRoot;

        public static NetBeansSourcesParser getInstance(File nbSrcZip) throws ZipException, IOException {
            ZipFile nbSrcZipFile;
            String zipNBRoot;
            NetBeansSourcesParser nbsp = instances.get(nbSrcZip);
            if (nbsp == null && (zipNBRoot = NetBeansSourcesParser.findNBRoot(nbSrcZipFile = new ZipFile(nbSrcZip))) != null) {
                nbsp = new NetBeansSourcesParser(nbSrcZipFile, zipNBRoot);
                instances.put(nbSrcZip, nbsp);
            }
            return nbsp;
        }

        NetBeansSourcesParser(ZipFile nbSrcZip, String zipNBRoot) {
            this.nbSrcZip = nbSrcZip;
            this.zipNBRoot = zipNBRoot;
        }

        String findSourceRoot(String cnb) {
            if (this.cnbToPrjDir == null) {
                try {
                    this.doScanZippedNetBeansOrgSources();
                }
                catch (IOException ex) {
                    Util.err.notify(16, (Throwable)ex);
                }
            }
            return this.cnbToPrjDir.get(cnb);
        }

        private static String findNBRoot(ZipFile nbSrcZip) {
            String nbRoot = null;
            Enumeration<? extends ZipEntry> en = nbSrcZip.entries();
            while (en.hasMoreElements()) {
                ZipEntry xmlEntry;
                String name;
                ZipEntry entry = en.nextElement();
                if (!entry.isDirectory() || !(name = entry.getName()).equals(NBBUILD_ENTRY) && (!name.endsWith(NBBUILD_ENTRY) || !name.substring(name.indexOf(47) + 1).equals(NBBUILD_ENTRY)) || (xmlEntry = nbSrcZip.getEntry(name + "nbproject/project.xml")) == null) continue;
                nbRoot = name.substring(0, name.length() - NBBUILD_ENTRY.length());
                break;
            }
            return nbRoot;
        }

        private void doScanZippedNetBeansOrgSources() throws IOException {
            this.cnbToPrjDir = new HashMap<String, String>();
            Enumeration<? extends ZipEntry> en = this.nbSrcZip.entries();
            while (en.hasMoreElements()) {
                String cnb;
                ZipEntry projectXML;
                ZipEntry src;
                String name;
                StringTokenizer st;
                ZipEntry entry = en.nextElement();
                if (!entry.isDirectory()) continue;
                String path = entry.getName().substring(0, entry.getName().length() - 1);
                if (this.zipNBRoot != null && (!path.startsWith(this.zipNBRoot) || path.equals(this.zipNBRoot)) || (st = new StringTokenizer(path, "/")).countTokens() > 3 || ModuleList.EXCLUDED_DIR_NAMES.contains(name = path.substring(path.lastIndexOf(47) + 1, path.length())) || (src = this.nbSrcZip.getEntry(entry.getName() + "src/")) == null || !src.isDirectory() || (projectXML = this.nbSrcZip.getEntry(entry.getName() + "nbproject/project.xml")) == null || (cnb = this.parseCNB(projectXML)) == null) continue;
                this.cnbToPrjDir.put(cnb, entry.getName() + "src/");
            }
        }

        private String parseCNB(ZipEntry projectXML) throws IOException {
            Element cfg;
            Element data;
            Document doc;
            InputStream is = this.nbSrcZip.getInputStream(projectXML);
            try {
                doc = XMLUtil.parse((InputSource)new InputSource(is), (boolean)false, (boolean)true, null, null);
            }
            catch (SAXException e) {
                throw (IOException)new IOException(projectXML + ": " + e.toString()).initCause(e);
            }
            finally {
                is.close();
            }
            Element docel = doc.getDocumentElement();
            Element type = XMLUtil.findElement((Element)docel, (String)"type", (String)"http://www.netbeans.org/ns/project/1");
            String cnb = null;
            if (XMLUtil.findText((Node)type).equals("org.netbeans.modules.apisupport.project") && (data = XMLUtil.findElement((Element)(cfg = XMLUtil.findElement((Element)docel, (String)"configuration", (String)"http://www.netbeans.org/ns/project/1")), (String)"data", null)) != null) {
                cnb = XMLUtil.findText((Node)XMLUtil.findElement((Element)data, (String)"code-name-base", null));
            }
            return cnb;
        }
    }

    private static final class NbPlatformResult
    extends SourceRootsProviderResult
    implements PropertyChangeListener {
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private final NbPlatform platform;
        private boolean alreadyListening;

        NbPlatformResult(NbPlatform platform, String cnb) {
            super(platform, cnb);
            this.platform = platform;
        }

        @Override
        public void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
            if (!this.alreadyListening) {
                this.platform.addPropertyChangeListener(this);
                this.alreadyListening = true;
            }
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
            if (!this.changeSupport.hasListeners()) {
                this.platform.removePropertyChangeListener(this);
                this.alreadyListening = false;
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("sourceRoots".equals(evt.getPropertyName())) {
                this.changeSupport.fireChange();
            }
        }

        @Override
        protected String resolveRelativePath(URL sourceRoot) throws IOException {
            return null;
        }
    }

    private static final class ExtClusterResult
    extends SourceRootsProviderResult {
        private ExtClusterResult(SourceRootsSupport sourceRootsSupport, String cnb) {
            super(sourceRootsSupport, cnb);
        }

        @Override
        protected String resolveRelativePath(URL sourceRoot) throws IOException {
            EditableProperties ep;
            String prjName;
            File srPath = new File(URI.create(sourceRoot.toExternalForm()));
            File moduleSrc = new File(srPath, "src");
            if (moduleSrc.exists()) {
                return "src/";
            }
            File prjProp = new File(srPath, "nbproject/project.properties");
            if (prjProp.exists() && (prjName = (ep = Util.loadProperties(FileUtil.toFileObject((File)prjProp))).get((Object)("project." + this.cnb))) != null) {
                return prjName + "/src/";
            }
            return null;
        }
    }

    static abstract class SourceRootsProviderResult
    implements SourceForBinaryQuery.Result {
        private SourceRootsProvider srp;
        final String cnb;

        SourceRootsProviderResult(SourceRootsProvider srp, String cnb) {
            this.srp = srp;
            this.cnb = cnb;
        }

        public FileObject[] getRoots() {
            ArrayList<FileObject> candidates = new ArrayList<FileObject>();
            try {
                for (URL root : this.srp.getSourceRoots()) {
                    URL url;
                    FileObject dir;
                    if (root.getProtocol().equals("jar")) {
                        URL u;
                        FileObject entryFO;
                        String pathInZip;
                        NetBeansSourcesParser nbsp;
                        File nbSrcF = FileUtil.archiveOrDirForURL((URL)root);
                        if (nbSrcF == null || !nbSrcF.exists()) continue;
                        try {
                            nbsp = NetBeansSourcesParser.getInstance(nbSrcF);
                        }
                        catch (ZipException e) {
                            if (quiet) continue;
                            Util.err.annotate((Throwable)e, 0, nbSrcF + " does not seem to be a valid ZIP file.", null, null, null);
                            Util.err.notify(1, (Throwable)e);
                            continue;
                        }
                        if (nbsp == null || (pathInZip = nbsp.findSourceRoot(this.cnb)) == null || (entryFO = URLMapper.findFileObject((URL)(u = new URL(root, pathInZip)))) == null) continue;
                        candidates.add(entryFO);
                        continue;
                    }
                    String relPath = this.resolveRelativePath(root);
                    if (relPath == null || (dir = URLMapper.findFileObject((URL)(url = new URL(root, relPath)))) == null) continue;
                    candidates.add(dir);
                }
            }
            catch (IOException ex) {
                throw new AssertionError((Object)ex);
            }
            return candidates.toArray(new FileObject[candidates.size()]);
        }

        protected abstract String resolveRelativePath(URL var1) throws IOException;

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }
}

