/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.wizards;

import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataObject;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.hibernate.wizards.HibernateRevengDatabaseTablesPanel;
import org.netbeans.modules.hibernate.wizards.support.Table;
import org.netbeans.modules.hibernate.wizards.support.TableClosure;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class HibernateRevengDbTablesWizardDescriptor
implements WizardDescriptor.FinishablePanel,
ChangeListener {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private HibernateRevengDatabaseTablesPanel panel;
    private boolean componentInitialized;
    private WizardDescriptor wizardDescriptor;
    private Project project;
    private String title;

    public HibernateRevengDbTablesWizardDescriptor(Project project, String title) {
        this.project = project;
        this.title = title;
    }

    public HibernateRevengDatabaseTablesPanel getComponent() {
        if (this.panel == null) {
            this.panel = new HibernateRevengDatabaseTablesPanel(this.project);
            this.panel.addChangeListener(this);
        }
        return this.panel;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(HibernateRevengDbTablesWizardDescriptor.class);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public boolean isValid() {
        if (this.getComponent().getConfigurationFile() != null) {
            try {
                DataObject cfgDataObject = DataObject.find((FileObject)this.getComponent().getConfigurationFile());
                HibernateCfgDataObject hco = (HibernateCfgDataObject)cfgDataObject;
                HibernateEnvironment env = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
                boolean value = env.canLoadDBDriver(hco.getHibernateConfiguration());
                if (!value) {
                    this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(HibernateRevengDbTablesWizardDescriptor.class, (String)"ERR_Include_DBJars"));
                    return false;
                }
                value = env.canDirectlyConnectToDB(hco.getHibernateConfiguration());
                if (!value) {
                    this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(HibernateRevengDbTablesWizardDescriptor.class, (String)"ERR_No_DB_Connection", (Object)this.getComponent().getConfigurationFile().getNameExt()));
                    return false;
                }
            }
            catch (Exception e) {
                this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(HibernateRevengDbTablesWizardDescriptor.class, (String)"ERR_Include_DBJars"));
                return false;
            }
        }
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.changeSupport.fireChange();
    }

    private void setErrorMessage(String errorMessage) {
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)errorMessage);
    }

    public boolean isFinishPanel() {
        return this.isValid();
    }

    public void readSettings(Object settings) {
        this.wizardDescriptor = (WizardDescriptor)settings;
        this.wizardDescriptor.putProperty("NewFileWizard_Title", (Object)this.title);
        if (!this.componentInitialized) {
            this.componentInitialized = true;
            this.project = Templates.getProject((WizardDescriptor)this.wizardDescriptor);
            FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)this.wizardDescriptor);
            this.getComponent().initialize(this.project);
        }
    }

    public void storeSettings(Object settings) {
        WizardDescriptor wiz = (WizardDescriptor)settings;
        this.wizardDescriptor = (WizardDescriptor)settings;
        this.panel = this.getComponent();
        if (WizardDescriptor.PREVIOUS_OPTION.equals(this.wizardDescriptor.getValue())) {
            return;
        }
        TableClosure tc = this.getTableClosure();
        if (tc == null) {
            this.getComponent().update(this.getTableClosure());
        }
    }

    public TableClosure getTableClosure() {
        return this.getComponent().getTableClosure();
    }

    public FileObject getConfigurationFile() {
        return this.getComponent().getConfigurationFile();
    }

    public String getSchemaName() {
        return this.getComponent().getSchemaName();
    }

    public String getCatalogName() {
        return this.getComponent().getCatalogName();
    }

    public Set<Table> getSelectedTables() {
        return this.getComponent().getTableClosure().getSelectedTables();
    }
}

