/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.TypeElementFinder;
import org.netbeans.api.project.Project;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.hibernate.wizards.HibernateConfigurationWizardPanel;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class HibernateMappingWizardPanel
extends JPanel {
    private Project project;
    List<FileObject> configFileObjects;
    List<String> databaseTables;
    private HibernateEnvironment env;
    private JButton browseButton;
    private JComboBox cmbDatabaseTable;
    private JComboBox cmbResource;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JTextField txtClassName;

    public HibernateMappingWizardPanel(Project project) {
        this.project = project;
        this.initComponents();
        this.env = (HibernateEnvironment)project.getLookup().lookup(HibernateEnvironment.class);
        String[] configFiles = this.getConfigFilesFromProject(project);
        this.cmbResource.setModel(new DefaultComboBoxModel<String>(configFiles));
        this.fillDatabaseTable();
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HibernateMappingWizardPanel.this.browseButtonActionPerformed(evt);
            }
        });
    }

    public void fillDatabaseTable() {
        if (this.cmbResource.getItemCount() == 0) {
            this.cmbDatabaseTable.setModel(new DefaultComboBoxModel<String>(new String[0]));
        } else if (this.cmbResource.getSelectedIndex() != -1) {
            try {
                this.databaseTables = this.env.getAllDatabaseTablesOnEventThread(this.configFileObjects.get(this.cmbResource.getSelectedIndex()));
                this.databaseTables.add(0, "");
                this.cmbDatabaseTable.setModel(new DefaultComboBoxModel<Object>(this.databaseTables.toArray()));
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (DatabaseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (SQLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ElementHandle handle = TypeElementFinder.find(null, (TypeElementFinder.Customizer)new TypeElementFinder.Customizer(){

                    public Set<ElementHandle<TypeElement>> query(ClasspathInfo classpathInfo, String textForQuery, ClassIndex.NameKind nameKind, Set<ClassIndex.SearchScope> searchScopes) {
                        return classpathInfo.getClassIndex().getDeclaredTypes(textForQuery, nameKind, searchScopes);
                    }

                    public boolean accept(ElementHandle<TypeElement> typeHandle) {
                        return true;
                    }
                });
                if (handle != null) {
                    HibernateMappingWizardPanel.this.txtClassName.setText(handle.getQualifiedName());
                }
            }
        });
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(HibernateConfigurationWizardPanel.class, (String)"LBL_HibernateMappingPanel_Name");
    }

    public String getClassName() {
        if (this.txtClassName.getText() != null) {
            return this.txtClassName.getText().trim();
        }
        return null;
    }

    public FileObject getConfigurationFile() {
        if (this.cmbResource.getSelectedIndex() != -1) {
            return this.configFileObjects.get(this.cmbResource.getSelectedIndex());
        }
        return null;
    }

    public String getDatabaseTable() {
        if (this.cmbDatabaseTable.getSelectedIndex() != -1) {
            return this.cmbDatabaseTable.getSelectedItem().toString().trim();
        }
        return null;
    }

    public String[] getConfigFilesFromProject(Project project) {
        ArrayList<String> configFiles = new ArrayList<String>();
        this.configFileObjects = this.env.getAllHibernateConfigFileObjects();
        for (FileObject fo : this.configFileObjects) {
            configFiles.add(fo.getNameExt());
        }
        return configFiles.toArray(new String[0]);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.txtClassName = new JTextField();
        this.browseButton = new JButton();
        this.jLabel2 = new JLabel();
        this.cmbResource = new JComboBox();
        this.jLabel3 = new JLabel();
        this.cmbDatabaseTable = new JComboBox();
        this.setName(NbBundle.getMessage(HibernateMappingWizardPanel.class, (String)"LBL_HibernateMappingPanel_Name"));
        this.jLabel1.setLabelFor(this.txtClassName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(HibernateMappingWizardPanel.class, (String)"HibernateMappingWizardPanel.jLabel1.text"));
        this.txtClassName.setColumns(30);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(HibernateMappingWizardPanel.class, (String)"HibernateMappingWizardPanel.browseButton.text"));
        this.jLabel2.setLabelFor(this.cmbResource);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(HibernateMappingWizardPanel.class, (String)"HibernateMappingWizardPanel.jLabel2.text"));
        this.cmbResource.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cmbResource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HibernateMappingWizardPanel.this.cmbResourceActionPerformed(evt);
            }
        });
        this.jLabel3.setLabelFor(this.cmbDatabaseTable);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(HibernateMappingWizardPanel.class, (String)"HibernateMappingWizardPanel.jLabel3.text"));
        this.cmbDatabaseTable.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).add(27, 27, 27).add((Component)this.txtClassName, -1, 374, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.browseButton)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jLabel3, -1, -1, Short.MAX_VALUE).add((Component)this.jLabel2, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.cmbDatabaseTable, 0, 431, Short.MAX_VALUE).add((Component)this.cmbResource, 0, 431, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.browseButton).add((Component)this.txtClassName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.cmbResource, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.cmbDatabaseTable, -2, -1, -2).add((Component)this.jLabel3)).addContainerGap(16, Short.MAX_VALUE)));
    }

    private void cmbResourceActionPerformed(ActionEvent evt) {
        this.fillDatabaseTable();
    }
}

