/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.loaders.cfg.multiview;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataObject;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.BrowseFolders;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.CollectionCachePanel;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.CollectionCachesTableModel;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.SecurityTablePanel;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.Util;
import org.netbeans.modules.xml.multiview.ui.DefaultTablePanel;
import org.netbeans.modules.xml.multiview.ui.EditDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class CollectionCachesTablePanel
extends DefaultTablePanel {
    private CollectionCachesTableModel model;
    private HibernateCfgDataObject configDataObject;

    public CollectionCachesTablePanel(HibernateCfgDataObject dObj, final CollectionCachesTableModel model) {
        super((AbstractTableModel)model);
        this.model = model;
        this.configDataObject = dObj;
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CollectionCachesTablePanel.this.configDataObject.modelUpdatedFromUI();
                int row = CollectionCachesTablePanel.this.getTable().getSelectedRow();
                model.removeRow(row);
            }
        });
        this.editButton.addActionListener(new TableActionListener(false));
        this.addButton.addActionListener(new TableActionListener(true));
    }

    private class TableActionListener
    implements ActionListener {
        private boolean add;

        TableActionListener(boolean add) {
            this.add = add;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int row = this.add ? -1 : CollectionCachesTablePanel.this.getTable().getSelectedRow();
            final CollectionCachePanel dialogPanel = new CollectionCachePanel();
            if (!this.add) {
                String className = (String)CollectionCachesTablePanel.this.model.getValueAt(row, 0);
                String region = (String)CollectionCachesTablePanel.this.model.getValueAt(row, 1);
                String usage = (String)CollectionCachesTablePanel.this.model.getValueAt(row, 2);
                dialogPanel.initValues(className, region, usage);
            }
            dialogPanel.addBrowseClassActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    try {
                        SourceGroup[] groups = Util.getJavaSourceGroups(CollectionCachesTablePanel.this.configDataObject);
                        FileObject fo = BrowseFolders.showDialog(groups);
                        if (fo != null) {
                            String className = Util.getResourcePath(groups, fo);
                            dialogPanel.getClassTextField().setText(className);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            EditDialog dialog = new EditDialog(dialogPanel, NbBundle.getMessage(SecurityTablePanel.class, (String)"LBL_Collection_Cache"), this.add){

                protected String validate() {
                    String className = dialogPanel.getClassName();
                    if (className.length() == 0) {
                        return NbBundle.getMessage(SecurityTablePanel.class, (String)"TXT_Class_Empty");
                    }
                    return null;
                }
            };
            if (this.add) {
                dialog.setValid(false);
            }
            EditDialog.DocListener docListener = new EditDialog.DocListener(dialog);
            dialogPanel.getClassTextField().getDocument().addDocumentListener((DocumentListener)docListener);
            Dialog d = DialogDisplayer.getDefault().createDialog((DialogDescriptor)dialog);
            d.setVisible(true);
            dialogPanel.getClassTextField().getDocument().removeDocumentListener((DocumentListener)docListener);
            if (dialog.getValue().equals(EditDialog.OK_OPTION)) {
                CollectionCachesTablePanel.this.configDataObject.modelUpdatedFromUI();
                String className = dialogPanel.getClassName();
                String region = dialogPanel.getRegion();
                String usage = dialogPanel.getUsage();
                if (this.add) {
                    CollectionCachesTablePanel.this.model.addRow(new String[]{className, region, usage});
                } else {
                    CollectionCachesTablePanel.this.model.editRow(row, new String[]{className, region, usage});
                }
            }
        }
    }
}

