/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints.rules;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import org.netbeans.modules.websvc.editor.hints.common.ProblemContext;
import org.netbeans.modules.websvc.editor.hints.common.Rule;
import org.netbeans.modules.websvc.editor.hints.common.Utilities;
import org.netbeans.modules.websvc.editor.hints.fixes.RemoveAnnotationArgument;
import org.netbeans.modules.websvc.editor.hints.rules.WebServiceAnnotations;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class InvalidExcludeAttribute
extends Rule<ExecutableElement>
implements WebServiceAnnotations {
    @Override
    protected ErrorDescription[] apply(ExecutableElement subject, ProblemContext ctx) {
        AnnotationMirror methodAnn = Utilities.findAnnotation(subject, "javax.jws.WebMethod");
        AnnotationValue val = Utilities.getAnnotationAttrValue(methodAnn, "exclude");
        Element classEl = subject.getEnclosingElement();
        if (val != null && val.getValue() == Boolean.TRUE) {
            if (classEl != null && classEl.getKind() == ElementKind.INTERFACE) {
                String label = NbBundle.getMessage(InvalidExcludeAttribute.class, (String)"MSG_WebMethod_ExcludeNotAllowed");
                RemoveAnnotationArgument fix = new RemoveAnnotationArgument(ctx.getFileObject(), subject, methodAnn, "exclude");
                AnnotationTree annotationTree = (AnnotationTree)ctx.getCompilationInfo().getTrees().getTree(subject, methodAnn);
                ExpressionTree problemTree = Utilities.getAnnotationArgumentTree(annotationTree, "exclude");
                ctx.setElementToAnnotate(problemTree);
                ErrorDescription problem = InvalidExcludeAttribute.createProblem((Element)subject, ctx, label, fix);
                ctx.setElementToAnnotate(null);
                return new ErrorDescription[]{problem};
            }
            if (classEl != null && classEl.getKind() == ElementKind.CLASS) {
                AnnotationValue opNameAttr = Utilities.getAnnotationAttrValue(methodAnn, "operationName");
                if (opNameAttr != null) {
                    String label = NbBundle.getMessage(InvalidExcludeAttribute.class, (String)"MSG_WebMethod_OperationNameNotAllowed");
                    RemoveAnnotationArgument fix = new RemoveAnnotationArgument(ctx.getFileObject(), subject, methodAnn, "operationName");
                    AnnotationTree annotationTree = (AnnotationTree)ctx.getCompilationInfo().getTrees().getTree(subject, methodAnn);
                    ExpressionTree problemTree = Utilities.getAnnotationArgumentTree(annotationTree, "operationName");
                    ctx.setElementToAnnotate(problemTree);
                    ErrorDescription problem = InvalidExcludeAttribute.createProblem((Element)subject, ctx, label, fix);
                    ctx.setElementToAnnotate(null);
                    return new ErrorDescription[]{problem};
                }
                AnnotationValue actionAttr = Utilities.getAnnotationAttrValue(methodAnn, "action");
                if (actionAttr != null) {
                    String label = NbBundle.getMessage(InvalidExcludeAttribute.class, (String)"MSG_WebMethod_ActionNotAllowed");
                    RemoveAnnotationArgument fix = new RemoveAnnotationArgument(ctx.getFileObject(), subject, methodAnn, "action");
                    AnnotationTree annotationTree = (AnnotationTree)ctx.getCompilationInfo().getTrees().getTree(subject, methodAnn);
                    ExpressionTree problemTree = Utilities.getAnnotationArgumentTree(annotationTree, "action");
                    ctx.setElementToAnnotate(problemTree);
                    ErrorDescription problem = InvalidExcludeAttribute.createProblem((Element)subject, ctx, label, fix);
                    ctx.setElementToAnnotate(null);
                    return new ErrorDescription[]{problem};
                }
            }
        }
        return null;
    }

    @Override
    protected boolean isApplicable(ExecutableElement subject, ProblemContext ctx) {
        return Utilities.hasAnnotation(subject, "javax.jws.WebMethod");
    }
}

