/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbverification.rules;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.ejbverification.EJBProblemContext;
import org.netbeans.modules.j2ee.ejbverification.EJBProblemFinder;
import org.netbeans.modules.j2ee.ejbverification.EJBVerificationRule;
import org.netbeans.modules.j2ee.ejbverification.HintsUtils;
import org.netbeans.modules.j2ee.ejbverification.JavaUtils;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.util.NbBundle;

public class BMnotPartOfRBIandLBI
extends EJBVerificationRule {
    @Override
    public Collection<ErrorDescription> check(EJBProblemContext ctx) {
        if (ctx.getEjb() instanceof Session) {
            Session session = (Session)ctx.getEjb();
            Collection<ExecutableElement> localMethods = null;
            HashMap<String, ExecutableElement> remoteMethods = new HashMap<String, ExecutableElement>();
            try {
                localMethods = this.getMethodsFromClasses(ctx.getComplilationInfo(), session.getBusinessLocal());
                for (ExecutableElement method : this.getMethodsFromClasses(ctx.getComplilationInfo(), session.getBusinessRemote())) {
                    remoteMethods.put(method.getSimpleName().toString(), method);
                }
                for (ExecutableElement localMethod : localMethods) {
                    ExecutableElement sameNameRemoteMethod = (ExecutableElement)remoteMethods.get(localMethod.getSimpleName().toString());
                    if (sameNameRemoteMethod == null || !JavaUtils.isMethodSignatureSame(ctx.getComplilationInfo(), localMethod, sameNameRemoteMethod)) continue;
                    ErrorDescription err = HintsUtils.createProblem((Element)ctx.getClazz(), ctx.getComplilationInfo(), NbBundle.getMessage(BMnotPartOfRBIandLBI.class, (String)"MSG_BMnotPartOfRBIandLBI"), Severity.WARNING);
                    return Collections.singletonList(err);
                }
            }
            catch (VersionNotSupportedException ex) {
                EJBProblemFinder.LOG.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        return null;
    }

    private Collection<ExecutableElement> getMethodsFromClasses(CompilationInfo cinfo, String[] classNames) {
        LinkedList<ExecutableElement> methods = new LinkedList<ExecutableElement>();
        if (classNames != null) {
            for (String className : classNames) {
                TypeElement clazz = cinfo.getElements().getTypeElement(className);
                if (clazz == null) continue;
                methods.addAll(ElementFilter.methodsIn(clazz.getEnclosedElements()));
            }
        }
        return methods;
    }
}

