/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbverification.fixes;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.HashSet;
import java.util.logging.Level;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.ejbverification.EJBProblemFinder;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class RemoveModifier
implements Fix {
    private FileObject fileObject;
    private Modifier modifier;
    private ElementHandle<TypeElement> classHandle;

    public RemoveModifier(FileObject fileObject, ElementHandle<TypeElement> classHandle, Modifier modifier) {
        this.classHandle = classHandle;
        this.fileObject = fileObject;
        this.modifier = modifier;
    }

    public ChangeInfo implement() {
        CancellableTask<WorkingCopy> task = new CancellableTask<WorkingCopy>(){

            public void cancel() {
            }

            public void run(WorkingCopy workingCopy) throws Exception {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                TypeElement clazz = (TypeElement)RemoveModifier.this.classHandle.resolve((CompilationInfo)workingCopy);
                if (clazz != null) {
                    ClassTree clazzTree = workingCopy.getTrees().getTree(clazz);
                    TreeMaker make = workingCopy.getTreeMaker();
                    HashSet<Modifier> flags = new HashSet<Modifier>(clazzTree.getModifiers().getFlags());
                    flags.remove((Object)RemoveModifier.this.modifier);
                    ModifiersTree newModifiers = make.Modifiers(flags, clazzTree.getModifiers().getAnnotations());
                    workingCopy.rewrite((Tree)clazzTree.getModifiers(), (Tree)newModifiers);
                }
            }
        };
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.fileObject);
        try {
            javaSource.runModificationTask((Task)task).commit();
        }
        catch (IOException e) {
            EJBProblemFinder.LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public String getText() {
        return NbBundle.getMessage(RemoveModifier.class, (String)"LBL_RemoveModifier", (Object)((Object)this.modifier));
    }
}

