/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.JavaFix;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class UseSpecificCatch {
    public static ErrorDescription hint1(HintContext ctx) {
        return UseSpecificCatch.impl(ctx, "java.lang.Throwable");
    }

    public static ErrorDescription hint2(HintContext ctx) {
        return UseSpecificCatch.impl(ctx, "java.lang.Exception");
    }

    private static ErrorDescription impl(HintContext ctx, String th) {
        if (ctx.getInfo().getSourceVersion().compareTo(SourceVersion.RELEASE_7) < 0) {
            return null;
        }
        TryTree tt = (TryTree)ctx.getPath().getLeaf();
        Set exceptions = ctx.getInfo().getTreeUtilities().getUncaughtExceptions(new TreePath(ctx.getPath(), tt.getBlock()));
        if (exceptions.size() <= 1) {
            return null;
        }
        TypeElement throwable = ctx.getInfo().getElements().getTypeElement(th);
        if (throwable == null) {
            return null;
        }
        if (exceptions.contains(throwable.asType())) {
            return null;
        }
        if (UseSpecificCatch.assignsTo(ctx, ctx.getVariables().get("$t"), (Iterable<? extends TreePath>)ctx.getMultiVariables().get("$catch$"))) {
            return null;
        }
        String displayName = NbBundle.getMessage(UseSpecificCatch.class, (String)"ERR_UseSpecificCatch");
        LinkedHashSet<TypeMirrorHandle<TypeMirror>> exceptionHandles = new LinkedHashSet<TypeMirrorHandle<TypeMirror>>();
        for (TypeMirror tm : exceptions) {
            exceptionHandles.add(TypeMirrorHandle.create((TypeMirror)tm));
        }
        return ErrorDescriptionFactory.forName(ctx, tt.getCatches().get(0).getParameter().getType(), displayName, JavaFix.toEditorFix(new FixImpl(ctx.getInfo(), new TreePath(ctx.getPath(), tt.getCatches().get(0)), exceptionHandles)));
    }

    static boolean assignsTo(final HintContext ctx, TreePath variable, Iterable<? extends TreePath> statements) {
        final Element tEl = ctx.getInfo().getTrees().getElement(variable);
        if (tEl == null || tEl.getKind() != ElementKind.EXCEPTION_PARAMETER) {
            return true;
        }
        final boolean[] result = new boolean[1];
        for (TreePath treePath : statements) {
            new TreePathScanner<Void, Void>(){

                @Override
                public Void visitAssignment(AssignmentTree node, Void p) {
                    if (((Object)tEl).equals(ctx.getInfo().getTrees().getElement(new TreePath(this.getCurrentPath(), node.getVariable())))) {
                        result[0] = true;
                    }
                    return (Void)super.visitAssignment(node, p);
                }
            }.scan(treePath, (Void)null);
        }
        return result[0];
    }

    private static final class FixImpl
    extends JavaFix {
        private final Set<TypeMirrorHandle<TypeMirror>> exceptionHandles;

        public FixImpl(CompilationInfo info, TreePath tryStatement, Set<TypeMirrorHandle<TypeMirror>> exceptionHandles) {
            super(info, tryStatement);
            this.exceptionHandles = exceptionHandles;
        }

        @Override
        protected String getText() {
            return NbBundle.getMessage(UseSpecificCatch.class, (String)"FIX_UseSpecificCatch");
        }

        @Override
        protected void performRewrite(WorkingCopy wc, TreePath tp, JavaFix.UpgradeUICallback callback) {
            LinkedList<Tree> exceptions = new LinkedList<Tree>();
            for (TypeMirrorHandle<TypeMirror> h : this.exceptionHandles) {
                TypeMirror tm = h.resolve((CompilationInfo)wc);
                if (tm == null) {
                    return;
                }
                exceptions.add(wc.getTreeMaker().Type(tm));
            }
            VariableTree excVar = ((CatchTree)tp.getLeaf()).getParameter();
            wc.rewrite(excVar.getType(), (Tree)wc.getTreeMaker().DisjunctiveType(exceptions));
        }
    }
}

