/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.impl.pm;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.introduce.CopyFinder;
import org.netbeans.modules.java.hints.jackpot.impl.Utilities;
import org.netbeans.modules.java.hints.jackpot.spi.Hacks;

public class Pattern {
    private final CompilationInfo info;
    private final String pattern;
    private final Tree patternTree;
    private final Iterable<Tree> antipatterns;
    private final Map<String, TypeMirror> constraintsHack;

    public Pattern(CompilationInfo info, String pattern, Tree patternTree, Iterable<Tree> antipatterns, Map<String, TypeMirror> constraintsHack) {
        this.info = info;
        this.pattern = pattern;
        this.patternTree = patternTree;
        this.antipatterns = antipatterns;
        this.constraintsHack = constraintsHack;
    }

    public static Pattern compile(CompilationInfo info, String pattern) {
        HashMap<String, TypeMirror> constraints = new HashMap<String, TypeMirror>();
        pattern = Pattern.parseOutTypesFromPattern(info, pattern, constraints);
        return Pattern.compile(info, pattern, constraints, Collections.emptyList());
    }

    public static Pattern compile(CompilationInfo info, String pattern, Map<String, TypeMirror> constraints, Iterable<? extends String> imports) {
        return Pattern.compile(info, pattern, Collections.<String>emptyList(), constraints, imports);
    }

    public static Pattern compile(CompilationInfo info, String pattern, Iterable<String> antipatterns, Map<String, TypeMirror> constraints, Iterable<? extends String> imports) {
        Scope[] scope = new Scope[1];
        Tree patternTree = Pattern.parseAndAttribute(info, pattern, constraints, scope, imports);
        LinkedList<Tree> antipatternsTrees = new LinkedList<Tree>();
        for (String ap : antipatterns) {
            ExpressionTree p = info.getTreeUtilities().parseExpression(ap, new SourcePositions[1]);
            info.getTreeUtilities().attributeTree((Tree)p, scope[0]);
            antipatternsTrees.add(p);
        }
        return new Pattern(info, pattern, patternTree, antipatternsTrees, constraints);
    }

    public Map<String, TreePath> match(TreePath toCheck) {
        CopyFinder.VariableAssignments variables = CopyFinder.computeVariables(this.info, new TreePath(new TreePath(this.info.getCompilationUnit()), this.patternTree), toCheck, new AtomicBoolean(), this.constraintsHack);
        if (variables == null) {
            return null;
        }
        return variables.variables;
    }

    public boolean checkAntipatterns(TreePath tp) {
        for (Tree ap : this.antipatterns) {
            if (CopyFinder.computeVariables(this.info, new TreePath(new TreePath(this.info.getCompilationUnit()), ap), tp, new AtomicBoolean(), this.constraintsHack) == null) continue;
            return false;
        }
        return true;
    }

    public Map<String, TypeMirror> getConstraints() {
        return this.constraintsHack;
    }

    public String getPatternCode() {
        return this.pattern;
    }

    public Tree getPattern() {
        return this.patternTree;
    }

    private static String parseOutTypesFromPattern(CompilationInfo info, String pattern, Map<String, TypeMirror> variablesToTypes) {
        java.util.regex.Pattern p = java.util.regex.Pattern.compile("(\\$.)(\\{([^}]*)\\})?");
        StringBuffer filtered = new StringBuffer();
        Matcher m = p.matcher(pattern);
        int i = 0;
        while (m.find()) {
            filtered.append(pattern.substring(i, m.start()));
            i = m.end();
            String var = m.group(1);
            String type = m.group(3);
            filtered.append(var);
            variablesToTypes.put(var, type != null ? Hacks.parseFQNType(info, type) : null);
        }
        filtered.append(pattern.substring(i));
        return filtered.toString();
    }

    public static Tree parseAndAttribute(CompilationInfo info, String pattern, Map<String, TypeMirror> constraints, Scope[] scope, Iterable<? extends String> imports) {
        scope[0] = Utilities.constructScope(info, constraints, imports);
        if (scope[0] == null) {
            return null;
        }
        return Utilities.parseAndAttribute(info, pattern, scope[0]);
    }
}

