/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.jackpot.spi.JavaFix;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public class ConvertToDiamond
implements ErrorRule<Void> {
    private static final Set<String> CODES = new HashSet<String>(Arrays.asList("compiler.warn.diamond.redundant.args", "compiler.warn.diamond.redundant.args.1"));

    @Override
    public Set<String> getCodes() {
        return CODES;
    }

    @Override
    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        return Collections.singletonList(JavaFix.toEditorFix(new FixImpl(info, treePath)));
    }

    @Override
    public String getId() {
        return ConvertToDiamond.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(ConvertToDiamond.class, (String)"DN_ConvertToDiamond");
    }

    @Override
    public void cancel() {
    }

    private static final class FixImpl
    extends JavaFix {
        public FixImpl(CompilationInfo info, TreePath path) {
            super(info, path);
        }

        @Override
        public String getText() {
            return NbBundle.getMessage(ConvertToDiamond.class, (String)"FIX_ConvertToDiamond");
        }

        @Override
        protected void performRewrite(WorkingCopy copy, TreePath tp, JavaFix.UpgradeUICallback callback) {
            if (tp.getLeaf().getKind() != Tree.Kind.PARAMETERIZED_TYPE) {
                return;
            }
            TreeMaker make = copy.getTreeMaker();
            ParameterizedTypeTree ptt = (ParameterizedTypeTree)tp.getLeaf();
            ParameterizedTypeTree nue = make.ParameterizedType(ptt.getType(), Collections.emptyList());
            copy.rewrite((Tree)ptt, (Tree)nue);
        }
    }
}

