/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.hints;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.web.jsf.editor.JsfSupportImpl;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibrary;
import org.netbeans.modules.web.jsfapi.api.Library;
import org.netbeans.modules.web.jsfapi.spi.LibraryUtils;
import org.openide.util.NbBundle;

public class FixLibDeclaration
implements HintFix {
    private String nsPrefix;
    private FaceletsLibrary lib;
    private Document doc;

    public FixLibDeclaration(Document doc, String nsPrefix, FaceletsLibrary lib) {
        this.doc = doc;
        this.nsPrefix = nsPrefix;
        this.lib = lib;
    }

    public String getDescription() {
        return NbBundle.getMessage(FixLibDeclaration.class, (String)"MSG_FixLibDeclaration", (Object)this.nsPrefix, (Object)this.lib.getNamespace());
    }

    public void implement() throws Exception {
        LibraryUtils.importLibrary((Document)this.doc, (Library)this.lib, (String)this.nsPrefix);
    }

    public boolean isSafe() {
        return true;
    }

    public boolean isInteractive() {
        return false;
    }

    public static List<FaceletsLibrary> getLibsByPrefix(Document doc, String prefix) {
        ArrayList<FaceletsLibrary> libs = new ArrayList<FaceletsLibrary>();
        JsfSupportImpl sup = JsfSupportImpl.findFor(doc);
        if (sup != null) {
            for (FaceletsLibrary lib : sup.getLibraries().values()) {
                if (!prefix.equals(lib.getDefaultPrefix())) continue;
                libs.add(lib);
            }
        }
        return libs;
    }
}

