/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.partitioning;

import org.eclipse.persistence.descriptors.partitioning.CustomPartitioningPolicy;
import org.eclipse.persistence.descriptors.partitioning.PartitioningPolicy;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.AbstractPartitioningMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

public class PartitioningMetadata
extends AbstractPartitioningMetadata {
    protected String className;

    public PartitioningMetadata() {
        super("<partitioning>");
    }

    public PartitioningMetadata(MetadataAnnotation annotation, MetadataAccessibleObject accessibleObject) {
        super(annotation, accessibleObject);
        this.className = (String)annotation.getAttribute("partitioningClass");
    }

    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof PartitioningMetadata) {
            PartitioningMetadata policy = (PartitioningMetadata)objectToCompare;
            return this.valuesMatch(this.className, policy.getClassName());
        }
        return false;
    }

    public String getClassName() {
        return this.className;
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.className = this.initXMLClassName(this.className).getName();
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public PartitioningPolicy buildPolicy() {
        CustomPartitioningPolicy policy = new CustomPartitioningPolicy();
        super.buildPolicy(policy);
        policy.setPartitioningClasName(this.className);
        return policy;
    }
}

