/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb;

import java.lang.reflect.Method;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.DomHandler;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.JAXBErrorHandler;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.platform.xml.XMLTransformer;
import org.eclipse.persistence.sessions.Session;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;

public class DomHandlerConverter
implements XMLConverter {
    private DomHandler domHandler;
    private XMLTransformer xmlTransformer;
    private String domHandlerClassName;
    private Class elementClass;
    private Class resultType;

    public DomHandlerConverter(String domHandlerClassName) {
        this.domHandlerClassName = domHandlerClassName;
    }

    public void initialize(DatabaseMapping mapping, Session session) {
        try {
            ConversionManager cMgr = session.getDatasourcePlatform().getConversionManager();
            Class domHandlerClass = cMgr.convertClassNameToClass(this.domHandlerClassName);
            this.domHandler = (DomHandler)domHandlerClass.newInstance();
            Method createUnmarshallerMethod = PrivilegedAccessHelper.getDeclaredMethod(domHandlerClass, "createUnmarshaller", new Class[]{ValidationEventHandler.class});
            this.resultType = PrivilegedAccessHelper.getMethodReturnType(createUnmarshallerMethod);
            Method getElementMethod = PrivilegedAccessHelper.getDeclaredMethod(domHandlerClass, "getElement", new Class[]{this.resultType});
            this.elementClass = PrivilegedAccessHelper.getMethodReturnType(getElementMethod);
            this.xmlTransformer = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLTransformer();
            this.xmlTransformer.setFormattedOutput(true);
        }
        catch (Exception ex) {
            throw JAXBException.couldNotInitializeDomHandlerConverter(ex, this.domHandlerClassName, mapping.getAttributeName());
        }
    }

    public Object convertDataValueToObjectValue(Object dataValue, Session session, XMLUnmarshaller unmarshaller) {
        if (dataValue instanceof Element) {
            ErrorHandler handler = unmarshaller.getErrorHandler();
            Result result = null;
            result = handler != null && handler instanceof JAXBErrorHandler ? this.domHandler.createUnmarshaller(((JAXBErrorHandler)handler).getValidationEventHandler()) : this.domHandler.createUnmarshaller(null);
            this.xmlTransformer.transform((Node)((Element)dataValue), result);
            Object value = this.domHandler.getElement(result);
            return value;
        }
        return dataValue;
    }

    public Object convertObjectValueToDataValue(Object objectValue, Session session, XMLMarshaller marshaller) {
        if (objectValue != null && this.elementClass.isAssignableFrom(objectValue.getClass())) {
            Source source = this.domHandler.marshal(objectValue, null);
            DOMResult result = new DOMResult();
            this.xmlTransformer.transform(source, (Result)result);
            return result.getNode();
        }
        return objectValue;
    }

    public boolean isMutable() {
        return true;
    }

    public Object convertDataValueToObjectValue(Object dataValue, Session session) {
        return this.convertDataValueToObjectValue(dataValue, session, null);
    }

    public Object convertObjectValueToDataValue(Object objectValue, Session session) {
        return this.convertObjectValueToDataValue(objectValue, session, null);
    }
}

