/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.debugger.registry;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.spi.debugger.ActionsProvider;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.netbeans.spi.debugger.DebuggerServiceRegistration;
import org.netbeans.spi.debugger.DebuggerServiceRegistrations;
import org.netbeans.spi.debugger.SessionProvider;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class DebuggerProcessor
extends LayerGeneratingProcessor {
    public Set<String> getSupportedAnnotationTypes() {
        return new HashSet<String>(Arrays.asList(ActionsProvider.Registration.class.getCanonicalName(), DebuggerEngineProvider.Registration.class.getCanonicalName(), SessionProvider.Registration.class.getCanonicalName(), LazyActionsManagerListener.Registration.class.getCanonicalName(), DebuggerServiceRegistration.class.getCanonicalName()));
    }

    /*
     * WARNING - void declaration
     */
    protected boolean handleProcess(Set<? extends TypeElement> annotations, RoundEnvironment env) throws LayerGenerationException {
        Annotation regs;
        String path;
        Annotation reg;
        if (env.processingOver()) {
            return false;
        }
        int cnt = 0;
        for (Element element : env.getElementsAnnotatedWith(ActionsProvider.Registration.class)) {
            reg = element.getAnnotation(ActionsProvider.Registration.class);
            path = reg.path();
            String[] actions = reg.actions();
            String[] stringArray = reg.activateForMIMETypes();
            this.handleProviderRegistrationInner(element, ActionsProvider.class, path, actions, stringArray);
            ++cnt;
        }
        for (Element element : env.getElementsAnnotatedWith(ActionsProvider.Registrations.class)) {
            regs = element.getAnnotation(ActionsProvider.Registrations.class);
            for (ActionsProvider.Registration reg2 : regs.value()) {
                String path2 = reg2.path();
                String[] stringArray = reg2.actions();
                String[] mimeTypes = reg2.activateForMIMETypes();
                this.handleProviderRegistrationInner(element, ActionsProvider.class, path2, stringArray, mimeTypes);
            }
            ++cnt;
        }
        for (Element element : env.getElementsAnnotatedWith(LazyActionsManagerListener.Registration.class)) {
            reg = element.getAnnotation(LazyActionsManagerListener.Registration.class);
            path = reg.path();
            this.handleProviderRegistrationInner(element, LazyActionsManagerListener.class, path);
            ++cnt;
        }
        for (Element element : env.getElementsAnnotatedWith(DebuggerEngineProvider.Registration.class)) {
            reg = element.getAnnotation(DebuggerEngineProvider.Registration.class);
            path = reg.path();
            this.handleProviderRegistrationInner(element, DebuggerEngineProvider.class, path);
            ++cnt;
        }
        for (Element element : env.getElementsAnnotatedWith(SessionProvider.Registration.class)) {
            reg = element.getAnnotation(SessionProvider.Registration.class);
            path = reg.path();
            this.handleProviderRegistrationInner(element, SessionProvider.class, path);
            ++cnt;
        }
        for (Element element : env.getElementsAnnotatedWith(DebuggerServiceRegistration.class)) {
            reg = element.getAnnotation(DebuggerServiceRegistration.class);
            AnnotationMirror am = null;
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().toString().equals(DebuggerServiceRegistration.class.getName())) continue;
                am = annotationMirror;
                break;
            }
            this.handleServiceRegistration(element, (DebuggerServiceRegistration)reg, am);
            ++cnt;
        }
        for (Element element : env.getElementsAnnotatedWith(DebuggerServiceRegistrations.class)) {
            void var9_29;
            DebuggerServiceRegistration[] regsv;
            regs = element.getAnnotation(DebuggerServiceRegistrations.class);
            AnnotationMirror amregs = null;
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().toString().equals(DebuggerServiceRegistrations.class.getName())) continue;
                amregs = annotationMirror;
                break;
            }
            if ((regsv = regs.value()) == null || regsv.length == 0) {
                throw new IllegalArgumentException("No service registration for element " + element);
            }
            AnnotationMirror[] annotationMirrorArray = new AnnotationMirror[regsv.length];
            Map<? extends ExecutableElement, ? extends AnnotationValue> annElementValues = amregs.getElementValues();
            for (AnnotationValue annotationValue : annElementValues.values()) {
                Object value = annotationValue.getValue();
                if (!(value instanceof Collection)) continue;
                AnnotationMirror[] annotationMirrorArray2 = (AnnotationMirror[])((Collection)value).toArray((T[])var9_29);
            }
            for (int i = 0; i < regsv.length; ++i) {
                this.handleServiceRegistration(element, regsv[i], (AnnotationMirror)var9_29[i]);
            }
            ++cnt;
        }
        return cnt == annotations.size();
    }

    private List<? extends TypeMirror> getTypeMirrors(DebuggerServiceRegistration reg, AnnotationMirror am) {
        int n;
        ArrayList<TypeMirror> typeMirrors = null;
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = am.getElementValues();
        String classNames = null;
        for (ExecutableElement executableElement : elementValues.keySet()) {
            if (!executableElement.getSimpleName().contentEquals("types")) continue;
            classNames = elementValues.get(executableElement).getValue().toString();
        }
        if (classNames == null) {
            throw new IllegalArgumentException("Annotation " + am + " does not provide types");
        }
        typeMirrors = new ArrayList<TypeMirror>();
        int i1 = 0;
        while ((n = classNames.indexOf(44, i1)) > 0 || i1 < classNames.length()) {
            String className;
            if (n < 0) {
                n = classNames.length();
            }
            if ((className = classNames.substring(i1, n).trim()).endsWith(".class")) {
                className = className.substring(0, className.length() - ".class".length());
            }
            TypeElement type = this.processingEnv.getElementUtils().getTypeElement(className);
            typeMirrors.add(type.asType());
            i1 = n + 1;
        }
        return typeMirrors;
    }

    private void handleServiceRegistration(Element e, DebuggerServiceRegistration reg, AnnotationMirror am) throws LayerGenerationException {
        List<? extends TypeMirror> typeMirrors = this.getTypeMirrors(reg, am);
        List<? extends TypeMirror> notImplTypeMirrors = this.implementsInterfaces(e, typeMirrors);
        if (!notImplTypeMirrors.isEmpty()) {
            throw new IllegalArgumentException("Annotated element " + e + " does not implement all interfaces " + notImplTypeMirrors);
        }
        String path = reg.path();
        LayerBuilder lb = this.layer(new Element[]{e});
        String className = this.instantiableClassOrMethod(e);
        StringBuilder classNamesBuilder = new StringBuilder();
        for (TypeMirror typeMirror : typeMirrors) {
            TypeElement te = (TypeElement)this.processingEnv.getTypeUtils().asElement(typeMirror);
            String cn = te != null ? this.processingEnv.getElementUtils().getBinaryName(te).toString() : ((Object)typeMirror).toString();
            if (classNamesBuilder.length() > 0) {
                classNamesBuilder.append(", ");
            }
            classNamesBuilder.append(cn);
        }
        path = path != null && path.length() > 0 ? "Debugger/" + path : "Debugger";
        String basename = className.replace('.', '-');
        LayerBuilder.File file = lb.file(path + "/" + basename + ".instance");
        file.stringvalue("serviceName", className).stringvalue("instanceOf", classNamesBuilder.toString()).methodvalue("instanceCreate", "org.netbeans.spi.debugger.ContextAwareSupport", "createService").position(reg.position()).write();
    }

    private void handleProviderRegistrationInner(Element e, Class providerClass, String path) throws IllegalArgumentException, LayerGenerationException {
        this.handleProviderRegistrationInner(e, providerClass, path, null, null);
    }

    private void handleProviderRegistrationInner(Element e, Class providerClass, String path, String[] actions, String[] enabledOnMIMETypes) throws IllegalArgumentException, LayerGenerationException {
        String className = this.instantiableClassOrMethod(e);
        if (!this.isClassOf(e, providerClass)) {
            throw new IllegalArgumentException("Annotated element " + e + " is not an instance of " + providerClass);
        }
        path = path != null && path.length() > 0 ? "Debugger/" + path : "Debugger";
        LayerBuilder lb = this.layer(new Element[]{e});
        String basename = className.replace('.', '-');
        LayerBuilder.File f = lb.file(path + "/" + basename + ".instance");
        f.stringvalue("serviceName", className).stringvalue("serviceClass", providerClass.getName());
        if (actions != null && actions.length > 0) {
            f.stringvalue("debugger_actions", Arrays.toString(actions));
        }
        if (enabledOnMIMETypes != null && enabledOnMIMETypes.length > 0) {
            f.stringvalue("debugger_activateForMIMETypes", Arrays.toString(enabledOnMIMETypes));
        }
        f.stringvalue("instanceOf", providerClass.getName());
        f.methodvalue("instanceCreate", providerClass.getName() + "$ContextAware", "createService");
        f.write();
    }

    private boolean isClassOf(Element e, Class providerClass) {
        switch (e.getKind()) {
            case CLASS: {
                TypeElement te = (TypeElement)e;
                TypeMirror superType = te.getSuperclass();
                if (superType.getKind().equals((Object)TypeKind.NONE)) {
                    return false;
                }
                e = ((DeclaredType)superType).asElement();
                String clazz = this.processingEnv.getElementUtils().getBinaryName((TypeElement)e).toString();
                if (clazz.equals(providerClass.getName())) {
                    return true;
                }
                return this.isClassOf(e, providerClass);
            }
            case METHOD: {
                TypeMirror retType = ((ExecutableElement)e).getReturnType();
                if (retType.getKind().equals((Object)TypeKind.NONE)) {
                    return false;
                }
                e = ((DeclaredType)retType).asElement();
                String clazz = this.processingEnv.getElementUtils().getBinaryName((TypeElement)e).toString();
                if (clazz.equals(providerClass.getName())) {
                    return true;
                }
                return this.isClassOf(e, providerClass);
            }
        }
        throw new IllegalArgumentException("Annotated element is not loadable as an instance: " + e);
    }

    private boolean implementsInterfaces(Element e, String classNames) {
        HashSet<String> interfaces = new HashSet<String>(Arrays.asList(classNames.split("[, ]+")));
        return this.implementsInterfaces(e, interfaces);
    }

    private boolean implementsInterfaces(Element e, Set<String> interfaces) {
        switch (e.getKind()) {
            case CLASS: 
            case INTERFACE: {
                TypeElement te = (TypeElement)e;
                this.removeImplementingInterfaces(te.asType(), interfaces);
                break;
            }
            case METHOD: {
                TypeMirror retType = ((ExecutableElement)e).getReturnType();
                if (retType.getKind().equals((Object)TypeKind.NONE)) {
                    return false;
                }
                TypeElement te = (TypeElement)((DeclaredType)retType).asElement();
                List<? extends TypeMirror> interfs = te.getInterfaces();
                for (TypeMirror typeMirror : interfs) {
                    e = ((DeclaredType)typeMirror).asElement();
                    String clazz = this.processingEnv.getElementUtils().getBinaryName((TypeElement)e).toString();
                    interfaces.remove(clazz);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Annotated element is not loadable as an instance: " + e);
            }
        }
        return interfaces.isEmpty();
    }

    private void removeImplementingInterfaces(TypeMirror tm, Set<String> interfaces) {
        Iterator<String> i = interfaces.iterator();
        while (i.hasNext()) {
            String type = i.next();
            DeclaredType typeMirror = this.processingEnv.getTypeUtils().getDeclaredType(this.processingEnv.getElementUtils().getTypeElement(type.replace('$', '.')), new TypeMirror[0]);
            if (!this.processingEnv.getTypeUtils().isAssignable(tm, typeMirror)) continue;
            i.remove();
        }
    }

    private List<? extends TypeMirror> implementsInterfaces(Element e, List<? extends TypeMirror> typeMirrors) {
        List notImplementedMirrors = Collections.emptyList();
        switch (e.getKind()) {
            case CLASS: 
            case INTERFACE: {
                TypeElement te = (TypeElement)e;
                TypeMirror tm = te.asType();
                for (TypeMirror typeMirror : typeMirrors) {
                    if (this.processingEnv.getTypeUtils().isAssignable(tm, typeMirror)) continue;
                    if (notImplementedMirrors == Collections.EMPTY_LIST) {
                        notImplementedMirrors = new ArrayList();
                    }
                    notImplementedMirrors.add(typeMirror);
                }
                break;
            }
            case METHOD: {
                TypeMirror retType = ((ExecutableElement)e).getReturnType();
                if (retType.getKind().equals((Object)TypeKind.NONE)) {
                    return typeMirrors;
                }
                TypeElement te = (TypeElement)((DeclaredType)retType).asElement();
                TypeMirror tm = te.asType();
                for (TypeMirror typeMirror : typeMirrors) {
                    if (this.processingEnv.getTypeUtils().isAssignable(tm, typeMirror)) continue;
                    if (notImplementedMirrors == Collections.EMPTY_LIST) {
                        notImplementedMirrors = new ArrayList();
                    }
                    notImplementedMirrors.add(typeMirror);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Annotated element is not loadable as an instance: " + e);
            }
        }
        return notImplementedMirrors;
    }

    private String instantiableClassOrMethod(Element e) throws IllegalArgumentException, LayerGenerationException {
        switch (e.getKind()) {
            case CLASS: {
                String clazz = this.processingEnv.getElementUtils().getBinaryName((TypeElement)e).toString();
                if (e.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    throw new LayerGenerationException(clazz + " must not be abstract", e);
                }
                boolean hasDefaultCtor = false;
                boolean hasContextCtor = false;
                for (ExecutableElement constructor : ElementFilter.constructorsIn(e.getEnclosedElements())) {
                    List<? extends VariableElement> parameters = constructor.getParameters();
                    if (parameters.isEmpty()) {
                        hasDefaultCtor = true;
                        break;
                    }
                    if (parameters.size() != 1) continue;
                    String type = ((Object)parameters.get(0).asType()).toString();
                    if (!ContextProvider.class.getName().equals(type)) continue;
                    hasContextCtor = true;
                    break;
                }
                if (!hasDefaultCtor && !hasContextCtor) {
                    throw new LayerGenerationException(clazz + " must have a no-argument constructor or constuctor taking " + ContextProvider.class.getName() + " as a parameter.", e);
                }
                return clazz;
            }
            case METHOD: {
                ExecutableElement ee = (ExecutableElement)e;
                String methodName = ee.getSimpleName().toString();
                String clazz = this.processingEnv.getElementUtils().getBinaryName((TypeElement)ee.getEnclosingElement()).toString();
                if (!e.getModifiers().contains((Object)Modifier.STATIC)) {
                    throw new LayerGenerationException(ee + " must be static", e);
                }
                if (ee.getParameters().size() > 0) {
                    throw new LayerGenerationException(ee + " must not have any parameters", e);
                }
                return clazz + "." + methodName + "()";
            }
        }
        throw new IllegalArgumentException("Annotated element is not loadable as an instance: " + e);
    }

    private String translateClassNames(String classNames) {
        int i2;
        StringBuilder builder = new StringBuilder();
        int i1 = 0;
        while ((i2 = classNames.indexOf(44, i1)) > 0) {
            if (i1 > 0) {
                builder.append(',');
            }
            builder.append(this.translateClass(classNames.substring(i1, i2).trim()));
            i1 = i2 + 1;
        }
        if (i1 > 0) {
            builder.append(',');
        }
        builder.append(this.translateClass(classNames.substring(i1).trim()));
        return builder.toString();
    }

    private String translateClass(String className) {
        if (className.endsWith(".class")) {
            className = className.substring(0, className.length() - ".class".length());
        }
        TypeElement type = this.processingEnv.getElementUtils().getTypeElement(className);
        return this.processingEnv.getElementUtils().getBinaryName(type).toString();
    }
}

