/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.client.subpanels;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.wsitconf.ui.ClassDialog;
import org.netbeans.modules.websvc.wsitconf.ui.client.PanelEnabler;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class DynamicCredsPanel
extends JPanel
implements PanelEnabler {
    private boolean inSync = false;
    private Binding binding;
    private boolean enable;
    private Project project;
    private JButton passwdBrowseButton;
    private JTextField passwdHandlerField;
    private JLabel passwdHandlerLabel;
    private JButton usernameBrowseButton;
    private JTextField usernameHandlerField;
    private JLabel usernameHandlerLabel;

    public DynamicCredsPanel(Binding b, Project project, boolean enable) {
        this.binding = b;
        this.enable = enable;
        this.project = project;
        this.initComponents();
        this.sync();
    }

    public void sync() {
        String passwdCallback;
        this.inSync = true;
        String usernameCallback = ProprietarySecurityPolicyModelHelper.getCallbackHandler(this.binding, "usernameHandler");
        if (usernameCallback != null) {
            this.setCallbackHandler(usernameCallback, "usernameHandler");
        }
        if ((passwdCallback = ProprietarySecurityPolicyModelHelper.getCallbackHandler(this.binding, "passwordHandler")) != null) {
            this.setCallbackHandler(passwdCallback, "passwordHandler");
        }
        this.enableDisable();
        this.inSync = false;
    }

    public void setValue(JComponent source, Object value) {
        if (this.inSync) {
            return;
        }
        ConfigVersion cfgVersion = PolicyModelHelper.getConfigVersion((WSDLComponent)this.binding);
        if (source.equals(this.usernameHandlerField)) {
            String classname = this.getCallbackHandler("usernameHandler");
            if (classname != null && classname.length() == 0) {
                classname = null;
            }
            ProprietarySecurityPolicyModelHelper.setCallbackHandler(this.binding, "usernameHandler", classname, null, true);
            return;
        }
        if (source.equals(this.passwdHandlerField)) {
            String classname = this.getCallbackHandler("passwordHandler");
            if (classname != null && classname.length() == 0) {
                classname = null;
            }
            ProprietarySecurityPolicyModelHelper.setCallbackHandler(this.binding, "passwordHandler", classname, null, true);
            return;
        }
        this.enableDisable();
    }

    private void enableDisable() {
        this.passwdBrowseButton.setEnabled(this.isPanelEnabled());
        this.passwdHandlerField.setEnabled(this.isPanelEnabled());
        this.passwdHandlerLabel.setEnabled(this.isPanelEnabled());
        this.usernameBrowseButton.setEnabled(this.isPanelEnabled());
        this.usernameHandlerField.setEnabled(this.isPanelEnabled());
        this.usernameHandlerLabel.setEnabled(this.isPanelEnabled());
    }

    @Override
    public boolean isPanelEnabled() {
        return this.enable;
    }

    @Override
    public void enablePanel(boolean doEnable) {
        this.enable = doEnable;
    }

    private String getCallbackHandler(String type) {
        if ("usernameHandler".equals(type)) {
            return this.usernameHandlerField.getText();
        }
        if ("passwordHandler".equals(type)) {
            return this.passwdHandlerField.getText();
        }
        return null;
    }

    private void setCallbackHandler(String classname, String type) {
        if ("usernameHandler".equals(type)) {
            this.usernameHandlerField.setText(classname);
        }
        if ("passwordHandler".equals(type)) {
            this.passwdHandlerField.setText(classname);
        }
    }

    private void initComponents() {
        this.usernameHandlerLabel = new JLabel();
        this.usernameHandlerField = new JTextField();
        this.passwdHandlerLabel = new JLabel();
        this.passwdHandlerField = new JTextField();
        this.usernameBrowseButton = new JButton();
        this.passwdBrowseButton = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.usernameHandlerLabel, (String)NbBundle.getMessage(DynamicCredsPanel.class, (String)"LBL_UsernameCBHLabel"));
        this.usernameHandlerField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DynamicCredsPanel.this.usernameHandlerFieldKeyReleased(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.passwdHandlerLabel, (String)NbBundle.getMessage(DynamicCredsPanel.class, (String)"LBL_PasswordCBHLabel"));
        this.passwdHandlerField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DynamicCredsPanel.this.passwdHandlerFieldKeyReleased(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.usernameBrowseButton, (String)NbBundle.getMessage(DynamicCredsPanel.class, (String)"LBL_Username_Browse"));
        this.usernameBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DynamicCredsPanel.this.usernameBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.passwdBrowseButton, (String)NbBundle.getMessage(DynamicCredsPanel.class, (String)"LBL_Password_Browse"));
        this.passwdBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DynamicCredsPanel.this.passwdBrowseButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.passwdHandlerLabel).add(13, 13, 13)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.usernameHandlerLabel).addPreferredGap(0))).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.usernameHandlerField, -1, 189, Short.MAX_VALUE).add((Component)this.passwdHandlerField, -1, 189, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.usernameBrowseButton).add((Component)this.passwdBrowseButton)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.usernameBrowseButton).add((Component)this.usernameHandlerField, -2, -1, -2).add((Component)this.usernameHandlerLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.passwdBrowseButton).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.passwdHandlerLabel).add((Component)this.passwdHandlerField, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void passwdHandlerFieldKeyReleased(KeyEvent evt) {
        this.setValue(this.passwdHandlerField, null);
    }

    private void usernameHandlerFieldKeyReleased(KeyEvent evt) {
        this.setValue(this.usernameHandlerField, null);
    }

    private void passwdBrowseButtonActionPerformed(ActionEvent evt) {
        block1: {
            Set<String> selectedClasses;
            Iterator<String> i$;
            if (this.project == null) break block1;
            ClassDialog classDialog = new ClassDialog(this.project, "javax.security.auth.callback.CallbackHandler");
            classDialog.show();
            if (classDialog.okButtonPressed() && (i$ = (selectedClasses = classDialog.getSelectedClasses()).iterator()).hasNext()) {
                String selectedClass = i$.next();
                this.setCallbackHandler(selectedClass, "passwordHandler");
                ProprietarySecurityPolicyModelHelper.setCallbackHandler(this.binding, "passwordHandler", selectedClass, null, true);
            }
        }
    }

    private void usernameBrowseButtonActionPerformed(ActionEvent evt) {
        block1: {
            Set<String> selectedClasses;
            Iterator<String> i$;
            if (this.project == null) break block1;
            ClassDialog classDialog = new ClassDialog(this.project, "javax.security.auth.callback.CallbackHandler");
            classDialog.show();
            if (classDialog.okButtonPressed() && (i$ = (selectedClasses = classDialog.getSelectedClasses()).iterator()).hasNext()) {
                String selectedClass = i$.next();
                this.setCallbackHandler(selectedClass, "usernameHandler");
                ProprietarySecurityPolicyModelHelper.setCallbackHandler(this.binding, "usernameHandler", selectedClass, null, true);
            }
        }
    }
}

