/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.text.NumberFormat;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.JTextComponent;
import javax.swing.text.NumberFormatter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RequiredConfigurationHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class AdvancedConfigPanelClient
extends SectionInnerPanel {
    private WSDLModel serviceModel;
    private Binding binding;
    private boolean inSync = false;
    private Project project;
    private static final String DEFAULT_LIFETIME = "36000";
    private static final String DEFAULT_RMRESENDINTERVAL = "2000";
    private static final String DEFAULT_RMCLOSETIMEOUT = "0";
    private static final String DEFAULT_RMREQUESTACKINTERVAL = "200";
    private DefaultFormatterFactory lifetimeDff = null;
    private DefaultFormatterFactory closeTimeoutDff = null;
    private DefaultFormatterFactory rmSendDff = null;
    private DefaultFormatterFactory rmReqDff = null;
    private DefaultFormatterFactory timeoutDff = null;
    private DefaultFormatterFactory freshnessDff = null;
    private DefaultFormatterFactory skewDff = null;
    private JFormattedTextField freshnessField;
    private JLabel freshnessLabel;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel lifeTimeLabel;
    private JFormattedTextField lifeTimeTextField;
    private JFormattedTextField maxClockSkewField;
    private JLabel maxClockSkewLabel;
    private JCheckBox renewExpiredChBox;
    private JCheckBox requireCancelChBox;
    private JCheckBox revocationChBox;
    private JFormattedTextField rmAckRequestField;
    private JLabel rmAckRequestLabel;
    private JFormattedTextField rmCloseTimeoutField;
    private JLabel rmCloseTimeoutLabel;
    private JFormattedTextField rmResendField;
    private JLabel rmResendLabel;

    public AdvancedConfigPanelClient(SectionView view, Node node, Binding binding, WSDLModel serviceModel) {
        super(view);
        this.serviceModel = serviceModel;
        this.binding = binding;
        FileObject fo = (FileObject)node.getLookup().lookup(FileObject.class);
        if (fo != null) {
            this.project = FileOwnerQuery.getOwner((FileObject)fo);
        }
        this.lifetimeDff = new DefaultFormatterFactory();
        NumberFormat lifetimeFormat = NumberFormat.getIntegerInstance();
        lifetimeFormat.setGroupingUsed(false);
        lifetimeFormat.setParseIntegerOnly(true);
        lifetimeFormat.setMaximumFractionDigits(0);
        NumberFormatter lifetimeFormatter = new NumberFormatter(lifetimeFormat);
        lifetimeFormatter.setCommitsOnValidEdit(true);
        lifetimeFormatter.setMinimum(Integer.valueOf(0));
        this.lifetimeDff.setDefaultFormatter(lifetimeFormatter);
        this.rmSendDff = new DefaultFormatterFactory();
        NumberFormat rmSendFormat = NumberFormat.getIntegerInstance();
        rmSendFormat.setGroupingUsed(false);
        rmSendFormat.setParseIntegerOnly(true);
        rmSendFormat.setMaximumFractionDigits(0);
        NumberFormatter rmSendFormatter = new NumberFormatter(rmSendFormat);
        rmSendFormatter.setCommitsOnValidEdit(true);
        rmSendFormatter.setMinimum(Integer.valueOf(0));
        this.rmSendDff.setDefaultFormatter(rmSendFormatter);
        this.rmReqDff = new DefaultFormatterFactory();
        NumberFormat rmReqFormat = NumberFormat.getIntegerInstance();
        rmReqFormat.setGroupingUsed(false);
        rmReqFormat.setParseIntegerOnly(true);
        rmReqFormat.setMaximumFractionDigits(0);
        NumberFormatter rmReqFormatter = new NumberFormatter(rmReqFormat);
        rmReqFormatter.setCommitsOnValidEdit(true);
        rmReqFormatter.setMinimum(Integer.valueOf(0));
        this.rmReqDff.setDefaultFormatter(rmReqFormatter);
        this.timeoutDff = new DefaultFormatterFactory();
        NumberFormat timeoutFormat = NumberFormat.getIntegerInstance();
        timeoutFormat.setGroupingUsed(false);
        timeoutFormat.setParseIntegerOnly(true);
        timeoutFormat.setMaximumFractionDigits(0);
        NumberFormatter timeoutFormatter = new NumberFormatter(timeoutFormat);
        timeoutFormatter.setCommitsOnValidEdit(true);
        timeoutFormatter.setMinimum(Integer.valueOf(0));
        this.timeoutDff.setDefaultFormatter(timeoutFormatter);
        this.closeTimeoutDff = new DefaultFormatterFactory();
        NumberFormat rmCloseTimeoutFormat = NumberFormat.getIntegerInstance();
        rmCloseTimeoutFormat.setGroupingUsed(false);
        rmCloseTimeoutFormat.setParseIntegerOnly(true);
        rmCloseTimeoutFormat.setMaximumFractionDigits(0);
        NumberFormatter rmCloseTimeoutFormatter = new NumberFormatter(rmCloseTimeoutFormat);
        rmCloseTimeoutFormatter.setCommitsOnValidEdit(true);
        rmCloseTimeoutFormatter.setMinimum(Integer.valueOf(0));
        this.closeTimeoutDff.setDefaultFormatter(rmCloseTimeoutFormatter);
        this.freshnessDff = new DefaultFormatterFactory();
        NumberFormat freshnessFormat = NumberFormat.getIntegerInstance();
        freshnessFormat.setGroupingUsed(false);
        freshnessFormat.setParseIntegerOnly(true);
        freshnessFormat.setMaximumFractionDigits(0);
        NumberFormatter freshnessFormatter = new NumberFormatter(freshnessFormat);
        freshnessFormatter.setCommitsOnValidEdit(true);
        freshnessFormatter.setMinimum(Integer.valueOf(0));
        this.freshnessDff.setDefaultFormatter(freshnessFormatter);
        this.skewDff = new DefaultFormatterFactory();
        NumberFormat skewFormat = NumberFormat.getIntegerInstance();
        skewFormat.setGroupingUsed(false);
        skewFormat.setParseIntegerOnly(true);
        skewFormat.setMaximumFractionDigits(0);
        NumberFormatter skewFormatter = new NumberFormatter(skewFormat);
        skewFormatter.setCommitsOnValidEdit(true);
        skewFormatter.setMinimum(Integer.valueOf(0));
        this.skewDff.setDefaultFormatter(skewFormatter);
        this.initComponents();
        this.lifeTimeLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.lifeTimeTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.renewExpiredChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.requireCancelChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.rmAckRequestField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.rmAckRequestLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.rmResendField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.rmResendLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.rmCloseTimeoutLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.rmCloseTimeoutField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.maxClockSkewField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.maxClockSkewLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.freshnessField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.freshnessLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.revocationChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.addImmediateModifier(this.rmAckRequestField);
        this.addImmediateModifier(this.rmCloseTimeoutField);
        this.addImmediateModifier(this.rmResendField);
        this.addImmediateModifier(this.lifeTimeTextField);
        this.addImmediateModifier(this.renewExpiredChBox);
        this.addImmediateModifier(this.requireCancelChBox);
        this.addImmediateModifier(this.maxClockSkewField);
        this.addImmediateModifier(this.freshnessField);
        this.addImmediateModifier(this.revocationChBox);
        this.sync();
    }

    public void sync() {
        this.inSync = true;
        String lifeTime = ProprietarySecurityPolicyModelHelper.getLifeTime(this.binding, true);
        if (lifeTime == null) {
            this.lifeTimeTextField.setText(DEFAULT_LIFETIME);
        } else {
            this.lifeTimeTextField.setText(lifeTime);
        }
        String skew = ProprietarySecurityPolicyModelHelper.getMaxClockSkew(this.binding);
        if (skew == null) {
            this.maxClockSkewField.setText("300000");
        } else {
            this.maxClockSkewField.setText(skew);
        }
        String freshness = ProprietarySecurityPolicyModelHelper.getTimestampFreshness(this.binding);
        if (freshness == null) {
            this.freshnessField.setText("300000");
        } else {
            this.freshnessField.setText(freshness);
        }
        String rmResendInterval = RMModelHelper.getResendInterval(this.binding);
        if (rmResendInterval == null) {
            this.rmResendField.setText(DEFAULT_RMRESENDINTERVAL);
        } else {
            this.rmResendField.setText(rmResendInterval);
        }
        String rmCloseTimeout = RMModelHelper.getCloseTimeout(this.binding);
        if (rmCloseTimeout == null) {
            this.rmCloseTimeoutField.setText(DEFAULT_RMCLOSETIMEOUT);
        } else {
            this.rmCloseTimeoutField.setText(rmCloseTimeout);
        }
        String rmAckRequest = RMModelHelper.getAckRequestInterval(this.binding);
        if (rmAckRequest == null) {
            this.rmAckRequestField.setText(DEFAULT_RMREQUESTACKINTERVAL);
        } else {
            this.rmAckRequestField.setText(rmAckRequest);
        }
        this.setChBox(this.renewExpiredChBox, ProprietarySecurityPolicyModelHelper.isRenewExpired(this.binding));
        this.setChBox(this.requireCancelChBox, ProprietarySecurityPolicyModelHelper.isRequireCancel(this.binding));
        this.setChBox(this.revocationChBox, ProprietarySecurityPolicyModelHelper.isRevocationEnabled(this.binding));
        this.enableDisable();
        this.inSync = false;
    }

    public void setValue(JComponent source, Object value) {
        if (!this.inSync) {
            Util.checkMetroLibrary(this.project);
            ConfigVersion configVersion = PolicyModelHelper.getConfigVersion((WSDLComponent)this.binding);
            RMModelHelper rmh = RMModelHelper.getInstance(configVersion);
            if (source.equals(this.lifeTimeTextField)) {
                String lifetimeStr;
                Integer lifeTime = (Integer)this.lifeTimeTextField.getValue();
                String string = lifetimeStr = lifeTime == null ? null : lifeTime.toString();
                if (lifetimeStr == null || lifetimeStr.length() == 0 || DEFAULT_LIFETIME.equals(lifetimeStr)) {
                    ProprietarySecurityPolicyModelHelper.setLifeTime(this.binding, null, true);
                } else {
                    ProprietarySecurityPolicyModelHelper.setLifeTime(this.binding, lifetimeStr, true);
                }
            }
            if (source.equals(this.maxClockSkewField)) {
                String skewStr;
                Integer skew = (Integer)this.maxClockSkewField.getValue();
                String string = skewStr = skew == null ? null : skew.toString();
                if (skewStr == null || skewStr.length() == 0 || "300000".equals(skewStr)) {
                    ProprietarySecurityPolicyModelHelper.setMaxClockSkew(this.binding, null, true);
                } else {
                    ProprietarySecurityPolicyModelHelper.setMaxClockSkew(this.binding, skewStr, true);
                }
            }
            if (source.equals(this.freshnessField)) {
                String freshnessStr;
                Integer freshness = (Integer)this.freshnessField.getValue();
                String string = freshnessStr = freshness == null ? null : freshness.toString();
                if (freshnessStr == null || freshnessStr.length() == 0 || "300000".equals(freshnessStr)) {
                    ProprietarySecurityPolicyModelHelper.setTimestampFreshness(this.binding, null, true);
                } else {
                    ProprietarySecurityPolicyModelHelper.setTimestampFreshness(this.binding, freshnessStr, true);
                }
            }
            if (source.equals(this.rmResendField)) {
                String resendIntStr;
                Integer resendInt = (Integer)this.rmResendField.getValue();
                String string = resendIntStr = resendInt == null ? null : resendInt.toString();
                if (resendIntStr == null || resendIntStr.length() == 0 || DEFAULT_RMRESENDINTERVAL.equals(resendIntStr)) {
                    rmh.setResendInterval(this.binding, null);
                } else {
                    rmh.setResendInterval(this.binding, resendIntStr);
                }
            }
            if (source.equals(this.rmCloseTimeoutField)) {
                String closeTimeoutStr;
                Integer closeTimeout = (Integer)this.rmCloseTimeoutField.getValue();
                String string = closeTimeoutStr = closeTimeout == null ? null : closeTimeout.toString();
                if (closeTimeoutStr == null || closeTimeoutStr.length() == 0 || DEFAULT_RMCLOSETIMEOUT.equals(closeTimeoutStr)) {
                    rmh.setCloseTimeout(this.binding, null);
                } else {
                    rmh.setCloseTimeout(this.binding, closeTimeoutStr);
                }
            }
            if (source.equals(this.rmAckRequestField)) {
                String ackRequestStr;
                Integer ackRequestInt = (Integer)this.rmAckRequestField.getValue();
                String string = ackRequestStr = ackRequestInt == null ? null : ackRequestInt.toString();
                if (ackRequestStr == null || ackRequestStr.length() == 0 || DEFAULT_RMREQUESTACKINTERVAL.equals(ackRequestStr)) {
                    rmh.setAckRequestInterval(this.binding, null);
                } else {
                    rmh.setAckRequestInterval(this.binding, ackRequestStr);
                }
            }
            if (source.equals(this.renewExpiredChBox)) {
                ProprietarySecurityPolicyModelHelper.setRenewExpired(this.binding, this.renewExpiredChBox.isSelected());
            }
            if (source.equals(this.requireCancelChBox)) {
                ProprietarySecurityPolicyModelHelper.setRequireCancel(this.binding, this.requireCancelChBox.isSelected());
            }
            if (source.equals(this.revocationChBox)) {
                ProprietarySecurityPolicyModelHelper.setRevocation(this.binding, this.revocationChBox.isSelected(), true);
            }
        }
    }

    private void enableDisable() {
        Binding serviceBinding = PolicyModelHelper.getBinding(this.serviceModel, this.binding.getName());
        boolean rmEnabled = RMModelHelper.getInstance(ConfigVersion.CONFIG_1_0).isRMEnabled((WSDLComponent)serviceBinding) || RMModelHelper.getInstance(ConfigVersion.CONFIG_1_3).isRMEnabled((WSDLComponent)serviceBinding) || RMModelHelper.getInstance(ConfigVersion.CONFIG_2_0).isRMEnabled((WSDLComponent)serviceBinding);
        boolean secConvConfigRequired = RequiredConfigurationHelper.isSecureConversationParamRequired((WSDLComponent)serviceBinding);
        this.rmAckRequestLabel.setEnabled(rmEnabled);
        this.rmAckRequestField.setEnabled(rmEnabled);
        this.rmResendLabel.setEnabled(rmEnabled);
        this.rmResendField.setEnabled(rmEnabled);
        this.rmCloseTimeoutField.setEnabled(rmEnabled);
        this.rmCloseTimeoutLabel.setEnabled(rmEnabled);
        this.lifeTimeTextField.setEnabled(secConvConfigRequired);
        this.lifeTimeLabel.setEnabled(secConvConfigRequired);
        this.renewExpiredChBox.setEnabled(secConvConfigRequired);
        this.requireCancelChBox.setEnabled(secConvConfigRequired);
        boolean security = SecurityPolicyModelHelper.isSecurityEnabled((WSDLComponent)serviceBinding);
        this.requireCancelChBox.setEnabled(security);
        this.maxClockSkewField.setEnabled(security);
        this.freshnessField.setEnabled(security);
    }

    private void setChBox(JCheckBox chBox, Boolean enable) {
        if (enable == null) {
            chBox.setSelected(false);
        } else {
            chBox.setSelected(enable);
        }
    }

    public void documentChanged(JTextComponent comp, String value) {
    }

    public void rollbackValue(JTextComponent source) {
    }

    protected void endUIChange() {
    }

    public void linkButtonPressed(Object ddBean, String ddProperty) {
    }

    public JComponent getErrorComponent(String errorId) {
        return null;
    }

    private void initComponents() {
        this.lifeTimeLabel = new JLabel();
        this.renewExpiredChBox = new JCheckBox();
        this.requireCancelChBox = new JCheckBox();
        this.rmResendLabel = new JLabel();
        this.rmAckRequestLabel = new JLabel();
        this.rmResendField = new JFormattedTextField();
        this.rmAckRequestField = new JFormattedTextField();
        this.lifeTimeTextField = new JFormattedTextField();
        this.rmCloseTimeoutLabel = new JLabel();
        this.rmCloseTimeoutField = new JFormattedTextField();
        this.maxClockSkewLabel = new JLabel();
        this.maxClockSkewField = new JFormattedTextField();
        this.freshnessLabel = new JLabel();
        this.freshnessField = new JFormattedTextField();
        this.revocationChBox = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.lifeTimeLabel.setLabelFor(this.lifeTimeTextField);
        Mnemonics.setLocalizedText((JLabel)this.lifeTimeLabel, (String)NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"LBL_AdvancedConfigPanel_SCTokenLifeTime"));
        Mnemonics.setLocalizedText((AbstractButton)this.renewExpiredChBox, (String)NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"LBL_AdvancedConfigPanel_RenewExpired"));
        this.renewExpiredChBox.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.requireCancelChBox, (String)NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"LBL_AdvancedConfigPanel_RequireCancel"));
        this.requireCancelChBox.setMargin(new Insets(0, 0, 0, 0));
        this.rmResendLabel.setLabelFor(this.rmResendField);
        Mnemonics.setLocalizedText((JLabel)this.rmResendLabel, (String)NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"LBL_AdvancedConfigPanel_ResendInterval"));
        this.rmAckRequestLabel.setLabelFor(this.rmAckRequestField);
        Mnemonics.setLocalizedText((JLabel)this.rmAckRequestLabel, (String)NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"LBL_AdvancedConfigPanel_AckRequestInterval"));
        this.rmResendField.setFormatterFactory(this.rmSendDff);
        this.rmAckRequestField.setFormatterFactory(this.rmReqDff);
        this.lifeTimeTextField.setFormatterFactory(this.lifetimeDff);
        this.rmCloseTimeoutLabel.setLabelFor(this.rmCloseTimeoutField);
        Mnemonics.setLocalizedText((JLabel)this.rmCloseTimeoutLabel, (String)NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"LBL_AdvancedConfigPanel_CloseTimeout"));
        this.rmCloseTimeoutField.setFormatterFactory(this.closeTimeoutDff);
        this.maxClockSkewLabel.setLabelFor(this.rmResendField);
        Mnemonics.setLocalizedText((JLabel)this.maxClockSkewLabel, (String)NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"LBL_AdvancedConfigPanel_MaxClockSkew"));
        this.maxClockSkewField.setFormatterFactory(this.skewDff);
        this.freshnessLabel.setLabelFor(this.rmResendField);
        Mnemonics.setLocalizedText((JLabel)this.freshnessLabel, (String)NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"LBL_AdvancedConfigPanel_TimestampFreshness"));
        this.freshnessField.setFormatterFactory(this.freshnessDff);
        Mnemonics.setLocalizedText((AbstractButton)this.revocationChBox, (String)NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"LBL_AdvancedConfigPanel_Revocation"));
        this.revocationChBox.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.rmResendLabel).add((Component)this.rmCloseTimeoutLabel).add((Component)this.rmAckRequestLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.rmResendField, -1, 87, Short.MAX_VALUE).add((Component)this.rmCloseTimeoutField, -1, 87, Short.MAX_VALUE).add(1, (Component)this.rmAckRequestField, -1, 87, Short.MAX_VALUE))).add((Component)this.jSeparator2, -1, 369, Short.MAX_VALUE).add(2, (Component)this.jSeparator1, -1, 369, Short.MAX_VALUE).add((Component)this.renewExpiredChBox).add((Component)this.requireCancelChBox).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.lifeTimeLabel).add(50, 50, 50).add((Component)this.lifeTimeTextField, -1, 93, Short.MAX_VALUE)).add((Component)this.revocationChBox).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.maxClockSkewLabel).add((Component)this.freshnessLabel)).add(69, 69, 69).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.freshnessField, -1, 92, Short.MAX_VALUE).add((Component)this.maxClockSkewField, -1, 92, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.rmResendLabel).add((Component)this.rmResendField, -2, 20, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.rmCloseTimeoutLabel).add((Component)this.rmCloseTimeoutField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.rmAckRequestLabel).add((Component)this.rmAckRequestField, -2, -1, -2)).addPreferredGap(0).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lifeTimeLabel).add((Component)this.lifeTimeTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.renewExpiredChBox).addPreferredGap(0).add((Component)this.requireCancelChBox).addPreferredGap(0).add((Component)this.jSeparator2, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.maxClockSkewLabel).add((Component)this.maxClockSkewField, -2, 20, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.freshnessLabel).add((Component)this.freshnessField, -2, -1, -2)).addPreferredGap(0).add((Component)this.revocationChBox).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.freshnessField, this.lifeTimeTextField, this.maxClockSkewField, this.rmAckRequestField, this.rmCloseTimeoutField, this.rmResendField}, 2);
        this.lifeTimeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"ACSN_AdvancedConfigPanel_SCTokenLifeTime"));
        this.lifeTimeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"ACSD_AdvancedConfigPanel_SCTokenLifeTime"));
        this.renewExpiredChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"ACSN_AdvancedConfigPanel_RenewExpired"));
        this.renewExpiredChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"ACSD_AdvancedConfigPanel_RenewExpired"));
        this.requireCancelChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"ACSN_AdvancedConfigPanel_RequireCancel"));
        this.requireCancelChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"ACSD_AdvancedConfigPanel_RequireCancel"));
        this.rmResendLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"ACSN_AdvancedConfigPanel_ResendInterval"));
        this.rmResendLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"ACSD_AdvancedConfigPanel_ResendInterval"));
        this.rmAckRequestLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"ACSN_AdvancedConfigPanel_AckRequestInterval"));
        this.rmAckRequestLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"ACSD_AdvancedConfigPanel_AckRequestInterval"));
        this.rmCloseTimeoutLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"ACSN_AdvancedConfigPanel_CloseTimeout"));
        this.rmCloseTimeoutLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedConfigPanelClient.class, (String)"ACSD_AdvancedConfigPanel_CloseTimeout"));
    }
}

