/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.projects;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.dd.api.common.NameAlreadyUsedException;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.wsitconf.spi.WsitProvider;
import org.netbeans.modules.websvc.wsitconf.util.ServerUtils;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.jaxws.JaxWs;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class MavenWsitProvider
extends WsitProvider {
    private static final Logger logger = Logger.getLogger(MavenWsitProvider.class.getName());
    protected static final String SERVLET_NAME = "ServletName";
    protected static final String SERVLET_CLASS = "ServletClass";
    protected static final String URL_PATTERN = "UrlPattern";

    public MavenWsitProvider(Project p) {
        this.project = p;
    }

    @Override
    public boolean isWsitSupported() {
        ClassPath classPath;
        FileObject txFO;
        SourceGroup[] sgs = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        return sgs != null && sgs.length > 0 && (txFO = (classPath = ClassPath.getClassPath((FileObject)sgs[0].getRootFolder(), (String)"classpath/compile")).findResource("com/sun/xml/ws/tx/service/TxServerPipe.class")) != null;
    }

    @Override
    public boolean isJsr109Project() {
        J2eePlatform j2eePlatform = ServerUtils.getJ2eePlatform(this.project);
        if (j2eePlatform != null) {
            Collection wsStacks = j2eePlatform.getLookup().lookupAll(WSStack.class);
            for (WSStack stack : wsStacks) {
                if (!stack.isFeatureSupported((WSStack.Feature)JaxWs.Feature.JSR109)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addServiceDDEntry(String serviceImplPath, String mexUrl, String targetName) {
        block12: {
            boolean isGlassFish = ServerUtils.isGlassfish(this.project);
            WebModule wm = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
            if (wm != null) {
                try {
                    WebApp wApp = DDProvider.getDefault().getDDRoot(wm.getDeploymentDescriptor());
                    Servlet servlet = Util.getServlet(wApp, serviceImplPath);
                    if (servlet == null) {
                        try {
                            if (isGlassFish) {
                                servlet = (Servlet)wApp.addBean("Servlet", new String[]{SERVLET_NAME, SERVLET_CLASS}, new Object[]{serviceImplPath, serviceImplPath}, SERVLET_NAME);
                                servlet.setLoadOnStartup(new BigInteger("0"));
                                wApp.addBean("ServletMapping", new String[]{SERVLET_NAME, URL_PATTERN}, new Object[]{serviceImplPath, "/" + targetName + "Service"}, SERVLET_NAME);
                                try {
                                    servlet = (Servlet)wApp.addBean("Servlet", new String[]{SERVLET_NAME, SERVLET_CLASS}, new Object[]{"com.sun.xml.ws.mex.server.MEXEndpoint", "com.sun.xml.ws.mex.server.MEXEndpoint"}, SERVLET_NAME);
                                    servlet.setLoadOnStartup(new BigInteger("0"));
                                }
                                catch (NameAlreadyUsedException ex) {
                                    // empty catch block
                                }
                                wApp.addBean("ServletMapping", new String[]{SERVLET_NAME, URL_PATTERN}, new Object[]{"com.sun.xml.ws.mex.server.MEXEndpoint", mexUrl}, URL_PATTERN);
                                wApp.write(wm.getDeploymentDescriptor());
                                break block12;
                            }
                            try {
                                servlet = (Servlet)wApp.addBean("Servlet", new String[]{SERVLET_NAME, SERVLET_CLASS}, new Object[]{"MEXEndpoint", "com.sun.xml.ws.mex.server.MEXEndpoint"}, SERVLET_NAME);
                                servlet.setLoadOnStartup(new BigInteger("0"));
                            }
                            catch (NameAlreadyUsedException ex) {
                                // empty catch block
                            }
                            wApp.addBean("ServletMapping", new String[]{SERVLET_NAME, URL_PATTERN}, new Object[]{"MEXEndpoint", mexUrl}, URL_PATTERN);
                            wApp.write(wm.getDeploymentDescriptor());
                        }
                        catch (NameAlreadyUsedException ex) {
                            ex.printStackTrace();
                        }
                        catch (ClassNotFoundException ex) {
                            ex.printStackTrace();
                        }
                        break block12;
                    }
                    servlet.setLoadOnStartup(new BigInteger("1"));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    @Override
    public boolean addMetroLibrary() {
        Library metroLib = LibraryManager.getDefault().getLibrary("metro");
        if (metroLib != null) {
            try {
                SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
                if (sourceGroups != null && sourceGroups.length > 0) {
                    return ProjectClassPathModifier.addLibraries((Library[])new Library[]{metroLib}, (FileObject)sourceGroups[0].getRootFolder(), (String)"classpath/compile");
                }
            }
            catch (IOException e) {
                logger.log(Level.FINE, e.getMessage());
            }
        }
        return false;
    }

    @Override
    public FileObject getConfigFilesFolder(boolean client) {
        J2eeModule.Type type;
        J2eeModule j2eeModule;
        J2eeModuleProvider provider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        if (provider != null && (j2eeModule = provider.getJ2eeModule()) != null && J2eeModule.Type.WAR.equals(type = j2eeModule.getType()) && !client) {
            FileObject dir = null;
            try {
                dir = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)"src/main/webapp/WEB-INF");
            }
            catch (IOException ex) {
                logger.log(Level.FINE, ex.getLocalizedMessage());
            }
            return dir;
        }
        FileObject cfgDir = null;
        try {
            cfgDir = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)"src/main/resources/META-INF");
        }
        catch (IOException ex) {
            logger.log(Level.FINE, ex.getLocalizedMessage());
        }
        return cfgDir;
    }

    @Override
    public void createUser() {
    }
}

