/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.spi;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.perfan.SunStudioDCConfiguration;
import org.netbeans.modules.dlight.perfan.spi.SunStudioDataCollector;
import org.netbeans.modules.dlight.perfan.storage.impl.ErprintSession;
import org.netbeans.modules.dlight.perfan.storage.impl.Metrics;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.util.Exceptions;

public class MonitorsUpdateService {
    private static final Pattern METRIC_LINE_PATTERN = Pattern.compile("^ *([0-9]+(?:,[0-9]*)?) [^<]*$");
    private static final DecimalFormat METRIC_FORMAT = new DecimalFormat();
    private static final Metrics LEAK_METRICS;
    private static final List<String> LEAK_COLNAMES;
    private static final Metrics SYNC_METRICS;
    private static final List<String> SYNC_COLNAMES;
    private static final List<String> DATARACE_COLNAMES;
    private static final List<String> DEADLOCK_COLNAMES;
    private static final Logger log;
    private final SunStudioDataCollector ssdc;
    private final ExecutionEnvironment execEnv;
    private final String sproHome;
    private final String experimentDir;
    private final boolean isSyncMonitor;
    private final boolean isMemoryMonitor;
    private final boolean isDataRaceMonitor;
    private final boolean isDeadlockMonitor;
    private final Object updaterLock = MonitorsUpdateService.class.getName() + "Lock";
    private Updater updater = null;
    private BlockingQueue<Object> requestsQueue = new LinkedBlockingQueue<Object>(1);

    MonitorsUpdateService(SunStudioDataCollector ssdc, ExecutionEnvironment execEnv, String sproHome, String experimentDir, Set<SunStudioDCConfiguration.CollectedInfo> collectedInfo) {
        this.ssdc = ssdc;
        this.sproHome = sproHome;
        this.execEnv = execEnv;
        this.experimentDir = experimentDir;
        this.isSyncMonitor = collectedInfo.contains((Object)SunStudioDCConfiguration.CollectedInfo.SYNCSUMMARY);
        this.isMemoryMonitor = collectedInfo.contains((Object)SunStudioDCConfiguration.CollectedInfo.MEMSUMMARY);
        this.isDataRaceMonitor = collectedInfo.contains((Object)SunStudioDCConfiguration.CollectedInfo.DATARACES);
        this.isDeadlockMonitor = collectedInfo.contains((Object)SunStudioDCConfiguration.CollectedInfo.DEADLOCKS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        boolean linuxMode;
        if (this.isBlank()) {
            return;
        }
        try {
            linuxMode = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.execEnv).getOSFamily() == HostInfo.OSFamily.LINUX;
        }
        catch (CancellationException ex) {
            linuxMode = false;
        }
        catch (IOException ex) {
            linuxMode = false;
        }
        Object object = this.updaterLock;
        synchronized (object) {
            if (this.updater != null) {
                return;
            }
            this.updater = new Updater(linuxMode);
            DLightExecutorService.submit((Runnable)this.updater, (String)MonitorsUpdateService.class.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.updaterLock;
        synchronized (object) {
            if (this.updater == null) {
                return;
            }
            this.updater.stop();
            this.updater = null;
        }
    }

    boolean isBlank() {
        return !this.isMemoryMonitor && !this.isSyncMonitor && !this.isDataRaceMonitor && !this.isDeadlockMonitor;
    }

    static /* synthetic */ ExecutionEnvironment access$100(MonitorsUpdateService x0) {
        return x0.execEnv;
    }

    static /* synthetic */ String access$200(MonitorsUpdateService x0) {
        return x0.sproHome;
    }

    static /* synthetic */ String access$300(MonitorsUpdateService x0) {
        return x0.experimentDir;
    }

    static /* synthetic */ SunStudioDataCollector access$400(MonitorsUpdateService x0) {
        return x0.ssdc;
    }

    static /* synthetic */ boolean access$600(MonitorsUpdateService x0) {
        return x0.isSyncMonitor;
    }

    static /* synthetic */ Metrics access$700() {
        return SYNC_METRICS;
    }

    static /* synthetic */ List access$800() {
        return SYNC_COLNAMES;
    }

    static /* synthetic */ boolean access$900(MonitorsUpdateService x0) {
        return x0.isMemoryMonitor;
    }

    static /* synthetic */ Metrics access$1000() {
        return LEAK_METRICS;
    }

    static /* synthetic */ List access$1100() {
        return LEAK_COLNAMES;
    }

    static /* synthetic */ boolean access$1200(MonitorsUpdateService x0) {
        return x0.isDataRaceMonitor;
    }

    static /* synthetic */ List access$1300() {
        return DATARACE_COLNAMES;
    }

    static /* synthetic */ boolean access$1400(MonitorsUpdateService x0) {
        return x0.isDeadlockMonitor;
    }

    static /* synthetic */ List access$1500() {
        return DEADLOCK_COLNAMES;
    }

    static {
        METRIC_FORMAT.getDecimalFormatSymbols().setDecimalSeparator(',');
        LEAK_METRICS = Metrics.constructFrom(Arrays.asList(SunStudioDCConfiguration.c_leakSize), Arrays.asList(SunStudioDCConfiguration.c_leakSize));
        LEAK_COLNAMES = Collections.unmodifiableList(Arrays.asList(SunStudioDCConfiguration.c_leakSize.getColumnName()));
        SYNC_METRICS = Metrics.constructFrom(Arrays.asList(SunStudioDCConfiguration.c_eSync), Arrays.asList(SunStudioDCConfiguration.c_eSync));
        SYNC_COLNAMES = Collections.unmodifiableList(Arrays.asList(SunStudioDCConfiguration.c_ulockSummary.getColumnName(), SunStudioDCConfiguration.c_threadsCount.getColumnName()));
        DATARACE_COLNAMES = Collections.unmodifiableList(Arrays.asList(SunStudioDCConfiguration.c_Datarace.getColumnName()));
        DEADLOCK_COLNAMES = Collections.unmodifiableList(Arrays.asList(SunStudioDCConfiguration.c_Deadlocks.getColumnName()));
        log = DLightLogger.getLogger(MonitorsUpdateService.class);
    }

    private class Updater
    implements Runnable {
        private volatile boolean isStopped = false;
        private volatile ErprintSession erprintSession;
        private boolean linuxMode;

        public Updater(boolean linuxMode) {
            this.linuxMode = linuxMode;
        }

        public void stop() {
            this.isStopped = true;
            MonitorsUpdateService.this.requestsQueue.offer(new Object());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block21: {
                if (this.erprintSession != null) {
                    throw new IllegalStateException("Updater can be started only once!");
                }
                this.erprintSession = ErprintSession.createNew(MonitorsUpdateService.access$100(MonitorsUpdateService.this), MonitorsUpdateService.access$200(MonitorsUpdateService.this), MonitorsUpdateService.access$300(MonitorsUpdateService.this), MonitorsUpdateService.access$400(MonitorsUpdateService.this));
                notifyer = DLightExecutorService.scheduleAtFixedRate((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!Updater.this.isStopped) {
                            MonitorsUpdateService.this.requestsQueue.offer(new Object());
                        }
                    }
                }, (long)1L, (TimeUnit)TimeUnit.SECONDS, (String)"SunStudio monitors update task");
                prevTime = 0.0;
                prevLocks = 0.0;
                while (true) lbl-1000:
                // 5 sources

                {
                    try {
                        if (MonitorsUpdateService.access$000(MonitorsUpdateService.this).poll(2L, TimeUnit.SECONDS) == null) {
                        }
                    }
                    catch (InterruptedException ex) {}
                    break block21;
                    restarted = false;
                    newData = new ArrayList<DataRow>();
                    try {
                        if (MonitorsUpdateService.access$600(MonitorsUpdateService.this)) {
                            stat = this.erprintSession.getExperimentStatistics(5, restarted == false);
                            threadsStatistic = this.erprintSession.getThreadsStatistic(5, false);
                            restarted = true;
                            currThreads = threadsStatistic.getThreadsCount();
                            ctime = stat.getDuration();
                            v0 = currTime = ctime == null ? 0.0 : ctime;
                            if (this.linuxMode) {
                                syncFunctions = this.erprintSession.getHotFunctions(MonitorsUpdateService.access$700(), 0x7FFFFFFF, 5, false);
                                currLocks = syncFunctions == null || syncFunctions.length == 0 ? prevLocks : this.sumMetrics(syncFunctions);
                            } else {
                                clocks = stat.getULock();
                                v1 = currLocks = clocks == null ? 0.0 : clocks;
                            }
                            if (0.1 < currTime - prevTime) {
                                newData.add(new DataRow(MonitorsUpdateService.access$800(), Arrays.asList(new Number[]{100.0 * (currLocks - prevLocks) / (currTime - prevTime) / (double)currThreads, currThreads})));
                                prevTime = currTime;
                                prevLocks = currLocks;
                            }
                        }
                        if (MonitorsUpdateService.access$900(MonitorsUpdateService.this)) {
                            leakFunctions = this.erprintSession.getHotFunctions(MonitorsUpdateService.access$1000(), 0x7FFFFFFF, 5, restarted == false);
                            restarted = true;
                            leaks = leakFunctions == null || leakFunctions.length == 0 ? 0L : (long)this.sumMetrics(leakFunctions);
                            newData.add(new DataRow(MonitorsUpdateService.access$1100(), Collections.singletonList(leaks)));
                        }
                        if (MonitorsUpdateService.access$1200(MonitorsUpdateService.this)) {
                            dataraces = this.erprintSession.getDataRaces(restarted == false);
                            restarted = true;
                            newData.add(new DataRow(MonitorsUpdateService.access$1300(), Collections.singletonList(dataraces.size())));
                        }
                        if (!MonitorsUpdateService.access$1400(MonitorsUpdateService.this)) ** GOTO lbl-1000
                        deadlocks = this.erprintSession.getDeadlocks(restarted == false);
                        restarted = true;
                        newData.add(new DataRow(MonitorsUpdateService.access$1500(), Collections.singletonList(deadlocks.size())));
                    }
                    catch (Throwable ex) {
                        MonitorsUpdateService.access$1600().log(Level.FINEST, "Exception while updateIndicators in MonitorUpdateService: {0}", ex.toString());
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        MonitorsUpdateService.access$400(MonitorsUpdateService.this).updateIndicators(newData);
                        continue;
                    }
                    break;
                }
                ** GOTO lbl-1000
                finally {
                    if (notifyer != null) {
                        notifyer.cancel(1L);
                    }
                    if (this.erprintSession != null) {
                        this.erprintSession.close();
                    }
                    MonitorsUpdateService.access$400(MonitorsUpdateService.this).notifyIndicatorsThatProviderFinished();
                }
            }
        }

        private double sumMetrics(String[] erprintOutput) {
            double sum = 0.0;
            for (String line : erprintOutput) {
                Matcher m = METRIC_LINE_PATTERN.matcher(line);
                if (!m.matches()) continue;
                String stringValue = m.group(1);
                try {
                    sum += METRIC_FORMAT.parse(stringValue).doubleValue();
                }
                catch (ParseException ex) {
                    log.log(Level.WARNING, null, ex);
                }
            }
            return sum;
        }
    }
}

