/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.dataprovider;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilter;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.api.FunctionCallWithMetric;
import org.netbeans.modules.dlight.core.stack.api.FunctionMetric;
import org.netbeans.modules.dlight.core.stack.api.ThreadDumpProvider;
import org.netbeans.modules.dlight.core.stack.dataprovider.FunctionCallTreeTableNode;
import org.netbeans.modules.dlight.core.stack.dataprovider.StackDataProvider;
import org.netbeans.modules.dlight.management.remote.spi.PathMapper;
import org.netbeans.modules.dlight.management.remote.spi.PathMapperProvider;
import org.netbeans.modules.dlight.perfan.SunStudioDCConfiguration;
import org.netbeans.modules.dlight.perfan.dataprovider.SSMetrics;
import org.netbeans.modules.dlight.perfan.lineinfo.impl.SSSourceFileInfoSupport;
import org.netbeans.modules.dlight.perfan.spi.datafilter.HotSpotFunctionsFilter;
import org.netbeans.modules.dlight.perfan.stack.impl.FunctionCallImpl;
import org.netbeans.modules.dlight.perfan.stack.impl.FunctionImpl;
import org.netbeans.modules.dlight.perfan.storage.impl.Address;
import org.netbeans.modules.dlight.perfan.storage.impl.ErprintCommand;
import org.netbeans.modules.dlight.perfan.storage.impl.Metrics;
import org.netbeans.modules.dlight.perfan.storage.impl.PerfanDataStorage;
import org.netbeans.modules.dlight.perfan.util.Computable;
import org.netbeans.modules.dlight.perfan.util.TasksCachedProcessor;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.threads.api.Datarace;
import org.netbeans.modules.dlight.threads.api.Deadlock;
import org.netbeans.modules.dlight.threads.dataprovider.ThreadAnalyzerDataProvider;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.util.Range;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.util.Lookup;

class SSStackDataProvider
implements StackDataProvider,
ThreadAnalyzerDataProvider {
    private static final Logger log = DLightLogger.getLogger(SSStackDataProvider.class);
    private static final Pattern fullInfoPattern = Pattern.compile("^(.*), line ([0-9]+) in \"(.*)\"");
    private static final Pattern noLineInfoPattern = Pattern.compile("^<Function: (.*), instructions from source file (.*)>");
    private static final Pattern noDebugInfoPattern = Pattern.compile("^<Function: (.*), instructions without line numbers>");
    private static final List<FunctionMetric> metricsList = Arrays.asList(SSMetrics.TimeMetric.UserFuncTimeExclusive, SSMetrics.TimeMetric.UserFuncTimeInclusive, SSMetrics.TimeMetric.SyncWaitCallInclusive, SSMetrics.TimeMetric.SyncWaitTimeInclusive, SSMetrics.TimeMetric.SyncWaitCallExclusive, SSMetrics.TimeMetric.SyncWaitTimeExclusive, SSMetrics.MemoryMetric.LeakBytesMetric, SSMetrics.MemoryMetric.LeaksCountMetric);
    private static boolean ompSupport = Boolean.valueOf(System.getProperty("dlight.sunstudio.omp"));
    private final Computable<HotSpotFunctionsFetcherParams, List<FunctionCallWithMetric>> hotSpotFunctionsFetcher = new TasksCachedProcessor<HotSpotFunctionsFetcherParams, List<FunctionCallWithMetric>>(new HotSpotFunctionsFetcher(), true);
    private final HashMap<Long, SourceFileInfoProvider.SourceFileInfo> nonSSSourceInfoCache = new HashMap();
    private PerfanDataStorage storage;
    private SSSourceFileInfoSupport sourceFileInfoSupport = null;
    private PathMapper pathMapper = null;
    private Map<String, String> serviceInfo = null;
    private volatile HotSpotFunctionsFilter filter;
    private volatile TimeIntervalDataFilter timeIntervalDataFilter;

    public void attachTo(ServiceInfoDataStorage serviceInfoStorage) {
        if (serviceInfoStorage == null) {
            throw new NullPointerException();
        }
        String envID = serviceInfoStorage.getValue("service.storage.execution.env.key");
        ExecutionEnvironment execEnv = envID == null ? ExecutionEnvironmentFactory.getLocal() : ExecutionEnvironmentFactory.fromUniqueID((String)envID);
        PathMapperProvider pathMapperProvider = (PathMapperProvider)Lookup.getDefault().lookup(PathMapperProvider.class);
        this.pathMapper = pathMapperProvider == null ? null : pathMapperProvider.getPathMapper(execEnv);
        this.serviceInfo = Collections.unmodifiableMap(serviceInfoStorage.getInfo());
        this.nonSSSourceInfoCache.clear();
    }

    public void dataFiltersChanged(List<DataFilter> newSet, boolean isAdjusting) {
        boolean hasTimeIntervalFilter = false;
        for (DataFilter f : newSet) {
            if (f instanceof HotSpotFunctionsFilter) {
                this.filter = (HotSpotFunctionsFilter)f;
            }
            if (!(f instanceof TimeIntervalDataFilter)) continue;
            this.timeIntervalDataFilter = (TimeIntervalDataFilter)f;
            hasTimeIntervalFilter = true;
        }
        if (!hasTimeIntervalFilter && this.timeIntervalDataFilter != null) {
            if (this.storage != null) {
                this.storage.setFilter("\"\"");
            }
            this.timeIntervalDataFilter = null;
        }
        if (hasTimeIntervalFilter && this.timeIntervalDataFilter != null) {
            Range filterInterval = this.timeIntervalDataFilter.getInterval();
            if (filterInterval.getStart() != null || filterInterval.getEnd() != null) {
                this.storage.setFilter(filterInterval.toString(null, "TSTAMP>%d", "&&", "TSTAMP<%d", null));
            } else {
                this.storage.setFilter(null);
            }
        }
    }

    public ThreadDumpProvider getThreadDumpProvider() {
        return null;
    }

    public List<FunctionCallWithMetric> getCallers(List<FunctionCallWithMetric> path, List<DataTableMetadata.Column> columns, List<DataTableMetadata.Column> orderBy, boolean aggregate) {
        return this.getCallersCallees(CC_MODE.CALLERS, path, aggregate);
    }

    public List<FunctionCallWithMetric> getCallees(List<FunctionCallWithMetric> path, List<DataTableMetadata.Column> columns, List<DataTableMetadata.Column> orderBy, boolean aggregate) {
        return this.getCallersCallees(CC_MODE.CALLEES, path, aggregate);
    }

    public List<FunctionCall> getCallStack(int stackId) {
        return Collections.emptyList();
    }

    public List<FunctionCallTreeTableNode> getTableView(List<DataTableMetadata.Column> columns, List<DataTableMetadata.Column> orderBy, int limit) {
        return FunctionCallTreeTableNode.getFunctionCallTreeTableNodes(this.getFunctionCalls(columns, orderBy, limit));
    }

    public List<FunctionCallTreeTableNode> getChildren(List<FunctionCallTreeTableNode> path, List<DataTableMetadata.Column> columns, List<DataTableMetadata.Column> orderBy) {
        List fpath = FunctionCallTreeTableNode.getFunctionCalls(path);
        List<FunctionCallWithMetric> callers = this.getCallers(fpath, columns, orderBy, false);
        return FunctionCallTreeTableNode.getFunctionCallTreeTableNodes(callers);
    }

    public FunctionCallTreeTableNode getValueAt(int row) {
        return null;
    }

    public String getTableValueAt(DataTableMetadata.Column column, int row) {
        return null;
    }

    private synchronized List<FunctionCallWithMetric> getCallersCallees(CC_MODE mode, List<FunctionCallWithMetric> path, boolean aggregate) {
        return Collections.emptyList();
    }

    public List<FunctionCallWithMetric> getFunctionCalls(List<DataTableMetadata.Column> columns, List<DataTableMetadata.Column> orderBy, int limit) {
        List<FunctionCallWithMetric> result = Collections.emptyList();
        try {
            result = this.hotSpotFunctionsFetcher.compute(new HotSpotFunctionsFetcherParams(ErprintCommand.lines(), columns, orderBy, limit, this.filter));
        }
        catch (InterruptedException ex) {
            log.fine("HotSpotFunctionsFetcher interrupted");
        }
        return result;
    }

    public List<FunctionCallWithMetric> getHotSpotFunctions(List<DataTableMetadata.Column> columns, List<DataTableMetadata.Column> orderBy, int limit) {
        try {
            return this.hotSpotFunctionsFetcher.compute(new HotSpotFunctionsFetcherParams(ErprintCommand.functions(), columns, orderBy, limit, this.filter));
        }
        catch (InterruptedException ex) {
            log.fine("HotSpotFunctionsFetcher interrupted.");
            return Collections.emptyList();
        }
    }

    public List<? extends Deadlock> getDeadlocks() {
        return this.storage.getDeadlocks();
    }

    public List<? extends Datarace> getDataraces() {
        return this.storage.getDataraces();
    }

    private FunctionMetric getMetricInstance(String name) {
        for (FunctionMetric metric : metricsList) {
            if (!metric.getMetricID().equals(name)) continue;
            return metric;
        }
        return null;
    }

    public List<FunctionMetric> getMetricsList() {
        return metricsList;
    }

    public void attachTo(DataStorage storage) {
        if (!(storage instanceof PerfanDataStorage)) {
            String msg = "Attempt to attach SSStackDataProvider to storage '" + storage + "'";
            throw new IllegalArgumentException(msg);
        }
        this.storage = (PerfanDataStorage)storage;
        this.sourceFileInfoSupport = SSSourceFileInfoSupport.getSourceFileInfoSupportFor(this.storage);
        this.nonSSSourceInfoCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceFileInfoProvider.SourceFileInfo getSourceFileInfo(FunctionCall functionCall) {
        if (this.sourceFileInfoSupport == null) {
            return null;
        }
        if (!(functionCall instanceof FunctionCallImpl)) {
            return null;
        }
        FunctionCallImpl fci = (FunctionCallImpl)functionCall;
        Long refID = fci.getFunctionRefID();
        SourceFileInfoProvider.SourceFileInfo result = this.sourceFileInfoSupport.getSourceFileInfo(fci, this.pathMapper);
        if (result == null || !result.isSourceKnown()) {
            HashMap<Long, SourceFileInfoProvider.SourceFileInfo> hashMap = this.nonSSSourceInfoCache;
            synchronized (hashMap) {
                if (this.nonSSSourceInfoCache.containsKey(refID)) {
                    result = this.nonSSSourceInfoCache.get(refID);
                } else {
                    Collection sourceInfoProviders = Lookup.getDefault().lookupAll(SourceFileInfoProvider.class);
                    for (SourceFileInfoProvider provider : sourceInfoProviders) {
                        result = provider.getSourceFileInfo(functionCall.getFunction().getQuilifiedName(), (int)functionCall.getOffset(), -1L, this.serviceInfo);
                        if (result == null || !result.isSourceKnown()) continue;
                        log.log(Level.FINEST, "SourceLineInfo data from {0}: {1}", new Object[]{provider.getClass().getSimpleName(), result.toString()});
                        break;
                    }
                    this.nonSSSourceInfoCache.put(refID, result);
                }
            }
        }
        fci.setSourceFileInfo(result);
        return result;
    }

    private class HotSpotFunctionsFetcher
    implements Computable<HotSpotFunctionsFetcherParams, List<FunctionCallWithMetric>> {
        private final DecimalFormat df = new DecimalFormat();

        public HotSpotFunctionsFetcher() {
            DecimalFormatSymbols symbols = this.df.getDecimalFormatSymbols();
            symbols.setDecimalSeparator('.');
            this.df.setDecimalFormatSymbols(symbols);
        }

        @Override
        public List<FunctionCallWithMetric> compute(HotSpotFunctionsFetcherParams taskArguments) throws InterruptedException {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Started to fetch Hot Spot Functions @ {0}", Thread.currentThread());
            }
            Metrics metrics = taskArguments.metrics;
            String[] er_result = null;
            try {
                er_result = SSStackDataProvider.this.storage.getTopFunctions(taskArguments.command, metrics, taskArguments.limit);
            }
            catch (InterruptedException ex) {
                log.log(Level.FINEST, "Fetching Interrupted! Hot Spot Functions @ {0}", Thread.currentThread());
                return null;
            }
            int limit = er_result == null || er_result.length == 0 ? 0 : Math.min(er_result.length, taskArguments.limit);
            ArrayList<FunctionCallWithMetric> result = new ArrayList<FunctionCallWithMetric>(limit);
            DataTableMetadata.Column primarySortColumn = (DataTableMetadata.Column)taskArguments.orderBy.get(0);
            for (int i = 0; i < limit; ++i) {
                Address address;
                int lineNumber = -1;
                String fileName = null;
                String[] info = er_result[i].split("[ \t]+", taskArguments.nameIdx + 1);
                String name = info[taskArguments.nameIdx];
                if (!taskArguments.isDefaultCommand() && ErprintCommand.lines().equals(taskArguments.command)) {
                    Matcher match = fullInfoPattern.matcher(name);
                    if (match.matches()) {
                        name = match.group(1);
                        lineNumber = Integer.valueOf(match.group(2));
                        fileName = match.group(3);
                    } else {
                        if (SSStackDataProvider.this.filter != null && SSStackDataProvider.this.filter.getType() == HotSpotFunctionsFilter.CollectedDataType.WITHSOURCECODEONLY) continue;
                        match = noLineInfoPattern.matcher(name);
                        if (match.matches()) {
                            name = match.group(1);
                            fileName = match.group(2);
                        } else {
                            match = noDebugInfoPattern.matcher(name);
                            if (!match.matches()) continue;
                            name = match.group(1);
                        }
                    }
                }
                FunctionImpl f = new FunctionImpl(name, (address = Address.parse(info[taskArguments.addressIdx] + info[taskArguments.addressIdx + 1])) == null ? (long)name.hashCode() : address.getAddress());
                HashMap<FunctionMetric, Object> metricsValues = new HashMap<FunctionMetric, Object>();
                boolean skipFunction = false;
                for (int midx = 0; midx < taskArguments.requestColumns.size(); ++midx) {
                    DataTableMetadata.Column col = (DataTableMetadata.Column)taskArguments.requestColumns.get(midx);
                    if (col.equals(SunStudioDCConfiguration.c_name)) continue;
                    String colName = col.getColumnName();
                    Class colClass = col.getColumnClass();
                    FunctionMetric metric = SSStackDataProvider.this.getMetricInstance(colName);
                    boolean isPrimaryColumn = col.equals(primarySortColumn);
                    String val = info[taskArguments.columnsIdxRef[midx]];
                    Object metricValue = val;
                    try {
                        Number nvalue = this.df.parse(val);
                        if (Integer.class == colClass) {
                            if (isPrimaryColumn && nvalue.intValue() == 0) {
                                skipFunction = true;
                            }
                            metricValue = nvalue.intValue();
                        } else if (Double.class == colClass) {
                            if (isPrimaryColumn && nvalue.doubleValue() == 0.0) {
                                skipFunction = true;
                            }
                            metricValue = nvalue.doubleValue();
                        } else if (Float.class == colClass) {
                            if (isPrimaryColumn && nvalue.floatValue() == 0.0f) {
                                skipFunction = true;
                            }
                            metricValue = Float.valueOf(nvalue.floatValue());
                        } else if (Long.class == colClass) {
                            if (isPrimaryColumn && nvalue.longValue() == 0L) {
                                skipFunction = true;
                            }
                            metricValue = nvalue.longValue();
                        }
                    }
                    catch (ParseException ex) {
                        // empty catch block
                    }
                    metricsValues.put(metric, metricValue);
                }
                if (skipFunction) continue;
                FunctionCallImpl fc = new FunctionCallImpl(f, lineNumber, metricsValues);
                if (fileName != null) {
                    fc.setSourceFileInfo(new SourceFileInfoProvider.SourceFileInfo((CharSequence)fileName, lineNumber, 0));
                }
                result.add(fc);
            }
            DataTableMetadata.Column ompPrimarySortColumn = null;
            List<DataTableMetadata.Column> ompColumns = null;
            int omp_limit = Integer.MAX_VALUE;
            if (ompSupport && SSStackDataProvider.this.storage.hasOMPCollected()) {
                if (metrics.getMspec().indexOf(SunStudioDCConfiguration.c_eSync.getColumnName()) != -1 && metrics.getMsort().indexOf(SunStudioDCConfiguration.c_eSync.getColumnName()) != -1) {
                    ompPrimarySortColumn = SunStudioDCConfiguration.c_iOMPWait;
                    ompColumns = Arrays.asList(SunStudioDCConfiguration.c_iOMPWait, SunStudioDCConfiguration.c_name);
                }
                if (metrics.getMspec().indexOf(SunStudioDCConfiguration.c_eUser.getColumnName()) != -1 && metrics.getMsort().indexOf(SunStudioDCConfiguration.c_eUser.getColumnName()) != -1) {
                    ompPrimarySortColumn = SunStudioDCConfiguration.c_iOMPWork;
                    ompColumns = Arrays.asList(SunStudioDCConfiguration.c_iOMPWork, SunStudioDCConfiguration.c_name);
                }
                String[] omp_er_result = null;
                HotSpotFunctionsFetcherParams ompTaskArguments = null;
                try {
                    if (ompColumns != null) {
                        ompTaskArguments = new HotSpotFunctionsFetcherParams(taskArguments.command, ompColumns, Arrays.asList(ompPrimarySortColumn), omp_limit, SSStackDataProvider.this.filter);
                        omp_er_result = SSStackDataProvider.this.storage.getTopFunctions(ompTaskArguments.command, ompTaskArguments.metrics, omp_limit);
                    }
                }
                catch (InterruptedException ex) {
                    log.log(Level.FINEST, "Fetching Interrupted! Hot Spot Functions @ {0}", Thread.currentThread());
                }
                omp_limit = omp_er_result == null || omp_er_result.length == 0 ? 0 : omp_er_result.length;
                for (int i = 0; i < omp_limit; ++i) {
                    Address address;
                    int lineNumber = -1;
                    String fileName = null;
                    String[] info = omp_er_result[i].split("[ \t]+", ompTaskArguments.nameIdx + 1);
                    String name = info[ompTaskArguments.nameIdx];
                    if (!taskArguments.isDefaultCommand() && ErprintCommand.lines().equals(ompTaskArguments.command)) {
                        Matcher match = fullInfoPattern.matcher(name);
                        if (match.matches()) {
                            name = match.group(1);
                            lineNumber = Integer.valueOf(match.group(2));
                            fileName = match.group(3);
                        } else {
                            if (SSStackDataProvider.this.filter != null && SSStackDataProvider.this.filter.getType() == HotSpotFunctionsFilter.CollectedDataType.WITHSOURCECODEONLY) continue;
                            match = noLineInfoPattern.matcher(name);
                            if (match.matches()) {
                                name = match.group(1);
                                fileName = match.group(2);
                            } else {
                                match = noDebugInfoPattern.matcher(name);
                                if (!match.matches()) continue;
                                name = match.group(1);
                            }
                        }
                    }
                    FunctionImpl f = new FunctionImpl(name, (address = Address.parse(info[ompTaskArguments.addressIdx] + info[ompTaskArguments.addressIdx + 1])) == null ? (long)name.hashCode() : address.getAddress());
                    HashMap<FunctionMetric, Object> metricsValues = new HashMap<FunctionMetric, Object>();
                    boolean skipFunction = false;
                    for (int midx = 0; midx < ompTaskArguments.requestColumns.size(); ++midx) {
                        DataTableMetadata.Column col = (DataTableMetadata.Column)ompTaskArguments.requestColumns.get(midx);
                        if (col.equals(SunStudioDCConfiguration.c_name)) continue;
                        String colName = col.getColumnName();
                        Class colClass = col.getColumnClass();
                        FunctionMetric metric = SSStackDataProvider.this.getMetricInstance(colName);
                        if (SunStudioDCConfiguration.c_iOMPWait.getColumnName().equals(colName)) {
                            metric = SSStackDataProvider.this.getMetricInstance(SunStudioDCConfiguration.c_eSync.getColumnName());
                        } else if (SunStudioDCConfiguration.c_iOMPWork.getColumnName().equals(colName)) {
                            metric = SSStackDataProvider.this.getMetricInstance(SunStudioDCConfiguration.c_eUser.getColumnName());
                        }
                        boolean isPrimaryColumn = col.equals(ompPrimarySortColumn);
                        String val = info[ompTaskArguments.columnsIdxRef[midx]];
                        Object metricValue = val;
                        try {
                            Number nvalue = this.df.parse(val);
                            if (Integer.class == colClass) {
                                if (isPrimaryColumn && nvalue.intValue() == 0) {
                                    skipFunction = true;
                                }
                                metricValue = nvalue.intValue();
                            } else if (Double.class == colClass) {
                                if (isPrimaryColumn && nvalue.doubleValue() == 0.0) {
                                    skipFunction = true;
                                }
                                metricValue = nvalue.doubleValue();
                            } else if (Float.class == colClass) {
                                if (isPrimaryColumn && nvalue.floatValue() == 0.0f) {
                                    skipFunction = true;
                                }
                                metricValue = Float.valueOf(nvalue.floatValue());
                            } else if (Long.class == colClass) {
                                if (isPrimaryColumn && nvalue.longValue() == 0L) {
                                    skipFunction = true;
                                }
                                metricValue = nvalue.longValue();
                            }
                        }
                        catch (ParseException ex) {
                            // empty catch block
                        }
                        metricsValues.put(metric, metricValue);
                    }
                    if (skipFunction) continue;
                    FunctionCallImpl fc = new FunctionCallImpl(f, lineNumber, metricsValues);
                    if (fileName != null) {
                        fc.setSourceFileInfo(new SourceFileInfoProvider.SourceFileInfo((CharSequence)fileName, lineNumber, 0));
                    }
                    result.add(fc);
                }
            }
            log.fine("Done with Hot Spot Functions fetching");
            return result;
        }
    }

    private static class HotSpotFunctionsFetcherParams {
        private final ErprintCommand command;
        private final List<DataTableMetadata.Column> resultColumns;
        private final List<DataTableMetadata.Column> requestColumns;
        private final int[] columnsIdxRef;
        private final List<DataTableMetadata.Column> orderBy;
        private final int limit;
        private final Metrics metrics;
        private final int nameIdx;
        private final int addressIdx;
        private final HotSpotFunctionsFilter filter;

        HotSpotFunctionsFetcherParams(ErprintCommand command, List<DataTableMetadata.Column> columns, List<DataTableMetadata.Column> orderBy, int limit, HotSpotFunctionsFilter filter) {
            if (columns == null) {
                throw new NullPointerException();
            }
            if (columns.isEmpty()) {
                throw new IllegalArgumentException("HotSpotFunctionsFetcherParams: empty columns list!");
            }
            this.resultColumns = new ArrayList<DataTableMetadata.Column>();
            int size = columns.size();
            this.columnsIdxRef = new int[size];
            int nameColumnIdx = -1;
            int addressColumnIdx = -1;
            int idx = 0;
            for (int cidx = 0; cidx < size; ++cidx) {
                DataTableMetadata.Column c = columns.get(cidx);
                if (c.equals(SunStudioDCConfiguration.c_address)) {
                    addressColumnIdx = cidx;
                    continue;
                }
                if (c.equals(SunStudioDCConfiguration.c_name)) {
                    nameColumnIdx = cidx;
                    continue;
                }
                this.resultColumns.add(c);
                this.columnsIdxRef[cidx] = idx++;
            }
            if (addressColumnIdx == -1) {
                this.resultColumns.add(SunStudioDCConfiguration.c_address);
                addressColumnIdx = idx;
            } else {
                this.resultColumns.add(columns.get(addressColumnIdx));
                this.columnsIdxRef[addressColumnIdx] = idx;
            }
            this.addressIdx = idx;
            idx += 2;
            if (nameColumnIdx == -1) {
                this.resultColumns.add(SunStudioDCConfiguration.c_name);
                nameColumnIdx = idx;
            } else {
                this.resultColumns.add(columns.get(nameColumnIdx));
                this.columnsIdxRef[nameColumnIdx] = idx;
            }
            this.nameIdx = idx++;
            this.command = command == null ? ErprintCommand.functions() : command;
            this.requestColumns = columns;
            this.orderBy = orderBy == null ? Arrays.asList(columns.get(0)) : orderBy;
            this.limit = limit;
            this.metrics = Metrics.constructFrom(this.resultColumns, orderBy);
            this.filter = filter;
        }

        boolean isDefaultCommand() {
            return ErprintCommand.functions().equals(this.command);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof HotSpotFunctionsFetcherParams)) {
                throw new IllegalArgumentException();
            }
            HotSpotFunctionsFetcherParams o = (HotSpotFunctionsFetcherParams)obj;
            return o.metrics.equals(this.metrics) && o.limit == this.limit;
        }

        public int hashCode() {
            int hash = 3;
            hash = 71 * hash + this.limit;
            hash = 71 * hash + (this.metrics != null ? this.metrics.hashCode() : 0);
            return hash;
        }
    }

    private static enum CC_MODE {
        CALLEES,
        CALLERS;

    }
}

