/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.ProjectFileNameBasedKey;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.repository.spi.KeyDataPresentation;
import org.openide.util.CharSequences;

abstract class OffsetableKey
extends ProjectFileNameBasedKey
implements Comparable<OffsetableKey> {
    private final int startOffset;
    private final int endOffset;
    private final int hashCode;
    private final CharSequence name;

    protected OffsetableKey(CsmOffsetable csmOffsetable, String string, CharSequence charSequence) {
        this((FileImpl)csmOffsetable.getContainingFile(), csmOffsetable.getStartOffset(), csmOffsetable.getEndOffset(), string, charSequence);
    }

    protected OffsetableKey(FileImpl fileImpl, int n, int n2, String string, CharSequence charSequence) {
        super(fileImpl);
        this.startOffset = n;
        this.endOffset = n2;
        assert (string.length() == 1);
        this.name = NameCache.getManager().getString(charSequence);
        this.hashCode = this._hashCode() << 8 | string.charAt(0) & 0xFF;
    }

    protected OffsetableKey(KeyDataPresentation keyDataPresentation) {
        super(keyDataPresentation);
        this.startOffset = keyDataPresentation.getStartPresentation();
        this.endOffset = keyDataPresentation.getEndPresentation();
        this.name = NameCache.getManager().getString(keyDataPresentation.getNamePresentation());
        this.hashCode = this._hashCode() << 8 | keyDataPresentation.getKindPresentation() & 0xFF;
    }

    char getKind() {
        return (char)(this.hashCode & 0xFF);
    }

    CharSequence getName() {
        if (this.name != null && 0 < this.name.length() && this.isDigit(this.name.charAt(0))) {
            return CharSequences.empty();
        }
        return this.name;
    }

    private boolean isDigit(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }

    int getStartOffset() {
        return this.startOffset;
    }

    int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        dataOutput.writeInt(this.startOffset);
        dataOutput.writeInt(this.endOffset);
        dataOutput.writeInt(this.hashCode);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, dataOutput);
    }

    protected OffsetableKey(DataInput dataInput) throws IOException {
        super(dataInput);
        this.startOffset = dataInput.readInt();
        this.endOffset = dataInput.readInt();
        this.hashCode = dataInput.readInt();
        this.name = PersistentUtils.readUTF(dataInput, NameCache.getManager());
        assert (CharSequences.isCompact((CharSequence)this.name));
    }

    @Override
    public String toString() {
        return this.name + "[" + this.getKind() + " " + this.getStartOffset() + "-" + this.getEndOffset() + "] {" + this.getFileNameSafe() + "; " + this.getProjectName() + "}";
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        OffsetableKey offsetableKey = (OffsetableKey)object;
        assert (CharSequences.isCompact((CharSequence)this.name));
        assert (CharSequences.isCompact((CharSequence)offsetableKey.name));
        return this.startOffset == offsetableKey.startOffset && this.endOffset == offsetableKey.endOffset && this.getKind() == offsetableKey.getKind() && this.name.equals(offsetableKey.name);
    }

    @Override
    public int hashCode() {
        return (this.hashCode >> 8) + 37 * (this.hashCode & 0xFF);
    }

    private int _hashCode() {
        int n = 19 * super.hashCode() + this.name.hashCode();
        n = 19 * n + this.startOffset;
        n = 19 * n + this.endOffset - this.startOffset;
        return n;
    }

    @Override
    public int compareTo(OffsetableKey offsetableKey) {
        if (this == offsetableKey) {
            return 0;
        }
        assert (this.getKind() == offsetableKey.getKind());
        assert (this.getUnitId() == offsetableKey.getUnitId());
        assert (this.fileNameIndex == offsetableKey.fileNameIndex);
        int n = this.startOffset;
        int n2 = offsetableKey.startOffset;
        if (n == n2) {
            return 0;
        }
        return n - n2;
    }

    @Override
    public int getDepth() {
        return super.getDepth() + 2;
    }

    @Override
    public CharSequence getAt(int n) {
        int n2 = super.getDepth();
        if (n < n2) {
            return super.getAt(n);
        }
        switch (n - n2) {
            case 0: {
                return new String(new char[]{this.getKind()});
            }
            case 1: {
                return this.name;
            }
        }
        throw new IllegalArgumentException("not supported level" + n);
    }

    @Override
    public int getSecondaryDepth() {
        return 2;
    }

    @Override
    public int getSecondaryAt(int n) {
        switch (n) {
            case 0: {
                return this.startOffset;
            }
            case 1: {
                return this.endOffset;
            }
        }
        throw new IllegalArgumentException("not supported level" + n);
    }

    @Override
    public final int getStartPresentation() {
        return this.startOffset;
    }

    @Override
    public final int getEndPresentation() {
        return this.endOffset;
    }

    @Override
    public final CharSequence getNamePresentation() {
        return this.name;
    }

    @Override
    public final short getKindPresentation() {
        return (short)this.getKind();
    }
}

