/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.platform;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.editor.DocumentUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBufferSnapshot;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.spi.utils.CndFileSystemProvider;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;
import org.netbeans.modules.dlight.libs.common.InvalidFileObjectSupport;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public class FileBufferImpl
implements FileBuffer,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(FileBufferImpl.class.getName());
    private final CharSequence absPath;
    private final FileSystem fileSystem;
    private Reference<Document> docRef = new WeakReference<Object>(null);
    private final FileImpl fileImpl;
    private SoftReference<FileBufferSnapshot> snapRef = new SoftReference<Object>(null);

    FileBufferImpl(FileObject fileObject, FileImpl fileImpl) {
        this(FileBufferImpl.getFileSystem(fileObject), CndFileUtils.normalizePath((FileObject)fileObject), fileImpl);
        this.attachListeners(fileObject);
    }

    FileBufferImpl(FileSystem fileSystem, CharSequence charSequence, FileImpl fileImpl) {
        this.absPath = FilePathCache.getManager().getString(charSequence);
        this.fileSystem = fileSystem;
        this.fileImpl = fileImpl;
    }

    private String getEncoding() {
        FileObject fileObject = this.getFileObject();
        Charset charset = null;
        if (fileObject != null && fileObject.isValid()) {
            charset = FileEncodingQuery.getEncoding((FileObject)fileObject);
        }
        if (charset == null) {
            charset = FileEncodingQuery.getDefaultEncoding();
        }
        return charset.name();
    }

    @Override
    public FileObject getFileObject() {
        FileObject fileObject = CndFileUtils.toFileObject((FileSystem)this.fileSystem, (CharSequence)this.absPath);
        if (fileObject == null) {
            CndUtils.assertTrueInConsole((boolean)false, (String)("can not find file object for " + this.absPath));
        }
        return fileObject;
    }

    private DataObject getDataObject() {
        return this.getDataObjectImpl(this.getFileObject());
    }

    public DataObject getDataObjectImpl(FileObject fileObject) {
        DataObject dataObject = null;
        if (fileObject != null && fileObject.isValid()) {
            try {
                dataObject = DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return dataObject;
    }

    private static FileSystem getFileSystem(FileObject fileObject) {
        try {
            return fileObject.getFileSystem();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            return InvalidFileObjectSupport.getDummyFileSystem();
        }
    }

    private Document getDocument() {
        EditorCookie editorCookie;
        Document document = this.docRef.get();
        if (document != null) {
            return document;
        }
        DataObject dataObject = this.getDataObject();
        EditorCookie editorCookie2 = editorCookie = dataObject == null ? null : (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
        if (editorCookie == null) {
            return null;
        }
        StyledDocument styledDocument = editorCookie.getDocument();
        this.docRef = new WeakReference<StyledDocument>(styledDocument);
        return styledDocument;
    }

    private void attachListeners(FileObject fileObject) {
        EditorCookie.Observable observable;
        DataObject dataObject;
        if (fileObject.isValid() && fileObject.canWrite() && (dataObject = this.getDataObjectImpl(fileObject)) != null && (observable = (EditorCookie.Observable)dataObject.getLookup().lookup(EditorCookie.Observable.class)) != null) {
            observable.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    @Override
    public String getText(int n, int n2) throws IOException {
        return this.getSnapshot().getText(n, n2);
    }

    @Override
    public CharSequence getText() throws IOException {
        return this.getSnapshot().getText();
    }

    @Override
    public long lastModified() {
        Document document = this.getDocument();
        if (document != null) {
            long l = org.netbeans.lib.editor.util.swing.DocumentUtilities.getDocumentTimestamp((Document)document);
            return l;
        }
        return this.getFileObject().lastModified().getTime();
    }

    public char[] getCharBuffer() throws IOException {
        return this.getSnapshot().getCharBuffer();
    }

    private FileBufferSnapshot getCharBufferDoc(final Document document) throws IOException {
        final AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
        final AtomicReference<Object> atomicReference2 = new AtomicReference<Object>(null);
        document.render(new Runnable(){

            @Override
            public void run() {
                try {
                    int n = document.getLength();
                    char[] cArray = new char[n];
                    DocumentUtilities.copyText((Document)document, (int)0, (int)n, (char[])cArray, (int)0);
                    long l = org.netbeans.lib.editor.util.swing.DocumentUtilities.getDocumentTimestamp((Document)document);
                    atomicReference2.set(new FileBufferSnapshot(FileBufferImpl.this.fileSystem, FileBufferImpl.this.absPath, cArray, null, l));
                }
                catch (BadLocationException badLocationException) {
                    atomicReference.set(badLocationException);
                }
            }
        });
        if (atomicReference.get() != null) {
            throw this.toIOException(atomicReference.get());
        }
        return atomicReference2.get();
    }

    private IOException toIOException(BadLocationException badLocationException) {
        IOException iOException = new IOException(badLocationException.getMessage());
        iOException.setStackTrace(badLocationException.getStackTrace());
        return iOException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileBufferSnapshot getCharBufferFile(FileObject fileObject) throws IOException {
        InputStream inputStream = fileObject.getInputStream();
        assert (inputStream != null) : "FileObject.getInputStream() returned null for FileObject: " + FileUtil.getFileDisplayName((FileObject)fileObject);
        try {
            FileBufferSnapshot fileBufferSnapshot;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, this.getEncoding()));
            try {
                char c;
                long l = fileObject.lastModified().getTime();
                StringBuilder stringBuilder = new StringBuilder(Math.max(16, (int)fileObject.getSize()));
                LinkedList<Integer> linkedList = new LinkedList<Integer>();
                boolean bl = false;
                char[] cArray = new char[1024];
                int n = -1;
                linkedList.add(0);
                while (-1 != (n = bufferedReader.read(cArray, 0, cArray.length))) {
                    for (int i = 0; i < n; ++i) {
                        c = cArray[i];
                        if (bl && c == '\n') {
                            stringBuilder.append('\n');
                            linkedList.add(stringBuilder.length());
                            bl = false;
                            continue;
                        }
                        if (c == '\r') {
                            bl = true;
                            continue;
                        }
                        if (c == '\u2028' || c == '\u2029') {
                            stringBuilder.append('\n');
                            linkedList.add(stringBuilder.length());
                            bl = false;
                            continue;
                        }
                        bl = false;
                        stringBuilder.append(c);
                    }
                }
                int[] nArray = new int[linkedList.size()];
                c = '\u0000';
                for (Integer object2 : linkedList) {
                    nArray[c++] = object2;
                }
                Object object3 = new char[stringBuilder.length()];
                stringBuilder.getChars(0, stringBuilder.length(), (char[])object3, 0);
                fileBufferSnapshot = new FileBufferSnapshot(this.fileSystem, this.absPath, (char[])object3, nArray, l);
            }
            catch (Throwable throwable) {
                bufferedReader.close();
                throw throwable;
            }
            bufferedReader.close();
            return fileBufferSnapshot;
        }
        finally {
            inputStream.close();
        }
    }

    @Override
    public boolean isFileBased() {
        return this.getDocument() == null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        LOG.log(Level.INFO, "{0}", propertyChangeEvent);
        if ("document".equals(propertyChangeEvent.getPropertyName()) || "openedPanes".equals(propertyChangeEvent.getPropertyName()) || "modified".equals(propertyChangeEvent.getPropertyName())) {
            // empty if block
        }
    }

    public CharSequence getAbsolutePath() {
        return this.absPath;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CharSequence getUrl() {
        return CndFileSystemProvider.toUrl((FileSystem)this.fileSystem, (CharSequence)this.absPath);
    }

    @Override
    public int[] getLineColumnByOffset(int n) throws IOException {
        return this.getSnapshot().getLineColumnByOffset(n);
    }

    @Override
    public int getOffsetByLineColumn(int n, int n2) throws IOException {
        return this.getSnapshot().getOffsetByLineColumn(n, n2);
    }

    public FileBufferSnapshot getSnapshot() throws IOException {
        FileBufferSnapshot fileBufferSnapshot = this.snapRef.get();
        if (fileBufferSnapshot == null) {
            Document document = this.getDocument();
            try {
                fileBufferSnapshot = document == null ? this.getCharBufferFile(this.getFileObject()) : this.getCharBufferDoc(document);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                fileBufferSnapshot = new FileBufferSnapshot(this.fileSystem, this.absPath, new char[0], new int[0], this.lastModified());
                LOG.log(Level.INFO, null, outOfMemoryError);
                if (document != null) {
                    LOG.log(Level.WARNING, "Can''t create snapshot of {0}, size={1}, url={2}", new Object[]{document, document.getLength(), this.getUrl()});
                }
                LOG.log(Level.WARNING, "Can''t create snapshot of file based {0}", this.getUrl());
            }
            this.snapRef = new SoftReference<FileBufferSnapshot>(fileBufferSnapshot);
        }
        return fileBufferSnapshot;
    }
}

