/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.platform;

import java.io.IOException;
import java.util.EventListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenChange;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.DocumentUtilities;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTFileCacheManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.AbstractFileBuffer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

public class FileBufferDoc
extends AbstractFileBuffer {
    private static final boolean TRACE = false;
    private final Document doc;
    private final EventListenerList listeners = new EventListenerList();
    private DocumentListener docListener;
    private TokenHierarchyListener tokensListener;
    private long lastModified;
    private final ChangedSegment changedSegment;
    private ChangedSegment lastChangedSegment;
    private long changedSegmentTaken;
    private volatile boolean preprocessorBlockChanged = false;

    public FileBufferDoc(FileObject fileObject, Document document) {
        super(fileObject);
        this.doc = document;
        this.changedSegment = new ChangedSegment(document);
        this.resetLastModified();
    }

    private boolean resetLastModified() {
        long l = org.netbeans.lib.editor.util.swing.DocumentUtilities.getDocumentTimestamp((Document)this.doc);
        if (l != this.lastModified) {
            this.lastModified = l;
            this.clearLineCache();
            return true;
        }
        return false;
    }

    private void fireDocumentChanged() {
        if (this.resetLastModified()) {
            EventListener[] eventListenerArray = this.listeners.getListeners(ChangeListener.class);
            if (eventListenerArray.length > 0) {
                ChangeEvent changeEvent = new ChangeEvent(this);
                for (int i = 0; i < eventListenerArray.length; ++i) {
                    ((ChangeListener)eventListenerArray[i]).stateChanged(changeEvent);
                }
            }
            APTDriver.invalidateAPT((APTFileBuffer)this);
            APTFileCacheManager.getInstance((FileSystem)this.getFileSystem()).invalidate(this.getAbsolutePath());
        }
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        if (this.listeners.getListenerCount() == 0) {
            this.docListener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    FileBufferDoc.this.changedSegment.addSegment(documentEvent.getOffset(), documentEvent.getLength());
                    FileBufferDoc.this.fireDocumentChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    FileBufferDoc.this.changedSegment.removeSegment(documentEvent.getOffset(), documentEvent.getLength());
                    FileBufferDoc.this.fireDocumentChanged();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                }
            };
            this.doc.addDocumentListener(this.docListener);
            final TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.doc);
            if (tokenHierarchy != null) {
                this.tokensListener = new TokenHierarchyListener(){

                    public void tokenHierarchyChanged(TokenHierarchyEvent tokenHierarchyEvent) {
                        FileBufferDoc.this.preprocessorBlockChanged = (byte)(FileBufferDoc.this.preprocessorBlockChanged | (FileBufferDoc.checkTokensEvent(tokenHierarchyEvent) ? 1 : 0));
                        if (FileBufferDoc.this.preprocessorBlockChanged) {
                            tokenHierarchy.removeTokenHierarchyListener((TokenHierarchyListener)this);
                        }
                    }
                };
                tokenHierarchy.addTokenHierarchyListener(this.tokensListener);
            }
        }
        this.listeners.add(ChangeListener.class, changeListener);
    }

    private static boolean checkTokensEvent(TokenHierarchyEvent tokenHierarchyEvent) {
        int n;
        TokenChange tokenChange = tokenHierarchyEvent.tokenChange();
        if (tokenChange == null) {
            return false;
        }
        TokenSequence tokenSequence = tokenChange.removedTokenSequence();
        if (tokenSequence != null && !tokenSequence.isEmpty()) {
            while (tokenSequence.moveNext()) {
                Token token = tokenSequence.token();
                if (CppTokenId.PREPROCESSOR_DIRECTIVE != token.id()) continue;
                return true;
            }
        }
        if ((n = tokenChange.index()) >= 0) {
            TokenSequence tokenSequence2 = tokenChange.currentTokenSequence();
            tokenSequence2.moveIndex(n++);
            if (tokenSequence2.moveNext()) {
                Token token = tokenSequence2.token();
                if (tokenChange.isBoundsChange()) {
                    if (CppTokenId.PREPROCESSOR_DIRECTIVE == token.id()) {
                        return true;
                    }
                } else {
                    int n2 = tokenChange.addedTokenCount();
                    while (n2-- > 0) {
                        tokenSequence2.moveIndex(n++);
                        if (!tokenSequence2.moveNext() || CppTokenId.PREPROCESSOR_DIRECTIVE != (token = tokenSequence2.token()).id()) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(ChangeListener.class, changeListener);
        if (this.listeners.getListenerCount() == 0) {
            this.doc.removeDocumentListener(this.docListener);
            this.docListener = null;
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.doc);
            if (tokenHierarchy != null && this.tokensListener != null) {
                tokenHierarchy.removeTokenHierarchyListener(this.tokensListener);
            }
            this.tokensListener = null;
        }
    }

    private IOException convert(BadLocationException badLocationException) {
        IOException iOException = new IOException(badLocationException.getMessage());
        iOException.setStackTrace(badLocationException.getStackTrace());
        return iOException;
    }

    @Override
    public CharSequence getText() throws IOException {
        final String[] stringArray = new String[]{null};
        final BadLocationException[] badLocationExceptionArray = new BadLocationException[]{null};
        this.doc.render(new Runnable(){

            @Override
            public void run() {
                try {
                    stringArray[0] = FileBufferDoc.this.doc.getText(0, FileBufferDoc.this.doc.getLength());
                }
                catch (BadLocationException badLocationException) {
                    badLocationExceptionArray[0] = badLocationException;
                }
            }
        });
        if (badLocationExceptionArray[0] != null) {
            throw this.convert(badLocationExceptionArray[0]);
        }
        return stringArray[0];
    }

    @Override
    public String getText(int n, int n2) throws IOException {
        try {
            return this.doc.getText(n, n2 - n);
        }
        catch (BadLocationException badLocationException) {
            throw this.convert(badLocationException);
        }
    }

    @Override
    public boolean isFileBased() {
        return false;
    }

    @Override
    public long lastModified() {
        return this.lastModified;
    }

    public ChangedSegment getLastChangedSegment() {
        return this.lastChangedSegment;
    }

    public char[] getCharBuffer() throws IOException {
        final Object[] objectArray = new Object[]{null, null};
        this.doc.render(new Runnable(){

            @Override
            public void run() {
                try {
                    int n = FileBufferDoc.this.doc.getLength();
                    char[] cArray = new char[n];
                    DocumentUtilities.copyText((Document)FileBufferDoc.this.doc, (int)0, (int)n, (char[])cArray, (int)0);
                    objectArray[0] = cArray;
                }
                catch (BadLocationException badLocationException) {
                    objectArray[1] = badLocationException;
                }
            }
        });
        if (objectArray[1] != null) {
            throw this.convert((BadLocationException)objectArray[1]);
        }
        return (char[])objectArray[0];
    }

    public static final class ChangedSegment {
        private int begUnchangedEnd;
        private int endUnchangedStart = -1;
        private int endUnchangedEnd = -1;

        public int[] begUnchanged() {
            return new int[]{0, this.begUnchangedEnd};
        }

        public int[] endUnchanged() {
            return new int[]{this.endUnchangedStart, this.endUnchangedEnd};
        }

        private ChangedSegment(ChangedSegment changedSegment) {
            this.begUnchangedEnd = changedSegment.begUnchangedEnd;
            this.endUnchangedStart = changedSegment.endUnchangedStart;
            this.endUnchangedEnd = changedSegment.endUnchangedEnd;
        }

        private ChangedSegment(Document document) {
            this.begUnchangedEnd = document.getLength();
        }

        private void reset(Document document) {
            this.begUnchangedEnd = document.getLength();
            this.endUnchangedStart = -1;
            this.endUnchangedEnd = -1;
        }

        private void addSegment(int n, int n2) {
            if (this.endUnchangedStart == -1) {
                this.endUnchangedStart = n + n2;
                this.endUnchangedEnd = this.begUnchangedEnd + n2;
                this.begUnchangedEnd = n;
            } else if (this.begUnchangedEnd <= n) {
                if (this.endUnchangedStart >= n) {
                    this.endUnchangedStart += n2;
                    this.endUnchangedEnd += n2;
                } else {
                    this.endUnchangedStart = n + n2;
                    this.endUnchangedEnd += n2;
                }
            } else {
                this.begUnchangedEnd = n;
                this.endUnchangedStart += n2;
                this.endUnchangedEnd += n2;
            }
        }

        private void removeSegment(int n, int n2) {
            if (this.endUnchangedStart == -1) {
                this.endUnchangedStart = n;
                this.endUnchangedEnd = this.begUnchangedEnd - n2;
                this.begUnchangedEnd = n;
            } else if (this.begUnchangedEnd <= n) {
                if (this.endUnchangedStart >= n) {
                    this.endUnchangedStart -= n2;
                    if (this.endUnchangedStart < n) {
                        this.endUnchangedStart = n;
                    }
                    this.endUnchangedEnd -= n2;
                } else {
                    this.endUnchangedStart = n + n2;
                    this.endUnchangedEnd -= n2;
                }
            } else {
                this.begUnchangedEnd = n;
                this.endUnchangedStart -= n2;
                if (this.endUnchangedStart < n) {
                    this.endUnchangedStart = n;
                }
                this.endUnchangedEnd -= n2;
            }
        }

        public String toString() {
            if (this.endUnchangedStart == -1) {
                return "No changes";
            }
            return "Start unchanged=[0," + this.begUnchangedEnd + ") End unhanged=[" + this.endUnchangedStart + "," + this.endUnchangedEnd + ")";
        }
    }
}

