/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmUsingDeclaration;
import org.netbeans.modules.cnd.api.model.CsmUsingDirective;
import org.netbeans.modules.cnd.api.model.deep.CsmDeclarationStatement;
import org.netbeans.modules.cnd.api.model.services.CsmClassifierResolver;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.services.CsmUsingResolver;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.modelimpl.csm.ForwardClass;
import org.netbeans.modules.cnd.modelimpl.csm.InheritanceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Unresolved;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.Context;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.Resolver;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.ResolverFactory;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.impl.services.BaseUtilitiesProviderImpl;
import org.netbeans.modules.cnd.modelutil.AntiLoop;
import org.openide.util.CharSequences;

public final class Resolver3
implements Resolver {
    private final ProjectBase project;
    private final CsmFile file;
    private final CsmFile startFile;
    private final int origOffset;
    private Resolver parentResolver;
    private final List<CharSequence> usedNamespaces = new ArrayList<CharSequence>();
    private final Map<CharSequence, CsmNamespace> namespaceAliases = new HashMap<CharSequence, CsmNamespace>();
    private final Map<CharSequence, CsmDeclaration> usingDeclarations = new HashMap<CharSequence, CsmDeclaration>();
    private final Map<CharSequence, CsmClassifier> currUsedClassifiers = new HashMap<CharSequence, CsmClassifier>();
    private CsmTypedef currTypedef;
    private CsmClassifier currLocalClassifier;
    private boolean currDone = false;
    private CharSequence[] names;
    private int currNamIdx;
    private int interestedKind;
    private boolean resolveInBaseClass;
    private final Context context;
    private Set<CsmFile> visitedFiles = new HashSet<CsmFile>();
    private static final CsmSelect.CsmFilter NO_FILTER = CsmSelect.getFilterBuilder().createOffsetFilter(0, Integer.MAX_VALUE);
    private static final CsmSelect.CsmFilter NAMESPACE_FILTER = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.NAMESPACE_DEFINITION, CsmDeclaration.Kind.NAMESPACE_ALIAS, CsmDeclaration.Kind.USING_DECLARATION, CsmDeclaration.Kind.USING_DIRECTIVE});
    private static final CsmSelect.CsmFilter CLASS_FILTER = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.NAMESPACE_DEFINITION, CsmDeclaration.Kind.NAMESPACE_ALIAS, CsmDeclaration.Kind.USING_DECLARATION, CsmDeclaration.Kind.USING_DIRECTIVE, CsmDeclaration.Kind.TYPEDEF, CsmDeclaration.Kind.CLASS, CsmDeclaration.Kind.ENUM, CsmDeclaration.Kind.STRUCT, CsmDeclaration.Kind.UNION});

    private CharSequence currName() {
        return this.names != null && this.currNamIdx < this.names.length ? this.names[this.currNamIdx] : CharSequences.empty();
    }

    Resolver3(CsmFile csmFile, int n, Resolver resolver, CsmFile csmFile2) {
        this.file = csmFile;
        this.origOffset = n;
        this.parentResolver = resolver;
        this.project = (ProjectBase)csmFile.getProject();
        this.startFile = csmFile2;
        this.context = new Context(csmFile, this.origOffset, this);
    }

    private Resolver3(CsmFile csmFile, int n, Resolver resolver) {
        this(csmFile, n, resolver, resolver == null ? csmFile : resolver.getStartFile());
    }

    private CsmClassifier findClassifier(CsmNamespace csmNamespace, CharSequence charSequence) {
        CsmClassifier csmClassifier = null;
        while (csmNamespace != null && csmClassifier == null) {
            String string = csmNamespace.getQualifiedName() + "::" + charSequence;
            csmClassifier = this.findClassifierUsedInFile(string);
            csmNamespace = csmNamespace.getParent();
        }
        return csmClassifier;
    }

    private CsmClassifier findClassifierUsedInFile(CharSequence charSequence) {
        CsmClassifier csmClassifier = null;
        if (!this.currDone) {
            this.currTypedef = null;
            this.currLocalClassifier = null;
            this.gatherMaps(this.file, false, this.origOffset);
            this.currDone = true;
        }
        if (this.currLocalClassifier != null && this.needClassifiers()) {
            csmClassifier = this.currLocalClassifier;
        }
        if (this.currTypedef != null && this.needClassifiers()) {
            csmClassifier = this.currTypedef;
        }
        if (csmClassifier == null) {
            CharSequence charSequence2 = CharSequences.create((CharSequence)charSequence);
            if (this.currUsedClassifiers.containsKey(charSequence2)) {
                csmClassifier = this.currUsedClassifiers.get(charSequence2);
            } else {
                csmClassifier = CsmClassifierResolver.getDefault().findClassifierUsedInFile(charSequence2, this.getStartFile(), this.needClasses());
                this.currUsedClassifiers.put(charSequence2, csmClassifier);
            }
        }
        return csmClassifier;
    }

    @Override
    public CsmFile getStartFile() {
        return this.startFile;
    }

    private CsmNamespace findNamespace(CsmNamespace csmNamespace, CharSequence charSequence) {
        CsmNamespace csmNamespace2 = null;
        if (csmNamespace == null) {
            csmNamespace2 = this.findNamespace(charSequence);
        } else {
            for (CsmNamespace csmNamespace3 = csmNamespace; csmNamespace3 != null && csmNamespace2 == null; csmNamespace3 = csmNamespace3.getParent()) {
                String string = (csmNamespace3.isGlobal() ? "" : csmNamespace3.getQualifiedName() + "::") + charSequence;
                csmNamespace2 = this.findNamespace(string);
            }
        }
        return csmNamespace2;
    }

    private CsmNamespace findNamespace(CharSequence charSequence) {
        CsmNamespace csmNamespace = this.project.findNamespace(charSequence);
        if (csmNamespace == null) {
            Iterator<CsmProject> iterator = this.getLibraries().iterator();
            while (iterator.hasNext() && csmNamespace == null) {
                CsmProject csmProject = iterator.next();
                csmNamespace = csmProject.findNamespace(charSequence);
            }
        }
        return csmNamespace;
    }

    @Override
    public Collection<CsmProject> getLibraries() {
        return Resolver3.getSearchLibraries(this.startFile.getProject());
    }

    public static Collection<CsmProject> getSearchLibraries(CsmProject csmProject) {
        if (csmProject.isArtificial() && csmProject instanceof ProjectBase) {
            List<ProjectBase> list = ((ProjectBase)csmProject).getDependentProjects();
            HashSet<CsmProject> hashSet = new HashSet<CsmProject>();
            for (ProjectBase projectBase : list) {
                if (projectBase.isArtificial()) continue;
                hashSet.addAll(projectBase.getLibraries());
            }
            return hashSet;
        }
        return csmProject.getLibraries();
    }

    @Override
    public CsmClassifier getOriginalClassifier(CsmClassifier csmClassifier) {
        if (this.isRecursionOnResolving(200)) {
            return null;
        }
        AntiLoop antiLoop = new AntiLoop(100);
        while (true) {
            CsmClassForwardDeclaration csmClassForwardDeclaration;
            antiLoop.add(csmClassifier);
            CsmClass csmClass = null;
            if (CsmKindUtilities.isClassForwardDeclaration((CsmObject)csmClassifier)) {
                csmClassForwardDeclaration = (CsmClassForwardDeclaration)csmClassifier;
                csmClass = csmClassForwardDeclaration.getCsmClass();
                if (csmClass == null) {
                    break;
                }
            } else if (CsmKindUtilities.isTypedef((CsmObject)csmClassifier)) {
                csmClassForwardDeclaration = ((CsmTypedef)csmClassifier).getType();
                csmClass = csmClassForwardDeclaration.getClassifier();
                if (csmClass == null) {
                    break;
                }
            } else {
                if (!ForwardClass.isForwardClass((CsmDeclaration)csmClassifier)) break;
                csmClass = this.findClassifierUsedInFile(csmClassifier.getQualifiedName());
            }
            if (antiLoop.contains((CsmClassifier)csmClass) && ((csmClass = this.findOtherClassifier(csmClassifier)) == null || antiLoop.contains((CsmClassifier)csmClass))) break;
            csmClassifier = csmClass;
        }
        return csmClassifier;
    }

    private CsmClassifier findOtherClassifier(CsmClassifier csmClassifier) {
        CsmClassifier csmClassifier2;
        block1: {
            CsmOffsetableDeclaration csmOffsetableDeclaration;
            CsmNamespace csmNamespace = BaseUtilitiesProviderImpl.getImpl()._getClassNamespace(csmClassifier);
            csmClassifier2 = null;
            if (csmNamespace == null) break block1;
            CsmUID csmUID = UIDs.get((Object)csmClassifier);
            CharSequence charSequence = csmClassifier.getQualifiedName();
            Collection<CsmOffsetableDeclaration> collection = null;
            collection = csmNamespace instanceof NamespaceImpl ? ((NamespaceImpl)csmNamespace).getDeclarationsRange(charSequence, new CsmDeclaration.Kind[]{CsmDeclaration.Kind.CLASS, CsmDeclaration.Kind.UNION, CsmDeclaration.Kind.STRUCT, CsmDeclaration.Kind.ENUM, CsmDeclaration.Kind.TYPEDEF, CsmDeclaration.Kind.TEMPLATE_DECLARATION, CsmDeclaration.Kind.TEMPLATE_SPECIALIZATION, CsmDeclaration.Kind.CLASS_FORWARD_DECLARATION}) : csmNamespace.getDeclarations();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext() && (!CsmKindUtilities.isClassifier((CsmObject)(csmOffsetableDeclaration = (CsmOffsetableDeclaration)iterator.next())) || !csmOffsetableDeclaration.getQualifiedName().equals(charSequence) || UIDs.get((Object)csmOffsetableDeclaration).equals(csmUID) || ForwardClass.isForwardClass((CsmDeclaration)(csmClassifier2 = (CsmClassifier)csmOffsetableDeclaration)))) {
            }
        }
        return csmClassifier2;
    }

    @Override
    public boolean isRecursionOnResolving(int n) {
        Resolver3 resolver3 = (Resolver3)this.parentResolver;
        int n2 = 0;
        while (resolver3 != null) {
            if (resolver3.origOffset == this.origOffset && resolver3.file.equals(this.file)) {
                return true;
            }
            resolver3 = (Resolver3)resolver3.parentResolver;
            if (++n2 <= n) continue;
            return true;
        }
        return false;
    }

    private CsmObject resolveInUsings(CsmNamespace csmNamespace, CharSequence charSequence) {
        Object object;
        Object object2;
        if (this.isRecursionOnResolving(200)) {
            return null;
        }
        CsmClassifier csmClassifier = null;
        CsmUsingResolver csmUsingResolver = CsmUsingResolver.getDefault().findUsingDirectives(csmNamespace).iterator();
        while (csmUsingResolver.hasNext() && (csmClassifier = this.findClassifierUsedInFile((CharSequence)(object2 = (object = (CsmUsingDirective)csmUsingResolver.next()).getName() + "::" + charSequence))) == null) {
        }
        if (csmClassifier == null) {
            csmUsingResolver = CsmUsingResolver.getDefault();
            object = null;
            object = csmUsingResolver.findUsedDeclarations(csmNamespace);
            object2 = object.iterator();
            while (object2.hasNext()) {
                CsmDeclaration csmDeclaration = (CsmDeclaration)object2.next();
                if (CharSequences.comparator().compare(charSequence, csmDeclaration.getName()) != 0) continue;
                if (CsmKindUtilities.isClassifier((CsmObject)csmDeclaration) && this.needClassifiers()) {
                    csmClassifier = csmDeclaration;
                    break;
                }
                if (!CsmKindUtilities.isClass((CsmObject)csmDeclaration) || !this.needClasses()) continue;
                csmClassifier = csmDeclaration;
                break;
            }
        }
        return csmClassifier;
    }

    void traceRecursion() {
        System.out.println("Detected recursion in resolver:");
        System.out.println("\t" + this);
        Resolver3 resolver3 = (Resolver3)this.parentResolver;
        while (resolver3 != null) {
            System.out.println("\t" + resolver3);
            resolver3 = (Resolver3)resolver3.parentResolver;
        }
        new Exception().printStackTrace();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.file.getAbsolutePath()).append(":").append(this.origOffset);
        stringBuilder.append(":Looking for ");
        if (this.needClassifiers()) {
            if (this.needClasses()) {
                stringBuilder.append("c");
            } else {
                stringBuilder.append("C");
            }
        }
        if (this.needNamespaces()) {
            stringBuilder.append("N");
        }
        stringBuilder.append(":").append(this.currName());
        for (int i = 0; i < this.names.length; ++i) {
            if (i == 0) {
                stringBuilder.append("?");
            } else {
                stringBuilder.append("::");
            }
            stringBuilder.append(this.names[i]);
        }
        if (this.context.getContainingClass() != null) {
            stringBuilder.append(":Class=").append(this.context.getContainingClass().getName());
        }
        if (this.context.getContainingNamespace() != null) {
            stringBuilder.append(":NS=").append(this.context.getContainingNamespace().getName());
        }
        return stringBuilder.toString();
    }

    private void gatherMaps(CsmFile csmFile, boolean bl, int n) {
        if (csmFile == null || this.visitedFiles.contains(csmFile)) {
            return;
        }
        this.visitedFiles.add(csmFile);
        CsmSelect.CsmFilter csmFilter = n == Integer.MAX_VALUE ? NO_FILTER : CsmSelect.getFilterBuilder().createOffsetFilter(0, n);
        if (bl) {
            Iterator iterator = CsmSelect.getIncludes((CsmFile)csmFile, (CsmSelect.CsmFilter)csmFilter);
            while (iterator.hasNext()) {
                CsmInclude csmInclude = (CsmInclude)iterator.next();
                CsmFile csmFile2 = csmInclude.getIncludeFile();
                if (csmFile2 == null) continue;
                this.gatherMaps(csmFile2, true, Integer.MAX_VALUE);
            }
        }
        if (n == Integer.MAX_VALUE) {
            csmFilter = this.needClassifiers() ? CLASS_FILTER : NAMESPACE_FILTER;
        }
        this.gatherMaps(CsmSelect.getDeclarations((CsmFile)csmFile, (CsmSelect.CsmFilter)csmFilter), false, n);
        if (!bl) {
            this.visitedFiles.remove(csmFile);
        }
    }

    private void gatherMaps(Iterable<? extends CsmObject> iterable, boolean bl, int n) {
        this.gatherMaps(iterable.iterator(), bl, n);
    }

    private void gatherMaps(Iterator<? extends CsmObject> iterator, boolean bl, int n) {
        while (iterator.hasNext()) {
            CsmObject csmObject = iterator.next();
            assert (csmObject instanceof CsmOffsetable);
            try {
                int n2 = ((CsmOffsetable)csmObject).getStartOffset();
                int n3 = ((CsmOffsetable)csmObject).getEndOffset();
                if (n2 >= n) break;
                if (csmObject instanceof CsmScopeElement) {
                    if (!bl && CsmKindUtilities.isFunctionDefinition((CsmObject)csmObject)) {
                        this.gatherMaps((CsmScopeElement)csmObject, n3, true, n);
                        continue;
                    }
                    this.gatherMaps((CsmScopeElement)csmObject, n3, bl, n);
                    continue;
                }
                if (!FileImpl.reportErrors) continue;
                System.err.println("Expected CsmScopeElement, got " + csmObject);
            }
            catch (NullPointerException nullPointerException) {
                if (!FileImpl.reportErrors) continue;
                System.err.println("Unexpected NULL element in declarations collection");
                DiagnosticExceptoins.register(nullPointerException);
            }
        }
    }

    private CsmClassifier findNestedClassifier(CsmClassifier csmClassifier) {
        if (CsmKindUtilities.isClass((CsmObject)csmClassifier)) {
            Iterator iterator = CsmSelect.getClassMembers((CsmClass)((CsmClass)csmClassifier), (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createNameFilter(this.currName(), true, true, false));
            while (iterator.hasNext()) {
                CsmMember csmMember = (CsmMember)iterator.next();
                if (CharSequences.comparator().compare(this.currName(), csmMember.getName()) != 0 || !CsmKindUtilities.isClassifier((CsmObject)csmMember)) continue;
                return (CsmClassifier)csmMember;
            }
        }
        return null;
    }

    private void doProcessTypedefsInUpperNamespaces(CsmNamespaceDefinition csmNamespaceDefinition) {
        CsmSelect.CsmFilter csmFilter = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.NAMESPACE_DEFINITION, CsmDeclaration.Kind.TYPEDEF});
        Iterator iterator = CsmSelect.getDeclarations((CsmNamespaceDefinition)csmNamespaceDefinition, (CsmSelect.CsmFilter)csmFilter);
        while (iterator.hasNext()) {
            CsmOffsetableDeclaration csmOffsetableDeclaration = (CsmOffsetableDeclaration)iterator.next();
            if (csmOffsetableDeclaration.getKind() == CsmDeclaration.Kind.NAMESPACE_DEFINITION) {
                this.processTypedefsInUpperNamespaces((CsmNamespaceDefinition)csmOffsetableDeclaration);
                continue;
            }
            if (csmOffsetableDeclaration.getKind() != CsmDeclaration.Kind.TYPEDEF) continue;
            CsmTypedef csmTypedef = (CsmTypedef)csmOffsetableDeclaration;
            if (CharSequences.comparator().compare(this.currName(), csmTypedef.getName()) != 0) continue;
            this.currTypedef = csmTypedef;
        }
    }

    private void processTypedefsInUpperNamespaces(CsmNamespaceDefinition csmNamespaceDefinition) {
        if (CharSequences.comparator().compare(csmNamespaceDefinition.getName(), this.currName()) == 0) {
            ++this.currNamIdx;
            this.doProcessTypedefsInUpperNamespaces(csmNamespaceDefinition);
        } else {
            CsmNamespace csmNamespace = this.context.getContainingNamespace();
            if (csmNamespace != null && csmNamespace.equals(csmNamespaceDefinition.getNamespace())) {
                this.doProcessTypedefsInUpperNamespaces(csmNamespaceDefinition);
            }
        }
    }

    private void gatherMaps(CsmScopeElement csmScopeElement, int n, boolean bl, int n2) {
        CsmDeclaration.Kind kind;
        CsmDeclaration.Kind kind2 = kind = csmScopeElement instanceof CsmDeclaration ? ((CsmDeclaration)csmScopeElement).getKind() : null;
        if (kind == CsmDeclaration.Kind.NAMESPACE_DEFINITION) {
            CsmNamespaceDefinition csmNamespaceDefinition = (CsmNamespaceDefinition)csmScopeElement;
            if (csmNamespaceDefinition.getName().length() == 0) {
                this.usedNamespaces.add(csmNamespaceDefinition.getQualifiedName());
            }
            if (n2 < n || this.isInContext((CsmScope)csmNamespaceDefinition)) {
                this.gatherMaps(csmNamespaceDefinition.getDeclarations(), bl, n2);
            } else if (this.needClassifiers()) {
                this.processTypedefsInUpperNamespaces(csmNamespaceDefinition);
            }
        } else if (kind == CsmDeclaration.Kind.NAMESPACE_ALIAS) {
            CsmNamespaceAlias csmNamespaceAlias = (CsmNamespaceAlias)csmScopeElement;
            this.namespaceAliases.put(csmNamespaceAlias.getAlias(), csmNamespaceAlias.getReferencedNamespace());
        } else if (kind == CsmDeclaration.Kind.USING_DECLARATION) {
            CsmDeclaration csmDeclaration = this.resolveUsingDeclaration((CsmUsingDeclaration)csmScopeElement);
            if (csmDeclaration != null) {
                CharSequence charSequence = csmDeclaration.getKind() == CsmDeclaration.Kind.FUNCTION || csmDeclaration.getKind() == CsmDeclaration.Kind.FUNCTION_DEFINITION || csmDeclaration.getKind() == CsmDeclaration.Kind.FUNCTION_FRIEND || csmDeclaration.getKind() == CsmDeclaration.Kind.FUNCTION_FRIEND ? ((CsmFunction)csmDeclaration).getSignature() : csmDeclaration.getName();
                this.usingDeclarations.put(charSequence, csmDeclaration);
            }
        } else if (kind == CsmDeclaration.Kind.USING_DIRECTIVE) {
            CsmUsingDirective csmUsingDirective = (CsmUsingDirective)csmScopeElement;
            CharSequence charSequence = csmUsingDirective.getName();
            if (!this.usedNamespaces.contains(charSequence)) {
                this.usedNamespaces.add(charSequence);
            }
        } else if (csmScopeElement instanceof CsmDeclarationStatement) {
            CsmDeclarationStatement csmDeclarationStatement = (CsmDeclarationStatement)csmScopeElement;
            if (csmDeclarationStatement.getStartOffset() < n2) {
                this.gatherMaps(((CsmDeclarationStatement)csmScopeElement).getDeclarators(), bl, n2);
            }
        } else if (CsmKindUtilities.isScope((CsmObject)csmScopeElement)) {
            if (bl && this.needClassifiers() && CsmKindUtilities.isClassifier((CsmObject)csmScopeElement) && (!CsmKindUtilities.isClassForwardDeclaration((CsmObject)csmScopeElement) || n2 > n) && CharSequences.comparator().compare(this.currName(), ((CsmClassifier)csmScopeElement).getName()) == 0) {
                this.currLocalClassifier = (CsmClassifier)csmScopeElement;
            }
            if (n2 < n || this.isInContext((CsmScope)csmScopeElement)) {
                this.gatherMaps(((CsmScope)csmScopeElement).getScopeElements(), bl, n2);
            }
        } else if (kind == CsmDeclaration.Kind.TYPEDEF && this.needClassifiers()) {
            CsmTypedef csmTypedef = (CsmTypedef)csmScopeElement;
            if (n2 > n && CharSequences.comparator().compare(this.currName(), csmTypedef.getName()) == 0) {
                this.currTypedef = csmTypedef;
            }
        }
    }

    private boolean isInContext(CsmScope csmScope) {
        if (!CsmKindUtilities.isClass((CsmObject)csmScope) && !CsmKindUtilities.isNamespace((Object)csmScope)) {
            return false;
        }
        CsmQualifiedNamedElement csmQualifiedNamedElement = (CsmQualifiedNamedElement)csmScope;
        CsmNamespace csmNamespace = this.context.getContainingNamespace();
        if (csmNamespace != null && this.startsWith(csmNamespace.getQualifiedName(), csmQualifiedNamedElement.getQualifiedName())) {
            return true;
        }
        CsmClass csmClass = this.context.getContainingClass();
        return csmClass != null && this.startsWith(csmClass.getQualifiedName(), csmQualifiedNamedElement.getQualifiedName());
    }

    private boolean startsWith(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence.length() < charSequence2.length()) {
            return false;
        }
        for (int i = 0; i < charSequence2.length(); ++i) {
            if (charSequence.charAt(i) == charSequence2.charAt(i)) continue;
            return false;
        }
        return charSequence.length() == charSequence2.length() || charSequence.charAt(charSequence2.length()) == ':';
    }

    private CsmDeclaration resolveUsingDeclaration(CsmUsingDeclaration csmUsingDeclaration) {
        if (this.isRecursionOnResolving(5)) {
            return null;
        }
        return csmUsingDeclaration.getReferencedDeclaration();
    }

    @Override
    public CsmObject resolve(CharSequence[] charSequenceArray, int n) {
        CsmObject csmObject = null;
        this.names = charSequenceArray;
        this.currNamIdx = 0;
        this.interestedKind = n;
        if (charSequenceArray.length == 1) {
            csmObject = this.resolveSimpleName(csmObject, charSequenceArray[0], n);
        } else if (charSequenceArray.length > 1) {
            csmObject = this.resolveCompoundName(charSequenceArray, csmObject, n);
        }
        return csmObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CsmObject resolveSimpleName(CsmObject object, CharSequence charSequence, int n) {
        Object object2;
        CsmNamespace csmNamespace = null;
        if (object == null && this.needClassifiers() && (object = this.resolveInClass((CsmClass)(object2 = this.context.getContainingClass()), charSequence)) == null && (this.parentResolver == null || !((Resolver3)this.parentResolver).resolveInBaseClass)) {
            object = this.resolveInBaseClasses((CsmClass)object2, charSequence);
            if (this.needTemplateClassesOnly() && !CsmKindUtilities.isTemplate((CsmObject)object)) {
                object = null;
            }
        }
        if (object == null && this.needClassifiers() && (object = this.findClassifier(csmNamespace = this.context.getContainingNamespace(), charSequence)) == null && csmNamespace != null) {
            object = this.resolveInUsings(csmNamespace, charSequence);
        }
        if (object == null && this.needNamespaces()) {
            csmNamespace = this.context.getContainingNamespace();
            object = this.findNamespace(csmNamespace, charSequence);
        }
        if (object == null && this.needClassifiers()) {
            object = this.findClassifierUsedInFile(charSequence);
            if (this.needTemplateClassesOnly() && !CsmKindUtilities.isTemplate((CsmObject)object)) {
                object = null;
            }
        }
        if (object == null) {
            String string;
            String string2;
            this.gatherMaps(this.file, true, this.origOffset);
            if (this.currLocalClassifier != null && this.needClassifiers()) {
                object = this.currLocalClassifier;
            }
            if (this.currTypedef != null && this.needClassifiers()) {
                object = this.currTypedef;
            }
            if (object == null && (object2 = this.usingDeclarations.get(CharSequences.create((CharSequence)charSequence))) != null) {
                object = object2;
            }
            if (object == null && this.needClassifiers()) {
                object2 = this.usedNamespaces.iterator();
                while (object2.hasNext()) {
                    CsmNamespace csmNamespace2;
                    string2 = ((Object)((CharSequence)object2.next())).toString();
                    string = string2 + "::" + charSequence;
                    object = this.findClassifierUsedInFile(string);
                    if (object == null) {
                        object = this.findClassifier(csmNamespace, string);
                    }
                    if (object == null && (csmNamespace2 = this.findNamespace(string2)) != null) {
                        object = this.resolveInUsings(csmNamespace2, charSequence);
                    }
                    if (object == null) continue;
                    break;
                }
            }
            if (object == null && this.needNamespaces() && (object2 = this.namespaceAliases.get(CharSequences.create((CharSequence)charSequence))) instanceof CsmNamespace) {
                object = (CsmNamespace)object2;
            }
            if (object == null && this.needNamespaces()) {
                object2 = this.usedNamespaces.iterator();
                while (object2.hasNext() && (object = this.findNamespace(string = (string2 = ((Object)((CharSequence)object2.next())).toString()) + "::" + charSequence)) == null) {
                }
            }
        }
        if (object == null && TemplateUtils.isTemplateQualifiedName(((Object)charSequence).toString())) {
            object2 = ResolverFactory.createResolver(this.file, this.origOffset);
            try {
                object = object2.resolve(Utils.splitQualifiedName(TemplateUtils.getTemplateQualifiedNameWithoutSiffix(((Object)charSequence).toString())), 8);
            }
            finally {
                ResolverFactory.releaseResolver((Resolver)object2);
            }
        }
        if (this.needTemplateClassesOnly() && !CsmKindUtilities.isTemplate((CsmObject)object)) {
            object = null;
        }
        return object;
    }

    private String fullName(CharSequence[] charSequenceArray) {
        StringBuilder stringBuilder = new StringBuilder(charSequenceArray[0]);
        for (int i = 1; i < charSequenceArray.length; ++i) {
            stringBuilder.append("::");
            stringBuilder.append(charSequenceArray[i]);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CsmObject resolveCompoundName(CharSequence[] charSequenceArray, CsmObject object, int n) {
        Object object2;
        Object object3;
        Object object4;
        CsmNamespace csmNamespace = null;
        String string = this.fullName(charSequenceArray);
        if (this.needClassifiers()) {
            object = this.findClassifierUsedInFile(string);
        }
        if (object == null && this.needClassifiers()) {
            csmNamespace = this.context.getContainingNamespace();
            object = this.findClassifier(csmNamespace, string);
        }
        if (object == null && this.needNamespaces()) {
            csmNamespace = this.context.getContainingNamespace();
            object = this.findNamespace(csmNamespace, string);
        }
        if (object == null && this.needClassifiers()) {
            this.gatherMaps(this.file, true, this.origOffset);
            if (this.currTypedef != null && (object4 = this.currTypedef.getType()) != null) {
                object3 = this.getTypeClassifier((CsmType)object4);
                while (this.currNamIdx < this.names.length - 1 && object3 != null) {
                    ++this.currNamIdx;
                    if (!CsmKindUtilities.isTypedef((CsmObject)(object3 = this.findNestedClassifier((CsmClassifier)object3)))) continue;
                    object2 = ((CsmTypedef)object3).getType();
                    object3 = object2 == null ? null : this.getTypeClassifier((CsmType)object2);
                }
                if (this.currNamIdx == this.names.length - 1) {
                    object = object3;
                }
            }
            if (object == null) {
                object4 = this.usedNamespaces.iterator();
                while (object4.hasNext() && (object = this.findClassifierUsedInFile((CharSequence)(object2 = (String)(object3 = ((Object)((CharSequence)object4.next())).toString()) + "::" + string))) == null) {
                }
            }
            if (object == null) {
                object4 = null;
                object3 = ResolverFactory.createResolver(this.file, this.origOffset);
                try {
                    object4 = object3.resolve(Utils.splitQualifiedName(((Object)charSequenceArray[0]).toString()), 1);
                }
                finally {
                    ResolverFactory.releaseResolver((Resolver)object3);
                }
                if (object4 != null) {
                    if (object4 instanceof CsmNamespace) {
                        int n2;
                        object2 = (NamespaceImpl)object4;
                        StringBuilder stringBuilder = new StringBuilder(((NamespaceImpl)object2).getQualifiedName());
                        for (n2 = 1; n2 < charSequenceArray.length; ++n2) {
                            stringBuilder.append("::");
                            stringBuilder.append(charSequenceArray[n2]);
                        }
                        object = this.findClassifierUsedInFile(stringBuilder.toString());
                        if (object == null) {
                            stringBuilder = new StringBuilder(charSequenceArray[1]);
                            for (n2 = 2; n2 < charSequenceArray.length; ++n2) {
                                stringBuilder.append("::");
                                stringBuilder.append(charSequenceArray[n2]);
                            }
                            object = this.resolveInUsings((CsmNamespace)object2, stringBuilder.toString());
                        }
                    } else if (object4 instanceof CsmClass) {
                        // empty if block
                    }
                }
            }
        }
        if (object == null && this.needNamespaces()) {
            object4 = null;
            object3 = ResolverFactory.createResolver(this.file, this.origOffset);
            try {
                object4 = object3.resolve(Utils.splitQualifiedName(((Object)charSequenceArray[0]).toString()), 1);
            }
            finally {
                ResolverFactory.releaseResolver((Resolver)object3);
            }
            if (object4 instanceof CsmNamespace) {
                object2 = (CsmNamespace)object4;
                for (int i = 1; i < charSequenceArray.length; ++i) {
                    CsmNamespace csmNamespace2 = null;
                    CharSequence charSequence = charSequenceArray[i];
                    Collection collection = CsmUsingResolver.getDefault().findNamespaceAliases((CsmNamespace)object2);
                    for (Object object5 : collection) {
                        if (!((Object)object5.getAlias()).toString().equals(((Object)charSequence).toString())) continue;
                        csmNamespace2 = object5.getReferencedNamespace();
                        break;
                    }
                    if (csmNamespace2 == null) {
                        Object object5;
                        Collection collection2 = object2.getNestedNamespaces();
                        object5 = collection2.iterator();
                        while (object5.hasNext()) {
                            CsmNamespace csmNamespace3 = (CsmNamespace)object5.next();
                            if (!((Object)csmNamespace3.getName()).toString().equals(((Object)charSequence).toString())) continue;
                            csmNamespace2 = csmNamespace3;
                            break;
                        }
                    }
                    if ((object2 = csmNamespace2) == null) break;
                }
                object = object2;
            }
        }
        if (object == null && TemplateUtils.isTemplateQualifiedName(string.toString())) {
            object4 = new StringBuilder(TemplateUtils.getTemplateQualifiedNameWithoutSiffix(((Object)charSequenceArray[0]).toString()));
            for (int i = 1; i < charSequenceArray.length; ++i) {
                ((StringBuilder)object4).append("::");
                ((StringBuilder)object4).append(TemplateUtils.getTemplateQualifiedNameWithoutSiffix(((Object)charSequenceArray[i]).toString()));
            }
            Resolver resolver = ResolverFactory.createResolver(this.file, this.origOffset);
            try {
                object = resolver.resolve(Utils.splitQualifiedName(((StringBuilder)object4).toString()), n);
            }
            finally {
                ResolverFactory.releaseResolver(resolver);
            }
        }
        return object;
    }

    private CsmClassifier getTypeClassifier(CsmType csmType) {
        if (this.isRecursionOnResolving(200)) {
            return null;
        }
        return csmType.getClassifier();
    }

    private CsmObject resolveInBaseClasses(CsmClass csmClass, CharSequence charSequence) {
        this.resolveInBaseClass = true;
        CsmObject csmObject = this._resolveInBaseClasses(csmClass, charSequence, new HashSet<CharSequence>(), 0);
        this.resolveInBaseClass = false;
        return csmObject;
    }

    private CsmObject _resolveInBaseClasses(CsmClass csmClass, CharSequence charSequence, Set<CharSequence> set, int n) {
        if (n == 50) {
            new Exception("Too many loops in resolver!!!").printStackTrace(System.err);
            return null;
        }
        if (this.isNotNullNotUnresolved(csmClass)) {
            List<CsmClass> list = this.getClassesContainers(csmClass);
            for (CsmClass csmClass2 : list) {
                for (CsmInheritance csmInheritance : csmClass2.getBaseClasses()) {
                    CsmClass csmClass3 = this.getInheritanceClass(csmInheritance);
                    if (csmClass3 == null || set.contains(csmClass3.getQualifiedName())) continue;
                    set.add(csmClass3.getQualifiedName());
                    CsmObject csmObject = this.resolveInClass(csmClass3, charSequence);
                    if (csmObject != null) {
                        return csmObject;
                    }
                    csmObject = this._resolveInBaseClasses(csmClass3, charSequence, set, n + 1);
                    if (csmObject == null) continue;
                    return csmObject;
                }
            }
        }
        return null;
    }

    private CsmClass getInheritanceClass(CsmInheritance csmInheritance) {
        if (csmInheritance instanceof InheritanceImpl) {
            if (this.isRecursionOnResolving(200)) {
                return null;
            }
            CsmClassifier csmClassifier = csmInheritance.getClassifier();
            if (CsmKindUtilities.isClass((CsmObject)(csmClassifier = this.getOriginalClassifier(csmClassifier)))) {
                return (CsmClass)csmClassifier;
            }
        }
        return this.getCsmClass(csmInheritance);
    }

    private CsmClass getCsmClass(CsmInheritance csmInheritance) {
        CsmClassifier csmClassifier = csmInheritance.getClassifier();
        if (CsmKindUtilities.isClass((CsmObject)(csmClassifier = this.getOriginalClassifier(csmClassifier)))) {
            return (CsmClass)csmClassifier;
        }
        return null;
    }

    private boolean isNotNullNotUnresolved(Object object) {
        return object != null && !Unresolved.isUnresolved(object);
    }

    private CsmObject resolveInClass(CsmClass csmClass, CharSequence charSequence) {
        if (this.isNotNullNotUnresolved(csmClass)) {
            List<CsmClass> list = this.getClassesContainers(csmClass);
            for (CsmClass csmClass2 : list) {
                CsmClassifier csmClassifier = null;
                CsmSelect.CsmFilter csmFilter = CsmSelect.getFilterBuilder().createNameFilter(charSequence, true, true, false);
                Iterator iterator = CsmSelect.getClassMembers((CsmClass)csmClass2, (CsmSelect.CsmFilter)csmFilter);
                while (iterator.hasNext()) {
                    CsmMember csmMember = (CsmMember)iterator.next();
                    if (!CsmKindUtilities.isClassifier((CsmObject)csmMember) || CsmKindUtilities.isClassForwardDeclaration((CsmObject)(csmClassifier = (CsmClassifier)csmMember))) continue;
                    return csmClassifier;
                }
                if (csmClassifier == null) continue;
                return csmClassifier;
            }
        }
        return null;
    }

    private List<CsmClass> getClassesContainers(CsmClass csmClass) {
        ArrayList<CsmClass> arrayList = new ArrayList<CsmClass>();
        CsmClass csmClass2 = csmClass;
        while (CsmKindUtilities.isClass((CsmObject)csmClass2)) {
            arrayList.add(csmClass2);
            csmClass2 = csmClass2.getScope();
        }
        return arrayList;
    }

    private boolean needClassifiers() {
        return (this.interestedKind & 2) == 2 || this.needClasses() || this.needTemplateClasses();
    }

    private boolean needNamespaces() {
        return (this.interestedKind & 1) == 1;
    }

    private boolean needClasses() {
        return (this.interestedKind & 4) == 4 || this.needTemplateClasses();
    }

    private boolean needTemplateClasses() {
        return (this.interestedKind & 8) == 8;
    }

    private boolean needTemplateClassesOnly() {
        return this.interestedKind == 8;
    }
}

