/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.LazyOffsPositionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.PositionStorageImpl;
import org.netbeans.modules.cnd.modelimpl.repository.KeyUtilities;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.repository.api.RepositoryAccessor;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.MapBasedTable;

public class PositionManager {
    private static final Impl IMPL = Impl.trivial;
    private static ConcurrentHashMap<Integer, ConcurrentHashMap<Integer, TreeMap<Integer, Integer>>> map = new ConcurrentHashMap();

    private PositionManager() {
    }

    public static CsmOffsetable.Position getPosition(CsmUID<CsmFile> csmUID, int n) {
        CsmFile csmFile = UIDCsmConverter.UIDtoFile(csmUID);
        if (csmFile instanceof FileImpl) {
            return new LazyOffsPositionImpl((FileImpl)csmFile, PositionManager.getOffset(csmUID, n));
        }
        return new PositionImpl(n);
    }

    private static MapBasedTable getPositionTable(Key key) {
        return (MapBasedTable)RepositoryAccessor.getRepository().getDatabaseTable(key, "position");
    }

    public static int getOffset(CsmUID<CsmFile> csmUID, int n) {
        if (IMPL == Impl.trivial) {
            return n;
        }
        Key key = RepositoryUtils.UIDtoKey(csmUID);
        if (IMPL == Impl.optimistic || IMPL == Impl.full) {
            MapBasedTable mapBasedTable = PositionManager.getPositionTable(key);
            PositionStorageImpl.FilePositionKey filePositionKey = new PositionStorageImpl.FilePositionKey(KeyUtilities.getProjectFileIndex(key), n);
            Position position = (Position)mapBasedTable.get((Object)filePositionKey);
            return position.getOffset();
        }
        TreeMap<Integer, Integer> treeMap = PositionManager.getFileMap(key);
        return (Integer)treeMap.get(n);
    }

    public static int createPositionID(CsmUID<CsmFile> csmUID, int n, Position.Bias bias) {
        if (IMPL == Impl.trivial) {
            return n;
        }
        Key key = RepositoryUtils.UIDtoKey(csmUID);
        int n2 = 0;
        if (IMPL == Impl.optimistic || IMPL == Impl.full) {
            Serializable serializable;
            PositionStorageImpl.FilePositionKey filePositionKey;
            MapBasedTable mapBasedTable = PositionManager.getPositionTable(key);
            if (IMPL == Impl.full) {
                filePositionKey = new PositionStorageImpl.FilePositionKey(KeyUtilities.getProjectFileIndex(key), 0);
                serializable = new PositionStorageImpl.FilePositionKey(KeyUtilities.getProjectFileIndex(key), Integer.MAX_VALUE);
                n2 = 0;
                for (Map.Entry entry : mapBasedTable.getSubMap((Object)filePositionKey, (Object)serializable)) {
                    PositionStorageImpl.FilePositionKey filePositionKey2 = (PositionStorageImpl.FilePositionKey)entry.getKey();
                    Position position = (Position)entry.getValue();
                    if (position.getOffset() == n) {
                        return filePositionKey2.getPositionID();
                    }
                    if (n2 >= filePositionKey2.getPositionID()) continue;
                    n2 = filePositionKey2.getPositionID();
                }
                ++n2;
            } else if (IMPL == Impl.optimistic) {
                n2 = n;
            }
            filePositionKey = new PositionStorageImpl.FilePositionKey(KeyUtilities.getProjectFileIndex(key), n2);
            serializable = new PositionStorageImpl.PositionDataImpl(n, -1, -1);
            mapBasedTable.put((Object)filePositionKey, (Object)serializable);
            return n2;
        }
        TreeMap<Integer, Integer> treeMap = PositionManager.getFileMap(key);
        if (treeMap.isEmpty()) {
            n2 = 1;
        } else {
            Integer n3 = treeMap.lastKey();
            n2 = n3 + 1;
        }
        treeMap.put(n2, n);
        return n2;
    }

    private static TreeMap<Integer, Integer> getFileMap(Key key) {
        AbstractMap abstractMap;
        int n = key.getUnitId();
        int n2 = KeyUtilities.getProjectFileIndex(key);
        AbstractMap abstractMap2 = map.get(n);
        if (abstractMap2 == null) {
            abstractMap2 = new ConcurrentHashMap();
            abstractMap = map.putIfAbsent(n, (ConcurrentHashMap<Integer, TreeMap<Integer, Integer>>)abstractMap2);
            if (abstractMap != null) {
                abstractMap2 = abstractMap;
            }
        }
        if ((abstractMap = abstractMap2.get(n2)) == null) {
            abstractMap = new TreeMap();
            TreeMap<Integer, Integer> treeMap = abstractMap2.putIfAbsent(n2, abstractMap);
            if (treeMap != null) {
                abstractMap = treeMap;
            }
        }
        return abstractMap;
    }

    private static class PositionImpl
    implements CsmOffsetable.Position {
        private final int offset;

        public PositionImpl(int n) {
            this.offset = n;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLine() {
            return -1;
        }

        public int getColumn() {
            return -1;
        }

        public String toString() {
            return "offset=" + this.offset;
        }
    }

    public static interface Position {
        public int getOffset();

        public int getLine();

        public int getColumn();

        public static enum Bias {
            FOWARD,
            BACKWARD;

        }
    }

    private static enum Impl {
        trivial,
        optimistic,
        full,
        map;

    }
}

