/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectItemsListener;
import org.netbeans.modules.cnd.modelimpl.csm.core.LibraryManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectImpl;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

class NativeProjectListenerImpl
implements NativeProjectItemsListener {
    private static final boolean TRACE = false;
    private final ModelImpl model;
    private final NativeProject nativeProject;
    private final ProjectBase projectBase;
    private volatile boolean enabledEventsHandling = true;

    public NativeProjectListenerImpl(ModelImpl modelImpl, NativeProject nativeProject, ProjectBase projectBase) {
        this.model = modelImpl;
        this.nativeProject = nativeProject;
        this.projectBase = projectBase;
    }

    public void fileAdded(NativeFileItem nativeFileItem) {
        this.onProjectItemAdded(nativeFileItem);
    }

    public void filesAdded(List<NativeFileItem> list) {
        for (List<NativeFileItem> list2 : this.divideByProjects(list)) {
            this.onProjectItemAdded(list2);
        }
    }

    public void fileRemoved(NativeFileItem nativeFileItem) {
        this.onProjectItemRemoved(nativeFileItem);
    }

    public void filesRemoved(List<NativeFileItem> list) {
        for (List<NativeFileItem> list2 : this.divideByProjects(list)) {
            this.onProjectItemRemoved(list2);
        }
    }

    public void fileRenamed(String string, NativeFileItem nativeFileItem) {
        this.onProjectItemRenamed(string, nativeFileItem);
    }

    public void filePropertiesChanged(NativeFileItem nativeFileItem) {
        this.onProjectItemChanged(nativeFileItem);
    }

    public void filesPropertiesChanged(final List<NativeFileItem> list) {
        if (this.enabledEventsHandling) {
            ModelImpl.instance().enqueueModelTask(new Runnable(){

                @Override
                public void run() {
                    NativeProjectListenerImpl.this.filesPropertiesChangedImpl(list);
                }
            }, "Applying property changes");
        } else if (TraceFlags.TIMING) {
            System.err.printf("\nskipped filesPropertiesChanged(list) %s...\n", this.nativeProject.getProjectDisplayName());
        }
    }

    final void enableListening(boolean bl) {
        if (TraceFlags.TIMING) {
            System.err.printf("\n%s ProjectListeners %s...\n", bl ? "enable" : "disable", this.nativeProject.getProjectDisplayName());
        }
        this.enabledEventsHandling = bl;
    }

    private void filesPropertiesChangedImpl(List<NativeFileItem> list) {
        for (List<NativeFileItem> list2 : this.divideByProjects(list)) {
            this.onProjectItemChanged(list2);
        }
    }

    public void filesPropertiesChanged() {
        if (this.enabledEventsHandling) {
            ModelImpl.instance().enqueueModelTask(new Runnable(){

                @Override
                public void run() {
                    ArrayList<NativeFileItem> arrayList = new ArrayList<NativeFileItem>();
                    for (NativeFileItem nativeFileItem : NativeProjectListenerImpl.this.nativeProject.getAllFiles()) {
                        if (nativeFileItem.isExcluded()) continue;
                        switch (nativeFileItem.getLanguage()) {
                            case C: 
                            case CPP: 
                            case FORTRAN: {
                                arrayList.add(nativeFileItem);
                                break;
                            }
                        }
                    }
                    NativeProjectListenerImpl.this.filesPropertiesChangedImpl(arrayList);
                }
            }, "Applying property changes");
        } else if (TraceFlags.TIMING) {
            System.err.printf("\nskipped filesPropertiesChanged %s...\n", this.nativeProject.getProjectDisplayName());
        }
    }

    public void projectDeleted(NativeProject nativeProject) {
        RepositoryUtils.onProjectDeleted(nativeProject);
    }

    private Collection<List<NativeFileItem>> divideByProjects(List<NativeFileItem> list) {
        HashMap<NativeProject, ArrayList<NativeFileItem>> hashMap = new HashMap<NativeProject, ArrayList<NativeFileItem>>();
        for (NativeFileItem nativeFileItem : list) {
            NativeProject nativeProject = nativeFileItem.getNativeProject();
            if (nativeProject == null) continue;
            ArrayList<NativeFileItem> arrayList = (ArrayList<NativeFileItem>)hashMap.get(nativeProject);
            if (arrayList == null) {
                arrayList = new ArrayList<NativeFileItem>();
                hashMap.put(nativeProject, arrayList);
            }
            arrayList.add(nativeFileItem);
        }
        return hashMap.values();
    }

    private void onProjectItemAdded(NativeFileItem nativeFileItem) {
        try {
            ProjectBase projectBase = this.getProject(nativeFileItem, true);
            if (projectBase != null) {
                projectBase.onFileAdded(nativeFileItem);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private void onProjectItemAdded(List<NativeFileItem> list) {
        if (list.size() > 0) {
            try {
                ProjectBase projectBase = this.getProject(list.get(0), true);
                if (projectBase != null) {
                    projectBase.onFileAdded(list);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    private void onProjectItemRemoved(NativeFileItem nativeFileItem) {
        try {
            ProjectBase projectBase = this.getProject(nativeFileItem, false);
            if (projectBase != null) {
                FileObject fileObject = nativeFileItem.getFileObject();
                if (fileObject != null) {
                    fileObject.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)new FileDeleteListener(projectBase), (Object)fileObject));
                }
                projectBase.onFileRemoved(nativeFileItem.getAbsolutePath());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private void onProjectItemRemoved(List<NativeFileItem> list) {
        if (!list.isEmpty()) {
            try {
                ProjectBase projectBase = this.getProject(list.get(0), false);
                if (projectBase != null) {
                    projectBase.onFileRemoved(list);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    private void onProjectItemRenamed(String string, NativeFileItem nativeFileItem) {
        try {
            ProjectBase projectBase = this.getProject(nativeFileItem, false);
            if (projectBase != null) {
                projectBase.onFileRemoved(string);
                projectBase.onFileAdded(nativeFileItem);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private void onProjectItemChanged(NativeFileItem nativeFileItem) {
        try {
            ProjectBase projectBase = this.getProject(nativeFileItem, false);
            if (projectBase != null) {
                projectBase.onFilePropertyChanged(nativeFileItem);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private void onProjectItemChanged(List<NativeFileItem> list) {
        if (list.size() > 0) {
            try {
                ProjectBase projectBase = this.getProject(list.get(0), true);
                if (projectBase != null && projectBase.isValid()) {
                    if (projectBase instanceof ProjectImpl) {
                        LibraryManager.getInstance().onProjectPropertyChanged(projectBase.getUID());
                    }
                    projectBase.onFilePropertyChanged(list);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    private ProjectBase getProject(NativeFileItem nativeFileItem, boolean bl) {
        assert (nativeFileItem != null) : "must not be null";
        ProjectBase projectBase = null;
        try {
            NativeProject nativeProject = nativeFileItem.getNativeProject();
            assert (nativeProject == null || this.nativeProject.equals(nativeProject)) : "listener was attached to " + this.nativeProject + "\n was notified from " + nativeProject;
            if (nativeProject == null) {
                nativeProject = this.nativeProject;
            }
            if (nativeProject != null) {
                projectBase = bl ? (ProjectBase)this.model._getProject(nativeProject) : (ProjectBase)this.model.findProject(nativeProject);
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace(System.err);
        }
        return projectBase;
    }

    private static class FileDeleteListener
    extends FileChangeAdapter {
        private final ProjectBase project;

        public FileDeleteListener(ProjectBase projectBase) {
            this.project = projectBase;
        }

        public void fileDeleted(FileEvent fileEvent) {
            FileObject fileObject = fileEvent.getFile();
            this.project.onFileRemoved(CndFileUtils.normalizePath((FileObject)fileObject));
            fileObject.removeFileChangeListener((FileChangeListener)this);
        }
    }
}

