/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.apt.support.ResolvedPath;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.LibProjectImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ListenersImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectImpl;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.filesystems.FileSystem;

public final class LibraryManager {
    private static final LibraryManager instance = new LibraryManager();
    private final Map<LibraryKey, LibraryEntry> librariesEntries = new ConcurrentHashMap<LibraryKey, LibraryEntry>();
    private final Object lock = new Lock();

    public static LibraryManager getInstance() {
        return instance;
    }

    private LibraryManager() {
    }

    public void shutdown() {
        this.librariesEntries.clear();
    }

    public List<LibProjectImpl> getLibraries(ProjectImpl projectImpl) {
        ArrayList<LibProjectImpl> arrayList = new ArrayList<LibProjectImpl>();
        CsmUID<CsmProject> csmUID = projectImpl.getUID();
        for (LibraryEntry libraryEntry : this.librariesEntries.values()) {
            LibProjectImpl libProjectImpl;
            if (!libraryEntry.containsProject((CsmUID<CsmProject>)csmUID) || (libProjectImpl = (LibProjectImpl)libraryEntry.getLibrary().getObject()) == null) continue;
            arrayList.add(libProjectImpl);
        }
        return arrayList;
    }

    public Collection<CsmUID<CsmProject>> getLirariesKeys(CsmUID<CsmProject> csmUID) {
        ArrayList<CsmUID<CsmProject>> arrayList = new ArrayList<CsmUID<CsmProject>>();
        for (LibraryEntry libraryEntry : this.librariesEntries.values()) {
            if (!libraryEntry.containsProject((CsmUID<CsmProject>)csmUID)) continue;
            arrayList.add((CsmUID<CsmProject>)libraryEntry.getLibrary());
        }
        return arrayList;
    }

    private void trace(String string, FileImpl fileImpl, ResolvedPath resolvedPath, ProjectBase projectBase, ProjectBase projectBase2) {
        System.out.println("Resolved Path " + resolvedPath.getPath());
        System.out.println("    start project " + projectBase2);
        System.out.println("    found in " + string + " " + projectBase);
        System.out.println("    included from " + fileImpl);
        System.out.println("    file from project " + fileImpl.getProject());
        for (CsmProject csmProject : projectBase2.getLibraries()) {
            System.out.println("    search lib " + csmProject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectBase resolveFileProjectOnInclude(ProjectBase projectBase, FileImpl fileImpl, ResolvedPath resolvedPath) {
        String string = ((Object)resolvedPath.getPath()).toString();
        ProjectBase projectBase2 = this.searchInProjectFiles(projectBase, resolvedPath);
        if (projectBase2 != null) {
            if (TraceFlags.TRACE_RESOLVED_LIBRARY) {
                this.trace("Projects", fileImpl, resolvedPath, projectBase2, projectBase);
            }
            return projectBase2;
        }
        String string2 = ((Object)resolvedPath.getFolder()).toString();
        projectBase2 = this.searchInProjectRoots(projectBase, resolvedPath.getFileSystem(), this.getPathToFolder(string2, string));
        if (projectBase2 != null) {
            if (TraceFlags.TRACE_RESOLVED_LIBRARY) {
                this.trace("Projects roots", fileImpl, resolvedPath, projectBase2, projectBase);
            }
            return projectBase2;
        }
        projectBase2 = this.searchInProjectFilesArtificial(projectBase, resolvedPath);
        if (projectBase2 != null) {
            if (TraceFlags.TRACE_RESOLVED_LIBRARY) {
                this.trace("Libraries", fileImpl, resolvedPath, projectBase2, projectBase);
            }
            return projectBase2;
        }
        Object object = this.lock;
        synchronized (object) {
            projectBase2 = this.searchInProjectRootsArtificial(projectBase, resolvedPath.getFileSystem(), this.getPathToFolder(string2, string));
            if (projectBase2 == null) {
                if (resolvedPath.isDefaultSearchPath()) {
                    projectBase2 = fileImpl.getProjectImpl(true);
                    if (TraceFlags.TRACE_RESOLVED_LIBRARY) {
                        this.trace("Base Project as Default Search Path", fileImpl, resolvedPath, projectBase2, projectBase);
                    }
                } else if (!projectBase.isArtificial()) {
                    projectBase2 = this.getLibrary((ProjectImpl)projectBase, resolvedPath.getFileSystem(), string2);
                    if (projectBase2 == null) {
                        if (CndUtils.isDebugMode()) {
                            this.trace("Not created library for folder " + string2, fileImpl, resolvedPath, projectBase2, projectBase);
                        }
                        projectBase2 = projectBase;
                    }
                    if (TraceFlags.TRACE_RESOLVED_LIBRARY) {
                        this.trace("Library for folder " + string2, fileImpl, resolvedPath, projectBase2, projectBase);
                    }
                } else {
                    projectBase2 = projectBase;
                    if (TraceFlags.TRACE_RESOLVED_LIBRARY) {
                        this.trace("Base Project", fileImpl, resolvedPath, projectBase2, projectBase);
                    }
                }
            } else if (TraceFlags.TRACE_RESOLVED_LIBRARY) {
                this.trace("Libraries roots", fileImpl, resolvedPath, projectBase2, projectBase);
            }
        }
        return projectBase2;
    }

    private List<String> getPathToFolder(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add(string);
        if (string2.startsWith(string)) {
            String string3;
            while ((string3 = CndPathUtilitities.getDirName((String)string2)) != null && !string.equals(string3) && string3.startsWith(string)) {
                arrayList.add(string3);
                if (arrayList.size() == 3) break;
                string2 = string3;
            }
        }
        return arrayList;
    }

    private ProjectBase searchInProjectFiles(ProjectBase projectBase, ResolvedPath resolvedPath) {
        return this.searchInProjectFiles(projectBase, resolvedPath, new HashSet<ProjectBase>());
    }

    private ProjectBase searchInProjectFiles(ProjectBase projectBase, ResolvedPath resolvedPath, Set<ProjectBase> set) {
        CsmProject csmProject;
        CsmUID<CsmFile> csmUID;
        if (set.contains(projectBase)) {
            return null;
        }
        set.add(projectBase);
        if (projectBase.getFileSystem() == resolvedPath.getFileSystem()) {
            projectBase.ensureFilesCreated();
            csmUID = projectBase.getFileUID(resolvedPath.getPath(), true);
            if (csmUID != null) {
                return projectBase;
            }
        }
        csmUID = projectBase.getLibraries();
        Iterator iterator = csmUID.iterator();
        while (iterator.hasNext() && !(csmProject = (CsmProject)iterator.next()).isArtificial()) {
            ProjectBase projectBase2 = this.searchInProjectFiles((ProjectBase)csmProject, resolvedPath, set);
            if (projectBase2 == null) continue;
            return projectBase2;
        }
        return null;
    }

    private ProjectBase searchInProjectFilesArtificial(ProjectBase projectBase, ResolvedPath resolvedPath) {
        Collection collection = projectBase.getLibraries();
        for (CsmProject csmProject : collection) {
            ProjectBase projectBase2;
            if (!csmProject.isArtificial() || (projectBase2 = this.searchInProjectFiles((ProjectBase)csmProject, resolvedPath)) == null) continue;
            return projectBase2;
        }
        return null;
    }

    private ProjectBase searchInProjectRoots(ProjectBase projectBase, FileSystem fileSystem, List<String> list) {
        return this.searchInProjectRoots(projectBase, fileSystem, list, new HashSet<ProjectBase>());
    }

    private ProjectBase searchInProjectRoots(ProjectBase projectBase, FileSystem fileSystem, List<String> list, HashSet<ProjectBase> hashSet) {
        CsmProject csmProject;
        if (hashSet.contains(projectBase)) {
            return null;
        }
        hashSet.add(projectBase);
        if (projectBase.getFileSystem() == fileSystem) {
            for (String object2 : list) {
                if (!projectBase.isMySource(object2)) continue;
                return projectBase;
            }
        }
        Collection collection = projectBase.getLibraries();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && !(csmProject = (CsmProject)iterator.next()).isArtificial()) {
            ProjectBase projectBase2 = this.searchInProjectRoots((ProjectBase)csmProject, fileSystem, list, hashSet);
            if (projectBase2 == null) continue;
            return projectBase2;
        }
        return null;
    }

    private ProjectBase searchInProjectRootsArtificial(ProjectBase projectBase, FileSystem fileSystem, List<String> list) {
        Collection collection = projectBase.getLibraries();
        ProjectBase projectBase2 = null;
        for (CsmProject csmProject : collection) {
            ProjectBase projectBase3;
            if (!csmProject.isArtificial() || (projectBase3 = this.searchInProjectRoots((ProjectBase)csmProject, fileSystem, list)) == null) continue;
            if (projectBase2 == null) {
                projectBase2 = projectBase3;
                continue;
            }
            CharSequence charSequence = ((LibProjectImpl)projectBase2).getPath();
            CharSequence charSequence2 = ((LibProjectImpl)projectBase3).getPath();
            if (charSequence2.length() <= charSequence.length()) continue;
            projectBase2 = projectBase3;
        }
        return projectBase2;
    }

    private LibProjectImpl getLibrary(ProjectImpl projectImpl, FileSystem fileSystem, String string) {
        CsmUID<CsmProject> csmUID = projectImpl.getUID();
        LibraryKey libraryKey = new LibraryKey(fileSystem, string);
        LibraryEntry libraryEntry = this.librariesEntries.get(libraryKey);
        if (libraryEntry == null) {
            libraryEntry = this.getOrCreateLibrary(libraryKey);
        }
        if (!libraryEntry.containsProject((CsmUID<CsmProject>)csmUID)) {
            libraryEntry.addProject((CsmUID<CsmProject>)csmUID);
        }
        return (LibProjectImpl)libraryEntry.getLibrary().getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LibraryEntry getOrCreateLibrary(LibraryKey libraryKey) {
        LibraryEntry libraryEntry = this.librariesEntries.get(libraryKey);
        if (libraryEntry == null) {
            boolean bl = false;
            Object object = this.lock;
            synchronized (object) {
                libraryEntry = this.librariesEntries.get(libraryKey);
                if (libraryEntry == null) {
                    libraryEntry = new LibraryEntry(libraryKey);
                    this.librariesEntries.put(libraryKey, libraryEntry);
                    bl = true;
                }
            }
            if (bl) {
                object = libraryEntry;
                ModelImpl.instance().enqueueModelTask(new Runnable((LibraryEntry)object){
                    final /* synthetic */ LibraryEntry val$passEntry;
                    {
                        this.val$passEntry = libraryEntry;
                    }

                    @Override
                    public void run() {
                        ListenersImpl.getImpl().fireProjectOpened((ProjectBase)this.val$passEntry.getLibrary().getObject());
                    }
                }, "postponed library opened " + libraryKey.folder);
            }
        }
        return libraryEntry;
    }

    public void onProjectPropertyChanged(CsmUID<CsmProject> csmUID) {
        for (LibraryEntry libraryEntry : this.librariesEntries.values()) {
            libraryEntry.removeProject((CsmUID<CsmProject>)csmUID);
        }
    }

    public void onProjectClose(CsmUID<CsmProject> csmUID) {
        ArrayList<LibraryEntry> arrayList = new ArrayList<LibraryEntry>();
        for (LibraryEntry libraryEntry : this.librariesEntries.values()) {
            libraryEntry.removeProject((CsmUID<CsmProject>)csmUID);
            if (!libraryEntry.isEmpty()) continue;
            arrayList.add(libraryEntry);
        }
        if (arrayList.size() > 0) {
            for (LibraryEntry libraryEntry : arrayList) {
                this.librariesEntries.remove(libraryEntry.getKey());
            }
        }
        this.closeLibraries(arrayList);
    }

    final void cleanLibrariesData(Collection<LibProjectImpl> collection) {
        for (LibProjectImpl libProjectImpl : collection) {
            this.librariesEntries.remove(new LibraryKey(libProjectImpl.getFileSystem(), ((Object)libProjectImpl.getPath()).toString()));
            libProjectImpl.dispose(true);
        }
    }

    private void closeLibraries(Collection<LibraryEntry> collection) {
        ModelImpl modelImpl = (ModelImpl)CsmModelAccessor.getModel();
        for (LibraryEntry libraryEntry : collection) {
            CsmUID csmUID = libraryEntry.getLibrary();
            ProjectBase projectBase = (ProjectBase)csmUID.getObject();
            assert (projectBase != null) : "Null project for UID " + csmUID;
            modelImpl.disposeProject(projectBase);
        }
    }

    void writeProjectLibraries(CsmUID<CsmProject> csmUID, DataOutput dataOutput) throws IOException {
        assert (dataOutput != null);
        HashSet<LibraryKey> hashSet = new HashSet<LibraryKey>();
        for (Map.Entry<LibraryKey, LibraryEntry> entry : this.librariesEntries.entrySet()) {
            if (!entry.getValue().containsProject((CsmUID<CsmProject>)csmUID)) continue;
            hashSet.add(entry.getKey());
        }
        dataOutput.writeInt(hashSet.size());
        for (LibraryKey libraryKey : hashSet) {
            libraryKey.write(dataOutput);
        }
    }

    void readProjectLibraries(CsmUID<CsmProject> csmUID, DataInput dataInput) throws IOException {
        assert (dataInput != null);
        int n = dataInput.readInt();
        if (n != -1) {
            for (int i = 0; i < n; ++i) {
                LibraryKey libraryKey = new LibraryKey(dataInput);
                LibraryEntry libraryEntry = this.getOrCreateLibrary(libraryKey);
                libraryEntry.addProject((CsmUID<CsmProject>)csmUID);
            }
        }
    }

    public void dumpInfo(PrintWriter printWriter, boolean bl) {
        printWriter.printf("LibraryManager: libs=%d\n", this.librariesEntries.size());
        int n = 1;
        for (Map.Entry<LibraryKey, LibraryEntry> entry : this.librariesEntries.entrySet()) {
            printWriter.printf("Lib[%d] %s with LibEntry %s\n", n++, entry.getKey(), entry.getValue());
            if (!bl) continue;
            CsmProject csmProject = UIDCsmConverter.UIDtoProject((CsmUID<CsmProject>)entry.getValue().libraryUID);
            if (csmProject == null) {
                printWriter.printf("Library was NOT restored from repository\n", new Object[0]);
                continue;
            }
            if (csmProject instanceof ProjectBase) {
                printWriter.printf("[%d] disposing=%s\n", n, ((ProjectBase)csmProject).isDisposing());
                ((ProjectBase)csmProject).traceFileContainer(printWriter);
                continue;
            }
            printWriter.printf("Library's project has unexpected class type %s\n", csmProject.getClass().getName());
        }
    }

    private static final class LibraryEntry {
        private final LibraryKey key;
        private CsmUID<CsmProject> libraryUID;
        private final ConcurrentMap<CsmUID<CsmProject>, Boolean> dependentProjects;

        private LibraryEntry(LibraryKey libraryKey) {
            this.key = libraryKey;
            this.dependentProjects = new ConcurrentHashMap<CsmUID<CsmProject>, Boolean>();
        }

        private String getFolder() {
            return this.key.folder;
        }

        private FileSystem getFileSystem() {
            return this.key.fileSystem;
        }

        public LibraryKey getKey() {
            return this.key;
        }

        private CsmUID<CsmProject> getLibrary() {
            if (this.libraryUID == null) {
                this.createUID();
            }
            return this.libraryUID;
        }

        private synchronized void createUID() {
            if (this.libraryUID == null) {
                ModelImpl modelImpl = (ModelImpl)CsmModelAccessor.getModel();
                LibProjectImpl libProjectImpl = LibProjectImpl.createInstance(modelImpl, this.getFileSystem(), this.getFolder());
                this.libraryUID = libProjectImpl.getUID();
            }
        }

        private boolean isEmpty() {
            return this.dependentProjects.size() == 0;
        }

        private boolean containsProject(CsmUID<CsmProject> csmUID) {
            return this.dependentProjects.containsKey(csmUID);
        }

        private void addProject(CsmUID<CsmProject> csmUID) {
            this.dependentProjects.put(csmUID, Boolean.TRUE);
        }

        private void removeProject(CsmUID<CsmProject> csmUID) {
            this.dependentProjects.remove(csmUID);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("folder=").append(this.key).append(",\nlibraryUID=").append(this.libraryUID);
            if (this.dependentProjects.isEmpty()) {
                stringBuilder.append(" NO DEPENDENT PROJECTS!");
            } else {
                stringBuilder.append("\ndependentProjects=");
                for (CsmUID csmUID : this.dependentProjects.keySet()) {
                    stringBuilder.append("\n(").append(System.identityHashCode(csmUID)).append(")").append(csmUID);
                }
            }
            return stringBuilder.toString();
        }
    }

    private static final class LibraryKey {
        private final FileSystem fileSystem;
        private final String folder;

        public LibraryKey(FileSystem fileSystem, String string) {
            this.fileSystem = fileSystem;
            this.folder = string;
        }

        private LibraryKey(DataInput dataInput) throws IOException {
            this.fileSystem = PersistentUtils.readFileSystem(dataInput);
            this.folder = dataInput.readUTF();
        }

        private void write(DataOutput dataOutput) throws IOException {
            PersistentUtils.writeFileSystem(this.fileSystem, dataOutput);
            dataOutput.writeUTF(this.folder);
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            LibraryKey libraryKey = (LibraryKey)object;
            if (this.folder == null ? libraryKey.folder != null : !this.folder.equals(libraryKey.folder)) {
                return false;
            }
            return this.fileSystem == libraryKey.fileSystem || this.fileSystem != null && this.fileSystem.equals(libraryKey.fileSystem);
        }

        public int hashCode() {
            int n = 5;
            n = 83 * n + (this.folder != null ? this.folder.hashCode() : 0);
            n = 83 * n + (this.fileSystem != null ? this.fileSystem.hashCode() : 0);
            return n;
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

