/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunctionInstantiation;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionParameterListImpl;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.openide.util.CharSequences;

public final class FunctionInstantiationImpl
extends OffsetableDeclarationBase<CsmFunctionInstantiation>
implements CsmFunctionInstantiation {
    private final FunctionParameterListImpl parameterList;
    private CsmScope scopeRef;
    private CsmUID<CsmScope> scopeUID;
    private final CharSequence name;

    private FunctionInstantiationImpl(AST aST, CsmFile csmFile, CsmScope csmScope, NameHolder nameHolder, boolean bl) throws AstRendererException {
        super(aST, csmFile);
        this.parameterList = this.createParameterList(aST, !bl);
        this._setScope(csmScope);
        this.name = QualifiedNameCache.getManager().getString(nameHolder.getName());
    }

    public static FunctionInstantiationImpl create(AST aST, CsmFile csmFile, boolean bl) throws AstRendererException {
        NameHolder nameHolder = NameHolder.createFunctionName(aST);
        FunctionInstantiationImpl functionInstantiationImpl = new FunctionInstantiationImpl(aST, csmFile, null, nameHolder, bl);
        FunctionInstantiationImpl.postObjectCreateRegistration(bl, functionInstantiationImpl);
        nameHolder.addReference(csmFile, functionInstantiationImpl);
        return functionInstantiationImpl;
    }

    private FunctionParameterListImpl createParameterList(AST aST, boolean bl) {
        return FunctionParameterListImpl.create(this.getContainingFile(), aST, this.getScope(), bl);
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.FUNCTION_INSTANTIATION;
    }

    public CharSequence getName() {
        return this.name;
    }

    public CharSequence getQualifiedName() {
        CharSequence charSequence;
        CsmScope csmScope = this.getScope();
        if ((csmScope instanceof CsmNamespace || csmScope instanceof CsmClass || csmScope instanceof CsmNamespaceDefinition) && (charSequence = ((CsmQualifiedNamedElement)csmScope).getQualifiedName()) != null && charSequence.length() > 0) {
            return CharSequences.create((CharSequence)(((Object)charSequence).toString() + "::" + this.getQualifiedNamePostfix()));
        }
        return this.getName();
    }

    public CsmScope getScope() {
        return this._getScope();
    }

    private void _setScope(CsmScope csmScope) {
        if (csmScope instanceof CsmIdentifiable) {
            this.scopeUID = UIDCsmConverter.scopeToUID(csmScope);
            assert (this.scopeUID != null || csmScope == null);
        } else {
            this.scopeRef = csmScope;
        }
    }

    private synchronized CsmScope _getScope() {
        CsmScope csmScope = this.scopeRef;
        if (csmScope == null) {
            csmScope = UIDCsmConverter.UIDtoScope(this.scopeUID);
        }
        return csmScope;
    }

    public Collection<CsmScopeElement> getScopeElements() {
        ArrayList<CsmScopeElement> arrayList = new ArrayList<CsmScopeElement>();
        arrayList.addAll(this.getParameters());
        return arrayList;
    }

    public Collection<CsmParameter> getParameters() {
        return this._getParameters();
    }

    private Collection<CsmParameter> _getParameters() {
        if (this.parameterList == null) {
            return Collections.emptyList();
        }
        return this.parameterList.getParameters();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.onDispose();
        CsmScope csmScope = this._getScope();
        if (csmScope instanceof MutableDeclarationsContainer) {
            ((MutableDeclarationsContainer)csmScope).removeDeclaration(this);
        }
        this.unregisterInProject();
        this._disposeParameters();
    }

    private void _disposeParameters() {
        if (this.parameterList != null) {
            this.parameterList.dispose();
        }
    }

    private void unregisterInProject() {
        CsmProject csmProject = this.getContainingFile().getProject();
        if (csmProject instanceof ProjectBase) {
            ((ProjectBase)csmProject).unregisterDeclaration(this);
            this.cleanUID();
        }
    }

    private synchronized void onDispose() {
        if (this.scopeRef == null) {
            this.scopeRef = UIDCsmConverter.UIDtoScope(this.scopeUID);
            assert (this.scopeRef != null || this.scopeUID == null) : "empty scope for UID " + this.scopeUID;
        }
    }

    public FunctionInstantiationImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.name = PersistentUtils.readUTF(dataInput, QualifiedNameCache.getManager());
        assert (this.name != null);
        this.parameterList = (FunctionParameterListImpl)PersistentUtils.readParameterList(dataInput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        this.scopeUID = uIDObjectFactory.readUID(dataInput);
        this.scopeRef = null;
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, dataOutput);
        PersistentUtils.writeParameterList(this.parameterList, dataOutput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        uIDObjectFactory.writeUID(this.scopeUID, dataOutput);
    }
}

