/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.CastUtils;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionParameterListImpl;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateUtils;
import org.netbeans.modules.cnd.modelimpl.csm.TypeFactory;
import org.netbeans.modules.cnd.modelimpl.csm.TypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.RawNamable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.impl.services.InstantiationProviderImpl;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.openide.util.CharSequences;

public class FunctionImpl<T>
extends OffsetableDeclarationBase<T>
implements CsmFunction,
Disposable,
RawNamable,
CsmTemplate {
    private static final String OPERATOR = "operator";
    private final CharSequence name;
    private final CsmType returnType;
    private final FunctionParameterListImpl parameterList;
    private CharSequence signature;
    private CsmScope scopeRef;
    private CsmUID<CsmScope> scopeUID;
    private final CharSequence[] rawName;
    private final TemplateDescriptor templateDescriptor;
    protected final CharSequence classTemplateSuffix;
    private static final byte FLAGS_VOID_PARMLIST = 1;
    private static final byte FLAGS_STATIC = 2;
    private static final byte FLAGS_CONST = 4;
    private static final byte FLAGS_OPERATOR = 8;
    private static final byte FLAGS_INVALID = 16;
    protected static final int LAST_USED_FLAG_INDEX = 4;
    private byte flags;
    private static final boolean CHECK_SCOPE = false;

    protected FunctionImpl(AST aST, CsmFile csmFile, CsmType csmType, CsmScope csmScope, NameHolder nameHolder, boolean bl) throws AstRendererException {
        super(aST, csmFile);
        Object object;
        this.name = QualifiedNameCache.getManager().getString(nameHolder.getName());
        if (this.name.length() == 0) {
            throw new AstRendererException((FileImpl)csmFile, this.getStartOffset(), "Empty function name.");
        }
        this.rawName = this.initRawName(aST);
        AST aST2 = aST.getFirstChild();
        if (aST2 != null) {
            this.setStatic(aST2.getType() == 132);
        } else {
            System.err.println("function ast " + aST.getText() + " without childs in file " + csmFile.getAbsolutePath());
        }
        if (!this.isStatic()) {
            CsmSelect.CsmFilter csmFilter = CsmSelect.getFilterBuilder().createNameFilter(this.name, true, true, false);
            object = CsmSelect.getStaticFunctions((CsmFile)csmFile, (CsmSelect.CsmFilter)csmFilter);
            while (object.hasNext()) {
                CsmFunction csmFunction = (CsmFunction)object.next();
                if (!this.name.equals(csmFunction.getName())) continue;
                this.setStatic(true);
                break;
            }
        }
        if (csmScope instanceof CsmNamespace && !NamespaceImpl.isNamespaceScope(this)) {
            csmScope = csmFile;
        }
        this._setScope(csmScope);
        boolean bl2 = FunctionImpl.initConst(aST);
        this.setFlags((byte)4, bl2);
        if (((Object)this.name).toString().startsWith(OPERATOR) && this.name.length() > OPERATOR.length() && !Character.isJavaIdentifierPart(this.name.charAt(OPERATOR.length()))) {
            this.setFlags((byte)8, true);
        }
        FunctionImpl.temporaryRepositoryRegistration(bl, this);
        object = new StringBuilder();
        this.templateDescriptor = this.createTemplateDescriptor(aST, (CsmScope)this, (StringBuilder)object, bl);
        this.classTemplateSuffix = NameCache.getManager().getString((CharSequence)object);
        this.returnType = csmType != null ? csmType : this.initReturnType(aST);
        this.parameterList = this.createParameterList(aST, !bl);
        if (this.parameterList == null || this.parameterList.isEmpty()) {
            this.setFlags((byte)1, this.isVoidParameter(aST));
        } else {
            this.setFlags((byte)1, false);
        }
        if (this.parameterList == null) {
            System.err.println("NO PARAM LIST FOR FUNC:" + this.name + " at " + AstUtil.getOffsetString(aST) + " in " + csmFile.getAbsolutePath());
        }
    }

    public static <T> FunctionImpl<T> create(AST aST, CsmFile csmFile, CsmType csmType, CsmScope csmScope, boolean bl) throws AstRendererException {
        NameHolder nameHolder = NameHolder.createFunctionName(aST);
        FunctionImpl<T> functionImpl = new FunctionImpl<T>(aST, csmFile, csmType, csmScope, nameHolder, bl);
        FunctionImpl.postObjectCreateRegistration(bl, functionImpl);
        nameHolder.addReference(csmFile, functionImpl);
        return functionImpl;
    }

    public static <T> FunctionImpl<T> create(CsmFile csmFile, CsmType csmType, CsmScope csmScope, String string, FunctionParameterListImpl functionParameterListImpl, boolean bl, boolean bl2, boolean bl3, int n, int n2) {
        FunctionImpl<T> functionImpl = new FunctionImpl<T>(csmFile, csmType, csmScope, string, functionParameterListImpl, bl, bl2, bl3, n, n2);
        FunctionImpl.postObjectCreateRegistration(bl3, functionImpl);
        return functionImpl;
    }

    private FunctionImpl(CsmFile csmFile, CsmType csmType, CsmScope csmScope, String string, FunctionParameterListImpl functionParameterListImpl, boolean bl, boolean bl2, boolean bl3, int n, int n2) {
        super(csmFile, n, n2);
        this.name = QualifiedNameCache.getManager().getString((CharSequence)string);
        this.rawName = null;
        this.setStatic(bl);
        if (csmScope instanceof CsmNamespace && !NamespaceImpl.isNamespaceScope(this)) {
            csmScope = csmFile;
        }
        this._setScope(csmScope);
        this.setFlags((byte)4, bl2);
        if (string.toString().startsWith(OPERATOR) && string.length() > OPERATOR.length() && !Character.isJavaIdentifierPart(string.charAt(OPERATOR.length()))) {
            this.setFlags((byte)8, true);
        }
        FunctionImpl.temporaryRepositoryRegistration(bl3, this);
        this.templateDescriptor = null;
        this.classTemplateSuffix = null;
        this.returnType = csmType;
        this.parameterList = functionParameterListImpl;
        if (!this.parameterList.isEmpty()) {
            this.setFlags((byte)1, false);
        }
    }

    public void setScope(CsmScope csmScope) {
        this.unregisterInProject();
        this._setScope(csmScope);
        this.registerInProject();
    }

    private void _setScope(CsmScope csmScope) {
        if (csmScope instanceof CsmIdentifiable) {
            this.scopeUID = UIDCsmConverter.scopeToUID(csmScope);
            assert (this.scopeUID != null || csmScope == null);
        } else {
            this.scopeRef = csmScope;
        }
    }

    public boolean isPureDefinition() {
        return this.getKind() == CsmDeclaration.Kind.FUNCTION_DEFINITION || this.getKind() == CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION;
    }

    protected boolean hasFlags(byte by) {
        return (this.flags & by) == by;
    }

    protected final void setFlags(byte by, boolean bl) {
        this.flags = bl ? (byte)(this.flags | by) : (byte)(this.flags & ~by);
    }

    public final boolean isStatic() {
        return this.hasFlags((byte)2);
    }

    protected final void setStatic(boolean bl) {
        this.setFlags((byte)2, bl);
    }

    private AST findParameterNode(AST aST) {
        AST aST2;
        AST aST3 = AstUtil.findChildOfType(aST, 495);
        if (aST3 != null && (aST2 = AstUtil.findSiblingOfType(aST3.getNextSibling(), 496)) != null) {
            aST3 = aST2;
        }
        return aST3;
    }

    protected CharSequence getScopeSuffix() {
        return this.classTemplateSuffix != null ? this.classTemplateSuffix : CharSequences.empty();
    }

    protected final CharSequence[] initRawName(AST aST) {
        return FunctionImpl.findFunctionRawName(aST);
    }

    public CharSequence getDisplayName() {
        return this.templateDescriptor != null ? CharSequences.create((CharSequence)(((Object)this.getName()).toString() + this.templateDescriptor.getTemplateSuffix())) : this.getName();
    }

    public List<CsmTemplateParameter> getTemplateParameters() {
        return this.templateDescriptor != null ? this.templateDescriptor.getTemplateParameters() : Collections.emptyList();
    }

    public List<CsmTemplateParameter> getInheritedTemplateParameters() {
        List<CsmTemplateParameter> list = this.getTemplateParameters();
        ArrayList<CsmTemplateParameter> arrayList = new ArrayList<CsmTemplateParameter>();
        if (list != null) {
            int n;
            int n2 = n = this.templateDescriptor != null ? this.templateDescriptor.getInheritedTemplateParametersNumber() : 0;
            if (list.size() > n) {
                Iterator<CsmTemplateParameter> iterator = list.iterator();
                for (int i = 0; i < n && iterator.hasNext(); ++i) {
                    arrayList.add(iterator.next());
                }
            }
        }
        return arrayList;
    }

    public List<CsmTemplateParameter> getOwnTemplateParameters() {
        List<CsmTemplateParameter> list = this.getTemplateParameters();
        ArrayList<CsmTemplateParameter> arrayList = new ArrayList<CsmTemplateParameter>();
        if (list != null) {
            int n;
            int n2 = n = this.templateDescriptor != null ? this.templateDescriptor.getInheritedTemplateParametersNumber() : 0;
            if (list.size() > n) {
                Iterator<CsmTemplateParameter> iterator = list.iterator();
                for (int i = 0; i < n && iterator.hasNext(); ++i) {
                    iterator.next();
                }
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
            }
        }
        return arrayList;
    }

    public boolean isVoidParameterList() {
        return this.hasFlags((byte)1);
    }

    private static CharSequence[] findFunctionRawName(AST aST) {
        if (CastUtils.isCast(aST)) {
            return CastUtils.getFunctionRawName(aST);
        }
        return AstUtil.getRawNameInChildren(aST);
    }

    protected boolean isCStyleStatic() {
        return this.isStatic() && CsmKindUtilities.isFile((CsmObject)this.getScope());
    }

    @Override
    protected boolean registerInProject() {
        if (this.isCStyleStatic()) {
            return false;
        }
        CsmProject csmProject = this.getContainingFile().getProject();
        if (csmProject instanceof ProjectBase) {
            return ((ProjectBase)csmProject).registerDeclaration(this);
        }
        return false;
    }

    private void unregisterInProject() {
        CsmProject csmProject = this.getContainingFile().getProject();
        if (csmProject instanceof ProjectBase) {
            ((ProjectBase)csmProject).unregisterDeclaration(this);
            this.cleanUID();
        }
    }

    public CharSequence getName() {
        return this.name;
    }

    public CharSequence getQualifiedName() {
        CharSequence charSequence;
        CsmScope csmScope = this.getScope();
        if ((csmScope instanceof CsmNamespace || csmScope instanceof CsmClass || csmScope instanceof CsmNamespaceDefinition) && (charSequence = ((CsmQualifiedNamedElement)csmScope).getQualifiedName()) != null && charSequence.length() > 0) {
            return CharSequences.create((CharSequence)(((Object)charSequence).toString() + (!CsmKindUtilities.isSpecialization((CsmObject)csmScope) ? this.getScopeSuffix() : "") + "::" + this.getQualifiedNamePostfix()));
        }
        return this.getName();
    }

    @Override
    public CharSequence[] getRawName() {
        return this.rawName;
    }

    @Override
    public CharSequence getUniqueNameWithoutPrefix() {
        return ((Object)this.getQualifiedName()).toString() + ((Object)this.getSignature()).toString().substring(this.getName().length());
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.FUNCTION;
    }

    public String getDeclarationText() {
        return "";
    }

    public CsmFunctionDefinition getDefinition() {
        return this.getDefinition(null);
    }

    public CsmFunctionDefinition getDefinition(CsmClass csmClass) {
        CsmFunctionDefinition csmFunctionDefinition;
        block10: {
            CsmProject csmProject;
            Iterator<Object> iterator;
            if (this.isCStyleStatic()) {
                CsmSelect.CsmFilter csmFilter = CsmSelect.getFilterBuilder().createNameFilter(this.getName(), true, true, false);
                Iterator iterator2 = CsmSelect.getDeclarations((CsmFile)this.getContainingFile(), (CsmSelect.CsmFilter)csmFilter);
                while (iterator2.hasNext()) {
                    CsmDeclaration csmDeclaration = (CsmDeclaration)iterator2.next();
                    if (!CsmKindUtilities.isFunctionDefinition((CsmObject)csmDeclaration) || !this.getName().equals(csmDeclaration.getName())) continue;
                    CsmFunctionDefinition csmFunctionDefinition2 = (CsmFunctionDefinition)csmDeclaration;
                    if (!this.getSignature().equals(csmFunctionDefinition2.getSignature())) continue;
                    return csmFunctionDefinition2;
                }
                return null;
            }
            String string = csmClass == null ? Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.FUNCTION_DEFINITION) + ':' + this.getUniqueNameWithoutPrefix() : Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.FUNCTION_DEFINITION) + ':' + ((Object)csmClass.getQualifiedName()).toString() + "::" + this.getSignature();
            CsmProject csmProject2 = this.getContainingFile().getProject();
            csmFunctionDefinition = this.findDefinition(csmProject2, string);
            if (csmFunctionDefinition == null) {
                iterator = csmProject2.getLibraries().iterator();
                while (iterator.hasNext() && (csmFunctionDefinition = this.findDefinition(csmProject = (CsmProject)iterator.next(), string)) == null) {
                }
            }
            if (csmFunctionDefinition == null && csmProject2 instanceof ProjectBase) {
                iterator = ((ProjectBase)csmProject2).getDependentProjects().iterator();
                while (iterator.hasNext() && (csmFunctionDefinition = this.findDefinition(csmProject = (ProjectBase)iterator.next(), string)) == null) {
                }
            }
            if (csmFunctionDefinition != null) break block10;
            string = csmClass == null ? Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION) + ':' + this.getUniqueNameWithoutPrefix() : Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION) + ':' + ((Object)csmClass.getQualifiedName()).toString() + "::" + this.getSignature();
            csmFunctionDefinition = this.findDefinition(csmProject2, string);
            if (csmFunctionDefinition == null) {
                iterator = csmProject2.getLibraries().iterator();
                while (iterator.hasNext() && (csmFunctionDefinition = this.findDefinition(csmProject = (CsmProject)iterator.next(), string)) == null) {
                }
            }
            if (csmFunctionDefinition == null && csmProject2 instanceof ProjectBase) {
                iterator = ((ProjectBase)csmProject2).getDependentProjects().iterator();
                while (iterator.hasNext() && (csmFunctionDefinition = this.findDefinition(csmProject = (ProjectBase)iterator.next(), string)) == null) {
                }
            }
        }
        return csmFunctionDefinition;
    }

    private CsmDeclaration fixCastOperator(CsmProject csmProject, String string) {
        String string2;
        int n;
        int n2 = string.indexOf("operator ");
        if (n2 > 0 && (n = (string2 = string.substring(n2 + 9)).lastIndexOf("::")) > 0) {
            string2 = string.substring(0, n2 + 9) + " " + string2.substring(n + 2);
            return csmProject.findDeclaration((CharSequence)string2);
        }
        return null;
    }

    public static boolean isObjectVisibleInFile(CsmFile csmFile, CsmOffsetableDeclaration csmOffsetableDeclaration) {
        CsmFile csmFile2 = csmOffsetableDeclaration.getContainingFile();
        if (csmFile2.equals(csmFile)) {
            return true;
        }
        return ((ProjectBase)csmFile.getProject()).getGraphStorage().isFileIncluded(csmFile, csmFile2);
    }

    private CsmFunctionDefinition findDefinition(CsmProject csmProject, String string) {
        Collection collection = csmProject.findDeclarations((CharSequence)string);
        CsmDeclaration csmDeclaration = null;
        if (collection.isEmpty()) {
            if (this.isOperator()) {
                csmDeclaration = this.fixCastOperator(csmProject, string);
            }
        } else if (collection.size() == 1) {
            csmDeclaration = (CsmDeclaration)collection.iterator().next();
        } else {
            for (CsmOffsetableDeclaration csmOffsetableDeclaration : collection) {
                if (!(csmOffsetableDeclaration instanceof CsmFunctionDefinition)) continue;
                if (FunctionImpl.isObjectVisibleInFile(csmOffsetableDeclaration.getContainingFile(), this)) {
                    csmDeclaration = csmOffsetableDeclaration;
                    break;
                }
                if (csmDeclaration != null) continue;
                csmDeclaration = csmOffsetableDeclaration;
            }
        }
        if (csmDeclaration instanceof CsmFunctionDefinition) {
            return (CsmFunctionDefinition)csmDeclaration;
        }
        if (csmProject instanceof ProjectBase) {
            int n = this.getParameters().size();
            boolean bl = this.isVoidParameterList();
            String string2 = string.substring(0, string.indexOf(40) + 1);
            Collection<CsmOffsetableDeclaration> collection2 = ((ProjectBase)csmProject).findDeclarationsByPrefix(string2);
            CsmFunctionDefinition csmFunctionDefinition = null;
            for (CsmOffsetableDeclaration csmOffsetableDeclaration : collection2) {
                CsmFunctionDefinition csmFunctionDefinition2 = (CsmFunctionDefinition)csmOffsetableDeclaration;
                int n2 = csmFunctionDefinition2.getParameters().size();
                if (!bl && n == 0 && !Utils.isCppFile(csmOffsetableDeclaration.getContainingFile())) {
                    return csmFunctionDefinition2;
                }
                if (n != n2 || csmFunctionDefinition != null) continue;
                csmFunctionDefinition = csmFunctionDefinition2;
            }
            return csmFunctionDefinition;
        }
        return null;
    }

    public boolean isTemplate() {
        return this.templateDescriptor != null;
    }

    public boolean isSpecialization() {
        return this.templateDescriptor != null && this.templateDescriptor.isSpecialization();
    }

    public boolean isExplicitSpecialization() {
        return false;
    }

    public CsmCompoundStatement getBody() {
        return null;
    }

    public boolean isInline() {
        return false;
    }

    private CsmType initReturnType(AST aST) {
        TypeImpl typeImpl = null;
        AST aST2 = FunctionImpl.getTypeToken(aST);
        if (aST2 != null) {
            typeImpl = AstRenderer.renderType(aST2, this.getContainingFile());
        }
        if (typeImpl == null) {
            typeImpl = TypeFactory.createBuiltinType("int", null, 0, null, this.getContainingFile());
        }
        return TemplateUtils.checkTemplateType(typeImpl, (CsmScope)this);
    }

    public CsmType getReturnType() {
        return this.returnType;
    }

    private static AST getTypeToken(AST aST) {
        for (AST aST2 = aST.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
            int n = aST2.getType();
            switch (n) {
                case 129: 
                case 157: 
                case 158: 
                case 159: 
                case 469: 
                case 470: {
                    return aST2;
                }
            }
            if (!AstRenderer.isCVQualifier(n)) continue;
            return aST2;
        }
        return null;
    }

    private FunctionParameterListImpl createParameterList(AST aST, boolean bl) {
        return FunctionParameterListImpl.create(this.getContainingFile(), aST, (CsmScope)this, bl);
    }

    private boolean isVoidParameter(AST aST) {
        AST aST2 = this.findParameterNode(aST);
        return AstRenderer.isVoidParameter(aST2);
    }

    public FunctionParameterListImpl getParameterList() {
        return this.parameterList;
    }

    public Collection<CsmParameter> getParameters() {
        return this._getParameters();
    }

    public CsmScope getScope() {
        return this._getScope();
    }

    public CharSequence getSignature() {
        if (this.signature == null) {
            this.signature = QualifiedNameCache.getManager().getString(this.createSignature());
        }
        return this.signature;
    }

    public CsmFunction getDeclaration() {
        return this;
    }

    public boolean isOperator() {
        return this.hasFlags((byte)8);
    }

    public CsmFunction.OperatorKind getOperatorKind() {
        CsmFunction.OperatorKind operatorKind = CsmFunction.OperatorKind.NONE;
        if (this.isOperator()) {
            int n;
            String string = ((Object)this.getName()).toString();
            int n2 = string.indexOf(OPERATOR);
            assert (n2 >= 0) : "must have word \"operator\" in name";
            String string2 = string.substring(n2 += OPERATOR.length()).trim();
            CsmFunction.OperatorKind operatorKind2 = CsmFunction.OperatorKind.getKindByImage((String)string2, (boolean)true);
            CsmFunction.OperatorKind operatorKind3 = CsmFunction.OperatorKind.getKindByImage((String)string2, (boolean)false);
            operatorKind = operatorKind2 != CsmFunction.OperatorKind.NONE && operatorKind3 != CsmFunction.OperatorKind.NONE ? ((n = this.getNrParameters()) == 0 ? operatorKind3 : (n == 1 ? (CsmKindUtilities.isClass((CsmObject)this.getScope()) ? operatorKind2 : operatorKind3) : (n == 2 ? operatorKind2 : operatorKind3))) : (operatorKind2 != CsmFunction.OperatorKind.NONE ? operatorKind2 : operatorKind3);
        }
        return operatorKind;
    }

    public Collection<CsmScopeElement> getScopeElements() {
        ArrayList<CsmScopeElement> arrayList = new ArrayList<CsmScopeElement>();
        arrayList.addAll(this.getParameters());
        return arrayList;
    }

    private CharSequence createSignature() {
        StringBuilder stringBuilder = new StringBuilder(this.getName());
        this.appendTemplateSignature(stringBuilder);
        InstantiationProviderImpl.appendParametersSignature(this.getParameters(), stringBuilder);
        if (this.isConst()) {
            stringBuilder.append(" const");
        }
        return stringBuilder;
    }

    private void appendTemplateSignature(StringBuilder stringBuilder) {
        InstantiationProviderImpl.appendTemplateParamsSignature(this.getOwnTemplateParameters(), stringBuilder);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.onDispose();
        CsmScope csmScope = this._getScope();
        if (csmScope instanceof MutableDeclarationsContainer) {
            ((MutableDeclarationsContainer)csmScope).removeDeclaration(this);
        }
        this.unregisterInProject();
        this._disposeParameters();
        this.setFlags((byte)16, true);
    }

    @Override
    public boolean isValid() {
        return !this.hasFlags((byte)16) && super.isValid();
    }

    private synchronized void onDispose() {
        if (this.scopeRef == null) {
            this.scopeRef = UIDCsmConverter.UIDtoScope(this.scopeUID);
            assert (this.scopeRef != null || this.scopeUID == null) : "empty scope for UID " + this.scopeUID;
        }
    }

    private static boolean initConst(AST aST) {
        AST aST2;
        for (aST2 = aST.getFirstChild(); aST2 != null && aST2.getType() != 503; aST2 = aST2.getNextSibling()) {
        }
        while (aST2 != null) {
            if (AstRenderer.isConstQualifier(aST2.getType())) {
                return true;
            }
            aST2 = aST2.getNextSibling();
        }
        return false;
    }

    protected boolean isConst() {
        return this.hasFlags((byte)4);
    }

    private synchronized CsmScope _getScope() {
        CsmScope csmScope = this.scopeRef;
        if (csmScope == null) {
            csmScope = UIDCsmConverter.UIDtoScope(this.scopeUID);
        }
        return csmScope;
    }

    private Collection<CsmParameter> _getParameters() {
        if (this.parameterList == null) {
            return Collections.emptyList();
        }
        return this.parameterList.getParameters();
    }

    private int getNrParameters() {
        if (this.isVoidParameterList() || this.parameterList == null) {
            return 0;
        }
        return this.parameterList.getNrParameters();
    }

    private void _disposeParameters() {
        if (this.parameterList != null) {
            this.parameterList.dispose();
        }
    }

    protected final CsmFunction chooseDeclaration(Collection<CsmDeclaration> collection) {
        CsmFunction csmFunction = null;
        if (collection.size() == 1) {
            csmFunction = (CsmFunction)collection.iterator().next();
        } else {
            CsmFile csmFile = null;
            for (CsmDeclaration csmDeclaration : collection) {
                CsmFunction csmFunction2 = (CsmFunction)csmDeclaration;
                CsmFile csmFile2 = csmFunction2.getContainingFile();
                if (csmFile == null) {
                    csmFile = csmFile2;
                    csmFunction = csmFunction2;
                    continue;
                }
                if (CharSequences.comparator().compare(csmFile.getAbsolutePath(), csmFile2.getAbsolutePath()) <= 0) continue;
                csmFile = csmFile2;
                csmFunction = csmFunction2;
            }
        }
        return csmFunction;
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, dataOutput);
        PersistentUtils.writeType(this.returnType, dataOutput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        PersistentUtils.writeParameterList(this.parameterList, dataOutput);
        PersistentUtils.writeStrings(this.rawName, dataOutput);
        uIDObjectFactory.writeUID(this.scopeUID, dataOutput);
        PersistentUtils.writeUTF(this.signature, dataOutput);
        dataOutput.writeByte(this.flags);
        PersistentUtils.writeUTF(this.getScopeSuffix(), dataOutput);
        PersistentUtils.writeTemplateDescriptor(this.templateDescriptor, dataOutput);
    }

    public FunctionImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.name = PersistentUtils.readUTF(dataInput, QualifiedNameCache.getManager());
        assert (this.name != null);
        this.returnType = PersistentUtils.readType(dataInput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        this.parameterList = (FunctionParameterListImpl)PersistentUtils.readParameterList(dataInput);
        this.rawName = PersistentUtils.readStrings(dataInput, NameCache.getManager());
        this.scopeUID = uIDObjectFactory.readUID(dataInput);
        this.scopeRef = null;
        this.signature = PersistentUtils.readUTF(dataInput, QualifiedNameCache.getManager());
        this.flags = dataInput.readByte();
        this.classTemplateSuffix = PersistentUtils.readUTF(dataInput, NameCache.getManager());
        this.templateDescriptor = PersistentUtils.readTemplateDescriptor(dataInput);
    }
}

