/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.ClassEnumBase;
import org.netbeans.modules.cnd.modelimpl.csm.EnumeratorImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;

public final class EnumImpl
extends ClassEnumBase<CsmEnum>
implements CsmEnum {
    private final List<CsmUID<CsmEnumerator>> enumerators;

    private EnumImpl(AST aST, NameHolder nameHolder, CsmFile csmFile) {
        super(nameHolder, csmFile, aST);
        this.enumerators = new ArrayList<CsmUID<CsmEnumerator>>();
    }

    private EnumImpl(String string, String string2, CsmFile csmFile, int n, int n2) {
        super(string, string2, csmFile, n, n2);
        this.enumerators = new ArrayList<CsmUID<CsmEnumerator>>();
    }

    private void init(CsmScope csmScope, AST aST, boolean bl) {
        this.initScope(csmScope);
        EnumImpl.temporaryRepositoryRegistration(bl, this);
        this.initEnumeratorList(aST, bl);
        if (bl) {
            this.register(csmScope, true);
        }
    }

    public static EnumImpl create(AST aST, CsmScope csmScope, CsmFile csmFile, boolean bl) {
        NameHolder nameHolder = NameHolder.createEnumName(aST);
        EnumImpl enumImpl = new EnumImpl(aST, nameHolder, csmFile);
        enumImpl.init(csmScope, aST, bl);
        nameHolder.addReference(csmFile, enumImpl);
        return enumImpl;
    }

    public static EnumImpl create(String string, String string2, CsmFile csmFile, CsmScope csmScope, int n, int n2, boolean bl) {
        EnumImpl enumImpl = new EnumImpl(string, string2, csmFile, n, n2);
        enumImpl.initScope(csmScope);
        EnumImpl.temporaryRepositoryRegistration(bl, enumImpl);
        if (bl) {
            enumImpl.register(csmScope, true);
        }
        return enumImpl;
    }

    void addEnumerator(String string, int n, int n2, boolean bl) {
        EnumeratorImpl enumeratorImpl = EnumeratorImpl.create(this, string, n, n2, bl);
        CsmUID<EnumeratorImpl> csmUID = UIDCsmConverter.objectToUID(enumeratorImpl);
        this.enumerators.add(csmUID);
    }

    private void initEnumeratorList(AST aST, boolean bl) {
        AST aST2;
        for (aST2 = aST.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
            if (aST2.getType() != 497) continue;
            this.addList(aST2, bl);
            return;
        }
        aST2 = aST.getNextSibling();
        if (aST2 != null) {
            AST aST3 = null;
            if (aST2.getType() == 90) {
                aST2 = aST2.getNextSibling();
            }
            if (aST2.getType() == 16) {
                aST3 = aST2.getNextSibling();
            }
            if (aST3 != null && aST3.getType() == 497) {
                this.addList(aST3, bl);
            }
        }
    }

    private void addList(AST aST, boolean bl) {
        for (AST aST2 = aST.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
            if (aST2.getType() != 90) continue;
            EnumeratorImpl enumeratorImpl = EnumeratorImpl.create(aST2, this, bl);
            CsmUID<EnumeratorImpl> csmUID = UIDCsmConverter.objectToUID(enumeratorImpl);
            this.enumerators.add(csmUID);
        }
    }

    public Collection<CsmEnumerator> getEnumerators() {
        Collection<CsmEnumerator> collection = UIDCsmConverter.UIDsToDeclarations(this.enumerators);
        return collection;
    }

    public Collection<CsmScopeElement> getScopeElements() {
        return this.getEnumerators();
    }

    @Override
    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.ENUM;
    }

    @Override
    public void dispose() {
        super.dispose();
        this._clearEnumerators();
    }

    private void _clearEnumerators() {
        Collection<CsmEnumerator> collection = this.getEnumerators();
        Utils.disposeAll(collection);
        RepositoryUtils.remove(this.enumerators);
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUIDCollection(this.enumerators, dataOutput, false);
    }

    public EnumImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        int n = dataInput.readInt();
        this.enumerators = n < 0 ? new ArrayList<CsmUID<CsmEnumerator>>(0) : new ArrayList<CsmUID<CsmEnumerator>>(n);
        UIDObjectFactory.getDefaultFactory().readUIDCollection(this.enumerators, dataInput, n);
    }
}

