/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriend;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.ClassEnumBase;
import org.netbeans.modules.cnd.modelimpl.csm.ClassForwardDeclarationImpl;
import org.netbeans.modules.cnd.modelimpl.csm.ClassImplSpecialization;
import org.netbeans.modules.cnd.modelimpl.csm.ConstructorDDImpl;
import org.netbeans.modules.cnd.modelimpl.csm.ConstructorImpl;
import org.netbeans.modules.cnd.modelimpl.csm.DeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.DestructorDDImpl;
import org.netbeans.modules.cnd.modelimpl.csm.DestructorImpl;
import org.netbeans.modules.cnd.modelimpl.csm.EnumImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FieldImpl;
import org.netbeans.modules.cnd.modelimpl.csm.ForwardClass;
import org.netbeans.modules.cnd.modelimpl.csm.FriendClassImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FriendFunctionDDImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FriendFunctionDefinitionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FriendFunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FriendFunctionImplEx;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.InheritanceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.MethodDDImpl;
import org.netbeans.modules.cnd.modelimpl.csm.MethodImpl;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateUtils;
import org.netbeans.modules.cnd.modelimpl.csm.TypeFactory;
import org.netbeans.modules.cnd.modelimpl.csm.TypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TypedefImpl;
import org.netbeans.modules.cnd.modelimpl.csm.UsingDeclarationImpl;
import org.netbeans.modules.cnd.modelimpl.csm.VariableImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.impl.services.SelectImpl;
import org.netbeans.modules.cnd.modelimpl.parser.CsmAST;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.openide.util.CharSequences;

public class ClassImpl
extends ClassEnumBase<CsmClass>
implements CsmClass,
CsmTemplate,
SelectImpl.FilterableMembers,
DeclarationsContainer {
    private final CsmDeclaration.Kind kind;
    private final List<CsmUID<CsmMember>> members;
    private final List<CsmUID<CsmFriend>> friends;
    private final ArrayList<CsmUID<CsmInheritance>> inheritances;
    private TemplateDescriptor templateDescriptor = null;
    private int leftBracketPos;
    private static final int CLASS_KIND = 1;
    private static final int UNION_KIND = 2;
    private static final int STRUCT_KIND = 3;

    protected ClassImpl(NameHolder nameHolder, AST aST, CsmFile csmFile) {
        this(nameHolder, aST, csmFile, ClassImpl.getStartOffset(aST), ClassImpl.getEndOffset(aST));
    }

    protected ClassImpl(NameHolder nameHolder, AST aST, CsmFile csmFile, int n, int n2) {
        super(nameHolder, csmFile, n, n2);
        this.members = new ArrayList<CsmUID<CsmMember>>();
        this.friends = new ArrayList<CsmUID<CsmFriend>>(0);
        this.inheritances = new ArrayList(0);
        this.kind = this.findKind(aST);
    }

    private ClassImpl(CsmFile csmFile, CsmScope csmScope, String string, CsmDeclaration.Kind kind, int n, int n2) {
        super(string, string, csmFile, n, n2);
        this.members = new ArrayList<CsmUID<CsmMember>>();
        this.friends = new ArrayList<CsmUID<CsmFriend>>(0);
        this.inheritances = new ArrayList(0);
        this.kind = kind;
        this.initScope(csmScope);
    }

    public static ClassImpl create(CsmFile csmFile, CsmScope csmScope, String string, CsmDeclaration.Kind kind, int n, int n2, boolean bl) {
        ClassImpl classImpl = new ClassImpl(csmFile, csmScope, string, kind, n, n2);
        ClassImpl.temporaryRepositoryRegistration(bl, classImpl);
        if (bl) {
            classImpl.register(classImpl.getScope(), false);
        }
        return classImpl;
    }

    protected void init(CsmScope csmScope, AST aST, boolean bl) {
        this.initScope(csmScope);
        ClassImpl.temporaryRepositoryRegistration(bl, this);
        this.initClassDefinition(csmScope);
        this.render(aST, !bl);
        if (bl) {
            this.register(this.getScope(), false);
        }
    }

    private void initClassDefinition(CsmScope csmScope) {
        ClassMemberForwardDeclaration classMemberForwardDeclaration = this.findClassDefinition(csmScope);
        if (classMemberForwardDeclaration != null && CsmKindUtilities.isClass((CsmObject)this)) {
            classMemberForwardDeclaration.setCsmClass(this);
            CsmClass csmClass = classMemberForwardDeclaration.getContainingClass();
            if (csmClass != null) {
                this.initScope((CsmScope)csmClass);
            }
        }
    }

    protected final void render(AST aST, boolean bl) {
        new ClassAstRenderer(this.getContainingFile(), CsmVisibility.PRIVATE, bl).render(aST);
        this.leftBracketPos = this.initLeftBracketPos(aST);
    }

    public final void fixFakeRender(CsmFile csmFile, CsmVisibility csmVisibility, AST aST, boolean bl) {
        new ClassAstRenderer(csmFile, csmVisibility, bl).render(aST);
    }

    protected static ClassImpl findExistingClassImplInContainer(DeclarationsContainer declarationsContainer, AST aST) {
        ClassImpl classImpl = null;
        if (declarationsContainer != null) {
            int n;
            CharSequence charSequence = CharSequences.create((CharSequence)AstUtil.findId(aST, 17, true));
            charSequence = charSequence == null ? CharSequences.empty() : charSequence;
            int n2 = ClassImpl.getStartOffset(aST);
            CsmOffsetableDeclaration csmOffsetableDeclaration = declarationsContainer.findExistingDeclaration(n2, n = ClassImpl.getEndOffset(aST), charSequence);
            if (csmOffsetableDeclaration instanceof ClassImpl) {
                classImpl = (ClassImpl)csmOffsetableDeclaration;
            }
        }
        return classImpl;
    }

    public static ClassImpl create(AST aST, CsmScope csmScope, CsmFile csmFile, boolean bl, DeclarationsContainer declarationsContainer) {
        ClassImpl classImpl = ClassImpl.findExistingClassImplInContainer(declarationsContainer, aST);
        if (classImpl != null && !ClassImpl.class.equals(classImpl.getClass())) {
            classImpl = null;
        }
        NameHolder nameHolder = null;
        if (classImpl == null) {
            nameHolder = NameHolder.createClassName(aST);
            classImpl = new ClassImpl(nameHolder, aST, csmFile);
        }
        classImpl.init(csmScope, aST, bl);
        if (nameHolder != null) {
            nameHolder.addReference(csmFile, classImpl);
        }
        return classImpl;
    }

    protected void setTemplateDescriptor(TemplateDescriptor templateDescriptor) {
        this.templateDescriptor = templateDescriptor;
    }

    @Override
    public CsmDeclaration.Kind getKind() {
        return this.kind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmMember> getMembers() {
        Collection<CsmMember> collection;
        List<CsmUID<CsmMember>> list = this.members;
        synchronized (list) {
            collection = UIDCsmConverter.UIDsToDeclarations(this.members);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<CsmMember> getMembers(CsmSelect.CsmFilter csmFilter) {
        ArrayList arrayList = new ArrayList();
        List<CsmUID<CsmMember>> list = this.members;
        synchronized (list) {
            arrayList.addAll(this.members);
        }
        return UIDCsmConverter.UIDsToDeclarations(arrayList, csmFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmFriend> getFriends() {
        Collection<CsmFriend> collection;
        List<CsmUID<CsmFriend>> list = this.friends;
        synchronized (list) {
            collection = UIDCsmConverter.UIDsToDeclarations(this.friends);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmInheritance> getBaseClasses() {
        Collection<CsmInheritance> collection;
        ArrayList<CsmUID<CsmInheritance>> arrayList = this.inheritances;
        synchronized (arrayList) {
            collection = UIDCsmConverter.UIDsToInheritances(this.inheritances);
        }
        return collection;
    }

    public boolean isTemplate() {
        return this.templateDescriptor != null;
    }

    public boolean isSpecialization() {
        return false;
    }

    public boolean isExplicitSpecialization() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CsmOffsetableDeclaration findExistingDeclaration(int n, int n2, CharSequence charSequence) {
        CsmUID csmUID = null;
        List<CsmUID<CsmMember>> list = this.members;
        synchronized (list) {
            csmUID = UIDUtilities.findExistingUIDInList(this.members, n, n2, charSequence);
        }
        if (csmUID == null) {
            list = this.friends;
            synchronized (list) {
                csmUID = UIDUtilities.findExistingUIDInList(this.friends, n, n2, charSequence);
            }
        }
        return (CsmOffsetableDeclaration)UIDCsmConverter.UIDtoDeclaration(csmUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMember(CsmMember csmMember, boolean bl) {
        if (bl) {
            RepositoryUtils.put(csmMember);
        }
        CsmUID<CsmMember> csmUID = UIDCsmConverter.declarationToUID(csmMember);
        assert (csmUID != null);
        List<CsmUID<CsmMember>> list = this.members;
        synchronized (list) {
            UIDUtilities.insertIntoSortedUIDList(csmUID, this.members);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInheritance(CsmInheritance csmInheritance, boolean bl) {
        if (bl) {
            RepositoryUtils.put(csmInheritance);
        }
        CsmUID<CsmInheritance> csmUID = UIDCsmConverter.inheritanceToUID(csmInheritance);
        assert (csmUID != null);
        ArrayList<CsmUID<CsmInheritance>> arrayList = this.inheritances;
        synchronized (arrayList) {
            UIDUtilities.insertIntoSortedUIDList(csmUID, this.inheritances);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFriend(CsmFriend csmFriend, boolean bl) {
        if (bl) {
            RepositoryUtils.put(csmFriend);
        }
        CsmUID<CsmFriend> csmUID = UIDCsmConverter.declarationToUID(csmFriend);
        assert (csmUID != null);
        List<CsmUID<CsmFriend>> list = this.friends;
        synchronized (list) {
            UIDUtilities.insertIntoSortedUIDList(csmUID, this.friends);
        }
    }

    private int initLeftBracketPos(AST aST) {
        AST aST2 = AstUtil.findChildOfType(aST, 16);
        return aST2 instanceof CsmAST ? ((CsmAST)aST2).getOffset() : this.getStartOffset();
    }

    public int getLeftBracketOffset() {
        return this.leftBracketPos;
    }

    public Collection<CsmScopeElement> getScopeElements() {
        return this.getMembers();
    }

    @Override
    public void dispose() {
        super.dispose();
        this._clearMembers();
        this._clearFriends();
        this._clearInheritances();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _clearMembers() {
        Collection<CsmMember> collection = this.getMembers();
        Utils.disposeAll(collection);
        List<CsmUID<CsmMember>> list = this.members;
        synchronized (list) {
            RepositoryUtils.remove(this.members);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _clearInheritances() {
        Collection<CsmInheritance> collection = this.getBaseClasses();
        Utils.disposeAll(collection);
        ArrayList<CsmUID<CsmInheritance>> arrayList = this.inheritances;
        synchronized (arrayList) {
            RepositoryUtils.remove(this.inheritances);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _clearFriends() {
        Collection<CsmFriend> collection = this.getFriends();
        Utils.disposeAll(collection);
        List<CsmUID<CsmFriend>> list = this.friends;
        synchronized (list) {
            RepositoryUtils.remove(this.friends);
        }
    }

    private CsmDeclaration.Kind findKind(AST aST) {
        for (AST aST2 = aST.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
            switch (aST2.getType()) {
                case 157: {
                    return CsmDeclaration.Kind.CLASS;
                }
                case 159: {
                    return CsmDeclaration.Kind.UNION;
                }
                case 158: {
                    return CsmDeclaration.Kind.STRUCT;
                }
            }
        }
        return CsmDeclaration.Kind.CLASS;
    }

    public CharSequence getDisplayName() {
        return this.templateDescriptor != null ? CharSequences.create((CharSequence)(((Object)this.getName()).toString() + this.templateDescriptor.getTemplateSuffix())) : this.getName();
    }

    public List<CsmTemplateParameter> getTemplateParameters() {
        return this.templateDescriptor != null ? this.templateDescriptor.getTemplateParameters() : Collections.emptyList();
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        assert (this.kind != null);
        ClassImpl.writeKind(this.kind, dataOutput);
        PersistentUtils.writeTemplateDescriptor(this.templateDescriptor, dataOutput);
        dataOutput.writeInt(this.leftBracketPos);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        uIDObjectFactory.writeUIDCollection(this.members, dataOutput, true);
        uIDObjectFactory.writeUIDCollection(this.friends, dataOutput, true);
        uIDObjectFactory.writeUIDCollection(this.inheritances, dataOutput, true);
    }

    public ClassImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.kind = ClassImpl.readKind(dataInput);
        this.templateDescriptor = PersistentUtils.readTemplateDescriptor(dataInput);
        this.leftBracketPos = dataInput.readInt();
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        int n = dataInput.readInt();
        this.members = n <= 0 ? new ArrayList<CsmUID<CsmMember>>(0) : new ArrayList<CsmUID<CsmMember>>(n);
        uIDObjectFactory.readUIDCollection(this.members, dataInput, n);
        n = dataInput.readInt();
        this.friends = n <= 0 ? new ArrayList<CsmUID<CsmFriend>>(0) : new ArrayList<CsmUID<CsmFriend>>(n);
        uIDObjectFactory.readUIDCollection(this.friends, dataInput, n);
        n = dataInput.readInt();
        this.inheritances = n <= 0 ? new ArrayList(0) : new ArrayList(n);
        uIDObjectFactory.readUIDCollection(this.inheritances, dataInput, n);
    }

    private static void writeKind(CsmDeclaration.Kind kind, DataOutput dataOutput) throws IOException {
        int n;
        if (kind == CsmDeclaration.Kind.CLASS) {
            n = 1;
        } else if (kind == CsmDeclaration.Kind.UNION) {
            n = 2;
        } else {
            assert (kind == CsmDeclaration.Kind.STRUCT);
            n = 3;
        }
        dataOutput.writeByte(n);
    }

    private static CsmDeclaration.Kind readKind(DataInput dataInput) throws IOException {
        CsmDeclaration.Kind kind;
        byte by = dataInput.readByte();
        switch (by) {
            case 1: {
                kind = CsmDeclaration.Kind.CLASS;
                break;
            }
            case 2: {
                kind = CsmDeclaration.Kind.UNION;
                break;
            }
            case 3: {
                kind = CsmDeclaration.Kind.STRUCT;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal handler " + by);
            }
        }
        return kind;
    }

    public static final class ClassMemberForwardDeclaration
    extends ClassForwardDeclarationImpl
    implements CsmMember,
    CsmClassifier {
        private final CsmVisibility visibility;
        private CsmUID<CsmClass> classDefinition;
        private final CsmUID<CsmClass> containerUID;
        private CsmClass containerRef;

        private ClassMemberForwardDeclaration(CsmClass csmClass, AST aST, CsmVisibility csmVisibility, boolean bl) {
            super(aST, csmClass.getContainingFile(), bl);
            this.visibility = csmVisibility;
            this.containerUID = UIDCsmConverter.declarationToUID(csmClass);
        }

        public static ClassMemberForwardDeclaration create(CsmClass csmClass, AST aST, CsmVisibility csmVisibility, boolean bl) {
            ClassMemberForwardDeclaration classMemberForwardDeclaration = new ClassMemberForwardDeclaration(csmClass, aST, csmVisibility, bl);
            ClassMemberForwardDeclaration.postObjectCreateRegistration(bl, classMemberForwardDeclaration);
            return classMemberForwardDeclaration;
        }

        @Override
        protected final boolean registerInProject() {
            CsmProject csmProject = this.getContainingFile().getProject();
            if (csmProject instanceof ProjectBase) {
                return ((ProjectBase)csmProject).registerDeclaration(this);
            }
            return false;
        }

        private void unregisterInProject() {
            CsmProject csmProject = this.getContainingFile().getProject();
            if (csmProject instanceof ProjectBase) {
                ((ProjectBase)csmProject).unregisterDeclaration(this);
                this.cleanUID();
            }
        }

        @Override
        public void dispose() {
            super.dispose();
            this.onDispose();
            CsmScope csmScope = this.getScope();
            if (csmScope instanceof MutableDeclarationsContainer) {
                ((MutableDeclarationsContainer)csmScope).removeDeclaration(this);
            }
            this.unregisterInProject();
        }

        public boolean isStatic() {
            return false;
        }

        public CsmVisibility getVisibility() {
            return this.visibility;
        }

        private void onDispose() {
            if (this.containerRef == null) {
                this.containerRef = UIDCsmConverter.UIDtoClass(this.containerUID);
            }
        }

        public CsmClass getContainingClass() {
            CsmClass csmClass = this.containerRef;
            if (csmClass == null) {
                csmClass = this.containerRef = UIDCsmConverter.UIDtoClass(this.containerUID);
            }
            return csmClass;
        }

        @Override
        public CsmScope getScope() {
            return this.getContainingClass();
        }

        @Override
        public CsmClass getCsmClass() {
            CsmClass csmClass = UIDCsmConverter.UIDtoClass(this.classDefinition);
            if (csmClass != null && csmClass.isValid() && !ForwardClass.isForwardClass((CsmDeclaration)csmClass)) {
                return csmClass;
            }
            csmClass = super.getCsmClass();
            this.setCsmClass(csmClass);
            return csmClass;
        }

        @Override
        protected CsmClass createForwardClassIfNeed(AST aST, CsmScope csmScope, boolean bl) {
            CsmClass csmClass = super.createForwardClassIfNeed(aST, csmScope, bl);
            this.classDefinition = UIDCsmConverter.declarationToUID(csmClass);
            if (csmClass != null) {
                RepositoryUtils.put(this);
            }
            return csmClass;
        }

        public void setCsmClass(CsmClass csmClass) {
            this.classDefinition = UIDCsmConverter.declarationToUID(csmClass);
        }

        @Override
        public CharSequence getQualifiedName() {
            CsmClass csmClass = this.getContainingClass();
            if (csmClass == null) {
                csmClass = this.getContainingClass();
            }
            return CharSequences.create((CharSequence)(csmClass.getQualifiedName() + "::" + this.getName()));
        }

        @Override
        public void write(DataOutput dataOutput) throws IOException {
            super.write(dataOutput);
            assert (this.visibility != null);
            PersistentUtils.writeVisibility(this.visibility, dataOutput);
            assert (this.containerUID != null);
            UIDObjectFactory.getDefaultFactory().writeUID(this.containerUID, dataOutput);
            UIDObjectFactory.getDefaultFactory().writeUID(this.classDefinition, dataOutput);
        }

        public ClassMemberForwardDeclaration(DataInput dataInput) throws IOException {
            super(dataInput);
            this.visibility = PersistentUtils.readVisibility(dataInput);
            assert (this.visibility != null);
            this.containerUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
            assert (this.containerUID != null);
            this.classDefinition = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
        }
    }

    public static final class MemberTypedef
    extends TypedefImpl
    implements CsmMember {
        private final CsmVisibility visibility;

        private MemberTypedef(CsmClass csmClass, AST aST, CsmType csmType, CharSequence charSequence, CsmVisibility csmVisibility) {
            super(aST, csmClass.getContainingFile(), (CsmObject)csmClass, csmType, charSequence);
            this.visibility = csmVisibility;
        }

        public static MemberTypedef create(CsmClass csmClass, AST aST, CsmType csmType, CharSequence charSequence, CsmVisibility csmVisibility, boolean bl) {
            MemberTypedef memberTypedef = new MemberTypedef(csmClass, aST, csmType, charSequence, csmVisibility);
            if (!bl) {
                Utils.setSelfUID(memberTypedef);
            }
            return memberTypedef;
        }

        public boolean isStatic() {
            return false;
        }

        public CsmVisibility getVisibility() {
            return this.visibility;
        }

        public CsmClass getContainingClass() {
            return (CsmClass)this.getScope();
        }

        @Override
        public void write(DataOutput dataOutput) throws IOException {
            super.write(dataOutput);
            assert (this.visibility != null);
            PersistentUtils.writeVisibility(this.visibility, dataOutput);
        }

        public MemberTypedef(DataInput dataInput) throws IOException {
            super(dataInput);
            this.visibility = PersistentUtils.readVisibility(dataInput);
            assert (this.visibility != null);
        }
    }

    private class ClassAstRenderer
    extends AstRenderer {
        private final boolean renderingLocalContext;
        private CsmVisibility curentVisibility;

        public ClassAstRenderer(CsmFile csmFile, CsmVisibility csmVisibility, boolean bl) {
            super((FileImpl)csmFile);
            this.renderingLocalContext = bl;
            this.curentVisibility = csmVisibility;
        }

        @Override
        protected boolean isRenderingLocalContext() {
            return this.renderingLocalContext;
        }

        protected VariableImpl<CsmField> createVariable(AST aST, CsmFile csmFile, CsmType csmType, NameHolder nameHolder, boolean bl, boolean bl2, MutableDeclarationsContainer mutableDeclarationsContainer, MutableDeclarationsContainer mutableDeclarationsContainer2, CsmScope csmScope) {
            csmType = TemplateUtils.checkTemplateType(csmType, (CsmScope)ClassImpl.this);
            FieldImpl fieldImpl = FieldImpl.create(aST, csmFile, csmType, nameHolder, ClassImpl.this, this.curentVisibility, bl, bl2, !this.isRenderingLocalContext());
            ClassImpl.this.addMember((CsmMember)fieldImpl, !this.isRenderingLocalContext());
            return fieldImpl;
        }

        @Override
        public void render(AST aST) {
            block43: for (AST aST2 = aST.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
                switch (aST2.getType()) {
                    case 115: {
                        Object object = TemplateUtils.getTemplateParameters(aST2, this.getContainingFile(), (CsmScope)ClassImpl.this, !this.isRenderingLocalContext());
                        Iterator<CsmTypedef> iterator = TemplateUtils.getClassSpecializationSuffix(aST2, null);
                        String astRendererException = "<" + (String)((Object)iterator) + ">";
                        this.setTemplateDescriptor((List<CsmTemplateParameter>)object, astRendererException, !((String)((Object)iterator)).isEmpty());
                        continue block43;
                    }
                    case 540: {
                        ClassImpl.this.addInheritance(InheritanceImpl.create(aST2, this.getContainingFile(), (CsmScope)ClassImpl.this), !this.isRenderingLocalContext());
                        continue block43;
                    }
                    case 157: {
                        continue block43;
                    }
                    case 159: {
                        this.curentVisibility = CsmVisibility.PUBLIC;
                        continue block43;
                    }
                    case 158: {
                        this.curentVisibility = CsmVisibility.PUBLIC;
                        continue block43;
                    }
                    case 163: {
                        this.curentVisibility = CsmVisibility.PUBLIC;
                        continue block43;
                    }
                    case 165: {
                        this.curentVisibility = CsmVisibility.PRIVATE;
                        continue block43;
                    }
                    case 164: {
                        this.curentVisibility = CsmVisibility.PROTECTED;
                        continue block43;
                    }
                    case 457: 
                    case 477: {
                        Object object = TemplateUtils.isPartialClassSpecialization(aST2) ? ClassImplSpecialization.create(aST2, (CsmScope)ClassImpl.this, this.getContainingFile(), !this.isRenderingLocalContext(), ClassImpl.this) : ClassImpl.create(aST2, (CsmScope)ClassImpl.this, this.getContainingFile(), !this.isRenderingLocalContext(), ClassImpl.this);
                        ((ClassEnumBase)object).setVisibility(this.curentVisibility);
                        ClassImpl.this.addMember((CsmMember)object, !this.isRenderingLocalContext());
                        AstRenderer.Pair pair = this.renderTypedef(aST2, (CsmClass)object, ClassImpl.this);
                        if (!pair.getTypesefs().isEmpty()) {
                            for (CsmTypedef astRendererException : pair.getTypesefs()) {
                                if (!this.isRenderingLocalContext()) {
                                    ((FileImpl)this.getContainingFile()).getProjectImpl(true).registerDeclaration((CsmOffsetableDeclaration)astRendererException);
                                }
                                ClassImpl.this.addMember((MemberTypedef)astRendererException, !this.isRenderingLocalContext());
                                if (pair.getEnclosingClassifier() == null) continue;
                                pair.getEnclosingClassifier().addEnclosingTypedef(astRendererException);
                            }
                            if (pair.getEnclosingClassifier() != null && !ForwardClass.isForwardClass(pair.getEnclosingClassifier())) {
                                ClassImpl.this.addMember(pair.getEnclosingClassifier(), !this.isRenderingLocalContext());
                            }
                        }
                        this.renderVariableInClassifier(aST2, (ClassEnumBase<?>)object, null, null);
                        continue block43;
                    }
                    case 458: {
                        Iterator<CsmTypedef> iterator = EnumImpl.create(aST2, (CsmScope)ClassImpl.this, this.getContainingFile(), !this.isRenderingLocalContext());
                        ((ClassEnumBase)((Object)iterator)).setVisibility(this.curentVisibility);
                        ClassImpl.this.addMember((CsmMember)iterator, !this.isRenderingLocalContext());
                        this.renderVariableInClassifier(aST2, (ClassEnumBase<?>)((Object)iterator), null, null);
                        continue block43;
                    }
                    case 483: 
                    case 484: {
                        try {
                            ClassImpl.this.addMember((CsmMember)ConstructorDDImpl.createConstructor(aST2, ClassImpl.this, this.curentVisibility, !this.isRenderingLocalContext()), !this.isRenderingLocalContext());
                        }
                        catch (AstRendererException astRendererException) {
                            DiagnosticExceptoins.register(astRendererException);
                        }
                        continue block43;
                    }
                    case 460: 
                    case 461: {
                        try {
                            ClassImpl.this.addMember((CsmMember)ConstructorImpl.createConstructor(aST2, ClassImpl.this, this.curentVisibility, !this.isRenderingLocalContext()), !this.isRenderingLocalContext());
                        }
                        catch (AstRendererException astRendererException) {
                            DiagnosticExceptoins.register(astRendererException);
                        }
                        continue block43;
                    }
                    case 480: 
                    case 481: {
                        try {
                            ClassImpl.this.addMember((CsmMember)DestructorDDImpl.createDestructor(aST2, ClassImpl.this, this.curentVisibility, !this.isRenderingLocalContext()), !this.isRenderingLocalContext());
                        }
                        catch (AstRendererException astRendererException) {
                            DiagnosticExceptoins.register(astRendererException);
                        }
                        continue block43;
                    }
                    case 482: {
                        try {
                            ClassImpl.this.addMember((CsmMember)DestructorImpl.createDestructor(aST2, ClassImpl.this, this.curentVisibility, !this.isRenderingLocalContext()), !this.isRenderingLocalContext());
                        }
                        catch (AstRendererException astRendererException) {
                            DiagnosticExceptoins.register(astRendererException);
                        }
                        continue block43;
                    }
                    case 492: {
                        ClassMemberForwardDeclaration astRendererException;
                        FunctionImpl functionImpl2;
                        AST aST3 = aST2.getFirstChild();
                        if (this.hasFriendPrefix(aST3)) {
                            try {
                                ClassImpl.this.addFriend(this.renderFriendClass(aST2), !this.isRenderingLocalContext());
                            }
                            catch (AstRendererException astRendererException2) {
                                DiagnosticExceptoins.register(astRendererException2);
                            }
                            continue block43;
                        }
                        if (this.renderVariable(aST2, null, null, false)) continue block43;
                        AstRenderer.Pair pair = this.renderTypedef(aST2, (FileImpl)this.getContainingFile(), (CsmScope)ClassImpl.this, null);
                        if (!pair.getTypesefs().isEmpty()) {
                            for (FunctionImpl functionImpl2 : pair.getTypesefs()) {
                                if (!this.isRenderingLocalContext()) {
                                    ((FileImpl)this.getContainingFile()).getProjectImpl(true).registerDeclaration(functionImpl2);
                                }
                                ClassImpl.this.addMember((MemberTypedef)((Object)functionImpl2), !this.isRenderingLocalContext());
                                if (pair.getEnclosingClassifier() == null) continue;
                                pair.getEnclosingClassifier().addEnclosingTypedef((CsmTypedef)functionImpl2);
                            }
                            if (pair.getEnclosingClassifier() == null || ForwardClass.isForwardClass(pair.getEnclosingClassifier())) continue block43;
                            ClassImpl.this.addMember(pair.getEnclosingClassifier(), !this.isRenderingLocalContext());
                            continue block43;
                        }
                        if (this.renderBitField(aST2) || (astRendererException = this.renderClassForwardDeclaration(aST2)) == null) continue block43;
                        ClassImpl.this.addMember(astRendererException, !this.isRenderingLocalContext());
                        astRendererException.init(aST2, (CsmScope)ClassImpl.this, !this.isRenderingLocalContext());
                        continue block43;
                    }
                    case 500: {
                        UsingDeclarationImpl astRendererException = UsingDeclarationImpl.create(aST2, this.getContainingFile(), (CsmScope)ClassImpl.this, !this.isRenderingLocalContext(), this.curentVisibility);
                        ClassImpl.this.addMember(astRendererException, !this.isRenderingLocalContext());
                        continue block43;
                    }
                    case 490: {
                        AST aST3 = aST2.getFirstChild();
                        if (this.hasFriendPrefix(aST3)) {
                            try {
                                ClassImpl.this.addFriend(this.renderFriendClass(aST2), !this.isRenderingLocalContext());
                            }
                            catch (AstRendererException astRendererException) {
                                DiagnosticExceptoins.register(astRendererException);
                            }
                            continue block43;
                        }
                        ClassMemberForwardDeclaration classMemberForwardDeclaration = this.renderClassForwardDeclaration(aST2);
                        if (classMemberForwardDeclaration == null) continue block43;
                        ClassImpl.this.addMember(classMemberForwardDeclaration, !this.isRenderingLocalContext());
                        classMemberForwardDeclaration.init(aST2, (CsmScope)ClassImpl.this, !this.isRenderingLocalContext());
                        continue block43;
                    }
                    case 462: 
                    case 464: 
                    case 466: 
                    case 485: 
                    case 486: {
                        FunctionImpl functionImpl;
                        FunctionImpl functionImpl3;
                        FunctionImpl functionImpl2;
                        AST aST3 = aST2.getFirstChild();
                        if (aST3 == null) continue block43;
                        if (this.hasFriendPrefix(aST3)) {
                            try {
                                CsmScope csmScope = this.getFriendScope();
                                if (this.isMemberDefinition(aST2)) {
                                    functionImpl = functionImpl3 = FriendFunctionImplEx.create(aST2, ClassImpl.this, csmScope, !this.isRenderingLocalContext());
                                    functionImpl2 = functionImpl3;
                                } else {
                                    functionImpl2 = functionImpl3 = FriendFunctionImpl.create(aST2, ClassImpl.this, csmScope, !this.isRenderingLocalContext());
                                    functionImpl = functionImpl3;
                                    if (csmScope instanceof NamespaceImpl) {
                                        ((NamespaceImpl)csmScope).addDeclaration(functionImpl);
                                    } else {
                                        ((NamespaceImpl)this.getContainingFile().getProject().getGlobalNamespace()).addDeclaration(functionImpl);
                                    }
                                }
                                ClassImpl.this.addFriend((CsmFriend)functionImpl2, !this.isRenderingLocalContext());
                            }
                            catch (AstRendererException astRendererException) {
                                DiagnosticExceptoins.register(astRendererException);
                            }
                            continue block43;
                        }
                        try {
                            ClassImpl.this.addMember((CsmMember)MethodImpl.create(aST2, ClassImpl.this, this.curentVisibility, !this.isRenderingLocalContext()), !this.isRenderingLocalContext());
                        }
                        catch (AstRendererException astRendererException) {
                            DiagnosticExceptoins.register(astRendererException);
                        }
                        continue block43;
                    }
                    case 463: 
                    case 465: 
                    case 467: 
                    case 487: 
                    case 488: {
                        FunctionImpl functionImpl;
                        FunctionImpl functionImpl3;
                        FunctionImpl functionImpl2;
                        AST aST3 = aST2.getFirstChild();
                        if (this.hasFriendPrefix(aST3)) {
                            try {
                                CsmScope csmScope = this.getFriendScope();
                                if (this.isMemberDefinition(aST2)) {
                                    functionImpl = functionImpl3 = FriendFunctionDefinitionImpl.create(aST2, ClassImpl.this, null, !this.isRenderingLocalContext());
                                    functionImpl2 = functionImpl3;
                                } else {
                                    functionImpl2 = functionImpl3 = FriendFunctionDDImpl.create(aST2, ClassImpl.this, csmScope, !this.isRenderingLocalContext());
                                    functionImpl = functionImpl3;
                                    if (csmScope instanceof NamespaceImpl) {
                                        ((NamespaceImpl)csmScope).addDeclaration(functionImpl);
                                    } else {
                                        ((NamespaceImpl)this.getContainingFile().getProject().getGlobalNamespace()).addDeclaration(functionImpl);
                                    }
                                }
                                ClassImpl.this.addFriend((CsmFriend)functionImpl2, !this.isRenderingLocalContext());
                            }
                            catch (AstRendererException astRendererException) {
                                DiagnosticExceptoins.register(astRendererException);
                            }
                            continue block43;
                        }
                        try {
                            ClassImpl.this.addMember((CsmMember)MethodDDImpl.create(aST2, ClassImpl.this, this.curentVisibility, !this.isRenderingLocalContext()), !this.isRenderingLocalContext());
                        }
                        catch (AstRendererException astRendererException) {
                            DiagnosticExceptoins.register(astRendererException);
                        }
                        continue block43;
                    }
                    case 493: {
                        UsingDeclarationImpl usingDeclarationImpl = UsingDeclarationImpl.create(aST2, this.getContainingFile(), (CsmScope)ClassImpl.this, !this.isRenderingLocalContext(), this.curentVisibility);
                        ClassImpl.this.addMember(usingDeclarationImpl, !this.isRenderingLocalContext());
                        continue block43;
                    }
                    case 17: {
                        continue block43;
                    }
                }
            }
            this.checkInnerIncludes(ClassImpl.this, ClassImpl.this.getMembers());
        }

        private CsmScope getFriendScope() {
            CsmScope csmScope;
            CsmScope csmScope2 = ClassImpl.this.getScope();
            while (CsmKindUtilities.isClass((CsmObject)csmScope2) && (csmScope = ((CsmClass)csmScope2).getScope()) != null) {
                csmScope2 = csmScope;
            }
            return csmScope2;
        }

        private void setTemplateDescriptor(List<CsmTemplateParameter> list, String string, boolean bl) {
            ClassImpl.this.templateDescriptor = new TemplateDescriptor(list, string, bl, !this.isRenderingLocalContext());
        }

        private boolean hasFriendPrefix(AST aST) {
            AST aST2;
            if (aST == null) {
                return false;
            }
            if (aST.getType() == 126) {
                return true;
            }
            return aST.getType() == 115 && (aST2 = aST.getNextSibling()) != null && aST2.getType() == 126;
        }

        private CsmFriend renderFriendClass(AST aST) throws AstRendererException {
            AST aST2 = aST.getFirstChild();
            AST aST3 = aST2;
            if (aST3.getType() == 126) {
                aST3 = aST3.getNextSibling();
            }
            if (aST3 != null && aST3.getType() == 115) {
                aST3 = aST3.getNextSibling();
            }
            CsmClassForwardDeclaration csmClassForwardDeclaration = null;
            AST aST4 = null;
            if (aST3 != null && (aST3.getType() == 158 || aST3.getType() == 157)) {
                AST aST5;
                aST4 = AstUtil.findChildOfType(aST, 503);
                CharSequence[] charSequenceArray = AstRenderer.getNameTokens(aST4);
                if (charSequenceArray != null && charSequenceArray.length == 1 && (aST5 = TemplateUtils.getTemplateStart(aST.getFirstChild())) == null) {
                    CsmScope csmScope = ClassImpl.this.getScope();
                    while (!CsmKindUtilities.isNamespace((Object)csmScope) && CsmKindUtilities.isScopeElement((CsmObject)csmScope)) {
                        csmScope = ((CsmScopeElement)csmScope).getScope();
                    }
                    if (!CsmKindUtilities.isNamespace((Object)csmScope)) {
                        csmScope = this.getContainingFile().getProject().getGlobalNamespace();
                    }
                    csmClassForwardDeclaration = super.createForwardClassDeclaration(aST, null, (FileImpl)this.getContainingFile(), csmScope);
                    RepositoryUtils.put(csmClassForwardDeclaration);
                    ((NamespaceImpl)csmScope).addDeclaration((CsmOffsetableDeclaration)csmClassForwardDeclaration);
                }
            } else {
                aST4 = aST3 != null && aST3.getType() == 470 ? aST3 : AstUtil.findChildOfType(aST, 503);
            }
            return FriendClassImpl.create(aST2, aST4, csmClassForwardDeclaration, (FileImpl)this.getContainingFile(), ClassImpl.this, !this.isRenderingLocalContext());
        }

        private ClassMemberForwardDeclaration renderClassForwardDeclaration(AST aST) {
            AST aST2 = aST.getFirstChild();
            if (aST2 == null) {
                return null;
            }
            if (aST2.getType() == 115) {
                aST2 = aST2.getNextSibling();
            }
            if (aST2 == null || aST2.getType() != 158 && aST2.getType() != 157) {
                return null;
            }
            AST aST3 = aST2.getNextSibling();
            if (aST3 == null || aST3.getType() != 503) {
                return null;
            }
            return ClassMemberForwardDeclaration.create(ClassImpl.this, aST, this.curentVisibility, !this.isRenderingLocalContext());
        }

        private boolean renderBitField(AST aST) {
            AST aST2 = aST.getFirstChild();
            if (aST2 == null) {
                return false;
            }
            if (aST2.getType() != 469) {
                if (aST2.getType() == 117) {
                    aST2 = aST2.getNextSibling();
                }
                if (aST2 == null || aST2.getType() != 470) {
                    return false;
                }
            }
            TypeImpl typeImpl = TypeFactory.createType(aST2, this.getContainingFile(), null, 0);
            boolean bl = this.renderBitFieldImpl(aST, aST2.getNextSibling(), typeImpl, null);
            return bl;
        }

        @Override
        protected boolean renderBitFieldImpl(AST aST, AST aST2, CsmType csmType, ClassEnumBase<?> classEnumBase) {
            boolean bl = true;
            boolean bl2 = false;
            AST aST3 = aST;
            AST aST4 = aST2;
            while (bl) {
                AST aST5;
                AST aST6;
                boolean bl3 = false;
                if (aST2 == null) break;
                if (aST2.getType() == 90) {
                    aST6 = aST2.getNextSibling();
                } else {
                    if (aST2.getType() != 7) break;
                    aST6 = aST2;
                    bl3 = true;
                }
                if (aST6 == null || aST6.getType() != 7 || (aST5 = aST6.getNextSibling()) == null || aST5.getType() != 528) break;
                aST4 = aST5.getNextSibling();
                if (aST4 != null && aST4.getType() == 8) {
                    aST3 = aST2;
                } else {
                    bl = false;
                    if (bl2) {
                        aST3 = aST2;
                    }
                }
                if (!bl3) {
                    NameHolder nameHolder = NameHolder.createSimpleName(aST2);
                    FieldImpl fieldImpl = FieldImpl.create(aST3, this.getContainingFile(), csmType, nameHolder, ClassImpl.this, this.curentVisibility, !this.isRenderingLocalContext());
                    ClassImpl.this.addMember((CsmMember)fieldImpl, !this.isRenderingLocalContext());
                    if (classEnumBase != null) {
                        classEnumBase.addEnclosingVariable(fieldImpl);
                    }
                }
                bl2 = true;
                if (!bl) continue;
                aST2 = aST4.getNextSibling();
            }
            return bl2;
        }

        @Override
        protected CsmTypedef createTypedef(AST aST, FileImpl fileImpl, CsmObject csmObject, CsmType csmType, CharSequence charSequence) {
            csmType = TemplateUtils.checkTemplateType(csmType, (CsmScope)ClassImpl.this);
            return MemberTypedef.create(ClassImpl.this, aST, csmType, charSequence, this.curentVisibility, !this.isRenderingLocalContext());
        }

        @Override
        protected CsmClassForwardDeclaration createForwardClassDeclaration(AST aST, MutableDeclarationsContainer mutableDeclarationsContainer, FileImpl fileImpl, CsmScope csmScope) {
            ClassMemberForwardDeclaration classMemberForwardDeclaration = ClassMemberForwardDeclaration.create(ClassImpl.this, aST, this.curentVisibility, !this.isRenderingLocalContext());
            ClassImpl.this.addMember(classMemberForwardDeclaration, !this.isRenderingLocalContext());
            classMemberForwardDeclaration.init(aST, (CsmScope)ClassImpl.this, !this.isRenderingLocalContext());
            return classMemberForwardDeclaration;
        }
    }
}

