/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el;

public class ELPreprocessor {
    public static String[][] XML_ENTITY_REFS_CONVERSION_TABLE = new String[][]{{"&amp;", "&"}, {"&gt;", ">"}, {"&lt;", "<"}, {"&quot;", "\""}, {"&apos;", "'"}};
    private final String originalExpression;
    private final String[][] conversionTable;
    private String preprocessedExpression;
    private final boolean[] diffs;

    public ELPreprocessor(String expression, String[][] conversionTable) {
        this.originalExpression = expression;
        this.conversionTable = conversionTable;
        this.diffs = new boolean[this.originalExpression.length()];
        this.init();
    }

    public String getOriginalExpression() {
        return this.originalExpression;
    }

    public String getPreprocessedExpression() {
        return this.preprocessedExpression;
    }

    public int getOriginalOffset(int preprocessedELoffset) {
        int diff = 0;
        for (int i = 0; i < this.originalExpression.length(); ++i) {
            int pointer = i + diff;
            if (pointer == preprocessedELoffset) {
                return i;
            }
            diff += this.diffs[i] ? -1 : 0;
        }
        assert (preprocessedELoffset == this.preprocessedExpression.length());
        return this.originalExpression.length();
    }

    public int getPreprocessedOffset(int originalOffset) {
        int diff = 0;
        for (int i = 0; i < originalOffset; ++i) {
            diff += this.diffs[i] ? -1 : 0;
        }
        return originalOffset + diff;
    }

    private void init() {
        String result = this.originalExpression;
        for (String[] patternPair : this.conversionTable) {
            int match;
            StringBuilder resolved = new StringBuilder();
            String source = patternPair[0];
            String dest = patternPair[1];
            int lastMatchEnd = 0;
            while ((match = result.indexOf(source, lastMatchEnd)) != -1) {
                resolved.append(result.substring(lastMatchEnd, match));
                resolved.append(dest);
                int patternsLenDiff = source.length() - dest.length();
                for (int i = match; i < match + patternsLenDiff; ++i) {
                    this.diffs[i] = true;
                }
                lastMatchEnd = match + source.length();
            }
            resolved.append(result.substring(lastMatchEnd));
            result = resolved.toString();
        }
        this.preprocessedExpression = result;
    }
}

