/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el;

import com.sun.el.parser.AstIdentifier;
import com.sun.el.parser.AstString;
import com.sun.el.parser.Node;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.AbstractElementVisitor6;
import javax.swing.text.Document;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProviderExt;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.el.lexer.api.ELTokenId;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.common.api.WebUtils;
import org.netbeans.modules.web.el.ELElement;
import org.netbeans.modules.web.el.ELParserResult;
import org.netbeans.modules.web.el.ELTypeUtilities;
import org.netbeans.modules.web.el.Pair;
import org.netbeans.modules.web.el.ResourceBundles;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class ELHyperlinkProvider
implements HyperlinkProviderExt {
    private static String[] c = new String[]{"&", "<", ">", "\n", "\""};
    private static String[] tags = new String[]{"&amp;", "&lt;", "&gt;", "<br>", "&quot;"};

    public boolean isHyperlinkPoint(final Document doc, final int offset, HyperlinkType type) {
        final AtomicBoolean ret = new AtomicBoolean(false);
        doc.render(new Runnable(){

            @Override
            public void run() {
                ret.set(ELHyperlinkProvider.this.getELIdentifierSpan(doc, offset) != null);
            }
        });
        return ret.get();
    }

    public int[] getHyperlinkSpan(final Document doc, final int offset, HyperlinkType type) {
        final AtomicReference ret = new AtomicReference();
        doc.render(new Runnable(){

            @Override
            public void run() {
                ret.set(ELHyperlinkProvider.this.getELIdentifierSpan(doc, offset));
            }
        });
        return (int[])ret.get();
    }

    public void performClickAction(final Document doc, final int offset, HyperlinkType type) {
        final AtomicBoolean cancel = new AtomicBoolean();
        ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ELHyperlinkProvider.this.performGoTo(doc, offset, cancel);
            }
        }, (String)NbBundle.getMessage(ELHyperlinkProvider.class, (String)"LBL_GoToDeclaration"), (AtomicBoolean)cancel, (boolean)false);
    }

    public Set<HyperlinkType> getSupportedHyperlinkTypes() {
        return EnumSet.of(HyperlinkType.GO_TO_DECLARATION);
    }

    public String getTooltipText(Document doc, int offset, HyperlinkType type) {
        Pair<Node, ELElement> nodeAndElement = this.resolveNodeAndElement(doc, offset, new AtomicBoolean());
        if (nodeAndElement != null) {
            if (nodeAndElement.first instanceof AstString) {
                return this.getTooltipTextForBundleKey(nodeAndElement);
            }
            return this.getTooltipTextForElement(nodeAndElement);
        }
        return null;
    }

    private String getTooltipTextForElement(Pair<Node, ELElement> pair) {
        FileObject context = ((ELElement)pair.second).getSnapshot().getSource().getFileObject();
        final Element resolvedElement = ELTypeUtilities.create(context).resolveElement((ELElement)pair.second, (Node)pair.first);
        if (resolvedElement == null) {
            return null;
        }
        final String[] result = new String[1];
        ClasspathInfo cp = ClasspathInfo.create((FileObject)((ELElement)pair.second).getSnapshot().getSource().getFileObject());
        try {
            JavaSource.create((ClasspathInfo)cp, (FileObject[])new FileObject[0]).runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController cc) throws Exception {
                    DisplayNameElementVisitor dnev = new DisplayNameElementVisitor((CompilationInfo)cc);
                    dnev.visit(resolvedElement, Boolean.TRUE);
                    result[0] = "<html><body>" + dnev.result.toString();
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return result[0];
    }

    private String getTooltipTextForBundleKey(Pair<Node, ELElement> pair) {
        FileObject context = ((ELElement)pair.second).getSnapshot().getSource().getFileObject();
        ResourceBundles resourceBundles = ResourceBundles.get(context);
        if (!resourceBundles.canHaveBundles()) {
            return null;
        }
        for (Pair<AstIdentifier, AstString> each : resourceBundles.collectKeys(((ELElement)pair.second).getNode())) {
            if (!((AstString)each.second).equals(pair.first)) continue;
            StringBuilder result = new StringBuilder();
            String key = ((AstString)each.second).getString();
            String value = resourceBundles.getValue(((AstIdentifier)each.first).getImage(), ((AstString)each.second).getString());
            String bundle = ((AstIdentifier)each.first).getImage();
            result.append("<html><body>").append(key).append("=<font color='#ce7b00'>").append(value).append("</font>");
            return result.toString();
        }
        return null;
    }

    private Pair<Node, ELElement> resolveNodeAndElement(Document doc, final int offset, final AtomicBoolean cancel) {
        final ArrayList result = new ArrayList(1);
        Source source = Source.create((Document)doc);
        try {
            ParserManager.parse(Collections.singletonList(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    ResultIterator elRi = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/x-el");
                    if (cancel.get()) {
                        return;
                    }
                    ELParserResult parserResult = (ELParserResult)elRi.getParserResult();
                    ELElement elElement = parserResult.getElementAt(offset);
                    if (elElement == null || !elElement.isValid()) {
                        return;
                    }
                    Node node = elElement.findNodeAt(offset);
                    if (node == null) {
                        return;
                    }
                    result.add(Pair.of(node, elElement));
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return result.isEmpty() ? null : (Pair)result.get(0);
    }

    private void performGoTo(Document doc, int offset, AtomicBoolean cancel) {
        Pair<Node, ELElement> nodeElem = this.resolveNodeAndElement(doc, offset, cancel);
        if (nodeElem == null) {
            return;
        }
        FileObject context = ((ELElement)nodeElem.second).getSnapshot().getSource().getFileObject();
        Element javaElement = ELTypeUtilities.create(context).resolveElement((ELElement)nodeElem.second, (Node)nodeElem.first);
        if (javaElement != null) {
            ElementOpen.open((ClasspathInfo)ClasspathInfo.create((FileObject)context), (Element)javaElement);
        }
    }

    private int[] getELIdentifierSpan(Document doc, int offset) {
        TokenSequence elTokenSequence = LexerUtils.getTokenSequence((Document)doc, (int)offset, (Language)ELTokenId.language(), (boolean)false);
        if (elTokenSequence == null) {
            return null;
        }
        elTokenSequence.move(offset);
        if (!elTokenSequence.moveNext()) {
            return null;
        }
        if (elTokenSequence.token().id() == ELTokenId.IDENTIFIER || elTokenSequence.token().id() == ELTokenId.STRING_LITERAL) {
            return new int[]{elTokenSequence.offset(), elTokenSequence.offset() + elTokenSequence.token().length()};
        }
        return null;
    }

    private static String getTypeName(CompilationInfo info, TypeMirror t, boolean fqn) {
        return ELHyperlinkProvider.translate(((Object)info.getTypeUtilities().getTypeName(t, new TypeUtilities.TypeNameOptions[0])).toString());
    }

    private static String translate(String input) {
        for (int cntr = 0; cntr < c.length; ++cntr) {
            input = input.replaceAll(c[cntr], tags[cntr]);
        }
        return input;
    }

    private static final class DisplayNameElementVisitor
    extends AbstractElementVisitor6<Void, Boolean> {
        private final CompilationInfo info;
        private StringBuffer result = new StringBuffer();

        public DisplayNameElementVisitor(CompilationInfo info) {
            this.info = info;
        }

        private void boldStartCheck(boolean highlightName) {
            if (highlightName) {
                this.result.append("<b>");
            }
        }

        private void boldStopCheck(boolean highlightName) {
            if (highlightName) {
                this.result.append("</b>");
            }
        }

        @Override
        public Void visitPackage(PackageElement e, Boolean highlightName) {
            this.boldStartCheck(highlightName);
            this.result.append(e.getQualifiedName());
            this.boldStopCheck(highlightName);
            return null;
        }

        @Override
        public Void visitType(TypeElement e, Boolean highlightName) {
            return this.printType(e, null, highlightName);
        }

        Void printType(TypeElement e, DeclaredType dt, Boolean highlightName) {
            this.modifier(e.getModifiers());
            switch (e.getKind()) {
                case CLASS: {
                    this.result.append("class ");
                    break;
                }
                case INTERFACE: {
                    this.result.append("interface ");
                    break;
                }
                case ENUM: {
                    this.result.append("enum ");
                    break;
                }
                case ANNOTATION_TYPE: {
                    this.result.append("@interface ");
                }
            }
            Element enclosing = e.getEnclosingElement();
            if (enclosing == this.info.getElementUtilities().enclosingTypeElement((Element)e)) {
                this.result.append(((TypeElement)enclosing).getQualifiedName());
                this.result.append('.');
                this.boldStartCheck(highlightName);
                this.result.append(e.getSimpleName());
                this.boldStopCheck(highlightName);
            } else {
                this.result.append(e.getQualifiedName());
            }
            if (dt != null) {
                this.dumpRealTypeArguments(dt.getTypeArguments());
            }
            return null;
        }

        @Override
        public Void visitVariable(VariableElement e, Boolean highlightName) {
            this.modifier(e.getModifiers());
            this.result.append(ELHyperlinkProvider.getTypeName(this.info, e.asType(), true));
            this.result.append(' ');
            this.boldStartCheck(highlightName);
            this.result.append(e.getSimpleName());
            this.boldStopCheck(highlightName);
            if (highlightName.booleanValue()) {
                if (e.getConstantValue() != null) {
                    this.result.append(" = ");
                    this.result.append(e.getConstantValue().toString());
                }
                Element enclosing = e.getEnclosingElement();
                if (e.getKind() != ElementKind.PARAMETER && e.getKind() != ElementKind.LOCAL_VARIABLE && e.getKind() != ElementKind.EXCEPTION_PARAMETER) {
                    this.result.append(" in ");
                    this.result.append(ELHyperlinkProvider.getTypeName(this.info, enclosing.asType(), true));
                }
            }
            return null;
        }

        @Override
        public Void visitExecutable(ExecutableElement e, Boolean highlightName) {
            return this.printExecutable(e, null, highlightName);
        }

        Void printExecutable(ExecutableElement e, DeclaredType dt, Boolean highlightName) {
            switch (e.getKind()) {
                case CONSTRUCTOR: {
                    this.modifier(e.getModifiers());
                    this.dumpTypeArguments(e.getTypeParameters());
                    this.result.append(' ');
                    this.boldStartCheck(highlightName);
                    this.result.append(e.getEnclosingElement().getSimpleName());
                    this.boldStopCheck(highlightName);
                    if (dt != null) {
                        this.dumpRealTypeArguments(dt.getTypeArguments());
                        this.dumpArguments(e.getParameters(), ((ExecutableType)this.info.getTypes().asMemberOf(dt, e)).getParameterTypes());
                    } else {
                        this.dumpArguments(e.getParameters(), null);
                    }
                    this.dumpThrows(e.getThrownTypes());
                    break;
                }
                case METHOD: {
                    this.modifier(e.getModifiers());
                    this.dumpTypeArguments(e.getTypeParameters());
                    this.result.append(ELHyperlinkProvider.getTypeName(this.info, e.getReturnType(), true));
                    this.result.append(' ');
                    this.boldStartCheck(highlightName);
                    this.result.append(e.getSimpleName());
                    this.boldStopCheck(highlightName);
                    this.dumpArguments(e.getParameters(), null);
                    this.dumpThrows(e.getThrownTypes());
                    break;
                }
            }
            return null;
        }

        @Override
        public Void visitTypeParameter(TypeParameterElement e, Boolean highlightName) {
            return null;
        }

        private void modifier(Set<Modifier> modifiers) {
            boolean addSpace = false;
            for (Modifier m : modifiers) {
                if (addSpace) {
                    this.result.append(' ');
                }
                addSpace = true;
                this.result.append(m.toString());
            }
            if (addSpace) {
                this.result.append(' ');
            }
        }

        private void dumpTypeArguments(List<? extends TypeParameterElement> list) {
            if (list.isEmpty()) {
                return;
            }
            boolean addSpace = false;
            this.result.append("&lt;");
            for (TypeParameterElement typeParameterElement : list) {
                if (addSpace) {
                    this.result.append(", ");
                }
                this.result.append(ELHyperlinkProvider.getTypeName(this.info, typeParameterElement.asType(), true));
                addSpace = true;
            }
            this.result.append("&gt;");
        }

        private void dumpRealTypeArguments(List<? extends TypeMirror> list) {
            if (list.isEmpty()) {
                return;
            }
            boolean addSpace = false;
            this.result.append("&lt;");
            for (TypeMirror typeMirror : list) {
                if (addSpace) {
                    this.result.append(", ");
                }
                this.result.append(ELHyperlinkProvider.getTypeName(this.info, typeMirror, true));
                addSpace = true;
            }
            this.result.append("&gt;");
        }

        private void dumpArguments(List<? extends VariableElement> list, List<? extends TypeMirror> types) {
            Iterator<? extends TypeMirror> typesIt;
            boolean addSpace = false;
            this.result.append('(');
            Iterator<? extends VariableElement> listIt = list.iterator();
            Iterator<? extends TypeMirror> iterator = typesIt = types != null ? types.iterator() : null;
            while (listIt.hasNext()) {
                if (addSpace) {
                    this.result.append(", ");
                }
                VariableElement ve = listIt.next();
                TypeMirror type = typesIt != null ? typesIt.next() : ve.asType();
                this.result.append(ELHyperlinkProvider.getTypeName(this.info, type, true));
                this.result.append(" ");
                this.result.append(ve.getSimpleName());
                addSpace = true;
            }
            this.result.append(')');
        }

        private void dumpThrows(List<? extends TypeMirror> list) {
            if (list.isEmpty()) {
                return;
            }
            boolean addSpace = false;
            this.result.append(" throws ");
            for (TypeMirror typeMirror : list) {
                if (addSpace) {
                    this.result.append(", ");
                }
                this.result.append(ELHyperlinkProvider.getTypeName(this.info, typeMirror, true));
                addSpace = true;
            }
        }
    }
}

