/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.csm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmFunctionInstantiation;
import org.netbeans.modules.cnd.api.model.CsmFunctionParameterList;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmInitializerListContainer;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVariableDefinition;
import org.netbeans.modules.cnd.api.model.deep.CsmDeclarationStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmSortUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmContext;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetUtilities;
import org.openide.util.CharSequences;

public class CsmContextUtilities {
    private static final boolean DEBUG = Boolean.getBoolean("csm.utilities.trace");
    private static final int FILE_LOCAL_MACROS = 0;
    private static final int FILE_PROJECT_LOCAL_MACROS = 1;
    private static final int FILE_LIB_LOCAL_MACROS = 2;
    private static final int PROJECT_MACROS = 3;
    private static final int LIB_MACROS = 4;

    private CsmContextUtilities() {
    }

    public static List<CsmDeclaration> findLocalDeclarations(CsmContext context, String strPrefix, boolean match, boolean caseSensitive) {
        return CsmContextUtilities.findLocalDeclarations(context, strPrefix, match, caseSensitive, true, false);
    }

    public static List<CsmDeclaration> findFileLocalVariables(CsmContext context) {
        return CsmContextUtilities.findFileLocalVariables(context, "", false, false);
    }

    public static List<CsmDeclaration> findFileLocalVariables(CsmContext context, String strPrefix, boolean match, boolean caseSensitive) {
        return CsmContextUtilities.findLocalDeclarations(context, strPrefix, match, caseSensitive, true, false);
    }

    public static List<CsmDeclaration> findFunctionLocalVariables(CsmContext context) {
        List<CsmDeclaration> decls = CsmContextUtilities.findFunctionLocalDeclarations(context, "", false, false);
        ArrayList<CsmDeclaration> out = new ArrayList<CsmDeclaration>(decls.size());
        for (CsmDeclaration elem : decls) {
            if (!CsmKindUtilities.isVariable((CsmObject)elem)) continue;
            out.add(elem);
        }
        return out;
    }

    public static List<CsmDeclaration> findFunctionLocalDeclarations(CsmContext context, String strPrefix, boolean match, boolean caseSensitive) {
        List<CsmDeclaration> decls = CsmContextUtilities.findLocalDeclarations(context, strPrefix, match, caseSensitive, false, true);
        return decls;
    }

    public static List<CsmMacro> findFileLocalMacros(CsmContext context, String strPrefix, boolean match, boolean caseSensitive) {
        return CsmContextUtilities.findMacros(context, strPrefix, match, caseSensitive, 0);
    }

    public static List<CsmMacro> findFileIncludedProjectMacros(CsmContext context, String strPrefix, boolean match, boolean caseSensitive) {
        return CsmContextUtilities.findMacros(context, strPrefix, match, caseSensitive, 1);
    }

    public static List<CsmMacro> findFileIncludedLibMacros(CsmContext context, String strPrefix, boolean match, boolean caseSensitive) {
        return CsmContextUtilities.findMacros(context, strPrefix, match, caseSensitive, 2);
    }

    public static List<CsmMacro> findProjectMacros(CsmContext context, String strPrefix, boolean match, boolean caseSensitive) {
        return CsmContextUtilities.findMacros(context, strPrefix, match, caseSensitive, 3);
    }

    public static List<CsmMacro> findLibMacros(CsmContext context, String strPrefix, boolean match, boolean caseSensitive) {
        return CsmContextUtilities.findMacros(context, strPrefix, match, caseSensitive, 4);
    }

    private static List<CsmMacro> findMacros(CsmContext context, CharSequence strPrefix, boolean match, boolean caseSensitive, int kind) {
        strPrefix = CharSequences.create((CharSequence)strPrefix);
        ArrayList<CsmMacro> res = new ArrayList<CsmMacro>();
        Iterator<CsmContext.CsmContextEntry> itContext = context.iterator();
        while (itContext.hasNext()) {
            CsmContext.CsmContextEntry entry = itContext.next();
            CsmScope scope = entry.getScope();
            if (!CsmKindUtilities.isFile((CsmObject)scope)) continue;
            CsmFile file = (CsmFile)scope;
            switch (kind) {
                case 0: {
                    CsmContextUtilities.getFileLocalMacros(file, res, new HashSet<CharSequence>(), strPrefix, match, caseSensitive);
                    break;
                }
                case 1: {
                    CsmContextUtilities.gatherProjectIncludedMacros(file, res, false, strPrefix, match, caseSensitive);
                    break;
                }
                case 2: {
                    CsmContextUtilities.gatherLibIncludedMacros(file, res, false, strPrefix, match, caseSensitive);
                    break;
                }
                case 3: {
                    CsmContextUtilities.gatherProjectIncludedMacros(file, res, true, strPrefix, match, caseSensitive);
                    break;
                }
                case 4: {
                    CsmContextUtilities.gatherLibIncludedMacros(file, res, true, strPrefix, match, caseSensitive);
                }
            }
        }
        return res;
    }

    private static void getFileLocalMacros(CsmFile file, List<CsmMacro> res, Set<CharSequence> alredyInList, CharSequence strPrefix, boolean match, boolean caseSensitive) {
        CsmSelect.CsmFilter filter = CsmSelect.getFilterBuilder().createNameFilter(strPrefix, match, caseSensitive, false);
        Iterator itFile = CsmSelect.getMacros((CsmFile)file, (CsmSelect.CsmFilter)filter);
        while (itFile.hasNext()) {
            CsmMacro macro = (CsmMacro)itFile.next();
            CharSequence name = macro.getName();
            if (alredyInList.contains(name) || !CsmSortUtilities.matchName((CharSequence)name, (CharSequence)strPrefix, (boolean)match, (boolean)caseSensitive)) continue;
            res.add(macro);
            alredyInList.add(name);
        }
    }

    private static void gatherProjectIncludedMacros(CsmFile file, List<CsmMacro> res, boolean all, CharSequence strPrefix, boolean match, boolean caseSensitive) {
        CsmProject prj = file.getProject();
        if (!all) {
            CsmContextUtilities.gatherIncludeMacros(file, prj, true, new HashSet<CsmFile>(), new HashSet<CharSequence>(), res, strPrefix, match, caseSensitive);
        } else {
            HashSet<CharSequence> alredyInList = new HashSet<CharSequence>();
            Iterator i = prj.getHeaderFiles().iterator();
            while (i.hasNext()) {
                CsmContextUtilities.getFileLocalMacros((CsmFile)i.next(), res, alredyInList, strPrefix, match, caseSensitive);
            }
        }
    }

    private static void gatherLibIncludedMacros(CsmFile file, List<CsmMacro> res, boolean all, CharSequence strPrefix, boolean match, boolean caseSensitive) {
        CsmProject prj = file.getProject();
        if (!all) {
            CsmContextUtilities.gatherIncludeMacros(file, prj, false, new HashSet<CsmFile>(), new HashSet<CharSequence>(), res, strPrefix, match, caseSensitive);
        } else {
            HashSet<CharSequence> alredyInList = new HashSet<CharSequence>();
            for (CsmProject lib : prj.getLibraries()) {
                Iterator i = lib.getHeaderFiles().iterator();
                while (i.hasNext()) {
                    CsmContextUtilities.getFileLocalMacros((CsmFile)i.next(), res, alredyInList, strPrefix, match, caseSensitive);
                }
            }
        }
    }

    private static void gatherIncludeMacros(CsmFile file, CsmProject prj, boolean own, Set<CsmFile> visitedFiles, Set<CharSequence> alredyInList, List<CsmMacro> res, CharSequence strPrefix, boolean match, boolean caseSensitive) {
        if (visitedFiles.contains(file)) {
            return;
        }
        visitedFiles.add(file);
        for (CsmInclude inc : file.getIncludes()) {
            CsmFile incFile = inc.getIncludeFile();
            if (incFile == null) continue;
            if (own) {
                if (incFile.getProject() != prj) continue;
                CsmContextUtilities.getFileLocalMacros(incFile, res, alredyInList, strPrefix, match, caseSensitive);
                CsmContextUtilities.gatherIncludeMacros(incFile, prj, own, visitedFiles, alredyInList, res, strPrefix, match, caseSensitive);
                continue;
            }
            if (incFile.getProject() != prj) {
                CsmContextUtilities.getFileLocalMacros(incFile, res, alredyInList, strPrefix, match, caseSensitive);
            }
            CsmContextUtilities.gatherIncludeMacros(incFile, prj, own, visitedFiles, alredyInList, res, strPrefix, match, caseSensitive);
        }
    }

    protected static List<CsmDeclaration> findLocalDeclarations(CsmContext context, String strPrefix, boolean match, boolean caseSensitive, boolean includeFileLocal, boolean includeFunctionVars) {
        boolean incAny;
        List<CsmDeclaration> res = new ArrayList<CsmDeclaration>();
        boolean bl = incAny = includeFileLocal || includeFunctionVars;
        assert (incAny) : "at least one must be true";
        boolean incAll = includeFileLocal && includeFunctionVars;
        Iterator<CsmContext.CsmContextEntry> it = context.iterator();
        while (it.hasNext() && incAny) {
            CsmContext.CsmContextEntry entry = it.next();
            boolean include = incAll;
            if (!include) {
                if (!includeFileLocal) {
                    assert (includeFunctionVars);
                    if (CsmKindUtilities.isFunction((CsmObject)entry.getScope())) {
                        include = true;
                        incAll = true;
                    }
                    if (CsmKindUtilities.isFunctionExplicitInstantiation((CsmObject)entry.getScope())) {
                        include = true;
                        incAll = true;
                    }
                } else if (!includeFunctionVars) {
                    assert (includeFileLocal);
                    if (CsmKindUtilities.isFunction((CsmObject)entry.getScope()) || CsmKindUtilities.isClassifier((CsmObject)entry.getScope())) {
                        include = false;
                        incAny = false;
                        incAll = false;
                    } else {
                        include = true;
                    }
                }
            }
            if (!include) continue;
            res = CsmContextUtilities.addEntryDeclarations(entry, res, context, strPrefix, match, caseSensitive);
        }
        return res;
    }

    private static List<CsmDeclaration> addEntryDeclarations(CsmContext.CsmContextEntry entry, List<CsmDeclaration> decls, CsmContext fullContext, String strPrefix, boolean match, boolean caseSensitive) {
        List<CsmDeclaration> newList = CsmContextUtilities.findEntryDeclarations(entry, fullContext, strPrefix, match, caseSensitive);
        return CsmContextUtilities.mergeDeclarations(decls, newList);
    }

    private static List<CsmDeclaration> findEntryDeclarations(CsmContext.CsmContextEntry entry, CsmContext fullContext, String strPrefix, boolean match, boolean caseSensitive) {
        CsmFunctionParameterList paramList;
        CsmScopeElement scpElem;
        assert (entry != null) : "can't work on null entries";
        CsmScope scope = entry.getScope();
        int offsetInScope = entry.getOffset();
        ArrayList<CsmDeclaration> resList = new ArrayList<CsmDeclaration>();
        boolean stoppedBeforeFirst = true;
        Iterator it = scope.getScopeElements().iterator();
        while (it.hasNext() && !CsmContextUtilities.canBreak(offsetInScope, scpElem = (CsmScopeElement)it.next(), fullContext)) {
            stoppedBeforeFirst = false;
            List<CsmDeclaration> declList = CsmContextUtilities.extractDeclarations(fullContext, scpElem, strPrefix, match, caseSensitive);
            resList.addAll(declList);
        }
        if (stoppedBeforeFirst && CsmKindUtilities.isFunction((CsmObject)scope) && CsmOffsetUtilities.isInObject((CsmObject)(paramList = ((CsmFunction)scope).getParameterList()), offsetInScope)) {
            for (CsmParameter csmParameter : paramList.getParameters()) {
                List<CsmDeclaration> declList = CsmContextUtilities.extractDeclarations(fullContext, (CsmScopeElement)csmParameter, strPrefix, match, caseSensitive);
                resList.addAll(declList);
            }
        }
        return resList;
    }

    public static CsmSelect.CsmFilter createFilter(CsmDeclaration.Kind[] kinds, String strPrefix, boolean match, boolean caseSensitive, boolean returnUnnamedMembers) {
        CsmSelect.CsmFilter filter = null;
        CsmSelect.CsmFilterBuilder builder = CsmSelect.getFilterBuilder();
        if (kinds != null && strPrefix != null) {
            filter = builder.createCompoundFilter(builder.createKindFilter(kinds), builder.createNameFilter((CharSequence)strPrefix, match, caseSensitive, returnUnnamedMembers));
        } else if (kinds != null) {
            filter = builder.createKindFilter(kinds);
        } else if (strPrefix != null) {
            filter = builder.createNameFilter((CharSequence)strPrefix, match, caseSensitive, returnUnnamedMembers);
        }
        return filter;
    }

    public static List<CsmEnumerator> findFileLocalEnumerators(CsmContext context, String strPrefix, boolean match, boolean caseSensitive) {
        ArrayList<CsmEnumerator> res = new ArrayList<CsmEnumerator>();
        Iterator<CsmContext.CsmContextEntry> itContext = context.iterator();
        while (itContext.hasNext()) {
            CsmDeclaration decl;
            CsmContext.CsmContextEntry entry = itContext.next();
            CsmScope scope = entry.getScope();
            int offsetInScope = entry.getOffset();
            if (!CsmKindUtilities.isFile((CsmObject)scope)) continue;
            CsmFile file = (CsmFile)scope;
            CsmSelect.CsmFilter fileFilter = CsmContextUtilities.createFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.ENUM, CsmDeclaration.Kind.NAMESPACE_DEFINITION, CsmDeclaration.Kind.CLASS, CsmDeclaration.Kind.STRUCT}, null, match, caseSensitive, true);
            Iterator itFile = CsmSelect.getDeclarations((CsmFile)file, (CsmSelect.CsmFilter)fileFilter);
            while (itFile.hasNext() && !CsmContextUtilities.canBreak(offsetInScope, (CsmScopeElement)(decl = (CsmDeclaration)itFile.next()), context)) {
                CsmMember member;
                if (CsmKindUtilities.isEnum((CsmObject)decl)) {
                    CsmEnum en = (CsmEnum)decl;
                    if (en.getName().length() != 0) continue;
                    CsmContextUtilities.addEnumerators(res, en, strPrefix, match, caseSensitive);
                    continue;
                }
                if (CsmKindUtilities.isNamespaceDefinition((CsmObject)decl) && decl.getName().length() == 0) {
                    CsmDeclaration nsDecl;
                    CsmNamespaceDefinition ns = (CsmNamespaceDefinition)decl;
                    CsmSelect.CsmFilter filter = CsmContextUtilities.createFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.ENUM}, strPrefix, match, caseSensitive, true);
                    Iterator i = CsmSelect.getDeclarations((CsmNamespaceDefinition)ns, (CsmSelect.CsmFilter)filter);
                    while (i.hasNext() && !CsmContextUtilities.canBreak(offsetInScope, (CsmScopeElement)(nsDecl = (CsmDeclaration)i.next()), context)) {
                        CsmEnum en;
                        if (!CsmKindUtilities.isEnum((CsmObject)nsDecl) || (en = (CsmEnum)nsDecl).getName().length() != 0) continue;
                        CsmContextUtilities.addEnumerators(res, en, strPrefix, match, caseSensitive);
                    }
                    continue;
                }
                if (!CsmKindUtilities.isClass((CsmObject)decl) || decl.getName().length() != 0) continue;
                CsmClass cls = (CsmClass)decl;
                Iterator i$ = cls.getMembers().iterator();
                while (i$.hasNext() && !CsmContextUtilities.canBreak(offsetInScope, (CsmScopeElement)(member = (CsmMember)i$.next()), context)) {
                    CsmEnum en;
                    if (!CsmKindUtilities.isEnum((CsmObject)member) || (en = (CsmEnum)member).getName().length() != 0) continue;
                    CsmContextUtilities.addEnumerators(res, en, strPrefix, match, caseSensitive);
                }
            }
        }
        return res;
    }

    private static void addEnumerators(List resList, CsmEnum en, String strPrefix, boolean match, boolean caseSensitive) {
        for (CsmNamedElement scpElem : en.getEnumerators()) {
            if (!CsmSortUtilities.matchName((CharSequence)scpElem.getName(), (CharSequence)strPrefix, (boolean)match, (boolean)caseSensitive)) continue;
            resList.add(scpElem);
        }
    }

    private static boolean canBreak(int offsetInScope, CsmScopeElement elem, CsmContext fullContext) {
        if (offsetInScope == -1) {
            return CsmContextUtilities.isInContext(fullContext, (CsmObject)elem);
        }
        if (CsmKindUtilities.isOffsetable((Object)elem)) {
            return ((CsmOffsetable)elem).getStartOffset() >= offsetInScope || CsmContextUtilities.isInContext(fullContext, (CsmObject)elem);
        }
        return CsmContextUtilities.isInContext(fullContext, (CsmObject)elem);
    }

    private static List<CsmDeclaration> mergeDeclarations(List<CsmDeclaration> prevScopeDecls, List<CsmDeclaration> newScopeDecls) {
        ArrayList<CsmDeclaration> res = new ArrayList<CsmDeclaration>();
        if (newScopeDecls != null && newScopeDecls.size() > 0) {
            res.addAll(newScopeDecls);
        }
        if (prevScopeDecls != null && prevScopeDecls.size() > 0) {
            res.addAll(prevScopeDecls);
        }
        return res;
    }

    public static void updateContextObject(CsmObject obj, int offset, CsmContext context) {
        if (context != null && obj != null) {
            context.setLastObject(obj);
        }
    }

    public static void updateContext(CsmObject obj, int offset, CsmContext context) {
        if (context != null) {
            if (CsmKindUtilities.isScope((CsmObject)obj)) {
                context.add((CsmScope)obj, offset);
            } else if (CsmKindUtilities.isOffsetable((Object)obj)) {
                CsmContextUtilities.updateContextObject(obj, offset, context);
            }
        }
    }

    private static boolean isInContext(CsmContext context, CsmObject obj) {
        ListIterator<CsmContext.CsmContextEntry> it = context.reverseIterator();
        while (it.hasPrevious()) {
            CsmContext.CsmContextEntry elem = it.previous();
            if (!obj.equals(elem.getScope())) continue;
            return true;
        }
        return false;
    }

    private static CsmClassifier getTypeClassifier(CsmContext fullContext, CsmType type) {
        return CsmBaseUtilities.getClassifier((CsmType)type, (CsmFile)fullContext.getFile(), (int)fullContext.getOffset(), (boolean)true);
    }

    private static List<CsmDeclaration> extractDeclarations(CsmContext fullContext, CsmScopeElement scpElem, String strPrefix, boolean match, boolean caseSensitive) {
        ArrayList<CsmDeclaration> list;
        block6: {
            CsmStatement.Kind kind;
            block5: {
                list = new ArrayList<CsmDeclaration>();
                if (!CsmKindUtilities.isDeclaration((CsmObject)scpElem)) break block5;
                if (!CsmSortUtilities.matchName((CharSequence)((CsmNamedElement)scpElem).getName(), (CharSequence)strPrefix, (boolean)match, (boolean)caseSensitive)) break block6;
                boolean add = true;
                if (CsmKindUtilities.isParamVariable((CsmObject)scpElem)) {
                    boolean bl = add = !((CsmParameter)scpElem).isVarArgs();
                }
                if (!add) break block6;
                list.add((CsmDeclaration)scpElem);
                break block6;
            }
            if (CsmKindUtilities.isStatement((CsmObject)scpElem) && (kind = ((CsmStatement)scpElem).getKind()) == CsmStatement.Kind.DECLARATION) {
                List decls = ((CsmDeclarationStatement)scpElem).getDeclarators();
                List listByName = CsmSortUtilities.filterList((Collection)decls, (CharSequence)strPrefix, (boolean)match, (boolean)caseSensitive);
                list.addAll(listByName);
                for (CsmDeclaration elem : decls) {
                    CsmType type;
                    CsmClassifier classifier;
                    if (CsmKindUtilities.isTypedef((CsmObject)elem) && CsmOffsetUtilities.isInObject((CsmObject)elem, (CsmObject)(classifier = CsmContextUtilities.getTypeClassifier(fullContext, type = ((CsmTypedef)elem).getType()))) && !CsmOffsetUtilities.sameOffsets((CsmObject)elem, (CsmObject)classifier)) {
                        elem = classifier;
                    }
                    if (CsmKindUtilities.isEnum((CsmObject)elem)) {
                        listByName = CsmSortUtilities.filterList((Collection)((CsmEnum)elem).getEnumerators(), (CharSequence)strPrefix, (boolean)match, (boolean)caseSensitive);
                        list.addAll(listByName);
                        continue;
                    }
                    if (!CsmKindUtilities.isUnion((CsmObject)elem) || ((CsmClass)elem).getName().length() != 0) continue;
                    listByName = CsmSortUtilities.filterList((Collection)((CsmClass)elem).getMembers(), (CharSequence)strPrefix, (boolean)match, (boolean)caseSensitive);
                    list.addAll(listByName);
                }
            }
        }
        return list;
    }

    public static CsmClass getClass(CsmContext context, boolean checkFunDefition, boolean inScope) {
        CsmVariable decl;
        CsmObject last;
        CsmClass clazz = null;
        for (int i = context.size() - 1; 0 <= i; --i) {
            CsmScope scope = context.get(i).getScope();
            if (!CsmKindUtilities.isClass((CsmObject)scope) || inScope && !CsmOffsetUtilities.isInClassScope((CsmClass)scope, context.getOffset())) continue;
            clazz = (CsmClass)scope;
            break;
        }
        if (clazz == null && checkFunDefition) {
            CsmFunction fun = CsmContextUtilities.getFunction(context, false);
            CsmClass csmClass = clazz = fun == null ? null : CsmBaseUtilities.getFunctionClass((CsmFunction)fun);
        }
        if (clazz == null && CsmKindUtilities.isVariableDefinition((CsmObject)(last = context.getLastObject())) && CsmKindUtilities.isClassMember((CsmObject)(decl = ((CsmVariableDefinition)last).getDeclaration()))) {
            clazz = ((CsmMember)decl).getContainingClass();
        }
        return clazz;
    }

    public static CsmFunction getFunction(CsmContext context, boolean inScope) {
        for (int i = context.size() - 1; 0 <= i; --i) {
            CsmScope scope = context.get(i).getScope();
            int offset = context.getOffset();
            if (!CsmKindUtilities.isFunction((CsmObject)scope) || inScope && !CsmOffsetUtilities.isInFunctionScope((CsmFunction)scope, offset)) continue;
            return (CsmFunction)scope;
        }
        return null;
    }

    public static CsmFunctionInstantiation getFunctionInstantiation(CsmContext context, boolean inScope) {
        for (int i = context.size() - 1; 0 <= i; --i) {
            CsmScope scope = context.get(i).getScope();
            int offset = context.getOffset();
            if (!CsmKindUtilities.isFunctionExplicitInstantiation((CsmObject)scope) || inScope && !CsmOffsetUtilities.isInObject((CsmObject)scope, offset)) continue;
            return (CsmFunctionInstantiation)scope;
        }
        return null;
    }

    public static CsmFunctionDefinition getFunctionDefinition(CsmContext context) {
        CsmFunctionDefinition fun = null;
        Iterator<CsmContext.CsmContextEntry> it = context.iterator();
        while (it.hasNext()) {
            CsmContext.CsmContextEntry elem = it.next();
            if (!CsmKindUtilities.isFunctionDefinition((CsmObject)elem.getScope())) continue;
            fun = (CsmFunctionDefinition)elem.getScope();
            break;
        }
        return fun;
    }

    public static CsmNamespace getNamespace(CsmContext context) {
        CsmFunction fun = CsmContextUtilities.getFunction(context, false);
        CsmNamespace ns = null;
        if (fun != null) {
            ns = CsmContextUtilities.getFunctionNamespace(fun);
        } else {
            CsmClass cls = CsmContextUtilities.getClass(context, false, false);
            CsmNamespace csmNamespace = ns = cls == null ? null : CsmContextUtilities.getClassNamespace(cls);
        }
        if (ns == null) {
            ListIterator<CsmContext.CsmContextEntry> it = context.reverseIterator();
            while (it.hasPrevious()) {
                CsmContext.CsmContextEntry elem = it.previous();
                if (!CsmKindUtilities.isNamespaceDefinition((CsmObject)elem.getScope())) continue;
                ns = ((CsmNamespaceDefinition)elem.getScope()).getNamespace();
                break;
            }
        }
        return ns;
    }

    private static CsmNamespace getFunctionNamespace(CsmFunction fun) {
        return CsmBaseUtilities.getFunctionNamespace((CsmFunction)fun);
    }

    private static CsmNamespace getClassNamespace(CsmClass cls) {
        return CsmBaseUtilities.getClassNamespace((CsmClassifier)cls);
    }

    public static boolean isInFunctionBodyOrInitializerList(CsmContext context, int offset) {
        return CsmContextUtilities.isInFunctionBody(context, offset) || CsmContextUtilities.isInInitializerList(context, offset);
    }

    public static boolean isInFunctionBody(CsmContext context, int offset) {
        CsmFunctionDefinition funDef = CsmContextUtilities.getFunctionDefinition(context);
        return funDef == null ? false : CsmOffsetUtilities.isInObject((CsmObject)funDef.getBody(), offset);
    }

    public static boolean isInInitializerList(CsmContext context, int offset) {
        CsmVariable var;
        CsmExpression initialValue;
        CsmFunction f = CsmContextUtilities.getFunction(context, false);
        if (CsmKindUtilities.isConstructor((CsmObject)f)) {
            for (CsmExpression izer : ((CsmInitializerListContainer)f).getInitializerList()) {
                if (!CsmOffsetUtilities.isInObject((CsmObject)izer, offset)) continue;
                return true;
            }
        }
        return CsmKindUtilities.isVariable((CsmObject)context.getLastObject()) && (initialValue = (var = (CsmVariable)context.getLastObject()).getInitialValue()) != null && CsmOffsetUtilities.isInObject((CsmObject)initialValue, offset);
    }

    public static boolean isInFunction(CsmContext context, int offset) {
        CsmFunction fun = CsmContextUtilities.getFunction(context, true);
        return fun != null;
    }

    public static boolean isInFunctionInstantiation(CsmContext context, int offset) {
        CsmFunctionInstantiation fi = CsmContextUtilities.getFunctionInstantiation(context, true);
        return fi != null;
    }

    public static boolean isInType(CsmContext context, int offset) {
        CsmObject last = context.getLastObject();
        CsmType type = null;
        if (CsmKindUtilities.isTypedef((CsmObject)last)) {
            type = ((CsmTypedef)last).getType();
        } else if (CsmKindUtilities.isType((CsmObject)last)) {
            type = (CsmType)last;
        }
        return type != null && !type.isInstantiation() && CsmOffsetUtilities.isInObject((CsmObject)type, offset);
    }
}

