/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.profiler.spi.LoadGenPlugin;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class LoadGenPanel
extends JPanel {
    private static final String LASTFILE_PROPERTY = LoadGenPanel.class.getName() + "_lastfile";
    private static final String ENABLESELECTOR_PROPERTY = LoadGenPanel.class.getName() + "_enable";
    public static final String PATH = "org.netbeans.modules.profiler.j2ee.LoadGenPanel#path";
    private String lastSelectedPath = null;
    private FriendlyFileObject lastSelectedFile = null;
    private Boolean shouldEnableSelector = false;
    private Project attachedProject = null;
    private Set<String> supportedExtensions = null;
    private DefaultComboBoxModel model = new DefaultComboBoxModel();
    private volatile boolean internalChanges = false;
    private JComboBox scriptsCombo;
    private JCheckBox scriptsEnabled;

    public LoadGenPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.scriptsCombo = new JComboBox();
        this.scriptsEnabled = new JCheckBox();
        this.setBorder(BorderFactory.createEmptyBorder(5, 15, 5, 5));
        this.scriptsCombo.setModel(this.getModel());
        this.scriptsCombo.setEnabled(false);
        this.scriptsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadGenPanel.this.pathChangeListener(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.scriptsEnabled, (String)NbBundle.getMessage(LoadGenPanel.class, (String)"LoadGenPanel.scriptsEnabled.text"));
        this.scriptsEnabled.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.scriptsEnabled.setMargin(new Insets(0, 0, 0, 0));
        this.scriptsEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadGenPanel.this.scriptsEnabledHandler(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.scriptsEnabled).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scriptsCombo, -2, 256, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scriptsEnabled).addComponent(this.scriptsCombo, -2, -1, -2)));
        this.scriptsCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(LoadGenPanel.class, (String)"LoadGenPanel.scriptsCombo.AccessibleContext.accessibleName"));
        this.scriptsCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LoadGenPanel.class, (String)"LoadGenPanel.scriptsCombo.AccessibleContext.accessibleDescription"));
    }

    private void scriptsEnabledHandler(ActionEvent evt) {
        if (this.internalChanges) {
            return;
        }
        this.lastSelectedFile = (FriendlyFileObject)this.getModel().getSelectedItem();
        String path = this.getSelectedScript();
        this.firePropertyChange(PATH, this.lastSelectedPath, path);
        this.scriptsCombo.setEnabled(this.scriptsEnabled.isSelected());
        this.shouldEnableSelector = this.scriptsEnabled.isSelected();
        this.lastSelectedPath = path;
    }

    private void pathChangeListener(ActionEvent evt) {
        if (this.internalChanges) {
            return;
        }
        this.lastSelectedFile = (FriendlyFileObject)this.getModel().getSelectedItem();
        String path = this.getSelectedScript();
        this.firePropertyChange(PATH, this.lastSelectedPath, path);
        this.lastSelectedPath = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(Project project) {
        this.internalChanges = true;
        try {
            this.attachedProject = project;
            ArrayList<FileObject> allScripts = new ArrayList<FileObject>();
            allScripts.addAll(this.findScripts(project));
            this.model.removeAllElements();
            for (FileObject fo : allScripts) {
                this.model.addElement(new FriendlyFileObject(fo));
            }
            this.adjustUI();
        }
        finally {
            this.internalChanges = false;
        }
    }

    public String getSelectedScript() {
        if (!this.scriptsEnabled.isSelected()) {
            return null;
        }
        if (this.scriptsCombo.getSelectedItem() == null) {
            return null;
        }
        try {
            Object script = this.scriptsCombo.getSelectedItem();
            if (script instanceof FriendlyFileObject) {
                FileObject pathFo = ((FriendlyFileObject)script).getFileObject();
                String path = FileUtil.toFile((FileObject)pathFo).getCanonicalPath();
                return path;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public void loadCustomSettings(Properties settings) {
        if (settings != null) {
            FileObject scriptFO;
            File lastScriptFile;
            this.lastSelectedFile = null;
            String lastScriptPath = settings.getProperty(LASTFILE_PROPERTY);
            if (lastScriptPath != null && (lastScriptFile = new File(lastScriptPath)).exists() && (scriptFO = FileUtil.toFileObject((File)lastScriptFile)) != null) {
                this.lastSelectedFile = new FriendlyFileObject(scriptFO);
            }
            this.shouldEnableSelector = false;
            String enablerText = settings.getProperty(ENABLESELECTOR_PROPERTY);
            if (enablerText != null) {
                this.shouldEnableSelector = Boolean.parseBoolean(enablerText);
            }
            this.adjustUI();
        }
    }

    public void storeCustomSettings(Properties settings) {
        if (settings != null) {
            if (this.lastSelectedFile != null) {
                String path = FileUtil.toFile((FileObject)this.lastSelectedFile.delegate).getAbsolutePath();
                settings.setProperty(LASTFILE_PROPERTY, path);
            }
            settings.setProperty(ENABLESELECTOR_PROPERTY, this.shouldEnableSelector.toString());
        }
    }

    private List<FileObject> findScripts(Project project) {
        ArrayList<FileObject> scripts = new ArrayList<FileObject>();
        LoadGenPlugin plugin = (LoadGenPlugin)Lookup.getDefault().lookup(LoadGenPlugin.class);
        if (plugin != null) {
            scripts.addAll(plugin.listScripts(project));
        }
        return scripts;
    }

    private ComboBoxModel getModel() {
        return this.model;
    }

    private void adjustUI() {
        if (this.isModelEmpty()) {
            this.scriptsEnabled.setSelected(false);
            this.scriptsEnabled.setEnabled(false);
            this.scriptsCombo.setEnabled(false);
            this.model.addElement(NbBundle.getMessage(this.getClass(), (String)"LoadGenPanel_NoScripts"));
            this.firePropertyChange(PATH, null, null);
        } else {
            this.scriptsEnabled.setSelected(this.shouldEnableSelector);
            this.scriptsEnabled.setEnabled(true);
            this.scriptsCombo.setEnabled(this.scriptsEnabled.isSelected());
            if (this.lastSelectedFile != null && this.model.getIndexOf(this.lastSelectedFile) > -1) {
                this.model.setSelectedItem(this.lastSelectedFile);
            }
            String path = this.getSelectedScript();
            this.firePropertyChange(PATH, this.lastSelectedPath, path);
            this.lastSelectedPath = path;
        }
    }

    private boolean isModelEmpty() {
        return this.model.getSize() == 0 || this.model.getElementAt(0).equals(NbBundle.getMessage(this.getClass(), (String)"LoadGenPanel_NoScripts"));
    }

    private class FriendlyFileObject {
        private FileObject delegate;

        public FriendlyFileObject(FileObject obj) {
            this.delegate = obj;
        }

        public FileObject getFileObject() {
            return this.delegate;
        }

        public String toString() {
            return this.delegate != null ? this.delegate.getNameExt() : "";
        }

        public int hashCode() {
            return this.delegate != null ? this.delegate.hashCode() : 0;
        }

        public boolean equals(Object obj) {
            if (this.delegate == null) {
                return false;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof FriendlyFileObject)) {
                return false;
            }
            if (((FriendlyFileObject)obj).delegate == null) {
                return false;
            }
            return this.delegate.equals(((FriendlyFileObject)obj).delegate);
        }
    }
}

