/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.copy;

import java.awt.EventQueue;
import java.io.File;
import java.text.MessageFormat;
import java.util.logging.Level;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.copy.CreateCopy;
import org.netbeans.modules.subversion.ui.copy.SwitchToAction;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class CreateCopyAction
extends ContextAction {
    private static final String MESSAGE_CREATE_FOLDER = "Netbeans SVN client generated message: create a new folder for the copy:\n{0}";

    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_MenuItem_Copy";
    }

    @Override
    protected int getFileEnabledStatus() {
        return -4;
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    @Override
    protected boolean enable(Node[] nodes) {
        return nodes != null && nodes.length == 1 && this.getCachedContext(nodes).getRoots().size() > 0;
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        SVNUrl fileUrl;
        SVNUrl repositoryUrl;
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Context ctx = this.getContext(nodes);
        File[] roots = SvnUtils.getActionRoots(ctx);
        if (roots == null || roots.length == 0) {
            return;
        }
        File[] files = Subversion.getInstance().getStatusCache().listFiles(ctx, 22996);
        File interestingFile = roots.length == 1 ? roots[0] : SvnUtils.getPrimaryFile(roots[0]);
        try {
            repositoryUrl = SvnUtils.getRepositoryRootUrl(interestingFile);
            fileUrl = SvnUtils.getRepositoryUrl(interestingFile);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        RepositoryFile repositoryFile = new RepositoryFile(repositoryUrl, fileUrl, SVNRevision.HEAD);
        RequestProcessor rp = this.createRequestProcessor(ctx);
        boolean hasChanges = files.length > 0;
        CreateCopy createCopy = new CreateCopy(repositoryFile, interestingFile, hasChanges);
        this.performCopy(createCopy, rp, nodes, roots);
    }

    private void performCopy(final CreateCopy createCopy, final RequestProcessor rp, final Node[] nodes, final File[] roots) {
        if (!createCopy.showDialog()) {
            return;
        }
        rp.post(new Runnable(){

            @Override
            public void run() {
                String errorText = CreateCopyAction.this.validateTargetPath(createCopy);
                if (errorText == null) {
                    ContextAction.ProgressSupport support = new ContextAction.ProgressSupport(CreateCopyAction.this, nodes){

                        @Override
                        public void perform() {
                            CreateCopyAction.this.performCopy(createCopy, this, roots);
                        }
                    };
                    support.start(rp);
                } else {
                    SvnClientExceptionHandler.annotate(errorText);
                    createCopy.setErrorText(errorText);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CreateCopyAction.this.performCopy(createCopy, rp, nodes, roots);
                        }
                    });
                }
            }
        });
    }

    private String validateTargetPath(CreateCopy createCopy) {
        String errorText = null;
        try {
            ISVNInfo info;
            block5: {
                RepositoryFile toRepositoryFile = createCopy.getToRepositoryFile();
                SvnClient client = Subversion.getInstance().getClient(toRepositoryFile.getRepositoryUrl());
                info = null;
                try {
                    info = client.getInfo(toRepositoryFile.getFileUrl());
                }
                catch (SVNClientException e) {
                    if (SvnClientExceptionHandler.isWrongUrl(e.getMessage())) break block5;
                    throw e;
                }
            }
            if (info != null) {
                errorText = NbBundle.getMessage(CreateCopyAction.class, (String)"MSG_CreateCopy_Target_Exists");
            }
        }
        catch (SVNClientException ex) {
            errorText = null;
        }
        return errorText;
    }

    private void performCopy(CreateCopy createCopy, SvnProgressSupport support, File[] roots) {
        if (roots == null) {
            return;
        }
        RepositoryFile toRepositoryFile = createCopy.getToRepositoryFile();
        try {
            SvnClient client;
            try {
                client = Subversion.getInstance().getClient(toRepositoryFile.getRepositoryUrl());
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                return;
            }
            if (!toRepositoryFile.isRepositoryRoot()) {
                ISVNInfo info;
                SVNUrl folderToCreate;
                block27: {
                    block26: {
                        folderToCreate = toRepositoryFile.removeLastSegment().getFileUrl();
                        try {
                            client.getInfo(folderToCreate);
                        }
                        catch (SVNClientException ex) {
                            if (SvnClientExceptionHandler.isWrongUrl(ex.getMessage())) break block26;
                            throw ex;
                        }
                    }
                    info = null;
                    try {
                        info = client.getInfo(folderToCreate);
                    }
                    catch (SVNClientException ex) {
                        if (SvnClientExceptionHandler.isWrongUrl(ex.getMessage())) break block27;
                        throw ex;
                    }
                }
                if (support.isCanceled()) {
                    return;
                }
                if (info == null) {
                    client.mkdir(folderToCreate, true, this.getCreateFolderMessage(createCopy.getMessage()));
                }
            }
            if (support.isCanceled()) {
                return;
            }
            if (createCopy.isLocal()) {
                if (roots.length == 1) {
                    client.copy(new File[]{createCopy.getLocalFile()}, toRepositoryFile.getFileUrl(), createCopy.getMessage(), true, false);
                } else {
                    for (File root : roots) {
                        SVNUrl toUrl = this.getToRepositoryFile(toRepositoryFile, root).getFileUrl();
                        client.copy(new File[]{root}, toUrl, createCopy.getMessage(), true, false);
                    }
                }
            } else if (roots.length == 1) {
                RepositoryFile fromRepositoryFile = createCopy.getFromRepositoryFile();
                client.copy(fromRepositoryFile.getFileUrl(), toRepositoryFile.getFileUrl(), createCopy.getMessage(), fromRepositoryFile.getRevision(), false);
            } else {
                for (File root : roots) {
                    SVNUrl fromUrl = SvnUtils.getRepositoryRootUrl(root).appendPath(SvnUtils.getRepositoryPath(root));
                    SVNUrl toUrl = this.getToRepositoryFile(toRepositoryFile, root).getFileUrl();
                    client.copy(fromUrl, toUrl, createCopy.getMessage(), SVNRevision.HEAD, false);
                }
            }
            if (support.isCanceled()) {
                return;
            }
            if (createCopy.switchTo()) {
                if (roots != null && roots.length > 1) {
                    for (File file : roots) {
                        SwitchToAction.performSwitch(this.getToRepositoryFile(toRepositoryFile, file), file, support);
                    }
                } else {
                    SwitchToAction.performSwitch(toRepositoryFile, createCopy.getLocalFile(), support);
                }
            }
        }
        catch (SVNClientException ex) {
            support.annotate(ex);
        }
    }

    private RepositoryFile getToRepositoryFile(RepositoryFile toRepositoryFile, File file) {
        return toRepositoryFile.replaceLastSegment(file.getName(), 0);
    }

    private String getCreateFolderMessage(String commitMessage) {
        String createMessage;
        String message = System.getProperty("subversion.copy.createFolderMessage", MESSAGE_CREATE_FOLDER);
        if (message == null || message.length() == 0) {
            message = "{0}";
        }
        try {
            createMessage = MessageFormat.format(message, commitMessage);
        }
        catch (IllegalArgumentException ex) {
            Subversion.LOG.log(Level.INFO, message, ex);
            createMessage = MessageFormat.format(MESSAGE_CREATE_FOLDER, commitMessage);
        }
        return createMessage;
    }
}

