/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SubversionVisibilityQuery;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.WorkingCopyAttributesCache;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.spi.VCSVisibilityQuery;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.netbeans.spi.queries.CollocationQueryImplementation;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SubversionVCS
extends VersioningSystem
implements VersioningListener,
PreferenceChangeListener,
PropertyChangeListener {
    private final Set<File> unversionedParents = Collections.synchronizedSet(new HashSet(20));
    private static final String PROP_PRIORITY = "Integer VCS.Priority";
    private static final Integer priority = Utils.getPriority((String)"subversion");
    private SubversionVisibilityQuery visibilityQuery;
    private final CollocationQueryImplementation collocationQueryImplementation = new CollocationQueryImplementation(){

        public boolean areCollocated(File a, File b) {
            File fra = SubversionVCS.this.getTopmostManagedAncestor(a);
            File frb = SubversionVCS.this.getTopmostManagedAncestor(b);
            if (fra == null || !fra.equals(frb)) {
                return false;
            }
            try {
                SVNUrl ra = SvnUtils.getRepositoryRootUrl(a);
                if (ra == null) {
                    Subversion.LOG.log(Level.WARNING, "areCollocated returning false due to missing repository url for {0} {1}", new Object[]{a, b});
                    return false;
                }
                SVNUrl rb = SvnUtils.getRepositoryRootUrl(b);
                SVNUrl rr = SvnUtils.getRepositoryRootUrl(fra);
                return ra.equals((Object)rb) && ra.equals((Object)rr);
            }
            catch (SVNClientException e) {
                if (!WorkingCopyAttributesCache.getInstance().isSuppressed(e)) {
                    Subversion.LOG.log(Level.INFO, null, e);
                }
                Subversion.LOG.log(Level.WARNING, "areCollocated returning false due to catched exception " + a + " " + b);
                return false;
            }
        }

        public File findRoot(File file) {
            return SubversionVCS.this.getTopmostManagedAncestor(file);
        }
    };

    public SubversionVCS() {
        this.putProperty("String VCS.DisplayName", NbBundle.getMessage(SubversionVCS.class, (String)"CTL_Subversion_DisplayName"));
        this.putProperty("String VCS.MenuLabel", NbBundle.getMessage(SubversionVCS.class, (String)"CTL_Subversion_MainMenu"));
        this.putProperty(PROP_PRIORITY, priority);
        SvnModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
    }

    public File getTopmostManagedAncestor(File file) {
        Subversion.LOG.log(Level.FINE, "looking for managed parent for {0}", new Object[]{file});
        if (this.unversionedParents.contains(file)) {
            Subversion.LOG.fine(" cached as unversioned");
            return null;
        }
        File metadataRoot = null;
        if (SvnUtils.isPartOfSubversionMetadata(file)) {
            Subversion.LOG.fine(" part of metaddata");
            while (file != null) {
                if (SvnUtils.isAdministrative(file)) {
                    Subversion.LOG.log(Level.FINE, " will use parent {0}", new Object[]{file});
                    metadataRoot = file;
                    file = file.getParentFile();
                    break;
                }
                file = file.getParentFile();
            }
        }
        File topmost = null;
        HashSet<File> done = new HashSet<File>();
        while (file != null) {
            if (this.unversionedParents.contains(file)) {
                Subversion.LOG.log(Level.FINE, " already known as unversioned {0}", new Object[]{file});
                break;
            }
            if (Utils.isScanForbidden((File)file)) break;
            if (SvnUtils.hasMetadata(file)) {
                Subversion.LOG.log(Level.FINE, " found managed parent {0}", new Object[]{file});
                topmost = file;
                done.clear();
            } else {
                Subversion.LOG.log(Level.FINE, " found unversioned {0}", new Object[]{file});
                if (file.exists()) {
                    done.add(file);
                }
            }
            file = file.getParentFile();
        }
        if (done.size() > 0) {
            Subversion.LOG.log(Level.FINE, " storing unversioned");
            this.unversionedParents.addAll(done);
        }
        if (topmost == null && metadataRoot != null) {
            Subversion.LOG.log(Level.FINE, "setting metadata root as managed parent {0}", new Object[]{metadataRoot});
            topmost = metadataRoot;
        }
        Subversion.LOG.log(Level.FINE, "returning managed parent {0}", new Object[]{topmost});
        return topmost;
    }

    public VCSAnnotator getVCSAnnotator() {
        return Subversion.getInstance().getVCSAnnotator();
    }

    public VCSInterceptor getVCSInterceptor() {
        return Subversion.getInstance().getVCSInterceptor();
    }

    public void getOriginalFile(File workingCopy, File originalFile) {
        Subversion.getInstance().getOriginalFile(workingCopy, originalFile);
    }

    public CollocationQueryImplementation getCollocationQueryImplementation() {
        return this.collocationQueryImplementation;
    }

    public VCSVisibilityQuery getVisibilityQuery() {
        if (this.visibilityQuery == null) {
            this.visibilityQuery = new SubversionVisibilityQuery();
        }
        return this.visibilityQuery;
    }

    public void versioningEvent(VersioningEvent event) {
        if (event.getId() == FileStatusCache.EVENT_FILE_STATUS_CHANGED) {
            File file = (File)event.getParams()[0];
            this.fireStatusChanged(file);
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().startsWith("commitExclusions")) {
            this.fireStatusChanged(null);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("annotationsChanged")) {
            this.fireAnnotationsChanged((Set)evt.getNewValue());
        } else if (evt.getPropertyName().equals("baseFileChanged")) {
            this.fireStatusChanged((Set)evt.getNewValue());
        } else if (evt.getPropertyName().equals("versionedFilesChanged")) {
            Subversion.LOG.fine("cleaning unversioned parents cache");
            this.unversionedParents.clear();
            this.fireVersionedFilesChanged();
        }
    }
}

