/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.sps.impl;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.SignatureException;
import java.security.acl.NotOwnerException;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.MacroExpanderFactory;
import org.netbeans.modules.nativeexecution.sps.impl.SPSCommonImpl;
import org.netbeans.modules.nativeexecution.support.Encrypter;
import org.netbeans.modules.nativeexecution.support.InstalledFileLocatorProvider;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

public final class SPSLocalImpl
extends SPSCommonImpl {
    private static final Map<String, Long> csums = new HashMap<String, Long>();
    private final String privp;
    private String pid = null;

    private SPSLocalImpl(ExecutionEnvironment execEnv, String privp) {
        super(execEnv);
        this.privp = privp;
    }

    public static SPSLocalImpl getNewInstance(ExecutionEnvironment execEnv) throws SignatureException, MissingResourceException {
        String privpCmd = null;
        MacroExpanderFactory.MacroExpander macroExpander = MacroExpanderFactory.getExpander(execEnv);
        String path = "$osname-$platform";
        try {
            path = macroExpander.expandPredefinedMacros(path);
        }
        catch (ParseException ex) {
            // empty catch block
        }
        privpCmd = "bin/nativeexecution/" + path + "/privp";
        InstalledFileLocator fl = InstalledFileLocatorProvider.getDefault();
        File file = fl.locate(privpCmd, "org.netbeans.modules.dlight.nativeexecution", false);
        if (file == null || !file.exists()) {
            throw new MissingResourceException(privpCmd, null, null);
        }
        privpCmd = file.getAbsolutePath();
        if (!Encrypter.checkCRC32(privpCmd, csums.get(path))) {
            throw new SignatureException("Wrong privp executable! CRC check failed!");
        }
        Future<Integer> chmod = CommonTasksSupport.chmod(execEnv, privpCmd, 493, null);
        try {
            chmod.get();
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return new SPSLocalImpl(execEnv, privpCmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestPrivileges(Collection<String> requestedPrivileges, String user, char[] passwd) throws NotOwnerException {
        PrintWriter w = null;
        try {
            StringBuilder sb = new StringBuilder();
            for (String priv : requestedPrivileges) {
                sb.append(priv).append(",");
            }
            Process process = new ProcessBuilder(this.privp, user, sb.toString(), this.getPID()).start();
            w = new PrintWriter(process.getOutputStream());
            w.println(passwd);
            w.flush();
            int result = process.waitFor();
            if (result != 0) {
                Logger.getInstance().log(Level.FINE, "privp returned {0}", result);
                throw new NotOwnerException();
            }
            boolean bl = true;
            return bl;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (IOException ex) {
            Logger.getInstance().log(Level.FINE, "IOException in requestPrivileges : {0}", ex);
        }
        finally {
            if (w != null) {
                w.close();
            }
        }
        return false;
    }

    @Override
    synchronized String getPID() {
        if (this.pid != null) {
            return this.pid;
        }
        try {
            File self = new File("/proc/self");
            this.pid = self.getCanonicalFile().getName();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return this.pid;
    }

    static {
        csums.put("SunOS-x86", 2839716019L);
        csums.put("SunOS-sparc", 2274267119L);
    }
}

