/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.execution;

import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.openide.util.NbBundle;

public interface PostMessageDisplayer {
    public String getPostMessage(NativeProcess.State var1, int var2, long var3);

    public String getPostStatusString(NativeProcess.State var1, int var2);

    public static final class Default
    implements PostMessageDisplayer {
        private final String actionName;

        public Default(String actionName) {
            this.actionName = actionName;
        }

        @Override
        public String getPostMessage(NativeProcess.State state, int rc, long timeMilliseconds) {
            StringBuilder res = new StringBuilder();
            switch (state) {
                case ERROR: {
                    res.append(NbBundle.getMessage(PostMessageDisplayer.class, (String)"FAILED", (Object)this.actionName.toUpperCase()));
                    break;
                }
                case CANCELLED: {
                    res.append(NbBundle.getMessage(PostMessageDisplayer.class, (String)"TERMINATED", (Object)this.actionName.toUpperCase()));
                    break;
                }
                case FINISHED: {
                    if (rc == 0) {
                        res.append(NbBundle.getMessage(PostMessageDisplayer.class, (String)"SUCCESSFUL", (Object)this.actionName.toUpperCase()));
                        break;
                    }
                    res.append(NbBundle.getMessage(PostMessageDisplayer.class, (String)"FAILED", (Object)this.actionName.toUpperCase()));
                    break;
                }
            }
            res.append(" (");
            if (rc != 0) {
                res.append(NbBundle.getMessage(PostMessageDisplayer.class, (String)"EXIT_VALUE", (Object)rc));
                res.append(' ');
            }
            res.append(NbBundle.getMessage(PostMessageDisplayer.class, (String)"TOTAL_TIME", (Object)Default.formatTime(timeMilliseconds)));
            res.append(')');
            return res.toString();
        }

        @Override
        public String getPostStatusString(NativeProcess.State state, int rc) {
            switch (state) {
                case ERROR: {
                    return NbBundle.getMessage(PostMessageDisplayer.class, (String)"MSG_FAILED", (Object)this.actionName);
                }
                case CANCELLED: {
                    return NbBundle.getMessage(PostMessageDisplayer.class, (String)"MSG_TERMINATED", (Object)this.actionName);
                }
                case FINISHED: {
                    if (rc == 0) {
                        return NbBundle.getMessage(PostMessageDisplayer.class, (String)"MSG_SUCCESSFUL", (Object)this.actionName);
                    }
                    return NbBundle.getMessage(PostMessageDisplayer.class, (String)"MSG_FAILED", (Object)this.actionName);
                }
            }
            return "";
        }

        private static String formatTime(long millis) {
            StringBuilder res = new StringBuilder();
            long seconds = millis / 1000L;
            long minutes = seconds / 60L;
            long hours = minutes / 60L;
            if (hours > 0L) {
                res.append(" ").append(hours).append(NbBundle.getMessage(PostMessageDisplayer.class, (String)"HOUR"));
            }
            if (minutes > 0L) {
                res.append(" ").append(minutes - hours * 60L).append(NbBundle.getMessage(PostMessageDisplayer.class, (String)"MINUTE"));
            }
            if (seconds > 0L) {
                res.append(" ").append(seconds - minutes * 60L).append(NbBundle.getMessage(PostMessageDisplayer.class, (String)"SECOND"));
            } else {
                res.append(" ").append(millis - seconds * 1000L).append(NbBundle.getMessage(PostMessageDisplayer.class, (String)"MILLISECOND"));
            }
            return res.toString();
        }
    }
}

