/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors.resource.elements;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.ActiveDocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.resources.FontCD;
import org.netbeans.modules.vmd.midp.propertyeditors.CleanUp;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElement;
import org.netbeans.modules.vmd.midp.screen.display.ScreenSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class FontEditorElement
extends PropertyEditorResourceElement
implements CleanUp {
    private FontStub currentStub;
    private Font defaultFont;
    private JCheckBox boldCheckBox;
    private JRadioButton customRadioButton;
    private JRadioButton defaultRadioButton;
    private ButtonGroup faceButtonGroup;
    private JLabel faceLabel;
    private JRadioButton inputRadioButton;
    private JCheckBox italicCheckBox;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private ButtonGroup kindButtonGroup;
    private JLabel kindLabel;
    private JRadioButton largeRadioButton;
    private JRadioButton mediumRadioButton;
    private JRadioButton monospaceRadioButton;
    private JCheckBox plainCheckBox;
    private JRadioButton proportionalRadioButton;
    private JLabel sampleLabel;
    private ButtonGroup sizeButtonGroup;
    private JLabel sizeLabel;
    private JRadioButton smallRadioButton;
    private JRadioButton staticRadioButton;
    private JLabel styleLabel;
    private JRadioButton systemRadioButton;
    private JCheckBox underlinedCheckBox;

    public FontEditorElement() {
        this.initComponents();
        this.attachListeners();
        this.defaultFont = this.sampleLabel.getFont();
    }

    @Override
    public void clean(DesignComponent component) {
        this.currentStub = null;
        this.defaultFont = null;
        this.boldCheckBox = null;
        this.customRadioButton = null;
        this.defaultRadioButton = null;
        this.faceButtonGroup = null;
        this.faceLabel = null;
        this.inputRadioButton = null;
        this.italicCheckBox = null;
        this.jPanel1 = null;
        this.jPanel2 = null;
        this.kindButtonGroup = null;
        this.kindLabel = null;
        this.largeRadioButton = null;
        this.mediumRadioButton = null;
        this.monospaceRadioButton = null;
        this.plainCheckBox = null;
        this.proportionalRadioButton = null;
        this.sampleLabel = null;
        this.sizeButtonGroup = null;
        this.sizeLabel = null;
        this.smallRadioButton = null;
        this.staticRadioButton = null;
        this.styleLabel = null;
        this.systemRadioButton = null;
        this.underlinedCheckBox = null;
        this.removeAll();
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }

    @Override
    public TypeID getTypeID() {
        return FontCD.TYPEID;
    }

    @Override
    public List<String> getPropertyValueNames() {
        return Arrays.asList("fontKind", "face", "style", "bold");
    }

    private void attachListeners() {
        KindActionListener kindActionListener = new KindActionListener();
        this.defaultRadioButton.addActionListener(kindActionListener);
        this.staticRadioButton.addActionListener(kindActionListener);
        this.inputRadioButton.addActionListener(kindActionListener);
        this.customRadioButton.addActionListener(kindActionListener);
        FaceActionListener faceActionListener = new FaceActionListener();
        this.systemRadioButton.addActionListener(faceActionListener);
        this.monospaceRadioButton.addActionListener(faceActionListener);
        this.proportionalRadioButton.addActionListener(faceActionListener);
        StyleActionListener styleActionListener = new StyleActionListener();
        this.plainCheckBox.addActionListener(styleActionListener);
        this.boldCheckBox.addActionListener(styleActionListener);
        this.italicCheckBox.addActionListener(styleActionListener);
        this.underlinedCheckBox.addActionListener(styleActionListener);
        SizeActionListener sizeActionListener = new SizeActionListener();
        this.smallRadioButton.addActionListener(sizeActionListener);
        this.mediumRadioButton.addActionListener(sizeActionListener);
        this.largeRadioButton.addActionListener(sizeActionListener);
    }

    private void setKindUnselected() {
        this.defaultRadioButton.setSelected(false);
        this.staticRadioButton.setSelected(false);
        this.inputRadioButton.setSelected(false);
        this.customRadioButton.setSelected(false);
    }

    private void setDefaultFont() {
        this.systemRadioButton.setSelected(false);
        this.monospaceRadioButton.setSelected(false);
        this.proportionalRadioButton.setSelected(false);
        this.plainCheckBox.setSelected(false);
        this.boldCheckBox.setSelected(false);
        this.italicCheckBox.setSelected(false);
        this.underlinedCheckBox.setSelected(false);
        this.smallRadioButton.setSelected(false);
        this.mediumRadioButton.setSelected(false);
        this.largeRadioButton.setSelected(false);
        this.setSampleFont(true);
    }

    private void setFaceSizeStyleEnabled(boolean isEnabled) {
        this.faceLabel.setEnabled(isEnabled);
        this.systemRadioButton.setEnabled(isEnabled);
        this.monospaceRadioButton.setEnabled(isEnabled);
        this.proportionalRadioButton.setEnabled(isEnabled);
        this.styleLabel.setEnabled(isEnabled);
        this.plainCheckBox.setEnabled(isEnabled);
        this.boldCheckBox.setEnabled(isEnabled);
        this.italicCheckBox.setEnabled(isEnabled);
        this.underlinedCheckBox.setEnabled(isEnabled);
        this.sizeLabel.setEnabled(isEnabled);
        this.smallRadioButton.setEnabled(isEnabled);
        this.mediumRadioButton.setEnabled(isEnabled);
        this.largeRadioButton.setEnabled(isEnabled);
    }

    private void setKindEnabled(boolean isEnabled) {
        this.kindLabel.setEnabled(isEnabled);
        this.defaultRadioButton.setEnabled(isEnabled);
        this.staticRadioButton.setEnabled(isEnabled);
        this.inputRadioButton.setEnabled(isEnabled);
        this.customRadioButton.setEnabled(isEnabled);
    }

    private void setAllEnabled(boolean isEnabled) {
        this.setKindEnabled(isEnabled);
        this.setFaceSizeStyleEnabled(isEnabled);
    }

    private void setKindSelected(int kindCode) {
        switch (kindCode) {
            case 0: {
                this.defaultRadioButton.setSelected(true);
                break;
            }
            case 1: {
                this.customRadioButton.setSelected(true);
                break;
            }
            case 2: {
                this.staticRadioButton.setSelected(true);
                break;
            }
            case 3: {
                this.inputRadioButton.setSelected(true);
            }
        }
    }

    private void setFaceSelected(int faceCode) {
        switch (faceCode) {
            case 0: {
                this.systemRadioButton.setSelected(true);
                break;
            }
            case 32: {
                this.monospaceRadioButton.setSelected(true);
                break;
            }
            case 64: {
                this.proportionalRadioButton.setSelected(true);
            }
        }
    }

    private void setSizeSelected(int sizeCode) {
        switch (sizeCode) {
            case 8: {
                this.smallRadioButton.setSelected(true);
                break;
            }
            case 0: {
                this.mediumRadioButton.setSelected(true);
                break;
            }
            case 16: {
                this.largeRadioButton.setSelected(true);
            }
        }
    }

    private void setStyleSelected(int styleCode) {
        if (styleCode == 0) {
            this.plainCheckBox.setSelected(true);
        } else {
            this.boldCheckBox.setSelected((styleCode & 1) != 0);
            this.italicCheckBox.setSelected((styleCode & 2) != 0);
            this.underlinedCheckBox.setSelected((styleCode & 4) != 0);
        }
    }

    private void setStateOfButtons() {
        int kindCode = this.currentStub.getKind();
        this.setKindSelected(kindCode);
        if (kindCode == 1) {
            int faceCode = this.currentStub.getFace();
            int styleCode = this.currentStub.getStyle();
            int sizeCode = this.currentStub.getSize();
            this.setFaceSelected(faceCode);
            this.setStyleSelected(styleCode);
            this.setSizeSelected(sizeCode);
        } else {
            this.setFaceSizeStyleEnabled(false);
        }
    }

    private void setSampleFont(boolean isDefault) {
        if (isDefault) {
            this.sampleLabel.setFont(this.defaultFont);
            return;
        }
        DesignDocument document = ActiveDocumentSupport.getDefault().getActiveDocument();
        if (document != null) {
            int kindCode = this.currentStub.getKind();
            int faceCode = this.currentStub.getFace();
            int styleCode = this.currentStub.getStyle();
            int sizeCode = this.currentStub.getSize();
            this.sampleLabel.setFont(ScreenSupport.getFont(document, kindCode, faceCode, styleCode, sizeCode));
        }
    }

    @Override
    public void setDesignComponentWrapper(PropertyEditorResourceElement.DesignComponentWrapper wrapper) {
        if (wrapper == null) {
            this.setKindUnselected();
            this.setDefaultFont();
            this.setAllEnabled(false);
            return;
        }
        long componentID = wrapper.getComponentID();
        final int[] kindCode = new int[]{0};
        final int[] faceCode = new int[]{0};
        final int[] styleCode = new int[]{0};
        final int[] sizeCode = new int[]{0};
        final DesignComponent component = wrapper.getComponent();
        if (component != null) {
            if (!component.getType().equals((Object)this.getTypeID())) {
                throw new IllegalArgumentException("Passed component must have typeID " + this.getTypeID() + " instead passed " + component.getType());
            }
            componentID = component.getComponentID();
            component.getDocument().getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    PropertyValue propertyValue = component.readProperty("fontKind");
                    if (!PropertyEditorResourceElement.isPropertyValueAUserCodeType(propertyValue)) {
                        kindCode[0] = MidpTypes.getInteger(propertyValue);
                    }
                    if (!PropertyEditorResourceElement.isPropertyValueAUserCodeType(propertyValue = component.readProperty("face"))) {
                        faceCode[0] = MidpTypes.getInteger(propertyValue);
                    }
                    if (!PropertyEditorResourceElement.isPropertyValueAUserCodeType(propertyValue = component.readProperty("style"))) {
                        styleCode[0] = MidpTypes.getInteger(propertyValue);
                    }
                    if (!PropertyEditorResourceElement.isPropertyValueAUserCodeType(propertyValue = component.readProperty("bold"))) {
                        sizeCode[0] = MidpTypes.getInteger(propertyValue);
                    }
                }
            });
        }
        if (wrapper.hasChanges()) {
            Map<String, PropertyValue> changes = wrapper.getChanges();
            for (String propertyName : changes.keySet()) {
                PropertyValue propertyValue = changes.get(propertyName);
                if ("fontKind".equals(propertyName)) {
                    kindCode[0] = MidpTypes.getInteger(propertyValue);
                    continue;
                }
                if ("face".equals(propertyName)) {
                    faceCode[0] = MidpTypes.getInteger(propertyValue);
                    continue;
                }
                if ("style".equals(propertyName)) {
                    styleCode[0] = MidpTypes.getInteger(propertyValue);
                    continue;
                }
                if (!"bold".equals(propertyName)) continue;
                sizeCode[0] = MidpTypes.getInteger(propertyValue);
            }
        }
        this.currentStub = new FontStub(componentID, kindCode[0], faceCode[0], styleCode[0], sizeCode[0]);
        this.setStateOfButtons();
        this.setKindEnabled(true);
        this.setFaceSizeStyleEnabled(kindCode[0] == 1);
        this.setSampleFont(false);
    }

    private void initComponents() {
        this.kindButtonGroup = new ButtonGroup();
        this.faceButtonGroup = new ButtonGroup();
        this.sizeButtonGroup = new ButtonGroup();
        this.defaultRadioButton = new JRadioButton();
        this.staticRadioButton = new JRadioButton();
        this.inputRadioButton = new JRadioButton();
        this.customRadioButton = new JRadioButton();
        this.kindLabel = new JLabel();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.sampleLabel = new JLabel();
        this.faceLabel = new JLabel();
        this.systemRadioButton = new JRadioButton();
        this.monospaceRadioButton = new JRadioButton();
        this.proportionalRadioButton = new JRadioButton();
        this.sizeLabel = new JLabel();
        this.smallRadioButton = new JRadioButton();
        this.mediumRadioButton = new JRadioButton();
        this.largeRadioButton = new JRadioButton();
        this.styleLabel = new JLabel();
        this.plainCheckBox = new JCheckBox();
        this.boldCheckBox = new JCheckBox();
        this.italicCheckBox = new JCheckBox();
        this.underlinedCheckBox = new JCheckBox();
        this.kindButtonGroup.add(this.defaultRadioButton);
        this.defaultRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.defaultRadioButton, (String)NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.defaultRadioButton.text"));
        this.defaultRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.defaultRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.kindButtonGroup.add(this.staticRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.staticRadioButton, (String)NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.staticRadioButton.text"));
        this.staticRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.staticRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.kindButtonGroup.add(this.inputRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.inputRadioButton, (String)NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.inputRadioButton.text"));
        this.inputRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.inputRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.kindButtonGroup.add(this.customRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.customRadioButton, (String)NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.customRadioButton.text"));
        this.customRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.customRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.kindLabel.setText(NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.kindLabel.text"));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.jPanel2.border.title")));
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel1.setLayout(null);
        this.sampleLabel.setFont(new Font("Dialog", 0, 12));
        this.sampleLabel.setText(NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.sampleLabel.text"));
        this.jPanel1.add(this.sampleLabel);
        this.sampleLabel.setBounds(0, 0, 310, 16);
        this.sampleLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FontEditorElement.class, (String)"ACSN_Preview"));
        this.sampleLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FontEditorElement.class, (String)"ACSD_Preview"));
        this.jPanel2.add((Component)this.jPanel1, "Center");
        this.faceLabel.setText(NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.faceLabel.text"));
        this.faceLabel.setEnabled(false);
        this.faceButtonGroup.add(this.systemRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.systemRadioButton, (String)NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.systemRadioButton.text"));
        this.systemRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.systemRadioButton.setEnabled(false);
        this.systemRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.faceButtonGroup.add(this.monospaceRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.monospaceRadioButton, (String)NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.monospaceRadioButton.text"));
        this.monospaceRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.monospaceRadioButton.setEnabled(false);
        this.monospaceRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.faceButtonGroup.add(this.proportionalRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.proportionalRadioButton, (String)NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.proportionalRadioButton.text"));
        this.proportionalRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.proportionalRadioButton.setEnabled(false);
        this.proportionalRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.sizeLabel.setText(NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.sizeLabel.text"));
        this.sizeLabel.setEnabled(false);
        this.sizeButtonGroup.add(this.smallRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.smallRadioButton, (String)NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.smallRadioButton.text"));
        this.smallRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.smallRadioButton.setEnabled(false);
        this.smallRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.sizeButtonGroup.add(this.mediumRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.mediumRadioButton, (String)NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.mediumRadioButton.text"));
        this.mediumRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.mediumRadioButton.setEnabled(false);
        this.mediumRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.sizeButtonGroup.add(this.largeRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.largeRadioButton, (String)NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.largeRadioButton.text"));
        this.largeRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.largeRadioButton.setEnabled(false);
        this.largeRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.styleLabel.setText(NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.styleLabel.text"));
        this.styleLabel.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.plainCheckBox, (String)NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.plainCheckBox.text"));
        this.plainCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.plainCheckBox.setEnabled(false);
        this.plainCheckBox.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.boldCheckBox, (String)NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.boldCheckBox.text"));
        this.boldCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.boldCheckBox.setEnabled(false);
        this.boldCheckBox.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.italicCheckBox, (String)NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.italicCheckBox.text"));
        this.italicCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.italicCheckBox.setEnabled(false);
        this.italicCheckBox.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.underlinedCheckBox, (String)NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.underlinedCheckBox.text"));
        this.underlinedCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.underlinedCheckBox.setEnabled(false);
        this.underlinedCheckBox.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.defaultRadioButton).add((Component)this.staticRadioButton).add((Component)this.inputRadioButton).add((Component)this.customRadioButton).add((Component)this.kindLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.faceLabel).add((Component)this.systemRadioButton).add((Component)this.monospaceRadioButton).add((Component)this.proportionalRadioButton)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.largeRadioButton).add((Component)this.sizeLabel).add((Component)this.mediumRadioButton).add((Component)this.smallRadioButton)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.styleLabel).add((Component)this.underlinedCheckBox).add((Component)this.boldCheckBox).add((Component)this.plainCheckBox).add((Component)this.italicCheckBox)).addContainerGap()).add(2, (Component)this.jPanel2, -1, 328, Short.MAX_VALUE));
        layout.linkSize(new Component[]{this.boldCheckBox, this.customRadioButton, this.defaultRadioButton, this.faceLabel, this.inputRadioButton, this.italicCheckBox, this.kindLabel, this.largeRadioButton, this.mediumRadioButton, this.monospaceRadioButton, this.plainCheckBox, this.proportionalRadioButton, this.sizeLabel, this.smallRadioButton, this.staticRadioButton, this.styleLabel, this.systemRadioButton, this.underlinedCheckBox}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.kindLabel).addPreferredGap(0).add((Component)this.defaultRadioButton).addPreferredGap(0).add((Component)this.staticRadioButton).addPreferredGap(0).add((Component)this.inputRadioButton).addPreferredGap(0).add((Component)this.customRadioButton)).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.faceLabel).addPreferredGap(0).add((Component)this.systemRadioButton).addPreferredGap(0).add((Component)this.monospaceRadioButton).addPreferredGap(0).add((Component)this.proportionalRadioButton)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.sizeLabel).add((Component)this.styleLabel)).addPreferredGap(0).add((Component)this.smallRadioButton).addPreferredGap(0).add((Component)this.mediumRadioButton).addPreferredGap(0).add((Component)this.largeRadioButton)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(20, 20, 20).add((Component)this.plainCheckBox).addPreferredGap(0).add((Component)this.boldCheckBox)).add((GroupLayout.Group)layout.createSequentialGroup().add(62, 62, 62).add((Component)this.italicCheckBox))).addPreferredGap(0).add((Component)this.underlinedCheckBox)))).addPreferredGap(0).add((Component)this.jPanel2, -1, 55, Short.MAX_VALUE)));
        this.defaultRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FontEditorElement.class, (String)"ACSN_FontKindDefault"));
        this.defaultRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FontEditorElement.class, (String)"ACSD_DefaultFontKind"));
        this.staticRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FontEditorElement.class, (String)"ACSN_FontKindStatic"));
        this.staticRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FontEditorElement.class, (String)"ACSD_FontKindStatic"));
        this.inputRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FontEditorElement.class, (String)"ACSN_FontKindInput"));
        this.inputRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FontEditorElement.class, (String)"ACSD_FontKindInput"));
        this.customRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FontEditorElement.class, (String)"ACSN_FontKindCustom"));
        this.customRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FontEditorElement.class, (String)"ACSD_FontKindCustom"));
        this.systemRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FontEditorElement.class, (String)"ACSN_FontFaceSystem"));
        this.systemRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FontEditorElement.class, (String)"ACSD_FontFaceSystem"));
        this.monospaceRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FontEditorElement.class, (String)"ACSN_FontFaceMonospace"));
        this.monospaceRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FontEditorElement.class, (String)"ACSD_FontFaceMonospace"));
        this.proportionalRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FontEditorElement.class, (String)"ACSN_FontFaceProportional"));
        this.proportionalRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FontEditorElement.class, (String)"ACSD_FontFaceProportional"));
        this.smallRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FontEditorElement.class, (String)"ACSN_FontSize"));
        this.smallRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FontEditorElement.class, (String)"ACSD_FontSizeSmall"));
        this.mediumRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FontEditorElement.class, (String)"ACSN_FontSizeMedium"));
        this.mediumRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FontEditorElement.class, (String)"ACSD_FontSizeMedium"));
        this.largeRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FontEditorElement.class, (String)"ACSN_FontSizeLarge"));
        this.largeRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FontEditorElement.class, (String)"ACSD_FontSizeLarge"));
        this.plainCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FontEditorElement.class, (String)"ACSN_FontStylePlain"));
        this.plainCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FontEditorElement.class, (String)"ACSD_FontStylePlain"));
        this.boldCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FontEditorElement.class, (String)"ACSN_FontStyleBold"));
        this.boldCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FontEditorElement.class, (String)"ACSD_FontStyleBold"));
        this.italicCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FontEditorElement.class, (String)"ACSN_FontStyleItalic"));
        this.italicCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FontEditorElement.class, (String)"ACSD_FontStyleItalic"));
        this.underlinedCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FontEditorElement.class, (String)"ACSN_FontStyleUnderlined"));
        this.underlinedCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FontEditorElement.class, (String)"ACSD_FontStyleUnderlined"));
    }

    private class StyleActionListener
    implements ActionListener {
        private StyleActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            int code = 0;
            if (src == FontEditorElement.this.plainCheckBox) {
                if (FontEditorElement.this.plainCheckBox.isSelected()) {
                    FontEditorElement.this.boldCheckBox.setSelected(false);
                    FontEditorElement.this.italicCheckBox.setSelected(false);
                    FontEditorElement.this.underlinedCheckBox.setSelected(false);
                }
            } else {
                FontEditorElement.this.plainCheckBox.setSelected(!FontEditorElement.this.boldCheckBox.isSelected() && !FontEditorElement.this.italicCheckBox.isSelected() && !FontEditorElement.this.underlinedCheckBox.isSelected());
                if (FontEditorElement.this.boldCheckBox.isSelected()) {
                    code |= 1;
                }
                if (FontEditorElement.this.italicCheckBox.isSelected()) {
                    code |= 2;
                }
                if (FontEditorElement.this.underlinedCheckBox.isSelected()) {
                    code |= 4;
                }
            }
            FontEditorElement.this.currentStub.setStyle(code);
            FontEditorElement.this.setSampleFont(false);
            FontEditorElement.this.fireElementChanged(FontEditorElement.this.currentStub.getComponentID(), "style", MidpTypes.createIntegerValue(code));
        }
    }

    private class FaceActionListener
    implements ActionListener {
        private FaceActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            int code = 0;
            if (src == FontEditorElement.this.monospaceRadioButton) {
                code = 32;
            } else if (src == FontEditorElement.this.proportionalRadioButton) {
                code = 64;
            }
            FontEditorElement.this.currentStub.setFace(code);
            FontEditorElement.this.setSampleFont(false);
            FontEditorElement.this.fireElementChanged(FontEditorElement.this.currentStub.getComponentID(), "face", MidpTypes.createIntegerValue(code));
        }
    }

    private class SizeActionListener
    implements ActionListener {
        private SizeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            int code = 0;
            if (src == FontEditorElement.this.smallRadioButton) {
                code = 8;
            } else if (src == FontEditorElement.this.largeRadioButton) {
                code = 16;
            }
            FontEditorElement.this.currentStub.setSize(code);
            FontEditorElement.this.setSampleFont(false);
            FontEditorElement.this.fireElementChanged(FontEditorElement.this.currentStub.getComponentID(), "bold", MidpTypes.createIntegerValue(code));
        }
    }

    private class KindActionListener
    implements ActionListener {
        private KindActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            int code = 0;
            if (src == FontEditorElement.this.customRadioButton) {
                FontEditorElement.this.setFaceSizeStyleEnabled(true);
                code = 1;
            } else if (src == FontEditorElement.this.defaultRadioButton) {
                FontEditorElement.this.setFaceSizeStyleEnabled(false);
                code = 0;
            } else if (src == FontEditorElement.this.staticRadioButton) {
                FontEditorElement.this.setFaceSizeStyleEnabled(false);
                code = 2;
            } else if (src == FontEditorElement.this.inputRadioButton) {
                FontEditorElement.this.setFaceSizeStyleEnabled(false);
                code = 3;
            }
            FontEditorElement.this.currentStub.setKind(code);
            FontEditorElement.this.setSampleFont(false);
            FontEditorElement.this.fireElementChanged(FontEditorElement.this.currentStub.getComponentID(), "fontKind", MidpTypes.createIntegerValue(code));
        }
    }

    private static class FontStub {
        private long componentID;
        private int kind;
        private int face;
        private int style;
        private int size;
        private boolean isChanged;

        public FontStub(long componentID, int kind, int face, int style, int size) {
            this.componentID = componentID;
            this.kind = kind;
            this.face = face;
            this.style = style;
            this.size = size;
        }

        public long getComponentID() {
            return this.componentID;
        }

        public boolean isChanged() {
            return this.isChanged;
        }

        public void setWasChanged(boolean isChanged) {
            this.isChanged = isChanged;
        }

        public int getKind() {
            return this.kind;
        }

        public void setKind(int kind) {
            this.kind = kind;
        }

        public int getFace() {
            return this.face;
        }

        public void setFace(int face) {
            this.face = face;
        }

        public int getStyle() {
            return this.style;
        }

        public void setStyle(int style) {
            this.style = style;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public String toString() {
            StringBuffer str = new StringBuffer();
            str.append("[componentID=");
            str.append(this.componentID);
            str.append(", kind=");
            str.append(this.kind);
            str.append(", face=");
            str.append(this.face);
            str.append(", style=");
            str.append(this.style);
            str.append(", size=");
            str.append(this.size);
            str.append(']');
            return str.toString();
        }
    }
}

