/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.palette.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.vmd.midp.palette.wizard.ComponentInstaller;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class AddToPaletteVisualPanel2
extends JPanel {
    private Collection<ComponentInstaller.Item> items;
    private JButton bDeselectAll;
    private JButton bSelectAll;
    private JCheckBox cLibraries;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JList list;

    public AddToPaletteVisualPanel2() {
        this.initComponents();
        this.list.setCellRenderer(new ItemRenderer());
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(AddToPaletteVisualPanel2.class, (String)"TITLE_SelectClasses");
    }

    public void setItems(Collection<ComponentInstaller.Item> items) {
        this.items = items;
        this.reload();
    }

    public void reload() {
        ArrayList<Object> lst;
        if (this.cLibraries.isSelected()) {
            lst = new ArrayList<ComponentInstaller.Item>(this.items);
        } else {
            lst = new ArrayList();
            for (ComponentInstaller.Item item : this.items) {
                if (!item.isInSource()) continue;
                lst.add(item);
            }
        }
        Collections.sort(lst, new Comparator<ComponentInstaller.Item>(){

            @Override
            public int compare(ComponentInstaller.Item o1, ComponentInstaller.Item o2) {
                return o1.getFQN().compareTo(o2.getFQN());
            }
        });
        this.list.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return lst.size();
            }

            @Override
            public Object getElementAt(int i) {
                return lst.get(i);
            }
        });
        if (lst.size() > 0) {
            this.list.setSelectionInterval(0, lst.size() - 1);
        }
    }

    public List<ComponentInstaller.Item> getSelectedItems() {
        ArrayList<ComponentInstaller.Item> lst = new ArrayList<ComponentInstaller.Item>();
        for (Object o : this.list.getSelectedValues()) {
            lst.add((ComponentInstaller.Item)o);
        }
        return lst;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.list = new JList();
        this.bSelectAll = new JButton();
        this.bDeselectAll = new JButton();
        this.cLibraries = new JCheckBox();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(AddToPaletteVisualPanel2.class, (String)"LBL_FoundClasses"));
        this.jScrollPane1.setViewportView(this.list);
        Mnemonics.setLocalizedText((AbstractButton)this.bSelectAll, (String)NbBundle.getMessage(AddToPaletteVisualPanel2.class, (String)"LBL_SelectAll"));
        this.bSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddToPaletteVisualPanel2.this.bSelectAllActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bDeselectAll, (String)NbBundle.getMessage(AddToPaletteVisualPanel2.class, (String)"LBL_DeselectAll"));
        this.bDeselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddToPaletteVisualPanel2.this.bDeselectAllActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cLibraries, (String)NbBundle.getMessage(AddToPaletteVisualPanel2.class, (String)"LBL_ShowAll"));
        this.cLibraries.setMargin(new Insets(0, 0, 0, 0));
        this.cLibraries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddToPaletteVisualPanel2.this.cLibrariesActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 337, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addContainerGap(29, Short.MAX_VALUE)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.bSelectAll).addPreferredGap(0).add((Component)this.bDeselectAll).add(10, 10, 10)).add((Component)this.cLibraries))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 180, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.cLibraries).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.bDeselectAll).add((Component)this.bSelectAll)).addContainerGap()));
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddToPaletteVisualPanel2.class, (String)"ACCESSIBLE_NAME_jLabel1"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddToPaletteVisualPanel2.class, (String)"ACCESSIBLE_DESCRIPTION_jLabel1"));
        this.bSelectAll.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddToPaletteVisualPanel2.class, (String)"ACCESSIBLE_NAME_bSelectAll"));
        this.bSelectAll.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddToPaletteVisualPanel2.class, (String)"ACCESSIBLE_DESCRIPTION_bSelectAll"));
        this.bDeselectAll.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddToPaletteVisualPanel2.class, (String)"ACCESSIBLE_NAME_bDesceletAll"));
        this.bDeselectAll.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddToPaletteVisualPanel2.class, (String)"ACCESSIBLE_DESCRIPTION_bDesceletAll"));
        this.cLibraries.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddToPaletteVisualPanel2.class, (String)"ACCESSIBLE_NAME_jCheckBox"));
        this.cLibraries.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddToPaletteVisualPanel2.class, (String)"ACCESSIBLE_DESCRIPTION_jCheckBox"));
    }

    private void cLibrariesActionPerformed(ActionEvent evt) {
        this.reload();
    }

    private void bDeselectAllActionPerformed(ActionEvent evt) {
        this.list.setSelectedIndices(new int[0]);
    }

    private void bSelectAllActionPerformed(ActionEvent evt) {
        int size = this.list.getModel().getSize();
        if (size > 0) {
            this.list.setSelectionInterval(0, size - 1);
        }
    }

    private static class ItemRenderer
    extends DefaultListCellRenderer {
        private ItemRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return super.getListCellRendererComponent((JList<?>)list, ((ComponentInstaller.Item)value).getFQN(), index, isSelected, cellHasFocus);
        }
    }
}

